<!DOCTYPE style-sheet PUBLIC "-//James Clark//DTD DSSSL Style Sheet//EN">

<style-sheet>
<style-specification>
<style-specification-body>

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; This file is part of RefDB
;; Markus Hoenicka markus at mhoenicka.de 20040924
;; $Id: makecss.dsl,v 1.1.2.1 2004/09/25 21:15:31 mhoenicka Exp $
;;
;;
;;; extracts the html specification from a RefDB-generated dsssl driver file
;
;;; Processing: jade -t sgml -d makecss.dsl stylename.dsl > stylename.css

(declare-flow-object-class element
			   "UNREGISTERED::James Clark//Flow Object Class::element")

(element STYLE-SHEET
  (make sequence
    (process-children)))

(element STYLE-SPECIFICATION
  (if (equal? (normalize (attribute-string (normalize "id"))) (normalize "html"))
      (make sequence
	(process-children))
      (empty-sosofo))
)

;; library functions

(define (normalize str)
  ;; REFENTRY normalize
  ;; PURP Normalize the str according to the SGML declaration in effect
  ;; DESC
  ;; Performs SGML general name normalization on the string;
  ;; used to compare attribute names and generic identifiers correctly
  ;; according to the SGML declaration in effect; this is necessary
  ;; since XML is case-sensitive but the reference concrete syntax and
  ;; many SGML DTDs are not.
  ;; /DESC
  ;; AUTHOR Chris Maden
  ;; /REFENTRY
  (if (string? str)
      (general-name-normalize str
			      (current-node))
      str))

</style-specification-body>
</style-specification>
</style-sheet>

