///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================

#include "rheolef/geo_domain.h"

namespace rheolef {

// ------------------------------------------------------------------------
// cstors 
// ------------------------------------------------------------------------
template <class T, class M>
geo_domain_rep<T,M>::geo_domain_rep (const geo_domain_rep<T,M>& x)
  : base(x),
    _dom (x._dom),
    _bgd_ie2dom_ie(x._bgd_ie2dom_ie)
{
  trace_macro ("*** PHYSICAL COPY OF GEO_DOMAIN ***"); 
}
template <class T, class M>
geo_abstract_rep<T,M>*
geo_domain_rep<T,M>::clone() const
{
  trace_macro ("*** CLONE GEO_DOMAIN ***"); 
  typedef geo_domain_rep<T,M> rep;
  return new_macro(rep(*this));
}
template <class T, class M>
geo_domain_rep<T,M>::geo_domain_rep (const geo_domain_indirect_rep<T,M>& dom)
  : base(),
    _dom (dom),
    _bgd_ie2dom_ie()
{
    geo_rep<T,M>::build_from_domain (
	_dom.get_indirect().data(),
	_dom.get_background_geo().data(),
	_bgd_ie2dom_ie);
}
// ----------------------------------------------------------------------------
// geo_element: goes from bgd to domain element
// ----------------------------------------------------------------------------
template <class T, class M>
const geo_element&
geo_domain_rep<T,M>::bgd2dom_geo_element (const geo_element& bgd_K) const
{
  size_type map_d = bgd_K.dimension();
  size_type bgd_dis_ie = bgd_K.dis_ie();
  size_type first_bgd_dis_ie = get_background_geo().sizes().ownership_by_dimension[map_d].first_index();
  check_macro (bgd_dis_ie >= first_bgd_dis_ie, "unexpected dis_index "<<bgd_dis_ie<<": out of local range");
  size_type bgd_ie = bgd_dis_ie - first_bgd_dis_ie;
  size_type dom_ie = bgd_ie2dom_ie (bgd_ie);
  const geo_element& dom_K = base::get_geo_element (map_d, dom_ie);
  return dom_K;
}
template <class T, class M>
const geo_element&
geo_domain_rep<T,M>::dom2bgd_geo_element (const geo_element& dom_K) const
{
  size_type map_d = dom_K.dimension();
  size_type dom_dis_ie = dom_K.dis_ie();
  size_type first_dom_dis_ie = base::sizes().ownership_by_dimension[map_d].first_index();
  check_macro (dom_dis_ie >= first_dom_dis_ie, "unexpected dis_index "<<dom_dis_ie<<": out of local range");
  size_type dom_ie = dom_dis_ie - first_dom_dis_ie;
  const geo_basic<T,M>& dom = get_background_domain();
  const geo_element& bgd_K = dom[dom_ie];
  return bgd_K;
}
// ----------------------------------------------------------------------------
// instanciation in library
// ----------------------------------------------------------------------------
#define _RHEOLEF_instanciation(T,M)                             \
template class geo_domain_rep<T,M>;

_RHEOLEF_instanciation(Float,sequential)
#ifdef _RHEOLEF_HAVE_MPI
_RHEOLEF_instanciation(Float,distributed)
#endif // _RHEOLEF_HAVE_MPI

} // namespace rheolef
