#ifndef _RHEOLEF_UBLAS_IO_H
#define _RHEOLEF_UBLAS_IO_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
#include "rheolef/compiler.h"
#include <boost/numeric/ublas/vector.hpp>
#include <boost/numeric/ublas/matrix.hpp>
namespace ublas = boost::numeric::ublas;

namespace rheolef { 
template <class T>
std::ostream&
operator << (std::ostream& out, const ublas::vector<T>& b) {
  out << std::setprecision(std::numeric_limits<T>::digits10);
  out << "[";
  for (size_t irow = 0; irow < b.size(); irow++) {
      out << b(irow);
      if (irow != b.size()-1) out << ";";
      else out << "]" << std::flush;
  }
  return out;
}
template <class T>
std::ostream&
operator << (std::ostream& out, const ublas::matrix<T>& A) {
  out << std::setprecision(std::numeric_limits<T>::digits10);
  out << "[";
  for (size_t irow = 0; irow < A.size1(); irow++) {
    for (size_t jrow = 0; jrow < A.size2(); jrow++) {
      if (jrow == 0) out << "      ";
      out << A(irow,jrow);
      if (jrow != A.size2()-1) out << ",";
      else if (irow != A.size1()-1) out << ";" << std::endl;
      else out << "]" << std::flush;
    }
  }
  return out;
}
}// namespace rheolef
#endif // _RHEOLEF_UBLAS_IO_H
