/*  RipOff - Plugin based CD Ripper
 *  Copyright (C) 2006 Bobby Ryan Newberry
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef RIPOFFPLUGINLIST_H
#define RIPOFFPLUGINLIST_H
#include "lib/RipOff.h"
#include "RipOffPlugin.h"

/*
Copyright (C) 2005 Bobby Ryan Newberry

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

/* simple linked list node containing a RipOffPlugin and a next pointer*/
typedef struct RipOffPluginListNode_ * RipOffPluginListNode;
struct RipOffPluginListNode_
{
	RipOffPlugin plugin; 
	RipOffPluginListNode next;
};

/* beginning is the first node in the list, and endtoadd is where the next node will be added in 
   the list */
struct RipOffPluginList_
{
	RipOffPluginListNode beginning;
	RipOffPluginListNode end;
	RipOffPluginListNode current;
};
typedef struct RipOffPluginList_ * RipOffPluginList;

RipOffPluginList ripoff_plugin_list_new();

/* returns pointer to first plugin in list, NULL if list is empty */
RipOffPlugin ripoff_plugin_list_start(RipOffPluginList list);

/* returns pointer to next plugin in list, NULL if no plugins are left */
RipOffPlugin ripoff_plugin_list_next_plugin(RipOffPluginList list);

/* adds plugin to list */
void ripoff_plugin_list_add_plugin(RipOffPluginList list, RipOffPlugin plugin);

/* checks whether or not the list is empty. returns true if empty, false if not empty */
gboolean ripoff_plugin_list_is_empty(RipOffPluginList list);

#endif
