= Collision Detection
* ((<Collision Detection outline>))
* ((<SDL::CollisionMap>))

* ((<Collision Detection Methods>))
  * ((<SDL::Surface#make_collision_map>)) -- Creates a new collision map
  * ((<SDL::CollisionMap#collision_check>)) -- Does pixel collision detection.
  * ((<SDL::CollisionMap.bounding_box_check>)) -- Checks if two shapes overlap.
  * ((<SDL::CollisionMap#bounding_box_check>)) -- Checks if two shapes overlap.
  * ((<SDL::CollisionMap#clear>)) -- Clears an area in the collision map
  * ((<SDL::CollisionMap#set>)) -- Makes an area in the collision map solid
  * ((<SDL::CollisionMap#w>)) -- Gets width of collision map
  * ((<SDL::CollisionMap#h>)) -- Get height of collision map

== Collision Detection outline
Ruby/SDL has collision detection system
derived from 
((<SGE|URL:http://www.etek.chalmers.se/~e8cal1/sge/index.html>)).
This enables you to pixel-pixel checking after
creating binary image by  ((<SDL::Surface#make_collision_map>)).

Please see sample/collision.rb too.

== SDL::CollisionMap
This class represents binary image used by collision 
detections.
You can create this instance only by 
((<SDL::Surface#make_collision_map>)).

* ((<SDL::CollisionMap#collision_check>)) -- Does pixel collision detection.
* ((<SDL::CollisionMap.bounding_box_check>)) -- Checks if two shapes overlap.
* ((<SDL::CollisionMap#bounding_box_check>)) -- Checks if two shapes overlap.
* ((<SDL::CollisionMap#clear>)) -- Clears an area in the collision map
* ((<SDL::CollisionMap#set>)) -- Makes an area in the collision map solid
* ((<SDL::CollisionMap#w>)) -- Gets width of collision map
* ((<SDL::CollisionMap#h>)) -- Get height of collision map

== Collision Detection Methods

--- SDL::Surface#make_collision_map
--- SDL::Surface#makeCollisionMap

    Creates a new collision map from ((<SDL::Surface>)) object.
    Use ((<SDL::Surface#set_color_key>)) before calling this method.
    Every non-transparent pixel is set to
    solid in the collision map. 
    
    Returns a new ((<SDL::CollisionMap>)) object.

    Raises ((<SDL::Error>)) on failure

    You need SGE to use this method.
    * See Also
      
      ((<SDL::Surface#set_color_key>)), ((<SDL::CollisionMap#collision_check>)), ((<SDL::CollisionMap#clear>)), ((<SDL::CollisionMap#set>))

--- SDL::CollisionMap#collision_check(x1, y1, cmap, x2, y2)

    Does pixel perfect collision detection with 
    ((|self|)) and ((|cmap|)). 
    The (((|x1|)),((|y1|))) and (((|x2|)),((|y2|)))
    coords are the positions of the upper left corners of the
    images. Returns true if any solid
    pixels of the two images overlap or else false.
    
    This method calls ((<SDL::CollisionMap#bounding_box_check>)) 
    internally.


    You need SGE to use this method.
    * See Also
      
      ((<SDL::CollisionMap#bounding_box_check>))

--- SDL::CollisionMap.bounding_box_check(x1,y1,w1,h1,x2,y2,w2,h2)
--- SDL::CollisionMap.boundingBoxCheck(x1,y1,w1,h1,x2,y2,w2,h2)

    
    Checks if two rectangles 
    (((|x1|)), ((|$y1|)), ((|w1|)), ((|h1|))) and
    (((|x2|)), ((|$y2|)), ((|w2|)), ((|h2|))) overlap.

    Returns true if two rectangles overlap, otherwise
    returns false.


    You need SGE to use this method.
    * See Also
      
      ((<SDL::CollisionMap#bounding_box_check>))

--- SDL::CollisionMap#bounding_box_check(x1, y1, cmap, x2, y2)
--- SDL::CollisionMap#boundingBoxCheck(x1, y1, cmap, x2, y2)

    
    Checks if two rectangles 
    (the bounding boxes, ((|self|)) and ((|cmap|))) overlap. 
    The (((|x1|)),((|y1|))) and (((|x2|)),((|y2|)))
    coords are the positions of the upper left corners of the
    images.

    Returns true if two rectangles overlap, otherwise
    returns false.


    You need SGE to use this method.
    * See Also
      
      ((<SDL::CollisionMap.bounding_box_check>)), ((<SDL::CollisionMap#collision_check>)), ((<SDL::CollisionMap#w>)), ((<SDL::CollisionMap#h>))

--- SDL::CollisionMap#clear(x, y, w, h)

    Clears an area in the collision map from anything solid.


    You need SGE to use this method.
    * See Also
      
      ((<SDL::CollisionMap#set>))

--- SDL::CollisionMap#set(x, y, w, h)

    Makes an area in the collision map solid.


    You need SGE to use this method.
    * See Also
      
      ((<SDL::CollisionMap#set>))

--- SDL::CollisionMap#w

    Returns width of collision map.


    You need SGE to use this method.
    * See Also
      
      ((<SDL::CollisionMap#h>))

--- SDL::CollisionMap#h

    Returns height of collision map.


    You need SGE to use this method.
    * See Also
      
      ((<SDL::CollisionMap#w>))

