/*
 * Decompiled with CFR 0.152.
 */
package app.authkit.envoy;

import app.authkit.envoy.Task;
import glguerin.authkit.Authorization;
import glguerin.authkit.imp.plain.DenyAllAuthorization;
import glguerin.util.SinkOutputStream;
import glguerin.util.VectorUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;

public class Envoy {
    public static final String TASKS_BETWEEN = ":-";
    public static final String TASKS_BETWEEN_PROP = "envoy.tasks.between";
    private Authorization myAuth;
    private InputStream myIn;
    private PrintStream myOut;
    protected int myTaskNumber;
    protected int myTaskStatus;
    public static final String PROTOCOL_DELIM = ":";
    public static final String PROTOCOL_NEWLINE = "\n";
    public static final String PROTOCOL_BEGIN_TASK = "task-begin";
    public static final String PROTOCOL_BEGIN_OUTPUT = "text-begin";
    public static final String PROTOCOL_END_OUTPUT = "text-end";
    public static final String PROTOCOL_END_TASK = "task-end";
    public static final String PROTOCOL_STOP = "stop";
    private PrintStream wasOut = null;

    public static void main(String[] stringArray) {
        PrintStream printStream = System.out;
        PrintStream printStream2 = System.err;
        try {
            Envoy envoy = new Envoy();
            envoy.prepare();
            envoy.perform(stringArray);
            System.exit(envoy.finish());
        }
        catch (Throwable throwable) {
            printStream.flush();
            throwable.printStackTrace(printStream2);
            printStream2.flush();
            System.exit(1);
        }
    }

    public void explain(Throwable throwable) {
        this.protocolOut().flush();
        throwable.printStackTrace(System.err);
        System.err.flush();
    }

    public void prepare() {
        this.protocolBegins();
        this.prepareTaskIO();
        this.myAuth = this.buildAuth();
    }

    public void perform(String[] stringArray) {
        String string = System.getProperty(TASKS_BETWEEN_PROP, TASKS_BETWEEN);
        Enumeration enumeration = VectorUtil.asVector(stringArray, false).elements();
        Vector vector = new Vector(stringArray.length);
        this.myTaskStatus = 0;
        this.myTaskNumber = 1;
        while (enumeration.hasMoreElements()) {
            this.groupTaskArgs(enumeration, vector, string);
            if (vector.size() == 0) continue;
            this.myTaskStatus = this.taskPerform(this.myTaskNumber, vector);
            if (this.myTaskStatus != 0) {
                return;
            }
            ++this.myTaskNumber;
        }
    }

    public int finish() {
        this.protocolEnds();
        return this.myTaskStatus;
    }

    protected void groupTaskArgs(Enumeration enumeration, Vector vector, String string) {
        vector.removeAllElements();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement().toString();
            if (string2.equals(string)) break;
            vector.addElement(string2);
        }
    }

    protected int taskPerform(int n, Vector vector) {
        if (vector.size() == 0) {
            throw new IllegalArgumentException("No Task");
        }
        String string = "No Task";
        Task task = null;
        boolean bl = false;
        int n2 = 0;
        try {
            try {
                string = vector.firstElement().toString();
                vector.removeElementAt(0);
                Object[] objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
                this.taskBegins(n, string);
                task = (Task)Class.forName(string).newInstance();
                bl = task.producesOutput();
                if (bl) {
                    this.taskBeginsOutput(n, task);
                }
                n2 = task.perform((String[])objectArray, this.getAuthorization());
            }
            catch (Throwable throwable) {
                n2 = -1;
                this.explain(throwable);
                Object var9_10 = null;
                if (bl) {
                    this.taskEndsOutput(n, task);
                }
            }
            Object var9_9 = null;
            if (bl) {
                this.taskEndsOutput(n, task);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (bl) {
                this.taskEndsOutput(n, task);
            }
            throw throwable;
        }
        if (n2 == 0) {
            this.taskEnds(n, task, n2);
        } else {
            this.taskFails(n, task, n2);
        }
        return n2;
    }

    protected Authorization getAuthorization() {
        return this.myAuth;
    }

    protected Authorization buildAuth() {
        Authorization authorization = this.newAuth();
        authorization.attachPrivileged();
        return authorization;
    }

    protected Authorization newAuth() {
        String string = "glguerin.authkit.imp.plain.DenyAllAuthorization";
        if ("Mac OS X".equals(System.getProperty("os.name"))) {
            string = "glguerin.authkit.imp.macosx.MacOSXAuthorization";
        }
        try {
            return (Authorization)Class.forName(string).newInstance();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            this.explain(throwable);
            return new DenyAllAuthorization();
        }
    }

    protected InputStream protocolIn() {
        return this.myIn;
    }

    protected PrintStream protocolOut() {
        return this.myOut;
    }

    protected void protocolBegins() {
        this.myIn = System.in;
        this.myOut = System.out;
    }

    protected void prepareTaskIO() {
        System.setOut(new PrintStream(new SinkOutputStream()));
        System.setIn(new ByteArrayInputStream(new byte[0]));
    }

    protected void protocolEnds() {
        PrintStream printStream = this.protocolOut();
        printStream.print("stop:0:" + this.myTaskStatus);
        printStream.print(PROTOCOL_NEWLINE);
        printStream.flush();
    }

    protected void taskBegins(int n, String string) {
        PrintStream printStream = this.protocolOut();
        printStream.print("task-begin:" + n + PROTOCOL_DELIM + string);
        printStream.print(PROTOCOL_NEWLINE);
        printStream.flush();
    }

    protected void taskBeginsOutput(int n, Task task) {
        if (this.wasOut != null) {
            throw new IllegalStateException();
        }
        PrintStream printStream = this.protocolOut();
        printStream.print("text-begin:" + n);
        printStream.print(PROTOCOL_NEWLINE);
        printStream.flush();
        this.wasOut = System.out;
        System.setOut(this.protocolOut());
    }

    protected void taskEndsOutput(int n, Task task) {
        System.out.flush();
        PrintStream printStream = this.wasOut;
        this.wasOut = null;
        if (printStream == null) {
            throw new IllegalStateException();
        }
        System.setOut(printStream);
        PrintStream printStream2 = this.protocolOut();
        printStream2.print("text-end:" + n);
        printStream2.print(PROTOCOL_NEWLINE);
        printStream2.flush();
    }

    protected void taskEnds(int n, Task task, int n2) {
        PrintStream printStream = this.protocolOut();
        printStream.print("task-end:" + n + PROTOCOL_DELIM + n2);
        printStream.print(PROTOCOL_NEWLINE);
        printStream.flush();
    }

    protected void taskFails(int n, Task task, int n2) {
        PrintStream printStream = this.protocolOut();
        printStream.print("task-end:" + n + PROTOCOL_DELIM + n2);
        printStream.print(PROTOCOL_NEWLINE);
        printStream.flush();
    }
}

