'''Protocol mapping (SiriDB version 2.0.x)

:copyright: 2016, Jeroen van der Heijden (Transceptor Technology)
'''

# data types
DTYPE_NONE = 0
DTYPE_QPACK = 1
DTYPE_FILE = 2

# SiriDB Client protocol client request types
CPROTO_REQ_QUERY = 0
CPROTO_REQ_INSERT = 1
CPROTO_REQ_AUTH = 2
CPROTO_REQ_PING = 3
CPROTO_REQ_INFO = 4
CPROTO_REQ_LOADDB = 5
CPROTO_REQ_REGISTER_SERVER = 6
CPROTO_REQ_FILE_SERVERS = 7
CPROTO_REQ_FILE_USERS = 8
CPROTO_REQ_FILE_GROUPS = 9

MAP_REQ_DTYPE = {
    # SiriDB Client protocol client request types
    CPROTO_REQ_QUERY: DTYPE_QPACK,
    CPROTO_REQ_INSERT: DTYPE_QPACK,
    CPROTO_REQ_AUTH: DTYPE_QPACK,
    CPROTO_REQ_PING: DTYPE_NONE,
    CPROTO_REQ_INFO: DTYPE_NONE,
    CPROTO_REQ_LOADDB: DTYPE_QPACK,
    CPROTO_REQ_REGISTER_SERVER: DTYPE_QPACK,
    CPROTO_REQ_FILE_SERVERS: DTYPE_NONE,
    CPROTO_REQ_FILE_USERS: DTYPE_NONE,
    CPROTO_REQ_FILE_GROUPS: DTYPE_NONE
}

TEXT_REQ_MAP = {
    CPROTO_REQ_QUERY: 'CPROTO_REQ_QUERY',
    CPROTO_REQ_INSERT: 'CPROTO_REQ_INSERT',
    CPROTO_REQ_AUTH: 'CPROTO_REQ_AUTH',
    CPROTO_REQ_PING: 'CPROTO_REQ_PING',
    CPROTO_REQ_INFO: 'CPROTO_REQ_INFO',
    CPROTO_REQ_LOADDB: 'CPROTO_REQ_LOADDB',
    CPROTO_REQ_REGISTER_SERVER: 'CPROTO_REQ_REGISTER_SERVER',
    CPROTO_REQ_FILE_SERVERS: 'CPROTO_REQ_FILE_SERVERS',
    CPROTO_REQ_FILE_USERS: 'CPROTO_REQ_FILE_USERS',
    CPROTO_REQ_FILE_GROUPS: 'CPROTO_REQ_FILE_GROUPS'
}

# SiriDB Client protocol success server response types
CPROTO_RES_QUERY = 0
CPROTO_RES_INSERT = 1
CPROTO_RES_AUTH_SUCCESS = 2
CPROTO_RES_ACK = 3
CPROTO_RES_INFO = 4
CPROTO_RES_FILE = 5

# SiriDB Client protocol error server response types
CPROTO_ERR_MSG = 64
CPROTO_ERR_QUERY = 65
CPROTO_ERR_INSERT = 66
CPROTO_ERR_SERVER = 67
CPROTO_ERR_POOL = 68
CPROTO_ERR_USER_ACCESS = 69
CPROTO_ERR = 70
CPROTO_ERR_NOT_AUTHENTICATED = 71
CPROTO_ERR_AUTH_CREDENTIALS = 72
CPROTO_ERR_AUTH_UNKNOWN_DB = 73
CPROTO_ERR_LOADING_DB = 74
CPROTO_ERR_FILE = 75

# mapping between package types and data types
MAP_RES_DTYPE = {
    # SiriDB Client protocol success server response types
    CPROTO_RES_QUERY: DTYPE_QPACK,
    CPROTO_RES_INSERT: DTYPE_QPACK,
    CPROTO_RES_AUTH_SUCCESS: DTYPE_NONE,
    CPROTO_RES_ACK: DTYPE_NONE,
    CPROTO_RES_INFO: DTYPE_QPACK,
    CPROTO_RES_FILE: DTYPE_FILE,

    # SiriDB Client protocol error server response types
    CPROTO_ERR_MSG: DTYPE_QPACK,
    CPROTO_ERR_QUERY: DTYPE_QPACK,
    CPROTO_ERR_INSERT: DTYPE_QPACK,
    CPROTO_ERR_SERVER: DTYPE_QPACK,
    CPROTO_ERR_POOL: DTYPE_QPACK,
    CPROTO_ERR_USER_ACCESS: DTYPE_QPACK,
    CPROTO_ERR: DTYPE_NONE,
    CPROTO_ERR_NOT_AUTHENTICATED: DTYPE_NONE,
    CPROTO_ERR_AUTH_CREDENTIALS: DTYPE_NONE,
    CPROTO_ERR_AUTH_UNKNOWN_DB: DTYPE_NONE,
    CPROTO_ERR_LOADING_DB: DTYPE_NONE,
    CPROTO_ERR_FILE: DTYPE_NONE
}

TEXT_RES_MAP = {
    # SiriDB Client protocol success response types
    CPROTO_RES_QUERY: 'CPROTO_RES_QUERY',
    CPROTO_RES_INSERT: 'CPROTO_RES_INSERT',
    CPROTO_RES_AUTH_SUCCESS: 'CPROTO_RES_AUTH_SUCCESS',
    CPROTO_RES_ACK: 'CPROTO_RES_ACK',
    CPROTO_RES_INFO: 'CPROTO_RES_INFO',
    CPROTO_RES_FILE: 'CPROTO_RES_FILE',

    # SiriDB Client protocol error response types
    CPROTO_ERR_MSG: 'CPROTO_ERR_MSG',
    CPROTO_ERR_QUERY: 'CPROTO_ERR_QUERY',
    CPROTO_ERR_INSERT: 'CPROTO_ERR_INSERT',
    CPROTO_ERR_SERVER: 'CPROTO_ERR_SERVER',
    CPROTO_ERR_POOL: 'CPROTO_ERR_POOL',
    CPROTO_ERR_USER_ACCESS: 'CPROTO_ERR_USER_ACCESS',
    CPROTO_ERR: 'CPROTO_ERR',
    CPROTO_ERR_NOT_AUTHENTICATED: 'CPROTO_ERR_NOT_AUTHENTICATED',
    CPROTO_ERR_AUTH_CREDENTIALS: 'CPROTO_ERR_AUTH_CREDENTIALS',
    CPROTO_ERR_AUTH_UNKNOWN_DB: 'CPROTO_ERR_AUTH_UNKNOWN_DB',
    CPROTO_ERR_LOADING_DB: 'CPROTO_ERR_LOADING_DB',
    CPROTO_ERR_FILE: 'CPROTO_ERR_FILE'
}

# mapping used to find a file name for a package type
FILE_MAP = {
    'servers.dat': CPROTO_REQ_FILE_SERVERS,
    'users.dat': CPROTO_REQ_FILE_USERS,
    'groups.dat': CPROTO_REQ_FILE_GROUPS
}


