# Translating Solaar

First, make sure you have installed the `gettext` package.

Here are the steps to add/update a translation (you should run all scripts from
the source root):

1. Get an up-to-date copy of the source files. Preferrably, make a clone on
   GitHub and clone it locally on your machine; this way you can later make a
   pull request to the main project.

2. Run `./tools/po-update.sh <language>`; it will create/update the file
   `./po/<language>.po`.

3. Edit `./po/<language>.po` with your favourite editor (just make sure it saves
   the file with the UTF-8 encoding). For each string in english (msgid), edit
   the translation (msgstr); if you leave msgstr empty, the string will remain
   untranslated.

   Alternatively, you can use the excellent `poedit`.

4. Run `./tools/po-compile.sh`. It will bring up-to-date all the compiled
   language files, necessary at runtime.

5. Start Solaar (`./bin/solaar`). By default it will pick up the system languge
   from your environment; to start it in another language, run
   `LANGUAGE=<language> ./bin/solaar`.

You can edit the translation iteratively, just repeat from step 3.
If the upstream changes, do a `git pull` and then repeat from step 2.
