-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with Ada.Command_Line;

package body SPARK.Ada.Command_Line.Unbounded_String is
   --# hide SPARK.Ada.Command_Line.Unbounded_String;

   function Argument (Number : Positive)
                     return Strings.Unbounded.Unbounded_String is
   begin
      return SPARK.Ada.Strings.Unbounded.String_To_Unbounded_String
        (Source => Standard.Ada.Command_Line.Argument (Number => Number));
   end Argument;

   function Command_Name return Strings.Unbounded.Unbounded_String is
   begin
      return SPARK.Ada.Strings.Unbounded.String_To_Unbounded_String
        (Source => Standard.Ada.Command_Line.Command_Name);
   end Command_Name;

end SPARK.Ada.Command_Line.Unbounded_String;
