/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Mon Jan 25 12:52:11 2021

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_49 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 23843, "epsg", 23843,
        "DGN95 / Indonesia TM-3 zone 53.1", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=133.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 53.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4755\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",133.5],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",200000],PARAMETER[\"false_northing\",150");
    add_srs_wkt (p, 10,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"23843\"]]");
    p = add_epsg_def_ex (filter, first, last, 23844, "epsg", 23844,
        "DGN95 / Indonesia TM-3 zone 53.2", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=136.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 53.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4755\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",136.5],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",200000],PARAMETER[\"false_northing\",150");
    add_srs_wkt (p, 10,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"23844\"]]");
    p = add_epsg_def_ex (filter, first, last, 23845, "epsg", 23845,
        "DGN95 / Indonesia TM-3 zone 54.1", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=139.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 54.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4755\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",139.5],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",200000],PARAMETER[\"false_northing\",150");
    add_srs_wkt (p, 10,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"23845\"]]");
    p = add_epsg_def_ex (filter, first, last, 23846, "epsg", 23846,
        "ID74 / UTM zone 46N", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 46N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6238\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4238\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"238");
    add_srs_wkt (p, 12,
        "46\"]]");
    p = add_epsg_def_ex (filter, first, last, 23847, "epsg", 23847,
        "ID74 / UTM zone 47N", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 47N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6238\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4238\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"238");
    add_srs_wkt (p, 12,
        "47\"]]");
    p = add_epsg_def_ex (filter, first, last, 23848, "epsg", 23848,
        "ID74 / UTM zone 48N", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 48N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6238\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4238\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "05],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "3848\"]]");
    p = add_epsg_def_ex (filter, first, last, 23849, "epsg", 23849,
        "ID74 / UTM zone 49N", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 49N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6238\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4238\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "11],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "3849\"]]");
    p = add_epsg_def_ex (filter, first, last, 23850, "epsg", 23850,
        "ID74 / UTM zone 50N", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 50N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6238\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4238\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "17],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "3850\"]]");
    p = add_epsg_def_ex (filter, first, last, 23851, "epsg", 23851,
        "ID74 / UTM zone 51N", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 51N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6238\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4238\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "23],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "3851\"]]");
    p = add_epsg_def_ex (filter, first, last, 23852, "epsg", 23852,
        "ID74 / UTM zone 52N", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 52N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6238\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4238\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "29],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "3852\"]]");
    p = add_epsg_def_ex (filter, first, last, 23853, "epsg", 23853,
        "ID74 / UTM zone 53N (deprecated)", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 53N (deprecated)\",GEOGCS[\"ID7");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"Indonesian_Datum_1974\",SPHEROID[\"Indonesia");
    add_srs_wkt (p, 2,
        "n National Spheroid\",6378160,298.247,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7021\"]],AUTHORITY[\"EPSG\",\"6238\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4238\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",135],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"23853\"]]");
    p = add_epsg_def_ex (filter, first, last, 23866, "epsg", 23866,
        "DGN95 / UTM zone 46N", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 46N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6755\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4755\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",0],PARAMETER[\"central_meridian\",93],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 10,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"23866\"]]");
    p = add_epsg_def_ex (filter, first, last, 23867, "epsg", 23867,
        "DGN95 / UTM zone 47N", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 47N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6755\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4755\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",0],PARAMETER[\"central_meridian\",99],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 10,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"23867\"]]");
    p = add_epsg_def_ex (filter, first, last, 23868, "epsg", 23868,
        "DGN95 / UTM zone 48N", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 48N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6755\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4755\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",0],PARAMETER[\"central_meridian\",105],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"23868\"]]");
    p = add_epsg_def_ex (filter, first, last, 23869, "epsg", 23869,
        "DGN95 / UTM zone 49N", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 49N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6755\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4755\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",0],PARAMETER[\"central_meridian\",111],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"23869\"]]");
    p = add_epsg_def_ex (filter, first, last, 23870, "epsg", 23870,
        "DGN95 / UTM zone 50N", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 50N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6755\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4755\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",0],PARAMETER[\"central_meridian\",117],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"23870\"]]");
    p = add_epsg_def_ex (filter, first, last, 23871, "epsg", 23871,
        "DGN95 / UTM zone 51N", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 51N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6755\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4755\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",0],PARAMETER[\"central_meridian\",123],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"23871\"]]");
    p = add_epsg_def_ex (filter, first, last, 23872, "epsg", 23872,
        "DGN95 / UTM zone 52N", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 52N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6755\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4755\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",0],PARAMETER[\"central_meridian\",129],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"23872\"]]");
    p = add_epsg_def_ex (filter, first, last, 23877, "epsg", 23877,
        "DGN95 / UTM zone 47S", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 47S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6755\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4755\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",0],PARAMETER[\"central_meridian\",99],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",500000],PARAMETER[\"false_northing\",10000000],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 11,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2387");
    add_srs_wkt (p, 12,
        "7\"]]");
    p = add_epsg_def_ex (filter, first, last, 23878, "epsg", 23878,
        "DGN95 / UTM zone 48S", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 48S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6755\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4755\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",0],PARAMETER[\"central_meridian\",105],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",500000],PARAMETER[\"false_northing\",10000000],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"238");
    add_srs_wkt (p, 12,
        "78\"]]");
    p = add_epsg_def_ex (filter, first, last, 23879, "epsg", 23879,
        "DGN95 / UTM zone 49S", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 49S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6755\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4755\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",0],PARAMETER[\"central_meridian\",111],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",500000],PARAMETER[\"false_northing\",10000000],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"238");
    add_srs_wkt (p, 12,
        "79\"]]");
    p = add_epsg_def_ex (filter, first, last, 23880, "epsg", 23880,
        "DGN95 / UTM zone 50S", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 50S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6755\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4755\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",0],PARAMETER[\"central_meridian\",117],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",500000],PARAMETER[\"false_northing\",10000000],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"238");
    add_srs_wkt (p, 12,
        "80\"]]");
    p = add_epsg_def_ex (filter, first, last, 23881, "epsg", 23881,
        "DGN95 / UTM zone 51S", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 51S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6755\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4755\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",0],PARAMETER[\"central_meridian\",123],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",500000],PARAMETER[\"false_northing\",10000000],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"238");
    add_srs_wkt (p, 12,
        "81\"]]");
    p = add_epsg_def_ex (filter, first, last, 23882, "epsg", 23882,
        "DGN95 / UTM zone 52S", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 52S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6755\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4755\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",0],PARAMETER[\"central_meridian\",129],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",500000],PARAMETER[\"false_northing\",10000000],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"238");
    add_srs_wkt (p, 12,
        "82\"]]");
    p = add_epsg_def_ex (filter, first, last, 23883, "epsg", 23883,
        "DGN95 / UTM zone 53S", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 53S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6755\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4755\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",0],PARAMETER[\"central_meridian\",135],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",500000],PARAMETER[\"false_northing\",10000000],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"238");
    add_srs_wkt (p, 12,
        "83\"]]");
    p = add_epsg_def_ex (filter, first, last, 23884, "epsg", 23884,
        "DGN95 / UTM zone 54S", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 54S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6755\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4755\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",0],PARAMETER[\"central_meridian\",141],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",500000],PARAMETER[\"false_northing\",10000000],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"238");
    add_srs_wkt (p, 12,
        "84\"]]");
    p = add_epsg_def_ex (filter, first, last, 23886, "epsg", 23886,
        "ID74 / UTM zone 46S (deprecated)", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 46S (deprecated)\",GEOGCS[\"ID7");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"Indonesian_Datum_1974\",SPHEROID[\"Indonesia");
    add_srs_wkt (p, 2,
        "n National Spheroid\",6378160,298.247,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7021\"]],AUTHORITY[\"EPSG\",\"6238\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4238\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",93],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"23886\"]]");
    p = add_epsg_def_ex (filter, first, last, 23887, "epsg", 23887,
        "ID74 / UTM zone 47S", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 47S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6238\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4238\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"23887\"]]");
    p = add_epsg_def_ex (filter, first, last, 23888, "epsg", 23888,
        "ID74 / UTM zone 48S", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 48S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6238\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4238\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "05],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"23888\"]]");
    p = add_epsg_def_ex (filter, first, last, 23889, "epsg", 23889,
        "ID74 / UTM zone 49S", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 49S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6238\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4238\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "11],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"23889\"]]");
    p = add_epsg_def_ex (filter, first, last, 23890, "epsg", 23890,
        "ID74 / UTM zone 50S", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 50S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6238\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4238\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "17],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"23890\"]]");
    p = add_epsg_def_ex (filter, first, last, 23891, "epsg", 23891,
        "ID74 / UTM zone 51S", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 51S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6238\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4238\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "23],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"23891\"]]");
    p = add_epsg_def_ex (filter, first, last, 23892, "epsg", 23892,
        "ID74 / UTM zone 52S", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 52S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6238\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4238\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "29],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"23892\"]]");
    p = add_epsg_def_ex (filter, first, last, 23893, "epsg", 23893,
        "ID74 / UTM zone 53S", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 53S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6238\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4238\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "35],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"23893\"]]");
    p = add_epsg_def_ex (filter, first, last, 23894, "epsg", 23894,
        "ID74 / UTM zone 54S", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 54S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6238\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4238\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "41],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"23894\"]]");
    p = add_epsg_def_ex (filter, first, last, 23946, "epsg", 23946,
        "Indian 1954 / UTM zone 46N", 0, 0,
        "Everest 1830 (1937 Adjustment)", "Greenwich",
        "Indian_1954", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +a=6377276.345 +b=6356075.41314024 +t");
    add_proj4text (p, 1,
        "owgs84=217,823,299,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Indian 1954 / UTM zone 46N\",GEOGCS[\"Indian 19");
    add_srs_wkt (p, 1,
        "54\",DATUM[\"Indian_1954\",SPHEROID[\"Everest 1830 (1937");
    add_srs_wkt (p, 2,
        " Adjustment)\",6377276.345,300.8017,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7015\"]],AUTHORITY[\"EPSG\",\"6239\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4239\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",93],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"23946\"]]");
    p = add_epsg_def_ex (filter, first, last, 23947, "epsg", 23947,
        "Indian 1954 / UTM zone 47N", 0, 0,
        "Everest 1830 (1937 Adjustment)", "Greenwich",
        "Indian_1954", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +a=6377276.345 +b=6356075.41314024 +t");
    add_proj4text (p, 1,
        "owgs84=217,823,299,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Indian 1954 / UTM zone 47N\",GEOGCS[\"Indian 19");
    add_srs_wkt (p, 1,
        "54\",DATUM[\"Indian_1954\",SPHEROID[\"Everest 1830 (1937");
    add_srs_wkt (p, 2,
        " Adjustment)\",6377276.345,300.8017,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7015\"]],AUTHORITY[\"EPSG\",\"6239\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4239\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",99],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"23947\"]]");
    p = add_epsg_def_ex (filter, first, last, 23948, "epsg", 23948,
        "Indian 1954 / UTM zone 48N", 0, 0,
        "Everest 1830 (1937 Adjustment)", "Greenwich",
        "Indian_1954", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +a=6377276.345 +b=6356075.41314024 +t");
    add_proj4text (p, 1,
        "owgs84=217,823,299,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Indian 1954 / UTM zone 48N\",GEOGCS[\"Indian 19");
    add_srs_wkt (p, 1,
        "54\",DATUM[\"Indian_1954\",SPHEROID[\"Everest 1830 (1937");
    add_srs_wkt (p, 2,
        " Adjustment)\",6377276.345,300.8017,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7015\"]],AUTHORITY[\"EPSG\",\"6239\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4239\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",105],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"23948\"]]");
    p = add_epsg_def_ex (filter, first, last, 24047, "epsg", 24047,
        "Indian 1975 / UTM zone 47N", 0, 0,
        "Everest 1830 (1937 Adjustment)", "Greenwich",
        "Indian_1975", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +a=6377276.345 +b=6356075.41314024 +t");
    add_proj4text (p, 1,
        "owgs84=210,814,289,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Indian 1975 / UTM zone 47N\",GEOGCS[\"Indian 19");
    add_srs_wkt (p, 1,
        "75\",DATUM[\"Indian_1975\",SPHEROID[\"Everest 1830 (1937");
    add_srs_wkt (p, 2,
        " Adjustment)\",6377276.345,300.8017,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7015\"]],AUTHORITY[\"EPSG\",\"6240\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4240\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",99],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"24047\"]]");
    p = add_epsg_def_ex (filter, first, last, 24048, "epsg", 24048,
        "Indian 1975 / UTM zone 48N", 0, 0,
        "Everest 1830 (1937 Adjustment)", "Greenwich",
        "Indian_1975", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +a=6377276.345 +b=6356075.41314024 +t");
    add_proj4text (p, 1,
        "owgs84=210,814,289,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Indian 1975 / UTM zone 48N\",GEOGCS[\"Indian 19");
    add_srs_wkt (p, 1,
        "75\",DATUM[\"Indian_1975\",SPHEROID[\"Everest 1830 (1937");
    add_srs_wkt (p, 2,
        " Adjustment)\",6377276.345,300.8017,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7015\"]],AUTHORITY[\"EPSG\",\"6240\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4240\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",105],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"24048\"]]");
    p = add_epsg_def_ex (filter, first, last, 24100, "epsg", 24100,
        "Jamaica 1875 / Jamaica (Old Grid)", 0, 0,
        "Clarke 1880", "Greenwich",
        "Jamaica_1875", "Lambert_Conformal_Conic_1SP", "Clarke's foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=18 +lat_0=18 +lon_0=-77 +k_0=1 +x_0=167");
    add_proj4text (p, 1,
        "638.49597 +y_0=121918.90616 +a=6378249.144808011 +b=6356");
    add_proj4text (p, 2,
        "514.966204134 +to_meter=0.3047972654 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Jamaica 1875 / Jamaica (Old Grid)\",GEOGCS[\"Ja");
    add_srs_wkt (p, 1,
        "maica 1875\",DATUM[\"Jamaica_1875\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "80\",6378249.14480801,293.466307655636,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7034\"]],AUTHORITY[\"EPSG\",\"6241\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4241\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_1SP\"],PARAMETER[\"latitude_of_origin\",18],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-77],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",550000],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",400000],UNIT[\"Clarke's foot\",0.3047972654,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9005\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24100\"]]");
    p = add_epsg_def_ex (filter, first, last, 24200, "epsg", 24200,
        "JAD69 / Jamaica National Grid", 0, 0,
        "Clarke 1866", "Greenwich",
        "Jamaica_1969", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=18 +lat_0=18 +lon_0=-77 +k_0=1 +x_0=250");
    add_proj4text (p, 1,
        "000 +y_0=150000 +ellps=clrk66 +towgs84=70,207,389.5,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JAD69 / Jamaica National Grid\",GEOGCS[\"JAD69\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Jamaica_1969\",SPHEROID[\"Clarke 1866\",6378206");
    add_srs_wkt (p, 2,
        ".4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6242\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4242\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",18],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-77],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",250000],PARAMETER[\"false_northing\",150000],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 11,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"24200\"]]");
    p = add_epsg_def_ex (filter, first, last, 24305, "epsg", 24305,
        "Kalianpur 1937 / UTM zone 45N", 0, 0,
        "Everest 1830 (1937 Adjustment)", "Greenwich",
        "Kalianpur_1937", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=45 +a=6377276.345 +b=6356075.41314024 +t");
    add_proj4text (p, 1,
        "owgs84=214,804,268,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1937 / UTM zone 45N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1937\",DATUM[\"Kalianpur_1937\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1937 Adjustment)\",6377276.345,300.8017,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7015\"]],AUTHORITY[\"EPSG\",\"6144\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4144\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",87],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"24305\"]]");
    p = add_epsg_def_ex (filter, first, last, 24306, "epsg", 24306,
        "Kalianpur 1937 / UTM zone 46N", 0, 0,
        "Everest 1830 (1937 Adjustment)", "Greenwich",
        "Kalianpur_1937", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +a=6377276.345 +b=6356075.41314024 +t");
    add_proj4text (p, 1,
        "owgs84=214,804,268,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1937 / UTM zone 46N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1937\",DATUM[\"Kalianpur_1937\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1937 Adjustment)\",6377276.345,300.8017,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7015\"]],AUTHORITY[\"EPSG\",\"6144\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4144\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",93],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"24306\"]]");
    p = add_epsg_def_ex (filter, first, last, 24311, "epsg", 24311,
        "Kalianpur 1962 / UTM zone 41N", 0, 0,
        "Everest 1830 (1962 Definition)", "Greenwich",
        "Kalianpur_1962", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=41 +a=6377301.243 +b=6356100.230165384 +");
    add_proj4text (p, 1,
        "towgs84=283,682,231,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1962 / UTM zone 41N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1962\",DATUM[\"Kalianpur_1962\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1962 Definition)\",6377301.243,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7044\"]],AUTHORITY[\"EPSG\",\"6145\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4145\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",63],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 9,
        "9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"24311\"]]");
    p = add_epsg_def_ex (filter, first, last, 24312, "epsg", 24312,
        "Kalianpur 1962 / UTM zone 42N", 0, 0,
        "Everest 1830 (1962 Definition)", "Greenwich",
        "Kalianpur_1962", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=42 +a=6377301.243 +b=6356100.230165384 +");
    add_proj4text (p, 1,
        "towgs84=283,682,231,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1962 / UTM zone 42N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1962\",DATUM[\"Kalianpur_1962\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1962 Definition)\",6377301.243,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7044\"]],AUTHORITY[\"EPSG\",\"6145\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4145\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",69],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 9,
        "9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"24312\"]]");
    p = add_epsg_def_ex (filter, first, last, 24313, "epsg", 24313,
        "Kalianpur 1962 / UTM zone 43N", 0, 0,
        "Everest 1830 (1962 Definition)", "Greenwich",
        "Kalianpur_1962", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=43 +a=6377301.243 +b=6356100.230165384 +");
    add_proj4text (p, 1,
        "towgs84=283,682,231,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1962 / UTM zone 43N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1962\",DATUM[\"Kalianpur_1962\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1962 Definition)\",6377301.243,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7044\"]],AUTHORITY[\"EPSG\",\"6145\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4145\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",75],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 9,
        "9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"24313\"]]");
    p = add_epsg_def_ex (filter, first, last, 24342, "epsg", 24342,
        "Kalianpur 1975 / UTM zone 42N", 0, 0,
        "Everest 1830 (1975 Definition)", "Greenwich",
        "Kalianpur_1975", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=42 +a=6377299.151 +b=6356098.145120132 +");
    add_proj4text (p, 1,
        "towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / UTM zone 42N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1975 Definition)\",6377299.151,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7045\"]],AUTHORITY[\"EPSG\",\"6146\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4146\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",69],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 9,
        "9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"24342\"]]");
    p = add_epsg_def_ex (filter, first, last, 24343, "epsg", 24343,
        "Kalianpur 1975 / UTM zone 43N", 0, 0,
        "Everest 1830 (1975 Definition)", "Greenwich",
        "Kalianpur_1975", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=43 +a=6377299.151 +b=6356098.145120132 +");
    add_proj4text (p, 1,
        "towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / UTM zone 43N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1975 Definition)\",6377299.151,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7045\"]],AUTHORITY[\"EPSG\",\"6146\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4146\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",75],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 9,
        "9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"24343\"]]");
    p = add_epsg_def_ex (filter, first, last, 24344, "epsg", 24344,
        "Kalianpur 1975 / UTM zone 44N", 0, 0,
        "Everest 1830 (1975 Definition)", "Greenwich",
        "Kalianpur_1975", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=44 +a=6377299.151 +b=6356098.145120132 +");
    add_proj4text (p, 1,
        "towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / UTM zone 44N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1975 Definition)\",6377299.151,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7045\"]],AUTHORITY[\"EPSG\",\"6146\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4146\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",81],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 9,
        "9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"24344\"]]");
    p = add_epsg_def_ex (filter, first, last, 24345, "epsg", 24345,
        "Kalianpur 1975 / UTM zone 45N", 0, 0,
        "Everest 1830 (1975 Definition)", "Greenwich",
        "Kalianpur_1975", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=45 +a=6377299.151 +b=6356098.145120132 +");
    add_proj4text (p, 1,
        "towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / UTM zone 45N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1975 Definition)\",6377299.151,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7045\"]],AUTHORITY[\"EPSG\",\"6146\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4146\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",87],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 9,
        "9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"24345\"]]");
    p = add_epsg_def_ex (filter, first, last, 24346, "epsg", 24346,
        "Kalianpur 1975 / UTM zone 46N", 0, 0,
        "Everest 1830 (1975 Definition)", "Greenwich",
        "Kalianpur_1975", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +a=6377299.151 +b=6356098.145120132 +");
    add_proj4text (p, 1,
        "towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / UTM zone 46N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1975 Definition)\",6377299.151,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7045\"]],AUTHORITY[\"EPSG\",\"6146\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4146\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",93],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 9,
        "9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"24346\"]]");
    p = add_epsg_def_ex (filter, first, last, 24347, "epsg", 24347,
        "Kalianpur 1975 / UTM zone 47N", 0, 0,
        "Everest 1830 (1975 Definition)", "Greenwich",
        "Kalianpur_1975", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +a=6377299.151 +b=6356098.145120132 +");
    add_proj4text (p, 1,
        "towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / UTM zone 47N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1975 Definition)\",6377299.151,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7045\"]],AUTHORITY[\"EPSG\",\"6146\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4146\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",99],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 9,
        "9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"24347\"]]");
    p = add_epsg_def_ex (filter, first, last, 24370, "epsg", 24370,
        "Kalianpur 1880 / India zone 0", 0, 0,
        "Everest (1830 Definition)", "Greenwich",
        "Kalianpur_1880", "Lambert_Conformal_Conic_1SP", "Indian yard",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.5 +lat_0=39.5 +lon_0=68 +k_0=0.99846");
    add_proj4text (p, 1,
        "154 +x_0=2153865.73916853 +y_0=2368292.194628102 +a=6377");
    add_proj4text (p, 2,
        "299.36559538 +b=6356098.359005156 +to_meter=0.9143985307");
    add_proj4text (p, 3,
        "444408 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1880 / India zone 0\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1880\",DATUM[\"Kalianpur_1880\",SPHEROID[\"Everest (");
    add_srs_wkt (p, 2,
        "1830 Definition)\",6377299.36559538,300.801725543355,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7042\"]],AUTHORITY[\"EPSG\",\"6243\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4243\"]],PROJECTION[\"Lamber");
    add_srs_wkt (p, 7,
        "t_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",39.5],PARAMETER[\"central_meridian\",68],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",0.99846154],PARAMETER[\"false_easting\",235");
    add_srs_wkt (p, 10,
        "5500],PARAMETER[\"false_northing\",2590000],UNIT[\"India");
    add_srs_wkt (p, 11,
        "n yard\",0.914398530744441,AUTHORITY[\"EPSG\",\"9084\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"24370\"]]");
    p = add_epsg_def_ex (filter, first, last, 24371, "epsg", 24371,
        "Kalianpur 1880 / India zone I", 0, 0,
        "Everest (1830 Definition)", "Greenwich",
        "Kalianpur_1880", "Lambert_Conformal_Conic_1SP", "Indian yard",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=68 +k_0=0.99878");
    add_proj4text (p, 1,
        "641 +x_0=2743195.592233322 +y_0=914398.5307444407 +a=637");
    add_proj4text (p, 2,
        "7299.36559538 +b=6356098.359005156 +to_meter=0.914398530");
    add_proj4text (p, 3,
        "7444408 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1880 / India zone I\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1880\",DATUM[\"Kalianpur_1880\",SPHEROID[\"Everest (");
    add_srs_wkt (p, 2,
        "1830 Definition)\",6377299.36559538,300.801725543355,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7042\"]],AUTHORITY[\"EPSG\",\"6243\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4243\"]],PROJECTION[\"Lamber");
    add_srs_wkt (p, 7,
        "t_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",32.5],PARAMETER[\"central_meridian\",68],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",0.99878641],PARAMETER[\"false_easting\",300");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",1000000],UNIT[\"India");
    add_srs_wkt (p, 11,
        "n yard\",0.914398530744441,AUTHORITY[\"EPSG\",\"9084\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"24371\"]]");
    p = add_epsg_def_ex (filter, first, last, 24372, "epsg", 24372,
        "Kalianpur 1880 / India zone IIa", 0, 0,
        "Everest (1830 Definition)", "Greenwich",
        "Kalianpur_1880", "Lambert_Conformal_Conic_1SP", "Indian yard",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26 +lat_0=26 +lon_0=74 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.592233322 +y_0=914398.5307444407 +a=6377299");
    add_proj4text (p, 2,
        ".36559538 +b=6356098.359005156 +to_meter=0.9143985307444");
    add_proj4text (p, 3,
        "408 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1880 / India zone IIa\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1880\",DATUM[\"Kalianpur_1880\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " (1830 Definition)\",6377299.36559538,300.801725543355,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7042\"]],AUTHORITY[\"EPSG\",\"6243\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4243\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",26],PARAMETER[\"central_meridian\",74],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.99878641],PARAMETER[\"false_easting\",30");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",1000000],UNIT[\"Indi");
    add_srs_wkt (p, 11,
        "an yard\",0.914398530744441,AUTHORITY[\"EPSG\",\"9084\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"24372\"]]");
    p = add_epsg_def_ex (filter, first, last, 24373, "epsg", 24373,
        "Kalianpur 1880 / India zone IIIa", 0, 0,
        "Everest (1830 Definition)", "Greenwich",
        "Kalianpur_1880", "Lambert_Conformal_Conic_1SP", "Indian yard",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=19 +lat_0=19 +lon_0=80 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.592233322 +y_0=914398.5307444407 +a=6377299");
    add_proj4text (p, 2,
        ".36559538 +b=6356098.359005156 +to_meter=0.9143985307444");
    add_proj4text (p, 3,
        "408 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1880 / India zone IIIa\",GEOGCS[\"Kal");
    add_srs_wkt (p, 1,
        "ianpur 1880\",DATUM[\"Kalianpur_1880\",SPHEROID[\"Everes");
    add_srs_wkt (p, 2,
        "t (1830 Definition)\",6377299.36559538,300.801725543355,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7042\"]],AUTHORITY[\"EPSG\",\"6243\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4243\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",19],PARAMETER[\"central_meridian\",80],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.99878641],PARAMETER[\"false_easting\",30");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",1000000],UNIT[\"Indi");
    add_srs_wkt (p, 11,
        "an yard\",0.914398530744441,AUTHORITY[\"EPSG\",\"9084\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"24373\"]]");
    p = add_epsg_def_ex (filter, first, last, 24374, "epsg", 24374,
        "Kalianpur 1880 / India zone IVa", 0, 0,
        "Everest (1830 Definition)", "Greenwich",
        "Kalianpur_1880", "Lambert_Conformal_Conic_1SP", "Indian yard",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=12 +lat_0=12 +lon_0=80 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.592233322 +y_0=914398.5307444407 +a=6377299");
    add_proj4text (p, 2,
        ".36559538 +b=6356098.359005156 +to_meter=0.9143985307444");
    add_proj4text (p, 3,
        "408 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1880 / India zone IVa\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1880\",DATUM[\"Kalianpur_1880\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " (1830 Definition)\",6377299.36559538,300.801725543355,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7042\"]],AUTHORITY[\"EPSG\",\"6243\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4243\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",12],PARAMETER[\"central_meridian\",80],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.99878641],PARAMETER[\"false_easting\",30");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",1000000],UNIT[\"Indi");
    add_srs_wkt (p, 11,
        "an yard\",0.914398530744441,AUTHORITY[\"EPSG\",\"9084\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"24374\"]]");
    p = add_epsg_def_ex (filter, first, last, 24375, "epsg", 24375,
        "Kalianpur 1937 / India zone IIb", 0, 0,
        "Everest 1830 (1937 Adjustment)", "Greenwich",
        "Kalianpur_1937", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26 +lat_0=26 +lon_0=90 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743185.69 +y_0=914395.23 +a=6377276.345 +b=6356075");
    add_proj4text (p, 2,
        ".41314024 +towgs84=214,804,268,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1937 / India zone IIb\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1937\",DATUM[\"Kalianpur_1937\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " 1830 (1937 Adjustment)\",6377276.345,300.8017,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7015\"]],AUTHORITY[\"EPSG\",\"6144\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4144\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 7,
        "ormal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",26],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",90],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.99878641],PARAMETER[\"false_easting\",2743185.69");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",914395.23],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24375\"]]");
    p = add_epsg_def_ex (filter, first, last, 24376, "epsg", 24376,
        "Kalianpur 1962 / India zone I", 0, 0,
        "Everest 1830 (1962 Definition)", "Greenwich",
        "Kalianpur_1962", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=68 +k_0=0.99878");
    add_proj4text (p, 1,
        "641 +x_0=2743196.4 +y_0=914398.8 +a=6377301.243 +b=63561");
    add_proj4text (p, 2,
        "00.230165384 +towgs84=283,682,231,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1962 / India zone I\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1962\",DATUM[\"Kalianpur_1962\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1962 Definition)\",6377301.243,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7044\"]],AUTHORITY[\"EPSG\",\"6145\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4145\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",32.");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"central_meridian\",68],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.99878641],PARAMETER[\"false_easting\",2743196");
    add_srs_wkt (p, 10,
        ".4],PARAMETER[\"false_northing\",914398.8],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24376\"]]");
    p = add_epsg_def_ex (filter, first, last, 24377, "epsg", 24377,
        "Kalianpur 1962 / India zone IIa", 0, 0,
        "Everest 1830 (1962 Definition)", "Greenwich",
        "Kalianpur_1962", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26 +lat_0=26 +lon_0=74 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743196.4 +y_0=914398.8 +a=6377301.243 +b=6356100.2");
    add_proj4text (p, 2,
        "30165384 +towgs84=283,682,231,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1962 / India zone IIa\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1962\",DATUM[\"Kalianpur_1962\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " 1830 (1962 Definition)\",6377301.243,300.8017255,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7044\"]],AUTHORITY[\"EPSG\",\"6145\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4145\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",26");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",74],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.99878641],PARAMETER[\"false_easting\",2743196.");
    add_srs_wkt (p, 10,
        "4],PARAMETER[\"false_northing\",914398.8],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24377\"]]");
    p = add_epsg_def_ex (filter, first, last, 24378, "epsg", 24378,
        "Kalianpur 1975 / India zone I", 0, 0,
        "Everest 1830 (1975 Definition)", "Greenwich",
        "Kalianpur_1975", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=68 +k_0=0.99878");
    add_proj4text (p, 1,
        "641 +x_0=2743195.5 +y_0=914398.5 +a=6377299.151 +b=63560");
    add_proj4text (p, 2,
        "98.145120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / India zone I\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1975 Definition)\",6377299.151,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7045\"]],AUTHORITY[\"EPSG\",\"6146\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4146\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",32.");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"central_meridian\",68],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.99878641],PARAMETER[\"false_easting\",2743195");
    add_srs_wkt (p, 10,
        ".5],PARAMETER[\"false_northing\",914398.5],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24378\"]]");
    p = add_epsg_def_ex (filter, first, last, 24379, "epsg", 24379,
        "Kalianpur 1975 / India zone IIa", 0, 0,
        "Everest 1830 (1975 Definition)", "Greenwich",
        "Kalianpur_1975", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26 +lat_0=26 +lon_0=74 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.5 +y_0=914398.5 +a=6377299.151 +b=6356098.1");
    add_proj4text (p, 2,
        "45120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / India zone IIa\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " 1830 (1975 Definition)\",6377299.151,300.8017255,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7045\"]],AUTHORITY[\"EPSG\",\"6146\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4146\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",26");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",74],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.99878641],PARAMETER[\"false_easting\",2743195.");
    add_srs_wkt (p, 10,
        "5],PARAMETER[\"false_northing\",914398.5],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24379\"]]");
    p = add_epsg_def_ex (filter, first, last, 24380, "epsg", 24380,
        "Kalianpur 1975 / India zone IIb", 0, 0,
        "Everest 1830 (1975 Definition)", "Greenwich",
        "Kalianpur_1975", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26 +lat_0=26 +lon_0=90 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.5 +y_0=914398.5 +a=6377299.151 +b=6356098.1");
    add_proj4text (p, 2,
        "45120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / India zone IIb\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " 1830 (1975 Definition)\",6377299.151,300.8017255,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7045\"]],AUTHORITY[\"EPSG\",\"6146\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4146\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",26");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",90],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.99878641],PARAMETER[\"false_easting\",2743195.");
    add_srs_wkt (p, 10,
        "5],PARAMETER[\"false_northing\",914398.5],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24380\"]]");
    p = add_epsg_def_ex (filter, first, last, 24381, "epsg", 24381,
        "Kalianpur 1975 / India zone IIIa", 0, 0,
        "Everest 1830 (1975 Definition)", "Greenwich",
        "Kalianpur_1975", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=19 +lat_0=19 +lon_0=80 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.5 +y_0=914398.5 +a=6377299.151 +b=6356098.1");
    add_proj4text (p, 2,
        "45120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / India zone IIIa\",GEOGCS[\"Kal");
    add_srs_wkt (p, 1,
        "ianpur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everes");
    add_srs_wkt (p, 2,
        "t 1830 (1975 Definition)\",6377299.151,300.8017255,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7045\"]],AUTHORITY[\"EPSG\",\"6146\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4146\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 7,
        "Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "19],PARAMETER[\"central_meridian\",80],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.99878641],PARAMETER[\"false_easting\",274319");
    add_srs_wkt (p, 10,
        "5.5],PARAMETER[\"false_northing\",914398.5],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24381\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 24382, "epsg", 24382,
        "Kalianpur 1880 / India zone IIb", 0, 0,
        "Everest (1830 Definition)", "Greenwich",
        "Kalianpur_1880", "Lambert_Conformal_Conic_1SP", "Indian yard",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26 +lat_0=26 +lon_0=90 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.592233322 +y_0=914398.5307444407 +a=6377299");
    add_proj4text (p, 2,
        ".36559538 +b=6356098.359005156 +to_meter=0.9143985307444");
    add_proj4text (p, 3,
        "408 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1880 / India zone IIb\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1880\",DATUM[\"Kalianpur_1880\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " (1830 Definition)\",6377299.36559538,300.801725543355,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7042\"]],AUTHORITY[\"EPSG\",\"6243\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4243\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",26],PARAMETER[\"central_meridian\",90],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.99878641],PARAMETER[\"false_easting\",30");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",1000000],UNIT[\"Indi");
    add_srs_wkt (p, 11,
        "an yard\",0.914398530744441,AUTHORITY[\"EPSG\",\"9084\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"24382\"]]");
    p = add_epsg_def_ex (filter, first, last, 24383, "epsg", 24383,
        "Kalianpur 1975 / India zone IVa", 0, 0,
        "Everest 1830 (1975 Definition)", "Greenwich",
        "Kalianpur_1975", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=12 +lat_0=12 +lon_0=80 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.5 +y_0=914398.5 +a=6377299.151 +b=6356098.1");
    add_proj4text (p, 2,
        "45120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / India zone IVa\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " 1830 (1975 Definition)\",6377299.151,300.8017255,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7045\"]],AUTHORITY[\"EPSG\",\"6146\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4146\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",12");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",80],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.99878641],PARAMETER[\"false_easting\",2743195.");
    add_srs_wkt (p, 10,
        "5],PARAMETER[\"false_northing\",914398.5],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24383\"]]");
    p = add_epsg_def_ex (filter, first, last, 24500, "epsg", 24500,
        "Kertau 1968 / Singapore Grid", 0, 0,
        "Everest 1830 Modified", "Greenwich",
        "Kertau_1968", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=1.287646666666667 +lon_0=103.853002222");
    add_proj4text (p, 1,
        "2222 +x_0=30000 +y_0=30000 +a=6377304.063 +b=6356103.038");
    add_proj4text (p, 2,
        "993155 +towgs84=-11,851,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau 1968 / Singapore Grid\",GEOGCS[\"Kertau ");
    add_srs_wkt (p, 1,
        "1968\",DATUM[\"Kertau_1968\",SPHEROID[\"Everest 1830 Mod");
    add_srs_wkt (p, 2,
        "ified\",6377304.063,300.8017,AUTHORITY[\"EPSG\",\"7018\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6245\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4245\"]],PROJECTION[\"Cassini_Soldner\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",1.28764666666667],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",103.853002222222],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",30000],PARAMETER[\"false_northing\",30000],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 11,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24500");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 24547, "epsg", 24547,
        "Kertau 1968 / UTM zone 47N", 0, 0,
        "Everest 1830 Modified", "Greenwich",
        "Kertau_1968", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +a=6377304.063 +b=6356103.038993155 +");
    add_proj4text (p, 1,
        "towgs84=-11,851,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau 1968 / UTM zone 47N\",GEOGCS[\"Kertau 19");
    add_srs_wkt (p, 1,
        "68\",DATUM[\"Kertau_1968\",SPHEROID[\"Everest 1830 Modif");
    add_srs_wkt (p, 2,
        "ied\",6377304.063,300.8017,AUTHORITY[\"EPSG\",\"7018\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6245\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4245\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",99],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "24547\"]]");
    p = add_epsg_def_ex (filter, first, last, 24548, "epsg", 24548,
        "Kertau 1968 / UTM zone 48N", 0, 0,
        "Everest 1830 Modified", "Greenwich",
        "Kertau_1968", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +a=6377304.063 +b=6356103.038993155 +");
    add_proj4text (p, 1,
        "towgs84=-11,851,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau 1968 / UTM zone 48N\",GEOGCS[\"Kertau 19");
    add_srs_wkt (p, 1,
        "68\",DATUM[\"Kertau_1968\",SPHEROID[\"Everest 1830 Modif");
    add_srs_wkt (p, 2,
        "ied\",6377304.063,300.8017,AUTHORITY[\"EPSG\",\"7018\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6245\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4245\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",105],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "24548\"]]");
    p = add_epsg_def_ex (filter, first, last, 24571, "epsg", 24571,
        "Kertau / R.S.O. Malaya (ch) (deprecated)", 0, 0,
        "Everest 1830 Modified", "Greenwich",
        "Kertau_1968", "Hotine_Oblique_Mercator", "British chain (Benoit 1895 B)",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=4 +lonc=102.25 +alpha=323.0257905 +k=");
    add_proj4text (p, 1,
        "0.99984 +x_0=804671.2997750348 +y_0=0 +no_uoff +gamma=32");
    add_proj4text (p, 2,
        "3.1301023611111 +a=6377304.063 +b=6356103.038993155 +tow");
    add_proj4text (p, 3,
        "gs84=-11,851,5,0,0,0,0 +to_meter=20.11678249437587 +no_d");
    add_proj4text (p, 4,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau / R.S.O. Malaya (ch) (deprecated)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Kertau 1968\",DATUM[\"Kertau_1968\",SPHEROID[\"Ever");
    add_srs_wkt (p, 2,
        "est 1830 Modified\",6377304.063,300.8017,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7018\"]],AUTHORITY[\"EPSG\",\"6245\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4245\"]],PROJECTION[\"Hotine_Oblique_Merc");
    add_srs_wkt (p, 7,
        "ator\"],PARAMETER[\"latitude_of_center\",4],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "longitude_of_center\",102.25],PARAMETER[\"azimuth\",323.");
    add_srs_wkt (p, 9,
        "0257905],PARAMETER[\"rectified_grid_angle\",323.13010236");
    add_srs_wkt (p, 10,
        "1111],PARAMETER[\"scale_factor\",0.99984],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",40000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 12,
        "T[\"British chain (Benoit 1895 B)\",20.1167824943759,AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"9062\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"24571\"]]");
    p = add_epsg_def_ex (filter, first, last, 24600, "epsg", 24600,
        "KOC Lambert", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Kuwait_Oil_Company", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=45 +k_0=0.99878");
    add_proj4text (p, 1,
        "64078000001 +x_0=1500000 +y_0=1166200 +ellps=clrk80 +tow");
    add_proj4text (p, 2,
        "gs84=-294.7,-200.1,525.5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"KOC Lambert\",GEOGCS[\"KOC\",DATUM[\"Kuwait_Oil");
    add_srs_wkt (p, 1,
        "_Company\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,29");
    add_srs_wkt (p, 2,
        "3.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6246\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4246\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",32.5],PARAMETER[\"central_meridian\",45],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"scale_factor\",0.9987864078],PARAMETER[\"false_ea");
    add_srs_wkt (p, 9,
        "sting\",1500000],PARAMETER[\"false_northing\",1166200],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 11,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"24600\"]]");
    p = add_epsg_def_ex (filter, first, last, 24718, "epsg", 24718,
        "La Canoa / UTM zone 18N", 0, 0,
        "International 1924", "Greenwich",
        "La_Canoa", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=intl +towgs84=-273.5,110.6,-35");
    add_proj4text (p, 1,
        "7.9,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"La Canoa / UTM zone 18N\",GEOGCS[\"La Canoa\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"La_Canoa\",SPHEROID[\"International 1924\",637838");
    add_srs_wkt (p, 2,
        "8,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6247\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4247\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",0],PARAMETER[\"central_meridian\",-75],PARAMETER[\"scal");
    add_srs_wkt (p, 8,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 10,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"24718\"]]");
    p = add_epsg_def_ex (filter, first, last, 24719, "epsg", 24719,
        "La Canoa / UTM zone 19N", 0, 0,
        "International 1924", "Greenwich",
        "La_Canoa", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=intl +towgs84=-273.5,110.6,-35");
    add_proj4text (p, 1,
        "7.9,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"La Canoa / UTM zone 19N\",GEOGCS[\"La Canoa\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"La_Canoa\",SPHEROID[\"International 1924\",637838");
    add_srs_wkt (p, 2,
        "8,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6247\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4247\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",0],PARAMETER[\"central_meridian\",-69],PARAMETER[\"scal");
    add_srs_wkt (p, 8,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 10,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"24719\"]]");
    p = add_epsg_def_ex (filter, first, last, 24720, "epsg", 24720,
        "La Canoa / UTM zone 20N", 0, 0,
        "International 1924", "Greenwich",
        "La_Canoa", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=intl +towgs84=-273.5,110.6,-35");
    add_proj4text (p, 1,
        "7.9,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"La Canoa / UTM zone 20N\",GEOGCS[\"La Canoa\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"La_Canoa\",SPHEROID[\"International 1924\",637838");
    add_srs_wkt (p, 2,
        "8,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6247\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4247\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",0],PARAMETER[\"central_meridian\",-63],PARAMETER[\"scal");
    add_srs_wkt (p, 8,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 10,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"24720\"]]");
    p = add_epsg_def_ex (filter, first, last, 24817, "epsg", 24817,
        "PSAD56 / UTM zone 17N", 0, 0,
        "International 1924", "Greenwich",
        "Provisional_South_American_Datum_1956", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=intl +towgs84=-288,175,-376,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 17N\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6248\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4248\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",-81],PARAMETER[\"scale_factor\",0.9996],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",500000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"24817\"]]");
    p = add_epsg_def_ex (filter, first, last, 24818, "epsg", 24818,
        "PSAD56 / UTM zone 18N", 0, 0,
        "International 1924", "Greenwich",
        "Provisional_South_American_Datum_1956", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=intl +towgs84=-288,175,-376,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 18N\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6248\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4248\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",-75],PARAMETER[\"scale_factor\",0.9996],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",500000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"24818\"]]");
    p = add_epsg_def_ex (filter, first, last, 24819, "epsg", 24819,
        "PSAD56 / UTM zone 19N", 0, 0,
        "International 1924", "Greenwich",
        "Provisional_South_American_Datum_1956", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=intl +towgs84=-288,175,-376,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 19N\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6248\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4248\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",-69],PARAMETER[\"scale_factor\",0.9996],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",500000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"24819\"]]");
    p = add_epsg_def_ex (filter, first, last, 24820, "epsg", 24820,
        "PSAD56 / UTM zone 20N", 0, 0,
        "International 1924", "Greenwich",
        "Provisional_South_American_Datum_1956", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=intl +towgs84=-288,175,-376,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 20N\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6248\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4248\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",-63],PARAMETER[\"scale_factor\",0.9996],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",500000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"24820\"]]");
    p = add_epsg_def_ex (filter, first, last, 24821, "epsg", 24821,
        "PSAD56 / UTM zone 21N", 0, 0,
        "International 1924", "Greenwich",
        "Provisional_South_American_Datum_1956", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +ellps=intl +towgs84=-288,175,-376,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 21N\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6248\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4248\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",-57],PARAMETER[\"scale_factor\",0.9996],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",500000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"24821\"]]");
    p = add_epsg_def_ex (filter, first, last, 24877, "epsg", 24877,
        "PSAD56 / UTM zone 17S", 0, 0,
        "International 1924", "Greenwich",
        "Provisional_South_American_Datum_1956", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +south +ellps=intl +towgs84=-288,175,");
    add_proj4text (p, 1,
        "-376,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 17S\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6248\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4248\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",-81],PARAMETER[\"scale_factor\",0.9996],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",500000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "0000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"24877\"]]");
    p = add_epsg_def_ex (filter, first, last, 24878, "epsg", 24878,
        "PSAD56 / UTM zone 18S", 0, 0,
        "International 1924", "Greenwich",
        "Provisional_South_American_Datum_1956", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=intl +towgs84=-288,175,");
    add_proj4text (p, 1,
        "-376,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 18S\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6248\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4248\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",-75],PARAMETER[\"scale_factor\",0.9996],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",500000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "0000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"24878\"]]");
    p = add_epsg_def_ex (filter, first, last, 24879, "epsg", 24879,
        "PSAD56 / UTM zone 19S", 0, 0,
        "International 1924", "Greenwich",
        "Provisional_South_American_Datum_1956", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=intl +towgs84=-288,175,");
    add_proj4text (p, 1,
        "-376,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 19S\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6248\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4248\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",-69],PARAMETER[\"scale_factor\",0.9996],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",500000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "0000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"24879\"]]");
    p = add_epsg_def_ex (filter, first, last, 24880, "epsg", 24880,
        "PSAD56 / UTM zone 20S", 0, 0,
        "International 1924", "Greenwich",
        "Provisional_South_American_Datum_1956", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +south +ellps=intl +towgs84=-288,175,");
    add_proj4text (p, 1,
        "-376,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 20S\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6248\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4248\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",-63],PARAMETER[\"scale_factor\",0.9996],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",500000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "0000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"24880\"]]");
    p = add_epsg_def_ex (filter, first, last, 24881, "epsg", 24881,
        "PSAD56 / UTM zone 21S", 0, 0,
        "International 1924", "Greenwich",
        "Provisional_South_American_Datum_1956", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=intl +towgs84=-288,175,");
    add_proj4text (p, 1,
        "-376,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 21S\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6248\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4248\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",-57],PARAMETER[\"scale_factor\",0.9996],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",500000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "0000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"24881\"]]");
    p = add_epsg_def_ex (filter, first, last, 24882, "epsg", 24882,
        "PSAD56 / UTM zone 22S", 0, 0,
        "International 1924", "Greenwich",
        "Provisional_South_American_Datum_1956", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=intl +towgs84=-288,175,");
    add_proj4text (p, 1,
        "-376,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 22S\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6248\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4248\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",-51],PARAMETER[\"scale_factor\",0.9996],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",500000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "0000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"24882\"]]");
    p = add_epsg_def_ex (filter, first, last, 24891, "epsg", 24891,
        "PSAD56 / Peru west zone", 0, 0,
        "International 1924", "Greenwich",
        "Provisional_South_American_Datum_1956", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-6 +lon_0=-80.5 +k=0.99983008 +x_0=22");
    add_proj4text (p, 1,
        "2000 +y_0=1426834.743 +ellps=intl +towgs84=-288,175,-376");
    add_proj4text (p, 2,
        ",0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / Peru west zone\",GEOGCS[\"PSAD56\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Provisional_South_American_Datum_1956\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "22\"]],AUTHORITY[\"EPSG\",\"6248\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4248\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",-6],PARAMETER[\"central_mer");
    add_srs_wkt (p, 8,
        "idian\",-80.5],PARAMETER[\"scale_factor\",0.99983008],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",222000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",1426834.743],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"24891\"]]");
    p = add_epsg_def_ex (filter, first, last, 24892, "epsg", 24892,
        "PSAD56 / Peru central zone", 0, 0,
        "International 1924", "Greenwich",
        "Provisional_South_American_Datum_1956", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-9.5 +lon_0=-76 +k=0.99932994 +x_0=72");
    add_proj4text (p, 1,
        "0000 +y_0=1039979.159 +ellps=intl +towgs84=-288,175,-376");
    add_proj4text (p, 2,
        ",0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / Peru central zone\",GEOGCS[\"PSAD56\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Provisional_South_American_Datum_1956\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7022\"]],AUTHORITY[\"EPSG\",\"6248\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4248\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",-9.5],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",-76],PARAMETER[\"scale_factor\",0.99932994],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",720000],PARAMETER[\"false_no");
    add_srs_wkt (p, 10,
        "rthing\",1039979.159],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"24892\"]]");
    p = add_epsg_def_ex (filter, first, last, 24893, "epsg", 24893,
        "PSAD56 / Peru east zone", 0, 0,
        "International 1924", "Greenwich",
        "Provisional_South_American_Datum_1956", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-9.5 +lon_0=-70.5 +k=0.99952992 +x_0=");
    add_proj4text (p, 1,
        "1324000 +y_0=1040084.558 +ellps=intl +towgs84=-288,175,-");
    add_proj4text (p, 2,
        "376,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / Peru east zone\",GEOGCS[\"PSAD56\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Provisional_South_American_Datum_1956\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "22\"]],AUTHORITY[\"EPSG\",\"6248\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4248\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",-9.5],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",-70.5],PARAMETER[\"scale_factor\",0.99952992],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",1324000],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",1040084.558],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"24893\"]]");
    p = add_epsg_def_ex (filter, first, last, 25000, "epsg", 25000,
        "Leigon / Ghana Metre Grid", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Leigon", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.666666666666667 +lon_0=-1 +k=0.9997");
    add_proj4text (p, 1,
        "5 +x_0=274319.51 +y_0=0 +ellps=clrk80 +towgs84=-130,29,3");
    add_proj4text (p, 2,
        "64,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Leigon / Ghana Metre Grid\",GEOGCS[\"Leigon\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Leigon\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.1");
    add_srs_wkt (p, 2,
        "45,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6250\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4250\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",4.66666666666667],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-1],PARAMETER[\"scale_factor\",0.99975],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",274319.51],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"25000\"]]");
    p = add_epsg_def_ex (filter, first, last, 25231, "epsg", 25231,
        "Lome / UTM zone 31N", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Lome", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=31 +a=6378249.2 +b=6356515 +units=m +no_");
    add_proj4text (p, 1,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Lome / UTM zone 31N\",GEOGCS[\"Lome\",DATUM[\"L");
    add_srs_wkt (p, 1,
        "ome\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46602");
    add_srs_wkt (p, 2,
        "1293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6252\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4252\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",3],PARAMETER[\"sc");
    add_srs_wkt (p, 8,
        "ale_factor\",0.9996],PARAMETER[\"false_easting\",500000]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 10,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"25231\"]]");
    p = add_epsg_def_ex (filter, first, last, 25391, "epsg", 25391,
        "Luzon 1911 / Philippines zone I", 0, 0,
        "Clarke 1866", "Greenwich",
        "Luzon_1911", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=0.99995 +x_0=500000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=clrk66 +towgs84=-133,-77,-51,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Luzon 1911 / Philippines zone I\",GEOGCS[\"Luzo");
    add_srs_wkt (p, 1,
        "n 1911\",DATUM[\"Luzon_1911\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6253\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4253\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "17],PARAMETER[\"scale_factor\",0.99995],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "25391\"]]");
    p = add_epsg_def_ex (filter, first, last, 25392, "epsg", 25392,
        "Luzon 1911 / Philippines zone II", 0, 0,
        "Clarke 1866", "Greenwich",
        "Luzon_1911", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=119 +k=0.99995 +x_0=500000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=clrk66 +towgs84=-133,-77,-51,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Luzon 1911 / Philippines zone II\",GEOGCS[\"Luz");
    add_srs_wkt (p, 1,
        "on 1911\",DATUM[\"Luzon_1911\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6253\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4253\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",119],PARAMETER[\"scale_factor\",0.99995],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 11,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"25392\"]]");
    p = add_epsg_def_ex (filter, first, last, 25393, "epsg", 25393,
        "Luzon 1911 / Philippines zone III", 0, 0,
        "Clarke 1866", "Greenwich",
        "Luzon_1911", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=121 +k=0.99995 +x_0=500000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=clrk66 +towgs84=-133,-77,-51,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Luzon 1911 / Philippines zone III\",GEOGCS[\"Lu");
    add_srs_wkt (p, 1,
        "zon 1911\",DATUM[\"Luzon_1911\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6253\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4253\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",121],PARAMETER[\"scale_factor\",0.99995],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"25393\"]]");
    p = add_epsg_def_ex (filter, first, last, 25394, "epsg", 25394,
        "Luzon 1911 / Philippines zone IV", 0, 0,
        "Clarke 1866", "Greenwich",
        "Luzon_1911", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=0.99995 +x_0=500000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=clrk66 +towgs84=-133,-77,-51,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Luzon 1911 / Philippines zone IV\",GEOGCS[\"Luz");
    add_srs_wkt (p, 1,
        "on 1911\",DATUM[\"Luzon_1911\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6253\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4253\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",123],PARAMETER[\"scale_factor\",0.99995],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 11,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"25394\"]]");
    p = add_epsg_def_ex (filter, first, last, 25395, "epsg", 25395,
        "Luzon 1911 / Philippines zone V", 0, 0,
        "Clarke 1866", "Greenwich",
        "Luzon_1911", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=125 +k=0.99995 +x_0=500000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=clrk66 +towgs84=-133,-77,-51,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Luzon 1911 / Philippines zone V\",GEOGCS[\"Luzo");
    add_srs_wkt (p, 1,
        "n 1911\",DATUM[\"Luzon_1911\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6253\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4253\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "25],PARAMETER[\"scale_factor\",0.99995],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "25395\"]]");
    p = add_epsg_def_ex (filter, first, last, 25700, "epsg", 25700,
        "Makassar / NEIEZ", 0, 0,
        "Bessel 1841", "Greenwich",
        "Makassar", "Mercator_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=merc +lon_0=110 +k=0.997 +x_0=3900000 +y_0=900000 ");
    add_proj4text (p, 1,
        "+ellps=bessel +towgs84=-587.8,519.75,145.76,0,0,0,0 +pm=");
    add_proj4text (p, 2,
        "jakarta +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Makassar / NEIEZ\",GEOGCS[\"Makassar\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Makassar\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528");
    add_srs_wkt (p, 2,
        "128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "257\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4257\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Mercator_1SP\"],PARAMETER[\"central_meridian\",110],PARA");
    add_srs_wkt (p, 7,
        "METER[\"scale_factor\",0.997],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 8,
        ",3900000],PARAMETER[\"false_northing\",900000],UNIT[\"me");
    add_srs_wkt (p, 9,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 10,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3002\"");
    add_srs_wkt (p, 11,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 25828, "epsg", 25828,
        "ETRS89 / UTM zone 28N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 28N\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",-15],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"25828\"]]");
    p = add_epsg_def_ex (filter, first, last, 25829, "epsg", 25829,
        "ETRS89 / UTM zone 29N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 29N\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",-9],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"25829\"]]");
    p = add_epsg_def_ex (filter, first, last, 25830, "epsg", 25830,
        "ETRS89 / UTM zone 30N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 30N\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",-3],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"25830\"]]");
    p = add_epsg_def_ex (filter, first, last, 25831, "epsg", 25831,
        "ETRS89 / UTM zone 31N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=31 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 31N\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",3],PARAMETER[\"scale_factor\",0.9996],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"25831\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

