use ui;
use core:geometry;
use graphics;

class Tabs on Render {
	private Text[] options;
	private Float textHeight;
	private Float pad;
	private SolidBrush sel;
	private SolidBrush bg;
	private SolidBrush fg;

	Nat selected;

	init(Str[] options) {
		init() {
			bg(Color(0.7, 0.7, 0.7));
			sel(white);
			fg(black);
		}

		Font font = defaultFont;
		for (o in options) {
			Text t(o, font);
			this.options << t;
			textHeight = height.max(t.size.h);
		}
	}

	Float height() {
		textHeight + 2*pad;
	}

	void render(Size size, Graphics g) {
		Float width = size.w / options.count.int.float;
		Float h = height;
		for (i, o in options) {
			Rect r(Point(width * i.int.float, 0), Size(width, h));
			g.fill(r, if (i == selected) sel; else bg;);
			g.draw(r, fg);

			g.draw(o, fg, r.center - o.size / 2);
		}
	}

	Nat? onClick(Point pt, Size size) {
		if (pt.y > height)
			return null;

		Float width = size.w / options.count.int.float;
		Nat sel = (pt.x / width).int.nat;
		if (sel != selected) {
			selected = sel;
			return selected;
		}
		return null;
	}
}
