/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_EXPORTPARAM_H
#define _SC_EXPORTPARAM_H

// sc
#include "ScParam.h"
#include "util/String.h"
#include "svn/Revision.h"


/**
 * Parameter class for ExportCmd.
 */
class ExportParam : public ScParam
{
public:
  /**
   * construct a ExportParam object.
   */
  ExportParam( const sc::String& srcPathOrUrl, const sc::String& path,
    const svn::RevisionPtr rev, bool force, const sc::String& eol )
    : _srcPathOrUrl(srcPathOrUrl), _path(path), _rev(rev), _force(force), _eol(eol)
  {
  }

  ~ExportParam()
  {
  }

  const sc::String& getSrcPathOrUrl() const
  {
    return _srcPathOrUrl;
  }

  void setSrcPathOrUrl( const sc::String& pathOrUrl )
  {
    _srcPathOrUrl = pathOrUrl;
  }

  const sc::String& getPath() const
  {
    return _path;
  }

  void setPath( const sc::String& path )
  {
    _path = path;
  }

  const svn::RevisionPtr getRevision() const
  {
    return _rev;
  }

  void setRevision( svn::RevisionPtr rev )
  {
    _rev = rev;
  }

  bool getForce() const
  {
    return _force;
  }

  void setForce( bool force )
  {
    _force = force;
  }

  const sc::String& getEol()
  {
    return _eol;
  }

  void setEol( const sc::String& eol )
  {
    _eol = eol;
  }

  svn::Revnumber& getRevnumber()
  {
    return _revnum;
  }

  ScParamAccept(ExportParam);

private:
  // in
  sc::String       _srcPathOrUrl;
  sc::String       _path;
  svn::RevisionPtr _rev;
  bool             _force;
  sc::String       _eol;

  // out
  svn::Revnumber   _revnum;
};

#endif // _SC_EXPORTPARAM_H
