C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=NOEROT,SSI=0
                        SUBROUTINE NOEROT
C                       *****************
C
C      ---------------------------
     * (N1,NDMATS,NELEMS,NODES)
C      ---------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C             PERMUTATION CIRCULAIRE DES NOEUDS D'UN ELEMENT           *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  N1       !  E ! D  ! NUMERO DE ELEMENT  A MODIFIER                !
C !  NDMATS   !  E ! D  ! NOMBRE DE NOEUDS DES ELTS VOL SOLIDES        !
C !  NELEMS   !  E ! D  ! NOMBRE D'ELTS DU MAILLAGE VOL SOLIDE         !
C !  NODES    ! TE ! M  ! CONNECTIVITE DU MAILLAGE                     !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : --- 
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
       IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
C
C***********************************************************************
C
      INTEGER IT
      PARAMETER (IT=10)
C
C.. Variables externes
      INTEGER N1,NELEMS,NDMATS,NODES(NELEMS,NDMATS)
C
C.. Variables internes
      INTEGER ITAB(IT),I
C
C***********************************************************************
C
C
C
C     1- CONSERVATION DES NOEUDS DE L'ELEMENT N1
C     ------------------------------------------
C
      DO 100 I=1,NDMATS
         ITAB(I) = NODES(N1,I)
  100 CONTINUE
C
C
C     2- PERMUTATION CIRCULAIRE POUR LES TRIANGLES
C     --------------------------------------------
C
      IF (NDMATS.EQ.6) THEN
C
        DO 200 I=1,3
           NODES(N1,I) = ITAB(1+ MOD(I,3))
  200   CONTINUE
C 
        DO 210 I=4,6
           NODES(N1,I) = ITAB(4+ MOD(I-3,3))
  210   CONTINUE
C
C     3- PERMUTATION CIRCULAIRE POUR LES TETRAEDRES
C     ---------------------------------------------
C
      ELSE
C
        DO 300 I=1,4
           NODES(N1,I) = ITAB(1+ MOD(I,4))
  300   CONTINUE
C 
        NODES(N1,5)  = ITAB(6)
        NODES(N1,6)  = ITAB(10)
        NODES(N1,7)  = ITAB(9)
        NODES(N1,8)  = ITAB(5)
        NODES(N1,9)  = ITAB(7)
        NODES(N1,10) = ITAB(8)
C
      ENDIF
C
      END
