[comment {-*- text -*- doctools manpage}]
[manpage_begin pt_parser_api i 1]
[include include/module.inc]
[titledesc {Parser API}]
[description]
[include include/ref_intro.inc]

This document describes the API shared by the grammar interpreter
provided by the package [package pt::peg::interp] and the parsers
generated by the [cmd pt] application for the result formats
[const critcl], [const snit], and [const oo] regarding access
to the actual parsing functionality.

[para]

Its intended audience are people who wish to create a parser for some
language of theirs and then use that parser within a Tcl-based package
or application.

[para]

It resides in the User Layer of Parser Tools.
[para][image arch_user_pkg][para]

[section {Class API}]

[list_begin definitions]
[call [cmd className] [opt [arg objectName]]]

The class command constructs parser instances, i.e. objects. The
result of the command is the fully-qualified name of the instance
command.

[para]

If no [arg objectName] is specified the class will generate and use an
automatic name. If the [arg objectName] was specified, but is not
fully qualified the command will be created in the current namespace.

[list_end]

[section {Instance API}]

All parser instances provide at least the methods shown below:

[list_begin definitions]
[include include/std_parser_object_api.inc]
[list_end]

[section Usage]

A generated parser is used like this

[example {
    package require the-parser-package ;# Generated by result-formats 'critcl', 'snit' or 'oo' of 'pt'.
    set parser [the-parser-class]

    set ast [$parser parse $channel]
    ... process the abstract syntax tree ...
}]

When using a grammar interpreter for parsing some differences creep in

[example {
    package require the-grammar-package ;# Generated by result-format 'container' of 'pt'.
    set grammar [the-grammar-class]

    package require pt::peg::interp
    set parser [pt::peg::interp]

    $parser use $grammar

    set ast [$parser parse $channel]
    $parser destroy

    ... process the abstract syntax tree ...
}]

[include include/serial/ast.inc]
[include include/serial/pexpression.inc]
[include include/feedback.inc]
[manpage_end]
