/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev$
 * $Date$
 */
#ifndef INDII_GUI_WINDOWMENU_HPP
#define INDII_GUI_WINDOWMENU_HPP

#include "wx/wx.h"

namespace indii {
  class Window;

/**
 * Window menu.
 */
class WindowMenu : public wxMenu {
public:
  /**
   * Constructor.
   *
   * @param window Window with which menu is associated.
   */
  WindowMenu(Window* window);

  /**
   * Add menu item.
   */
  void add(const wxString& name);

  /**
   * Update check marks.
   */
  void update();

  /*
   * Event handlers.
   */
  void OnShow(wxMenuEvent& evt);
  void OnSelect(wxCommandEvent& evt);
  void OnDefault(wxCommandEvent& evt);

private:
  /**
   * Window with which menu is associated.
   */
  Window* window;

  /*
   * Control ids.
   */
  enum ID {
    ID_SELECT = 1432,
    ID_DEFAULTS = 2758,
  };

  DECLARE_EVENT_TABLE()
};
}

#endif
