# $Id: unixkeys.tcl 1450 2008-06-08 13:06:13Z sergei $
# "Unixkeys" -- plugin for Tkabber.
# Provides keybindings in Tk Text widgets which are familiar
# to Unix users: they resemble "canonical" bindings found in
# readline and Emacs.
# Written by Konstantin Khomoutov <flatworm@users.sourceforge.net>
# See INSTALL for installation procedure.
# See README for usage guidelines.
# See license.terms for details on usage and distribution.

namespace eval unixkeys {
    proc BindEntry {event script} {
	bind Entry   $event $script
	bind BwEntry $event $script
    }

    foreach mod {Alt Meta} {
	bind Text <$mod-Key-a> [bind Text <Control-Key-Home>]
	bind Text <$mod-Key-e> [bind Text <Control-Key-End>]
	BindEntry <$mod-Key-a> [bind Entry <Key-Home>]
	BindEntry <$mod-Key-e> [bind Entry <Key-End>]
    }

    foreach mod {Alt Meta} {
	bind Text <$mod-Key-b> [bind Text <Control-Key-Left>]
	bind Text <$mod-Key-f> [bind Text <Control-Key-Right>]
    }
    BindEntry <Alt-Key-b> [bind Entry <Meta-Key-b>]
    BindEntry <Alt-Key-f> [bind Entry <Meta-Key-f>]

    bind Text  <Control-Key-u> { %W delete {insert linestart} insert}
    BindEntry <Control-Key-u>  { %W delete 0 insert }

    foreach {mod key} {Alt BackSpace Control w} {
	bind Text  <$mod-Key-$key> { %W delete [tk::TextPrevPos %W insert tcl_startOfPreviousWord] insert }
	BindEntry <$mod-Key-$key>  { %W delete [tk::EntryPreviousWord %W insert] insert }
    }

    foreach key {d Delete} {
	foreach mod {Alt Meta} {
	    bind Text  <$mod-Key-$key> { %W delete insert [::tk::TextNextPos %W insert tcl_endOfWord] }
	    BindEntry <$mod-Key-$key>  { %W delete insert [::tk::EntryNextWord %W insert] }
	}
    }

    if {[string equal $::tcl_platform(os) windows]} {
	event add <<Undo>> <Control-Key-underscore>
    }
    event add <<Undo>> <Control-Key-x><Control-Key-u>

    bind Text <Control-slash>     { %W tag add sel 1.0 end }
    bind Text <Control-backslash> { %W tag remove sel 1.0 end }
    bind Text <Control-Key-x><h>  { %W tag add sel 1.0 end }
    BindEntry <Control-Key-x><h>  [bind Entry <Control-slash>]
}

namespace delete unixkeys

# vim:ts=8:sw=4:sts=4:noet
