#ifndef INCLUDED_TIGER_H
#define INCLUDED_TIGER_H
/* vim: set ts=8 sts=4 sw=4 tw=80 noet: */
/*======================================================================
Copyright (C) 2004,2005,2009 Walter Doekes <walter+tthsum@wjd.nu>
This file is part of tthsum.

tthsum is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

tthsum is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with tthsum.  If not, see <http://www.gnu.org/licenses/>.
======================================================================*/

/**
 * The tiger3/192 hash algorithm (192 bits, 3 passes)
 */

#include "types.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/**
 * The Tiger Hash function.
 * Supply an 64-bit aligned octet-stream and the length of the _octet_ stream.
 * The last parameter, result, must be large enough to hold 3 uint64_t's.
 */
void tiger(const uint64_t* data, unsigned length, uint64_t* result);

/**
 * The Tiger Hash function, modified to prepend the specified byte to the input
 * data. This is useful for the THEX algorithm which prepends a 0x00 to leaf
 * nodes and 0x01 to the hash nodes.
 *
 * Note that this function does not align the data properly on little endian
 * machines. On big endian machines it will re-align because it copies the
 * data to a temporary buffer while converting the little endian input.
 *
 * See tiger() for details of the other arguments.
 */
void tiger_bp(char prepend, const void* data, unsigned length,
	uint64_t* result);

#ifdef __cplusplus
} /* extern "C" */
#endif /* __cplusplus */

#endif /* INCLUDED_TIGER_H */
