/*
    hdkeyb.c - routines for hdkeyb control
    http://ok1zia.nagano.cz/wiki/Hdkeyb

    Copyright (C) 2010 Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

*/

/* TODO

   pri chybe na USB ukoncit/znovu spustit

   */

#include "header.h"

#define PIN_HD_E    0x04
#define PIN_HD_RS   0x01
#define PIN_HD_RW   0x10
#define PIN_HD_D4   0x02
#define PIN_HD_D5   0x80
#define PIN_HD_D6   0x20
#define PIN_HD_D7   0x40
#define PIN_HD_BUSY 0x08

#define PIN_KEYB_A0 0x10
#define PIN_KEYB_A1 0x01
#define PIN_KEYB_A2 0x04



#define PIN(pins, value) if (value) hdkeyb->wr |= (pins); else hdkeyb->wr &= ~(pins);
struct hdkeyb *hdkeyb;

struct hdkeyb *init_hdkeyb(void){
    struct hdkeyb *hdkeyb;

    if (rotars->len == 0) return NULL;

    hdkeyb = g_new0(struct hdkeyb, 1);
#ifdef HAVE_LIBFTDI

    hdkeyb->thread = g_thread_create(hdkeyb_main, (gpointer)hdkeyb, TRUE, NULL); 
    if (!hdkeyb->thread) {
        log_addf("Can't create hdkeyb thread");
        dbg("Can't create hdkeyb thread\n");
        g_free(hdkeyb);
        return NULL;
    }
	dbg("hdkeyb started\n");
    hdkeyb_draw_rotars(hdkeyb);          
#endif   
//    hdkeyb->thread_break = 1;
	//hdkeyb_dump_vrams(hdkeyb);
    return hdkeyb;
}

void free_hdkeyb(struct hdkeyb *hdkeyb){
#ifdef HAVE_LIBFTDI
    if (!hdkeyb) return;
    if (hdkeyb->thread){
        hdkeyb->thread_break = 1;
        dbg("join hdkeyb...\n");
        g_thread_join(hdkeyb->thread);
        dbg("done\n");
        hdkeyb->thread=NULL;
    }
#endif
    g_free(hdkeyb);
}

#ifdef HAVE_LIBFTDI
void hdkeyb_dump_vrams(struct hdkeyb *hdkeyb){
	int i;
	char vrc;
	dbg("oldv='");
	for (i=0; i<16; i++) {
		vrc = hdkeyb->oldvram[0][i];
        dbg("%c", isprint(vrc) ? vrc : '.');
	}
	dbg("'\nvram='");
	for (i=0; i<16; i++) {
		vrc = hdkeyb->vram[0][i];
        dbg("%c", isprint(vrc) ? vrc : '.');
	}
	dbg("'\n");
}

gpointer hdkeyb_main(gpointer xxx){
    struct hdkeyb *hdkeyb;
    int i;
    int ret, ftdi_vid = 0xa600, ftdi_pid = 0xe114;

    hdkeyb = (struct hdkeyb*)xxx;

    hdkeyb->ftdi = ftdi_new();
    if (!hdkeyb->ftdi){
        tp_printf("HD;!;Can't create hdkeyb ftdi\n");
        return NULL;
    }

    ret = ftdi_usb_open(hdkeyb->ftdi, ftdi_vid, ftdi_pid);
    if (ret){
        tp_printf("HD;!;Can't open ftdi device %04x:%04x, error=%d %s\n", ftdi_vid, ftdi_pid, ret, ftdi_get_error_string(hdkeyb->ftdi));
        dbg("HD;!;Can't open ftdi device %04x:%04x, error=%d %s", ftdi_vid, ftdi_pid, ret, ftdi_get_error_string(hdkeyb->ftdi));
        if (ret==-8) tp_printf("HD;!;Maybe run program as root");
        return NULL;
    }
            
    int bitmask = (PIN_HD_RS | PIN_HD_RW | PIN_HD_E | PIN_HD_D4 | PIN_HD_D5 | PIN_HD_D6 | PIN_HD_D7);
    ret=ftdi_set_bitmode(hdkeyb->ftdi, bitmask, BITMODE_SYNCBB);
    //dbg("ftdi_set_bitmode(0x%02x)=%d", bitmask, ret);
    if (ret){
        tp_printf("HD;!;Can't enable bitbang, error=%d %s\n", ret, ftdi_get_error_string(hdkeyb->ftdi));
        return NULL;
    }
        
    ret=ftdi_set_baudrate(hdkeyb->ftdi, 1200);
    if (ret){
        tp_printf("HD;!;Can't set baudrate for ftdi, error=%d %s\n", ret, ftdi_get_error_string(hdkeyb->ftdi));
        return NULL;
    }

    hdkeyb_reset(hdkeyb);
    hdkeyb_clear(hdkeyb);
#if defined(HAVE_SDL) && defined(HAVE_LIBPNG)
    SDL_Surface *png = do_png_create(icon_tucnak23, sizeof(icon_tucnak23));
    if (png) internal_("Can't create icon_tucnak23, currupted executable?");

    hdkeyb_setdir(hdkeyb); 	
    hdkeyb_cursor(hdkeyb, 0);
    for (i = 0; i < 4; i++) hdkeyb_data(hdkeyb, i);
    hdkeyb_cursor(hdkeyb, 64);
    for (i = 4; i < 8; i++) hdkeyb_data(hdkeyb, i);
    hdkeyb_print(hdkeyb, 5, "Tucnak");
    hdkeyb_print(hdkeyb, 12, PACKAGE_VERSION);
    hdkeyb_print(hdkeyb, 64+5, "(C) OK1ZIA");
    hdkeyb_flush(hdkeyb);

    for (i=png->h - 17; i>=0; i--){
        int j, x, y, d, k;
        hdkeyb_cgram(hdkeyb, 0);

        for (j=0; j<64; j++){
            x = ((j % 32) / 8) * 6;
            y = (j / 32) * 9 + j % 8 + i;
            
            
            d = 0;
   //         dbg("j=%d x=%d y=%d\n", j, x, y);
            for (k=0; k<5; k++){
                if (x + k >= png->w) continue;
                if (y >= png->h) continue;
                if (fast_getpixel8(png, 3*(x + k), y) == 0) {
                    d |= 1 << (4 - k); 
                    /*fast_putpixel(sdl->screen, x + k, y - i, makecol(255, 255, 255));
                }else{
                    fast_putpixel(sdl->screen, x + k, y - i, makecol(40, 40, 40));*/
                }
            }
            hdkeyb_data(hdkeyb, d);
        } 
        hdkeyb_flush(hdkeyb);
        /*for (x = 0; x < png->w; x++)
            for (y=0; y < png->h; y++){
                if (fast_getpixel8(png, x*3, y) == 0) {
                    fast_putpixel(sdl->screen, x + 30, y, makecol(255, 255, 255));
                }else{
                    fast_putpixel(sdl->screen, x + 30, y, makecol(40, 40, 40));
                }
                fast_putpixel(sdl->screen, x + 60, y, fast_getpixel8(png, 3*x, y));
            }
        SDL_Rect r;
        r.x = 90;
        r.y = 0;
        r.w = 50;;
        r.h = 50;
        SDL_BlitSurface(png, NULL, sdl->screen, &r);
        SDL_UpdateRect(sdl->screen, 0, 0, sdl->screen->w, sdl->screen->h);*/
        usleep(150000);  
    }
    sleep(2);
#endif

    hdkeyb_clear(hdkeyb);
	hdkeyb_setdir(hdkeyb); 	
    hdkeyb_cgram(hdkeyb, 8);
    hdkeyb_data(hdkeyb, 0x1c); // degree
    hdkeyb_data(hdkeyb, 0x14);
    hdkeyb_data(hdkeyb, 0x1c);
    hdkeyb_data(hdkeyb, 0x00);
    hdkeyb_data(hdkeyb, 0x00);
    hdkeyb_data(hdkeyb, 0x00);
    hdkeyb_data(hdkeyb, 0x00);
    hdkeyb_data(hdkeyb, 0x00);
    hdkeyb_data(hdkeyb, 0x08); // right arrow
    hdkeyb_data(hdkeyb, 0x0c);
    hdkeyb_data(hdkeyb, 0x0e);
    hdkeyb_data(hdkeyb, 0x1f);
    hdkeyb_data(hdkeyb, 0x0e);
    hdkeyb_data(hdkeyb, 0x0c);
    hdkeyb_data(hdkeyb, 0x08);
    hdkeyb_data(hdkeyb, 0x00);
    hdkeyb_data(hdkeyb, 0x02); // left arrow
    hdkeyb_data(hdkeyb, 0x06);
    hdkeyb_data(hdkeyb, 0x0e);
    hdkeyb_data(hdkeyb, 0x1f);
    hdkeyb_data(hdkeyb, 0x0e);
    hdkeyb_data(hdkeyb, 0x06);
    hdkeyb_data(hdkeyb, 0x02);
    hdkeyb_data(hdkeyb, 0x00);
	hdkeyb_flush(hdkeyb);

    while(!hdkeyb->thread_break){
        int li, co;

        g_thread_yield();

        char key = hdkeyb_read_key(hdkeyb);
        if (key){
            tp_printf("HD;k;%c\n", key);
        }

        for (li = 0; li < HDKEYB_LINES; li++){
            for (co = 0; co < HDKEYB_CHARS; co++){
                char vrc = hdkeyb->vram[li][co];
                if (vrc == hdkeyb->oldvram[li][co]) continue;

         //       dbg("1 li=%d co=%d old='%c' c='%c'\n", li, co, hdkeyb->oldvram[li][co], vrc);

			    hdkeyb_setdir(hdkeyb); 	
                hdkeyb_cursor(hdkeyb, li * 64 + co);
                hdkeyb_data(hdkeyb, vrc);
                hdkeyb->oldvram[li][co] = vrc;
                for (co++; co < HDKEYB_CHARS; co++){
                    vrc = hdkeyb->vram[li][co];
           //     	dbg("2 li=%d co=%d old='%c' c='%c'\n", li, co, hdkeyb->oldvram[li][co], vrc);
                    if (vrc == hdkeyb->oldvram[li][co]) break;
                    hdkeyb_data(hdkeyb, vrc);
                    hdkeyb->oldvram[li][co] = vrc;
                }
				hdkeyb_flush(hdkeyb);
            }
        }


    }
    ftdi_set_bitmode(hdkeyb->ftdi, 0x00, BITMODE_RESET);
    ftdi_free(hdkeyb->ftdi);
    return NULL;
}


void hdkeyb_read_handler(char *s){
    struct zstring *zs;
    char *cmd, *key;

    if (!hdkeyb) return;
    zs = zstrdup(s);
    
    cmd = ztokenize(zs, 1);
//     dbg("hdkeyb_read_handler   rcvd: '%s'  cmd='%s'\n", s, cmd);
    if (strcmp(cmd, "!")==0){  /* error */
        log_addf("Hdkeyb error: %s", ztokenize(zs, 0));
    }

    if (strcasecmp(cmd, "k")==0){
		key=ztokenize(zs, 0);
        hdkeyb_key(hdkeyb, key[0]);
    }

    zfree(zs);
    redraw_later();
}

void hdkeyb_key(struct hdkeyb *hdkeyb, char key){
    //dbg("Hdkeyb key='%c'\n", key);
    int len = strlen(hdkeyb->qtfstr);

    switch (key){
        case 'A':
            hdkeyb_activate(hdkeyb, 0);
            return;
        case 'B':
            hdkeyb_activate(hdkeyb, 1);
            return;
    }

    if (len == 0){
        switch(key){
            case 'C':
                hdkeyb_activate(hdkeyb, 2);
                return;
            case 'D':
                hdkeyb_activate(hdkeyb, 3);
                return;
            case '0':
            case '1':
            case '2':
            case '3':
                hdkeyb->qtfstr[len++] = key;
                hdkeyb->qtfstr[len] = '\0';
                break;
            case '4':
                hdkeyb_rel_qtf(hdkeyb, -5);
                return;
            case '6':
                hdkeyb_rel_qtf(hdkeyb, +5);
                return;
            case '7':
                hdkeyb_rel_qtf(hdkeyb, -10);
                return;
            case '9':
                hdkeyb_rel_qtf(hdkeyb, +10);
                return;
            case '*':
                hdkeyb_rel_qtf(hdkeyb, -2);
                return;
            case '#':
                hdkeyb_rel_qtf(hdkeyb, +2);
                return;
        }
    }else{
        switch(key){
            case 'C':
                hdkeyb->qtfstr[len - 1] = '\0';
                return;
            case 'D':
                hdkeyb_set_qtf(hdkeyb);
                return;
        }
        if (key >= '0' && key <= '9'){
            hdkeyb->qtfstr[len++] = key;
            hdkeyb->qtfstr[len] = '\0';
        }
    }
    
    len = strlen(hdkeyb->qtfstr);
    if (len == 3) hdkeyb_set_qtf(hdkeyb);
    hdkeyb_draw_rotar(hdkeyb, hdkeyb->actnr);
}

void hdkeyb_activate(struct hdkeyb *hdkeyb, int nr){
    int oldnr;

	dbg("hdkeyb_activate(%d) old=%d\n", nr, hdkeyb->actnr);
    oldnr = hdkeyb->actnr;
    hdkeyb->actnr = nr;
    hdkeyb_draw_rotar(hdkeyb, oldnr);
    hdkeyb_draw_rotar(hdkeyb, nr);
    hdkeyb->qtfstr[0] = '\0';
}

void hdkeyb_set_qtf(struct hdkeyb *hdkeyb){
    struct rotar *rot;
    int qtf;

    rot = get_rotar(hdkeyb->actnr);
    if (rot){
        qtf = atoi(hdkeyb->qtfstr);
        rot_seek(rot, qtf);
		dbg("******** rot_seek(%c, %d, %03d)\n", rot->rotchar, rot->sdev->saddr, qtf);
    }
    strcpy(hdkeyb->qtfstr, "");
}

void hdkeyb_rel_qtf(struct hdkeyb *hdkeyb, int rel){
    struct rotar *rot;
    int qtf;

    rot = get_rotar(hdkeyb->actnr);
    if (!rot) return;

    qtf = rot->qtf + rel;
    rot_seek(rot, qtf);
}


static long int difftimeval_ms(struct timeval *stop, struct timeval *start){
    int sec, usec; 

    usec = stop->tv_usec - start->tv_usec;
    sec = stop->tv_sec - start->tv_sec;
    if (usec < 0){
        usec += 1000000;
        sec --;
    }
    if (sizeof(long) == 4){
        if (sec > 2000000) sec = 2000000;
    }
    if (sizeof(long) == 2){
        if (sec > 63) sec = 63;
    }
    return (long)sec * 1000L + (long)usec / 1000L;
}






void hdkeyb_send(struct hdkeyb *hdkeyb){
//    dbg("hdkeyb_send(%x) slen=%d\n", (unsigned char)hdkeyb->wr, hdkeyb->slen);
    hdkeyb->sbuf[hdkeyb->slen++] = hdkeyb->wr;
    if (hdkeyb->slen==HDKEYB_BUFLEN) hdkeyb_flush(hdkeyb);
}

int hdkeyb_flush(struct hdkeyb *hdkeyb){
    int ret;
    int l;

    if (!hdkeyb->slen) return 0;

    l = hdkeyb->slen;
    hdkeyb->slen = 0;
    hdkeyb->rlen = 0;

//    dbg("hdkeyb_flush() slen=%d\n", l);
    ret = ftdi_write_data(hdkeyb->ftdi, (unsigned char*)hdkeyb->sbuf, l);
    if (ret != l){
        zwrite(tpipe->threadpipe_write, zconcatesc("HD", "!", "ftdi_write_data", ftdi_get_error_string(hdkeyb->ftdi), NULL));
        return -1;
    }
#if 0
    int i;
    for (i=0; i<l; i++) hdkeyb_debug_pins(hdkeyb->sbuf[i], "f");    
#endif
#if 0
    { int i;
    dbg("w ");
    for (i=0; i<ret; i++) dbg("%02x ", (unsigned char)hdkeyb->sbuf[i]);    
    dbg("\n"); }
#endif

    ret = ftdi_read_data(hdkeyb->ftdi, (unsigned char *)hdkeyb->rbuf, l);
    if (ret < 0){
        zwrite(tpipe->threadpipe_write, zconcatesc("HD", "!", "ftdi_read_data", ftdi_get_error_string(hdkeyb->ftdi), NULL));
        return -1;
    }
#if 0
    for (i=0; i<ret; i++) hdkeyb_debug_pins(hdkeyb->sbuf[i], "f");    
#endif
#if 0
    {int i;
    dbg("r ");
    for (i=0; i<ret; i++) dbg("%02x ", (unsigned char)hdkeyb->sbuf[i]);    
    dbg("\n");}
#endif
    hdkeyb->rlen = ret;

    return 0;
}

int hdkeyb_reset(struct hdkeyb *hdkeyb){
    int ret;
    int d = 1;

    hdkeyb->wr &= ~(PIN_HD_D7|PIN_HD_D6|PIN_HD_D5|PIN_HD_D4|PIN_HD_E|PIN_HD_RW|PIN_HD_RS);
    hdkeyb->wr |= PIN_HD_BUSY;
    
//    dbg("hdkeyb_reset\n");
    hdkeyb_send(hdkeyb);
    hdkeyb_flush(hdkeyb);
    usleep(16000*d); // more than 15 ms

    ret = hdkeyb_cmd_nowait(hdkeyb, 0x3);  // - - - -   0 0 1 DL 
    if (ret) return ret;
    hdkeyb_flush(hdkeyb);
    usleep(5000*d);  // more than 4.1 ms

    ret = hdkeyb_cmd_nowait(hdkeyb, 0x3);
    if (ret) return ret;
    hdkeyb_flush(hdkeyb);
    usleep(1000*d);  // more than 100 us

    ret = hdkeyb_cmd_nowait(hdkeyb, 0x3);
    if (ret) return ret;
    hdkeyb_flush(hdkeyb);
    usleep(6000*d);  

    ret = hdkeyb_cmd_nowait(hdkeyb, 0x2);  // - - - -   0 0 1 DL    datalen
    if (ret) return ret;
    hdkeyb_flush(hdkeyb);
    usleep(10000*d);

    ret = hdkeyb_cmd(hdkeyb, 0x28); // 0 0 1 DL  N F - -     datalen numberlines font
    if (ret) return ret;
    ret = hdkeyb_cmd(hdkeyb, 0x0c); // 0 0 0 0   1 D C B     displayon cursoron blinkcursor
    if (ret) return ret;
    ret = hdkeyb_cmd(hdkeyb, 0x01); // 0 0 0 0   0 0 0 1     clear display, DDRAM addr=0
    if (ret) return ret;
    ret = hdkeyb_cmd(hdkeyb, 0x06); // 0 0 0 0   0 1 I/D S   increment shift
    if (ret) return ret;

    hdkeyb_flush(hdkeyb);
    return 0;
}

int hdkeyb_setdir(struct hdkeyb *hdkeyb){
    int ret;

    int bitmask = (PIN_HD_RS | PIN_HD_RW | PIN_HD_E | PIN_HD_D4 | PIN_HD_D5 | PIN_HD_D6 | PIN_HD_D7);
    ret = ftdi_set_bitmode(hdkeyb->ftdi, bitmask, BITMODE_SYNCBB);
    if (ret){
        zwrite(tpipe->threadpipe_write, zconcatesc("HD", "!", "ftdi_set_bitmode", ftdi_get_error_string(hdkeyb->ftdi), NULL));
        return ret;
    }
    return ret;
}

int hdkeyb_cmd_nowait(struct hdkeyb *hdkeyb, char c){
//    int ret;  
    
//    dbg("hdkeyb_cmd_nowait(%02x)\n", (unsigned char)c);
    PIN(PIN_HD_RS, 0);
    PIN(PIN_HD_RW, 0);
    PIN(PIN_HD_E, 0);
    hdkeyb_send(hdkeyb);

    PIN(PIN_HD_D4, c & 0x01);
    PIN(PIN_HD_D5, c & 0x02);
    PIN(PIN_HD_D6, c & 0x04);
    PIN(PIN_HD_D7, c & 0x08);
    PIN(PIN_HD_E, 1);
    hdkeyb_send(hdkeyb);

    PIN(PIN_HD_E, 0);
    hdkeyb_send(hdkeyb);

    return 0;
}

int hdkeyb_write(struct hdkeyb *hdkeyb, char c){
//    int ret;

//    dbg("hdkeyb_write(%02x) slen=%d\n", (unsigned char)c, hdkeyb->slen);
    PIN(PIN_HD_RW, 0);
    PIN(PIN_HD_E, 0);
    hdkeyb_send(hdkeyb);

    PIN(PIN_HD_D4, c & 0x10);
    PIN(PIN_HD_D5, c & 0x20);
    PIN(PIN_HD_D6, c & 0x40);
    PIN(PIN_HD_D7, c & 0x80);
    PIN(PIN_HD_E, 1);
    hdkeyb_send(hdkeyb);

    PIN(PIN_HD_E, 0);
    hdkeyb_send(hdkeyb);

    PIN(PIN_HD_D4, c & 0x01);
    PIN(PIN_HD_D5, c & 0x02);
    PIN(PIN_HD_D6, c & 0x04);
    PIN(PIN_HD_D7, c & 0x08);
    PIN(PIN_HD_E, 1);
    hdkeyb_send(hdkeyb);
    
    PIN(PIN_HD_E, 0);
    hdkeyb_send(hdkeyb);

    return 0;
}

int hdkeyb_wait(struct hdkeyb *hdkeyb){
    int busy = 1;
    struct timeval start, stop;
    long int diff;

    //usleep(2000);
    return 0;
    gettimeofday(&start, NULL);
    while(busy){
        PIN(PIN_HD_RS, 0);
        PIN(PIN_HD_RW, 1); // read
        PIN(PIN_HD_E, 0);
        hdkeyb_send(hdkeyb);
        
        PIN(PIN_HD_E, 1);
        hdkeyb_send(hdkeyb);

        PIN(PIN_HD_E, 0);
        hdkeyb_send(hdkeyb);
        
        PIN(PIN_HD_E, 1);
        hdkeyb_send(hdkeyb);

        PIN(PIN_HD_E, 0);
        hdkeyb_send(hdkeyb);
        busy = hdkeyb->rd & PIN_HD_BUSY;

        gettimeofday(&stop, NULL);
        diff = difftimeval_ms(&stop, &start);
        if (diff > 5) {
            error("hdkeyb_wait: no BUSY reply\n");
            break;
        }
    }
    return 0;
}
                                

int hdkeyb_cmd(struct hdkeyb *hdkeyb, char c){
    int ret;

#if 0
	if (c & 0x80)
	    dbg("hdkeyb_cursor(0x%02d)\n", ((unsigned char)c)&0x7f);
	else if (c & 0x80)
		dbg("hdkeyb_cgram(0x%02x)\n", ((unsigned char)c)&0x3f);
	else
		dbg("hdkeyb_cmd(0x%02x)\n", (unsigned char)c);
#endif

    PIN(PIN_HD_RS, 0);
    ret = hdkeyb_write(hdkeyb, c);
    if (ret) return ret;

    ret = hdkeyb_wait(hdkeyb);
    if (ret) return ret;
    return 0;
}

int hdkeyb_data(struct hdkeyb *hdkeyb, char c){
    int ret;

//    dbg("hdkeyb_data(0x%02x)\n", (unsigned char)c);
    PIN(PIN_HD_RS, 1);
    ret = hdkeyb_write(hdkeyb, c);
    if (ret) return ret;

    ret = hdkeyb_wait(hdkeyb);
    if (ret) return ret;

    return 0;
}

void hdkeyb_cgram(struct hdkeyb *hdkeyb, char pos) {
    hdkeyb_cmd(hdkeyb, 0x40|(pos&0x7f));
    return;
}

void hdkeyb_printc(struct hdkeyb *hdkeyb, char *str){
    hdkeyb_setdir(hdkeyb);
    while (*str) {
        hdkeyb_data(hdkeyb, *str);
        str++;
    }
    hdkeyb_flush(hdkeyb);
} 

void hdkeyb_printf(struct hdkeyb *hdkeyb, char line, char col, char *m, ...){
    va_list l;
    int li, co;
    char *s, *c;
    
    if (line < 0 || col < 0) return;

    va_start(l, m);
    s = g_strdup_vprintf(m, l);
    va_end(l);

    li = line;
    co = col;
    for (c = s; *c != '\0'; c++){
        if (*c == '\n'){
            li++;
            co = 0;
        }
        if (li < HDKEYB_LINES && co < HDKEYB_CHARS){
            hdkeyb->vram[li][co++] = *c;
        }
    }

    g_free(s);
}
void hdkeyb_print(struct hdkeyb *hdkeyb, char pos, char *str){
    hdkeyb_setdir(hdkeyb);
    hdkeyb_cursor(hdkeyb, pos);
    while(*str){
        hdkeyb_data(hdkeyb, *str);
        str++;
        pos++;
#ifdef MC1601       
        if (pos==0+8) hdkeyb_cursor(hdkeyb, pos=64);
        if (pos==64+8) hdkeyb_cursor(hdkeyb, pos=0);
#endif      
    }
    hdkeyb_flush(hdkeyb);
}

void hdkeyb_clear(struct hdkeyb *hdkeyb){
    unsigned char i;
    
    hdkeyb_cursor(hdkeyb, LINE_1);
    for (i=20;i;i--) {
        hdkeyb_data(hdkeyb, ' ');
    }
    
    hdkeyb_cursor(hdkeyb, LINE_2);
    for (i=20;i;i--) {
        hdkeyb_data(hdkeyb, ' ');
    }
}


/* keyboard routines */
char hdkeyb_keyb_state(struct hdkeyb *hdkeyb){
    int ret, cnt;
    char scan;

    int bitmask = (PIN_HD_RS | PIN_HD_RW | PIN_HD_E );
    ret = ftdi_set_bitmode(hdkeyb->ftdi, bitmask, BITMODE_SYNCBB);
    if (ret){
        zwrite(tpipe->threadpipe_write, zconcatesc("HD", "!", "ftdi_set_bitmode", ftdi_get_error_string(hdkeyb->ftdi), NULL));
        return 0xff;
    }
    hdkeyb_flush(hdkeyb);
    PIN(PIN_HD_D4,1);
    PIN(PIN_HD_D5,1);
    PIN(PIN_HD_D6,1);
    PIN(PIN_HD_D7,1);
    PIN(PIN_HD_BUSY,1);
    PIN(PIN_KEYB_A0,0);
    PIN(PIN_KEYB_A1,0);
    PIN(PIN_KEYB_A2,0);
    PIN(PIN_HD_E,0);  // already 0
    hdkeyb_send(hdkeyb);

    PIN(PIN_KEYB_A0,1);
    PIN(PIN_KEYB_A1,0);
    hdkeyb_send(hdkeyb);

    PIN(PIN_KEYB_A0,0);
    PIN(PIN_KEYB_A1,1);
    hdkeyb_send(hdkeyb);

    PIN(PIN_KEYB_A0,1);
    PIN(PIN_KEYB_A1,1);
    hdkeyb_send(hdkeyb);
    hdkeyb_send(hdkeyb);
    hdkeyb_flush(hdkeyb);

    cnt = 0;
    scan = 0xff;
    
    if (!(hdkeyb->rbuf[1] & PIN_HD_D4)) { scan = 'A'; cnt++; }
    if (!(hdkeyb->rbuf[1] & PIN_HD_D5)) { scan = '3'; cnt++; }
    if (!(hdkeyb->rbuf[1] & PIN_HD_D6)) { scan = '2'; cnt++; }
    if (!(hdkeyb->rbuf[1] & PIN_HD_D7)) { scan = '1'; cnt++; }

    if (!(hdkeyb->rbuf[2] & PIN_HD_D4)) { scan = 'B'; cnt++; }
    if (!(hdkeyb->rbuf[2] & PIN_HD_D5)) { scan = '6'; cnt++; }
    if (!(hdkeyb->rbuf[2] & PIN_HD_D6)) { scan = '5'; cnt++; }
    if (!(hdkeyb->rbuf[2] & PIN_HD_D7)) { scan = '4'; cnt++; }

    if (!(hdkeyb->rbuf[3] & PIN_HD_D4)) { scan = 'C'; cnt++; }
    if (!(hdkeyb->rbuf[3] & PIN_HD_D5)) { scan = '9'; cnt++; }
    if (!(hdkeyb->rbuf[3] & PIN_HD_D6)) { scan = '8'; cnt++; }
    if (!(hdkeyb->rbuf[3] & PIN_HD_D7)) { scan = '7'; cnt++; }

    if (!(hdkeyb->rbuf[4] & PIN_HD_D4)) { scan = 'D'; cnt++; }
    if (!(hdkeyb->rbuf[4] & PIN_HD_D5)) { scan = '#'; cnt++; }
    if (!(hdkeyb->rbuf[4] & PIN_HD_D6)) { scan = '0'; cnt++; }
    if (!(hdkeyb->rbuf[4] & PIN_HD_D7)) { scan = '*'; cnt++; }
//    dbg("%d %c\n", scan, scan);

    if (cnt != 1) return 0xff;
    return scan;
}

char hdkeyb_read_key(struct hdkeyb *hdkeyb){
    char state;

    state = hdkeyb_keyb_state(hdkeyb);
    if (state == hdkeyb->oldkeystate) return '\0';
    hdkeyb->oldkeystate = state;
    return state;
}

int hdkeyb_debug_pins(char a, char *t){
    dbg("%s E=%d  RS=%d  RW=%d  D=%d  BUSY=%d\n", 
            t,
            !!(a & PIN_HD_E),
            !!(a & PIN_HD_RS),
            !!(a & PIN_HD_RW),
            (!!(a & PIN_HD_D4))+ 
            (!!(a & PIN_HD_D5))*2+ 
            (!!(a & PIN_HD_D6))*4+ 
            (!!(a & PIN_HD_D7))*8, 
            !!(a & PIN_HD_BUSY));
    return 0;
}

void hdkeyb_draw_rotar(struct hdkeyb *hdkeyb, int nr){
    int li, co;

    if (!hdkeyb) return;
    struct rotar *rot = get_rotar(nr);
    if (!rot) return;

    li = nr / 2;
    co = (nr % 2) * HDKEYB_CHARS / 2;
//	dbg("nr=%d li=%d co=%d\n", nr, li, co);

    if (nr == hdkeyb->actnr){
        if (strlen(hdkeyb->qtfstr) > 0){
            hdkeyb_printf(hdkeyb, li, co, "\x02%c%3s\x01\x03", 
                    'A' + nr,
                    hdkeyb->qtfstr);
        }else{
            hdkeyb_printf(hdkeyb, li, co, "\x02%c%03d\x01\x03", 
                    'A' + nr,
                    rot->qtf);
        }
    }else{
        hdkeyb_printf(hdkeyb, li, co, " %c%03d\x01 ", 
                'A' + nr,
                rot->qtf);
    }


}

void hdkeyb_draw_rotars(struct hdkeyb *hdkeyb){
    int i;
//	return;
    for (i=0; i < HDKEYB_LINES * 2; i++) 
        hdkeyb_draw_rotar(hdkeyb, i);          

	//hdkeyb_dump_vrams(hdkeyb);
}

#if 0
int hdkeyb_test(void){
    struct hdkeyb *hdkeyb;
    int i;

    dbg("\n\n\n");
    hdkeyb = init_hdkeyb();
    if (!hdkeyb) {
        error("init_hdkeyb() failed\n");
        return -1;
    }
    hdkeyb_setdir(hdkeyb);
    hdkeyb_reset(hdkeyb);
    usleep(300000);

/*//    dbg("1 %x\n", hdkeyb->rd);
    hdkeyb->wr = 0x55;
    WRITE;
//    dbg("2 %x\n", hdkeyb->rd);
    hdkeyb->wr = 0xaa;
    WRITE;
//    dbg("3 %x\n", hdkeyb->rd);
    READ;
//    dbg("4 %x\n", hdkeyb->rd);
    READ;
    READ;
//    dbg("5 %x\n", hdkeyb->rd);
    hdkeyb_free(hdkeyb);
    */

/*    while(1){
        int a= hdkeyb_key(hdkeyb);
        if (a==0) continue;
        dbg("%c\n", a);
    } */
//  gst_start();
//    hdkeyb_print2(hdkeyb, 0, "ABC");
    char ss[50];
    strcpy(ss, "");
    for (i=0; i<100000000; i++){
        char s[50];
        sprintf(s, "jedeme %d", i);
        hdkeyb_setdir(hdkeyb);
        hdkeyb_print(hdkeyb, 80, s);
        
        int a= hdkeyb_key(hdkeyb);
        if (a==0) continue;
        if (a==-1) continue;

        dbg("%d\n", a);
        switch(a){
            case 'C':
                if (strlen(ss)==0) break;
                ss[strlen(ss)-1]='\0';
                break;
            default:
                if (strlen(ss)==15) break;
                ss[strlen(ss)+1]='\0';
                ss[strlen(ss)]=a;
                break;
        }
        sprintf(s, "%-16s", ss);
        hdkeyb_print(hdkeyb, 16, s);
        
    }
//  gst_stop();
    return 0;
}
#endif
#endif
