/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

*/

#include "header.h"

/******************** MISC OPTIONS *******************************/


char loglines_str[MAX_STR_LEN],skedshift_str[MAX_STR_LEN],skedcount_str[MAX_STR_LEN],startbandchar_str[MAX_STR_LEN];
char gfx_x_ch_str[MAX_STR_LEN],gfx_y_ch_str[MAX_STR_LEN];
char gfx_x_px_str[MAX_STR_LEN],gfx_y_px_str[MAX_STR_LEN];
char fontheight_str[EQSO_LEN];
char slashkey[3];
int dssaver;

void refresh_misc_opts(void *xxx)
{
    struct config_band *confb;
    int gfx_x_ch, gfx_y_ch, gfx_x_px, gfx_y_px;
    int new_x, new_y, resize;

    STORE_SINT(cfg,loglines);
    STORE_SINT(cfg,skedshift);
    STORE_SINT(cfg,skedcount);

    confb=get_config_band_by_bandchar(startbandchar_str[0]);
    if (confb){
        CONDGFREE(cfg->startband);
        cfg->startband=g_strdup(confb->pband);
    }
    gfx_x_ch=atoi(gfx_x_ch_str);
    gfx_y_ch=atoi(gfx_y_ch_str);
    gfx_x_px=atoi(gfx_x_px_str);
    gfx_y_px=atoi(gfx_y_px_str);
    STORE_STR(cfg, slashkey);
    STORE_INT(cfg, dssaver);
    
    new_x=800;
    new_y=600;
    resize=0;
    
    if (atoi(fontheight_str)!=cfg->fontheight) {
        cfg->fontheight = atoi(fontheight_str);
        resize++;
    }

#ifdef HAVE_SDL    
    if (sdl){
        if (gfx_x_ch>10 && gfx_y_ch>10){
            if (gfx_x_ch*sdl->font_w!=cfg->gfx_x ||
                gfx_y_ch*sdl->font_h!=cfg->gfx_y){
                new_x=gfx_x_ch*sdl->font_w;
                new_y=gfx_y_ch*sdl->font_h;
                resize++;
            }
        }
        if (gfx_x_px>100 && gfx_y_px>100){
            if (gfx_x_px!=cfg->gfx_x ||
                gfx_y_px!=cfg->gfx_y){
                new_x=gfx_x_px;
                new_y=gfx_y_px;
                resize++;
            }
        }

        if (resize && new_x<=2048 && new_y<=2048) {
            cfg->gfx_x=new_x;
            cfg->gfx_y=new_y;
            sdl_setvideomode(new_x, new_y, 0);
            resize_terminal(CBA0);
        }
    }
    
#endif  
}

void misc_opts(cba_t cba)
{
    struct dialog *d;
    int i;
    struct config_band *confb;

    g_snprintf(loglines_str, MAX_STR_LEN, "%d", cfg->loglines);
    g_snprintf(skedshift_str, MAX_STR_LEN, "%d", cfg->skedshift);
    g_snprintf(skedcount_str, MAX_STR_LEN, "%d", cfg->skedcount);
    
    confb=get_config_band_by_pband(cfg->startband);
    if (!confb) confb=(struct config_band *)g_ptr_array_index(cfg->bands,0);
    startbandchar_str[0]=toupper(confb->bandchar);
    startbandchar_str[1]='\0';

//    dbg("gfx_x=%d gfx_x=%d %%=%d %d\n", cfg->gfx_x, cfg->gfx_y, cfg->gfx_x%sdl->font_w, cfg->gfx_y%font_h);
#ifdef HAVE_SDL        
    if (sdl){
        if (cfg->gfx_x%sdl->font_w!=0 || cfg->gfx_y%sdl->font_h!=0){
            strcpy(gfx_x_ch_str, "");
            strcpy(gfx_y_ch_str, "");
        }else{
            g_snprintf(gfx_x_ch_str, MAX_STR_LEN, "%d", cfg->gfx_x/sdl->font_w);
            g_snprintf(gfx_y_ch_str, MAX_STR_LEN, "%d", cfg->gfx_y/sdl->font_h);
        }
    }
    else
#endif        
    {
        strcpy(gfx_x_ch_str, "");
        strcpy(gfx_y_ch_str, "");
    }

    g_snprintf(gfx_x_px_str, MAX_STR_LEN, "%d", cfg->gfx_x);
    g_snprintf(gfx_y_px_str, MAX_STR_LEN, "%d", cfg->gfx_y);
    g_snprintf(fontheight_str, EQSO_LEN, "%d", cfg->fontheight);
    safe_strncpy0(slashkey, cfg->slashkey, sizeof(slashkey));
    dssaver = cfg->dssaver;


    if (!(d = mem_alloc(sizeof(struct dialog) + 20 * sizeof(struct dialog_item)))) return;
    memset(d, 0, sizeof(struct dialog) + 20 * sizeof(struct dialog_item));
    d->title = VTEXT(T_MISCOPTS);
    d->fn = dlg_pf_fn;
    d->refresh = (void (*)(void *))refresh_misc_opts;
    d->y0 = 1;
    

    d->items[i=0].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = loglines_str;
    d->items[i].maxl = 3;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 1;
    d->items[i].gnum = 30;
    d->items[i].msg = CTEXT(T_LOGLINES);
    d->items[i].wrap = 1;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = skedshift_str;
    d->items[i].maxl = 3;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 0;
    d->items[i].gnum = 10;
    d->items[i].msg = CTEXT(T_SKEDSHIFT);
    d->items[i].wrap = 1;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = skedcount_str;
    d->items[i].maxl = 3;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 0;
    d->items[i].gnum = 10;
    d->items[i].msg = CTEXT(T_SKEDCOUNT);
    d->items[i].wrap = 1;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = startbandchar_str;
    d->items[i].maxl = 3;
    d->items[i].msg = CTEXT(T_STARTBAND);
    d->items[i].wrap = 1;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = gfx_x_ch_str;
    d->items[i].maxl = 5;
    d->items[i].msg = CTEXT(T_GFX_X_CH);
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = gfx_y_ch_str;
    d->items[i].maxl = 5;
    d->items[i].msg = CTEXT(T_GFX_Y_CH);
    d->items[i].wrap = 1;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = gfx_x_px_str;
    d->items[i].maxl = 5;
    d->items[i].msg = CTEXT(T_GFX_X_PX);
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = gfx_y_px_str;
    d->items[i].maxl = 5;
    d->items[i].msg = CTEXT(T_GFX_Y_PX);
    d->items[i].wrap = 1;
    
    d->items[++i].type = D_FIELD;
    d->items[i].gid  = 16;
    d->items[i].gnum = 32;
    d->items[i].maxl = 5;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = fontheight_str;
    d->items[i].msg = CTEXT(T_FONTHEIGHT);
    d->items[i].wrap = 1;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = 3;
    d->items[i].data = slashkey;
    d->items[i].maxl = 2;
    d->items[i].msg = CTEXT(T_SLASHKEY);
    d->items[i].wrap = 1;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid  = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (char *)&dssaver;
    d->items[i].msg = CTEXT(T_DSSAVER);
    d->items[i].wrap = 2;
    
    
    d->items[++i].type = D_BUTTON;   /* 9 */
    d->items[i].gid = B_ENTER;
    d->items[i].fn = ok_dialog;
    d->items[i].text = VTEXT(T_OK);
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ESC;
    d->items[i].fn = cancel_dialog;
    d->items[i].text = VTEXT(T_CANCEL);
    d->items[i].align = AL_BUTTONS;
    d->items[i].wrap = 1;
    
    d->items[++i].type = D_END;
    do_dialog(d, getml(d, NULL));
}

/*********************** FIXQRG - Change operator *************************/

#ifdef HAVE_HAMLIB
void fixqrg(struct session *ses, char *qrgstr){
    gdouble newqrg;

    if (!qrgstr) return;

    
    newqrg = atof(qrgstr);
    if (newqrg<=0){
        errbox(CTEXT(T_BAD_QRG), 0);
        return;
    }

    set_rig_lo(aband, get_rig_lo(aband) + newqrg - trig->qrg);
    
    trig_resend_freq(trig);
//    redraw_later();
}

void menu_fixqrg(struct terminal *term, void *d, struct session *ses){
    static char qrgstr[EQSO_LEN];
    
    if (!ctest || !aband || !trig) return;
    
    g_snprintf(qrgstr, EQSO_LEN, "%1.0f", trig->qrg);

    input_field(NULL, CTEXT(T_FIXQRG), CTEXT(T_ENTER_QRG) ,
               CTEXT(T_OK), CTEXT(T_CANCEL), ses, 
               NULL, 20, qrgstr, 0, 0, NULL,
               (void (*)(void *, char *)) fixqrg, NULL, 0);

}
#endif


/************************** winkey ******************************/

int wk_wk2, wk_usepot, wk_usebut, wk_keymode, wk_swap;


void refresh_winkey_opts(void *xxx)
{
    STORE_INT(cfg, wk_wk2);
    STORE_INT(cfg, wk_usepot);
    STORE_INT(cfg, wk_usebut);
    STORE_INT(cfg, wk_keymode);
    STORE_INT(cfg, wk_swap);
}

char *winkey_opts_msg[] = {
    CTEXT(T_WK_WK2),
    CTEXT(T_WK_USEPOT),
    CTEXT(T_WK_USEBUT),
    CTEXT(T_WK_KM_B), 
    CTEXT(T_WK_KM_A), 
    CTEXT(T_WK_KM_U), 
    CTEXT(T_WK_KM_G), 
    CTEXT(T_WK_SWAP), 
    "",
    ""
};

void winkey_opts_fn(struct dialog_data *dlg)
{
    struct terminal *term = dlg->win->term;
    int max = 0, min = 0;
    int w, rw;
    int y = -1;

    max_group_width(term, winkey_opts_msg + 0, dlg->items + 0, 1, &max);
    min_group_width(term, winkey_opts_msg + 0, dlg->items + 0, 1, &min);
    max_group_width(term, winkey_opts_msg + 1, dlg->items + 1, 2, &max);
    min_group_width(term, winkey_opts_msg + 1, dlg->items + 1, 2, &min);
    max_group_width(term, winkey_opts_msg + 3, dlg->items + 3, 4, &max);
    min_group_width(term, winkey_opts_msg + 3, dlg->items + 3, 4, &min);
    max_group_width(term, winkey_opts_msg + 7, dlg->items + 1, 1, &max);
    min_group_width(term, winkey_opts_msg + 7, dlg->items + 1, 1, &min);
    
    max_buttons_width(term, dlg->items + 8, 2, &max);
    min_buttons_width(term, dlg->items + 8, 2, &min);
    
    w = dlg->win->term->x * 9 / 10 - 2 * DIALOG_LB;
    if (w > max) w = max;
    if (w < min) w = min;
    if (w > dlg->win->term->x - 2 * DIALOG_LB) w = dlg->win->term->x - 2 * DIALOG_LB;
    if (w < 1) w = 1;
    
    rw = 0;
    y ++;
    dlg_format_group(NULL, term, winkey_opts_msg + 0, dlg->items + 0, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, winkey_opts_msg + 1, dlg->items + 1, 2, 0, &y, w, &rw);
    dlg_format_group(NULL, term, winkey_opts_msg + 3, dlg->items + 3, 4, 0, &y, w, &rw);
    dlg_format_group(NULL, term, winkey_opts_msg + 7, dlg->items + 7, 1, 0, &y, w, &rw);
    y++;
    dlg_format_buttons(NULL, term, dlg->items +8, 2, 0, &y, w, &rw, AL_LEFT);
    
    
    w = rw;
    dlg->xw = w + 2 * DIALOG_LB;
    dlg->yw = y + 2 * DIALOG_TB;

    
    center_dlg(dlg);
    draw_dlg(dlg);
    y = dlg->y + DIALOG_TB;
    y++;
    dlg_format_group(term, term, winkey_opts_msg + 0, dlg->items + 0, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, winkey_opts_msg + 1, dlg->items + 1, 2, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, winkey_opts_msg + 3, dlg->items + 3, 4, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, winkey_opts_msg + 7, dlg->items + 7, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_buttons(term, term, dlg->items +8, 2, dlg->x + DIALOG_LB, &y, w, NULL, AL_LEFT);
}

void winkey_opts(cba_t cba)
{
    struct dialog *d;
    int i;

    wk_wk2 = cfg->wk_wk2;
    wk_usepot = cfg->wk_usepot;
    wk_usebut = cfg->wk_usebut;
    wk_keymode = cfg->wk_keymode;
    wk_swap = cfg->wk_swap;


    if (!(d = mem_alloc(sizeof(struct dialog) + 20 * sizeof(struct dialog_item)))) return;
    memset(d, 0, sizeof(struct dialog) + 20 * sizeof(struct dialog_item));
    d->title = VTEXT(T_WINKEYOPTS); 
    d->fn = winkey_opts_fn;
    d->refresh = (void (*)(void *))refresh_winkey_opts;
    
    d->items[i=0].type = D_CHECKBOX;    /* 0 */
    d->items[i].gid  = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (char *)&wk_wk2;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid  = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (char *)&wk_usepot;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid  = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (char *)&wk_usebut;
    
    d->items[++i].type = D_CHECKBOX;  /* 3 */
    d->items[i].gid  = 1;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (char *)&wk_keymode;

    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid  = 1;
    d->items[i].gnum = 2;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (char *)&wk_keymode;

    d->items[++i].type = D_CHECKBOX;       /* 5 */
    d->items[i].gid  = 1;
    d->items[i].gnum = 3;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (char *)&wk_keymode;

    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid  = 1;
    d->items[i].gnum = 4;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (char *)&wk_keymode;

    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid  = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (char *)&wk_swap;

    
    d->items[++i].type = D_BUTTON;   /* 8 */
    d->items[i].gid = B_ENTER;
    d->items[i].fn = ok_dialog;
    d->items[i].text = VTEXT(T_OK);
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ESC;
    d->items[i].fn = cancel_dialog;
    d->items[i].text = VTEXT(T_CANCEL);
    
    d->items[++i].type = D_END;
    do_dialog(d, getml(d, NULL));
}

int dlg_winkey_opts(struct dialog_data *dd, struct dialog_item_data *did){
    winkey_opts(CBA0);
    return 0;
}


/************************** rig ******************************/
#ifdef HAVE_HAMLIB
char rig_filename[MAX_STR_LEN];
char rig_model_str[EQSO_LEN];
char rig_speed_str[EQSO_LEN];
/* choose manufacturer */
char rig_civaddr_str[EQSO_LEN];
char rig_ssbcw_shift_str[EQSO_LEN];
char rig_lo_str[MAX_STR_LEN];
//int rig_poll_ms;
char rig_poll_ms_str[MAX_STR_LEN];
int rig_qrg_r2t, rig_qrg_t2r, rig_mode_t2r, rig_clr_rit, rig_verbose;

char new_model_str[EQSO_LEN];

void set_rig (cba_t cba){
    struct rig_caps *mcaps;
    
    if (cba.int_<0 || cba.int_>=riglist->len) return;
    mcaps = (struct rig_caps *)g_index_array_index(riglist, cba.int_);
    
    dbg("%4d %4d %-20s %s\n", cba.int_, mcaps->rig_model, mcaps->mfg_name, mcaps->model_name);
    g_snprintf(new_model_str, EQSO_LEN, "%d", mcaps->rig_model);
    dbg("set_rig: new_model_str = '%s'\n", new_model_str);
    redraw_later();
}
    
void choose_rig (cba_t cba){
    struct rig_caps *mcaps;
    int i, sel=0, model;
    struct menu_item *mi;
    
    if (cba.int_<0 || cba.int_>=riglist->len) return;
    mcaps = (struct rig_caps *)g_index_array_index(riglist, cba.int_);
    
    dbg("%4d %4d %-20s %s\n", cba.int_, mcaps->rig_model, mcaps->mfg_name, mcaps->model_name);
    
    if (!(mi = new_menu(1))) return;

    model=cfg->rig_model;
    for (i=cba.int_; i<riglist->len; i++){
        struct rig_caps *caps = (struct rig_caps *)g_index_array_index(riglist, i);
        if (strcasecmp(mcaps->mfg_name, caps->mfg_name)!=0) break;
        if (model==caps->rig_model) sel = i - cba.int_;
        add_to_menu(&mi, (char *)caps->model_name, "", "", MENU_FUNC set_rig, (cba_t)i, 0);
    }
    
    dbg("sel=%d\n", sel);
    do_menu_selected(mi, CBA0, sel);
    
}

int choose_manufacturer(struct dialog_data *dlg, struct dialog_item_data *di){
    int i, sel=0, j=0, same, model;
    struct menu_item *mi;
    const char *old = NULL;
    
    if (!(mi = new_menu(1))) return 0;
    
    model=cfg->rig_model;
    dbg("rig_model=%d\n", model);
    for (i=0; i<riglist->len; i++){
        struct rig_caps *caps = (struct rig_caps *)g_index_array_index(riglist, i);
        same=0;
        if (old && strcasecmp(old, caps->mfg_name)==0) same=1;
        
        if (model==caps->rig_model) {
            dbg("i=%d j=%d\n", i, j);
            sel = j;
            if (same) sel--;
        }
        if (same) continue;
        
        add_to_menu(&mi, (char *)caps->mfg_name, "", "", MENU_FUNC choose_rig, (cba_t)i, 0);
        old = caps->mfg_name;
        j++;
    }
    dbg("sel=%d\n", sel);
    do_menu_selected(mi, CBA0, sel);
    return 0;
}

void refresh_rig_opts(void *xxx){
    STORE_STR(cfg, rig_filename);
    STORE_SINT(cfg, rig_model);
    STORE_SINT(cfg, rig_speed);
    STORE_SINT(cfg, rig_civaddr);
    STORE_SINT(cfg, rig_ssbcw_shift);
    STORE_SDBL(cfg, rig_lo);
    STORE_SINT(cfg, rig_poll_ms);
    STORE_INT(cfg, rig_qrg_r2t);
    STORE_INT(cfg, rig_qrg_t2r);
    STORE_INT(cfg, rig_mode_t2r);
    STORE_INT(cfg, rig_clr_rit);
    STORE_INT(cfg, rig_verbose);
    free_trig(trig);
    trig = init_trig();        
}

void rig_opts_fn(struct dialog_data *dlg)
{
    if (strlen(new_model_str)>0){
        dbg("new_model_str=%s\n", new_model_str);
        safe_strncpy0(dlg->items[1].cdata, new_model_str, EQSO_LEN);
        strcpy(new_model_str, "");
    }

}

void menu_rig_opts(cba_t cba)
{
    struct dialog *d;
    int i;

    safe_strncpy0(rig_filename, cfg->rig_filename, MAX_STR_LEN);
    g_snprintf(rig_model_str, EQSO_LEN, "%d", cfg->rig_model);
    g_snprintf(rig_speed_str, EQSO_LEN, "%d", cfg->rig_speed);
    g_snprintf(rig_civaddr_str, EQSO_LEN, "%d", cfg->rig_civaddr);
    g_snprintf(rig_ssbcw_shift_str, EQSO_LEN, "%d", cfg->rig_ssbcw_shift);
    g_snprintf(rig_lo_str, MAX_STR_LEN, "%1.1f", cfg->rig_lo);
    g_snprintf(rig_poll_ms_str, MAX_STR_LEN, "%d", cfg->rig_poll_ms);

    rig_qrg_r2t = cfg->rig_qrg_r2t;
    rig_qrg_t2r = cfg->rig_qrg_t2r;
    rig_mode_t2r = cfg->rig_mode_t2r;
    rig_clr_rit = cfg->rig_clr_rit;
    rig_verbose = cfg->rig_verbose;

    strcpy(new_model_str, "");
    

    if (!(d = mem_alloc(sizeof(struct dialog) + 20 * sizeof(struct dialog_item)))) return;
    memset(d, 0, sizeof(struct dialog) + 20 * sizeof(struct dialog_item));
    d->title = VTEXT(T_RIGOPTS); 
//    d->fn = rig_opts_fn;
    d->fn = dlg_pf_fn;
    d->fn2 = rig_opts_fn;
    d->refresh = (void (*)(void *))refresh_rig_opts;
    d->y0 = 1;
    
    d->items[i=0].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = rig_filename;
    d->items[i].maxl = 35;
    d->items[i].msg  = CTEXT(T_RIG_DEVICE);
    d->items[i].wrap = 1;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = rig_model_str;
    d->items[i].maxl = 7;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 0;
    d->items[i].msg  = CTEXT(T_RIG_MODEL);
    d->items[i].gnum = 20000;

    d->items[++i].type = D_BUTTON;   /* 2 */
    d->items[i].gid = 0;
    d->items[i].fn = choose_manufacturer;
    d->items[i].text = VTEXT(T_RIG_CHOOSE);
    d->items[i].wrap = 1;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = rig_speed_str;
    d->items[i].maxl = 7;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 0;
    d->items[i].msg  = CTEXT(T_RIG_SPEED);
    d->items[i].gnum = 999999;
    d->items[i].wrap = 1;

    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = rig_civaddr_str;
    d->items[i].maxl = 4;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 0;
    d->items[i].msg  = CTEXT(T_RIG_CIV);
    d->items[i].gnum = 255;

    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = rig_ssbcw_shift_str;
    d->items[i].maxl = 5;
    d->items[i].fn   = check_number;
    d->items[i].gid  = -2000;
    d->items[i].gnum = +2000;
    d->items[i].msg  = CTEXT(T_RIG_FREQSHIFT);
    d->items[i].wrap = 1;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = rig_lo_str;
    d->items[i].maxl = 16;
    d->items[i].fn   = check_qrg;
    d->items[i].msg  = CTEXT(T_BAND_LO);
    d->items[i].wrap = 1;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = rig_poll_ms_str;
    d->items[i].maxl = 6;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 0;
    d->items[i].gnum = 9999;
    d->items[i].msg  = CTEXT(T_RIG_POLL_MS);
    d->items[i].wrap = 1;

    
    d->items[++i].type = D_CHECKBOX;      
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data=(char *)&rig_qrg_r2t;
    d->items[i].msg = CTEXT(T_RIG_QRG_R2T);
    d->items[i].wrap = 1;

    d->items[++i].type = D_CHECKBOX;      
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data=(char *)&rig_qrg_t2r;
    d->items[i].msg = CTEXT(T_RIG_QRG_T2R);
    d->items[i].wrap = 1;

    d->items[++i].type = D_CHECKBOX;      
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data=(char *)&rig_mode_t2r;
    d->items[i].msg = CTEXT(T_RIG_MODE_T2R);
    d->items[i].wrap = 1;

    d->items[++i].type = D_CHECKBOX;      
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data=(char *)&rig_clr_rit;
    d->items[i].msg = CTEXT(T_RIG_CLR_RIT);
    d->items[i].wrap = 1;

    d->items[++i].type = D_CHECKBOX;      
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data=(char *)&rig_verbose;
    d->items[i].msg = CTEXT(T_RIG_DEBUG);
    d->items[i].wrap = 2;

    
    d->items[++i].type = D_BUTTON;   /* 6 */
    d->items[i].gid = B_ENTER;
    d->items[i].fn = ok_dialog;
    d->items[i].text = VTEXT(T_OK);
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ESC;
    d->items[i].fn = cancel_dialog;
    d->items[i].text = VTEXT(T_CANCEL);
    d->items[i].align = AL_BUTTONS;
    d->items[i].wrap = 1;
    
    d->items[++i].type = D_END;
    do_dialog(d, getml(d, NULL));
}
#endif
    


/************************** rotar ******************************/

char rot_desc[MAX_STR_LEN];
int rot_type;
char rot_filename[MAX_STR_LEN], rot_hostname[MAX_STR_LEN]; 
char rot_port_str[EQSO_LEN];
char rot_vid_str[EQSO_LEN];
char rot_pid_str[EQSO_LEN];
char rot_serial[EQSO_LEN];
char rot_timeout_ms_str[EQSO_LEN];
char rot_beamwidth_str[EQSO_LEN];
char rot_saddr_str[EQSO_LEN], rot_model_str[EQSO_LEN];
char rot_rem_rotstr[EQSO_LEN];

void refresh_rotar_opts(void *xxx){
    struct config_rotar *crot = (struct config_rotar *)xxx;

    if (!crot) {
        crot = g_new0(struct config_rotar, 1);
        crot->nr = cfg->crotars->len;
        g_ptr_array_add(cfg->crotars, crot);
        
    }

    STORE_STR (crot, rot_desc);
    STORE_INT (crot, rot_type);
    STORE_STR (crot, rot_filename); 
    STORE_STR (crot, rot_hostname); 
    STORE_SINT(crot, rot_port);
    STORE_SHEX(crot, rot_vid);
    STORE_SHEX(crot, rot_pid);
    STORE_STR (crot, rot_serial);
    STORE_SINT(crot, rot_timeout_ms);
    STORE_SINT(crot, rot_beamwidth);
    STORE_SINT(crot, rot_model);
    STORE_SINT(crot, rot_saddr);
    STORE_STR (crot, rot_rem_rotstr); 

    free_rotars();
    init_rotars();
}
        

void menu_rotar_opts(cba_t cba){
    struct dialog *d;
    int i, roti;
    struct config_rotar *crot;

	roti = (int)GETCBA(cba, int_);
    dbg("menu_rotar_opts(%d)\n", roti);
    if (roti >= (int)cfg->crotars->len) return;

    if (roti < 0){
        crot = NULL;
        
        safe_strncpy0(rot_desc, "", MAX_STR_LEN);
        
        rot_type = ROT_HAMLIB;
        strcpy(rot_filename, "");
        strcpy(rot_hostname, "");
        strcpy(rot_port_str, "10001");
        strcpy(rot_vid_str, "a600");
        strcpy(rot_pid_str, "e112");
        strcpy(rot_serial, "");
        strcpy(rot_timeout_ms_str,"400");
        strcpy(rot_beamwidth_str, "10");
        strcpy(rot_saddr_str, "240");
        strcpy(rot_model_str, "0");
        strcpy(rot_rem_rotstr, "A");
    }else{
        crot = (struct config_rotar *)g_ptr_array_index(cfg->crotars, roti);
        
        LOAD_STR  (crot, rot_desc);
        LOAD_INT  (crot, rot_type);
        LOAD_STR  (crot, rot_filename); 
        LOAD_STR  (crot, rot_hostname); 
        LOAD_SINT (crot, rot_port);
        LOAD_SHEX4(crot, rot_vid);
        LOAD_SHEX4(crot, rot_pid);
        LOAD_STR  (crot, rot_serial); 
        LOAD_SINT (crot, rot_timeout_ms);
        LOAD_SINT (crot, rot_beamwidth);
        LOAD_SINT (crot, rot_saddr);
        LOAD_SINT (crot, rot_model);
        LOAD_STR  (crot, rot_rem_rotstr); 
    }

    if (!(d = mem_alloc(sizeof(struct dialog) + 20 * sizeof(struct dialog_item)))) return;
    memset(d, 0, sizeof(struct dialog) + 20 * sizeof(struct dialog_item));
    d->title = VTEXT(T_ROTAROPTS);
    d->fn = dlg_pf_fn;
    d->refresh = (void (*)(void *))refresh_rotar_opts;
    d->refresh_data = crot;
    d->y0 = 1;
    

    d->items[i=0].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = rot_desc;
    d->items[i].maxl = 30;
    d->items[i].msg = CTEXT(T_DESC);
    d->items[i].wrap = 1;

    
    d->items[++i].type = D_CHECKBOX;      
    d->items[i].gid = 1;
    d->items[i].gnum = ROT_NONE;
    d->items[i].dlen = sizeof(int);
    d->items[i].data=(char *)&rot_type;
    d->items[i].msg = CTEXT(T_ROT_NONE);
    
    d->items[++i].type = D_CHECKBOX;      
    d->items[i].gid = 1;
    d->items[i].gnum = ROT_OK1ZIA_TTYS;
    d->items[i].dlen = sizeof(int);
    d->items[i].data=(char *)&rot_type;
    d->items[i].msg = CTEXT(T_ROT_OK1ZIA_TTYS);
    
    d->items[++i].type = D_CHECKBOX;      
    d->items[i].gid = 1;
    d->items[i].gnum = ROT_OK1ZIA_FTDI;
    d->items[i].dlen = sizeof(int);
    d->items[i].data=(char *)&rot_type;
    d->items[i].msg = CTEXT(T_ROT_OK1ZIA_FTDI);
    
    d->items[++i].type = D_CHECKBOX;      
    d->items[i].gid = 1;
    d->items[i].gnum = ROT_HAMLIB;
    d->items[i].dlen = sizeof(int);
    d->items[i].data=(char *)&rot_type;
    d->items[i].msg = CTEXT(T_ROT_HAMLIB);
    
    d->items[++i].type = D_CHECKBOX;      
    d->items[i].gid = 1;
    d->items[i].gnum = ROT_REMOTE;
    d->items[i].dlen = sizeof(int);
    d->items[i].data=(char *)&rot_type;
    d->items[i].msg = CTEXT(T_ROT_REMOTE);
    d->items[i].wrap = 1;

    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = rot_filename;
    d->items[i].maxl = 15;
    d->items[i].msg = CTEXT(T_FILENAME);
    d->items[i].wrap = 1;

    
    d->items[++i].type = D_FIELD;   // 5
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = rot_hostname;
    d->items[i].maxl = 15;
    d->items[i].msg = CTEXT(T_HOSTNAME);
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = rot_port_str;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 1;
    d->items[i].gnum = 65535;
    d->items[i].maxl = 6;
    d->items[i].msg = CTEXT(T_UDPPORT);
    d->items[i].wrap = 1;

    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = rot_vid_str;
    d->items[i].maxl = 6;
    d->items[i].msg = CTEXT(T_ROT_VID);
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = rot_pid_str;
    d->items[i].maxl = 6;
    d->items[i].msg = CTEXT(T_ROT_VID);
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = rot_serial;
    d->items[i].maxl = 10;
    d->items[i].msg = CTEXT(T_ROT_SERIAL);
    d->items[i].wrap = 1;
    
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = rot_timeout_ms_str;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 1;
    d->items[i].gnum = 2000;
    d->items[i].maxl = 5;
    d->items[i].msg = CTEXT(T_TIMEOUT);

    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = rot_beamwidth_str;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 0;
    d->items[i].gnum = 360;
    d->items[i].maxl = 5;
    d->items[i].msg = CTEXT(T_BEAMWIDTH);
    d->items[i].wrap = 1;

    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = rot_saddr_str;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 128;
    d->items[i].gnum = 255;
    d->items[i].maxl = 5;
    d->items[i].msg = CTEXT(T_SADDR);
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = rot_model_str;
    d->items[i].fn   = check_number;
    d->items[i].gid  = 0;
    d->items[i].gnum = 9999;
    d->items[i].maxl = 5;
    d->items[i].msg = CTEXT(T_MODEL);
    d->items[i].wrap = 1;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = rot_rem_rotstr;
    d->items[i].maxl = 3;
    d->items[i].msg = CTEXT(T_ROT_REM_ROTSTR);
    d->items[i].wrap = 2;
    
    
    
    d->items[++i].type = D_BUTTON;      // 10
    d->items[i].gid = B_ENTER;
    d->items[i].fn = ok_dialog;
    d->items[i].text = VTEXT(T_OK);
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ESC;
    d->items[i].fn = cancel_dialog;
    d->items[i].text = VTEXT(T_CANCEL);
    d->items[i].align = AL_BUTTONS;
    d->items[i].wrap = 1;
    
    d->items[++i].type = D_END;
    do_dialog(d, getml(d, NULL));
}

void menu_rotar_delete(cba_t cba){
    struct config_rotar *crot;
	int roti;

	roti = (int)GETCBA(cba, int_);
    dbg("menu_rotar_delete(%d)\n", roti);
    if (roti >= (int)cfg->crotars->len) return;
    crot = g_ptr_array_index(cfg->crotars, roti);
    free_config_rotar(crot);
    g_ptr_array_remove_index(cfg->crotars, roti);
}

void menu_rotars_delete(cba_t cba)
{
    struct menu_item *mi = NULL;
    static char *rotstrs[]={"A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"};
    int i;
    
    
    if (!(mi = new_menu(3))) return;

    for (i=0; i<cfg->crotars->len; i++){
        struct config_rotar *rot = (struct config_rotar *)g_ptr_array_index(cfg->crotars, i);
        
        add_to_menu(&mi, 
            stracpy(rot->rot_desc && *rot->rot_desc?rot->rot_desc:"Rotator"), 
            rotstrs[rot->nr],
            rotstrs[rot->nr],
            MENU_FUNC menu_rotar_delete, (cba_t)i, 0);
    }
    do_menu(mi, CBA0);
}

void menu_rotars(cba_t cba)
{
    struct menu_item *mi = NULL;
    static char *rotstrs[]={"A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"};
    int i;
    
    
    if (!(mi = new_menu(3))) return;

    for (i=0; i<cfg->crotars->len; i++){
        struct config_rotar *rot = (struct config_rotar *)g_ptr_array_index(cfg->crotars, i);
        
        add_to_menu(&mi, 
            stracpy(rot->rot_desc && *rot->rot_desc?rot->rot_desc:"Rotator"), 
            rotstrs[rot->nr],
            rotstrs[rot->nr],
            MENU_FUNC menu_rotar_opts, (cba_t)i, 0);
    }
    add_to_menu(&mi, stracpy(""), "", M_BAR, NULL, CBA0, 0);
    
    add_to_menu(&mi, 
        stracpy(VTEXT(T_ROT_ADD)),
        VTEXT(T_HK_ROT_ADD),
        VTEXT(T_HK_ROT_ADD),
        MENU_FUNC menu_rotar_opts, (cba_t)-1, 0);
    
    add_to_menu(&mi, 
        stracpy(VTEXT(T_ROT_REMOVE)),
        VTEXT(T_HK_ROT_REMOVE),
        VTEXT(T_HK_ROT_REMOVE),
        MENU_FUNC menu_rotars_delete, (cba_t)-1, 1);
    do_menu(mi, CBA0);
}
