/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "vdk/colors.h"
#include <stdlib.h>

VDKColor::VDKColor(VDKObject* obj, int red, int green, int blue):
  VDKRawObject(obj)
{
 color = (GdkColor*) malloc (sizeof (GdkColor));
 colormap = gdk_window_get_colormap (obj->Widget()->window);
 color->red    = red << 8;
 color->green  =  green << 8;
 color->blue   = blue << 8;
 if(! gdk_colormap_alloc_color (colormap,
			       color,
			       FALSE,
			       TRUE))
   gdk_color_black (colormap, color);

}

VDKColor::VDKColor(VDKObject* obj, VDKRgb rgb): VDKRawObject(obj)
{
  color = (GdkColor*) malloc (sizeof (GdkColor));
  colormap = gdk_window_get_colormap (obj->Widget()->window);
  color->red    = rgb.red << 8;
  color->green  =  rgb.green << 8;
  color->blue   = rgb.blue << 8;
  if(! gdk_colormap_alloc_color (colormap,
				 color,
				 FALSE,
				 TRUE))
     gdk_color_black (colormap, color);
}


VDKColor::VDKColor(VDKObject* obj, char* name): VDKRawObject(obj)
{
  color = (GdkColor*) malloc (sizeof (GdkColor));
  colormap = gdk_window_get_colormap (obj->Widget()->window);
  if( (!name) || 
      (!gdk_color_parse(name, color)) ||
      (! gdk_colormap_alloc_color (colormap,
				 color,
				 FALSE,
				 TRUE))
      )
     gdk_color_black (colormap, color);
}

VDKColor::~VDKColor()
{
if(color)
  free(color);
}


