/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 1.0.4
 * December 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef GNOME_FORMS_H
#define GNOME_FORMS_H

#if HAVE_GNOME
#include <vdk/forms.h>
#include <vdk/vdkgnomeapp.h>
#include <gnome.h>
/*!
  \class VDKGnomeForm
  \brief Provides an application main form for gnome apps.

  This class encapsulate most of behaviour of a gnome-aware application
  main form. Use this class as your application main form.
 */
class VDKGnomeForm: public VDKForm
{
 public:
  /*!
    Constructor
    \param app owner gnome application
    \param title main form title
    \param mode either v_box or h_box
   */
    VDKGnomeForm(VDKGnomeApplication* app,
		 char* title = (char*) NULL,
		 int mode = v_box);
    virtual void Add(VDKObject* obj, 
		     int justify = l_justify,
		     int expand = TRUE,
		     int fill = TRUE ,
		     int padding = 1);

    virtual ~VDKGnomeForm();

    /*!
      for vdkbuilder only.
      \internal 
    */
    VDKGnomeForm(VDKForm* owner,
		 char* app_id,
		 char* title = NULL,
		 int mode = v_box);
};
#endif

#endif
