/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.misc;

import java.text.StringCharacterIterator;

public final class StringEscaper {
    public static final char BACKSLASH = '\\';
    public static final char NEWLINE = '\n';
    public static final char RETURN = '\r';
    public static final char TAB = '\t';
    public static final char SPACE = ' ';
    public static final char ESCAPE_CHAR = '\\';
    public static final char UNICODE_START = 'u';
    final char mEscapeChar;
    final char[] mCharsToEscape;
    StringCharacterIterator mCharIter = null;

    public StringEscaper() {
        this("\n\r\t");
    }

    public StringEscaper(String charsToEscape) {
        this('\\', charsToEscape);
    }

    public StringEscaper(char escapeChar, String charsToEscape) {
        this.mEscapeChar = escapeChar;
        this.mCharsToEscape = new char[1 + charsToEscape.length()];
        this.mCharsToEscape[0] = 92;
        int length = charsToEscape.length();
        for (int i = 0; i < length; ++i) {
            this.mCharsToEscape[i + 1] = charsToEscape.charAt(i);
        }
    }

    boolean shouldEscape(char c) {
        boolean shouldEscape = false;
        for (int i = 0; i < this.mCharsToEscape.length; ++i) {
            if (c != this.mCharsToEscape[i]) continue;
            shouldEscape = true;
            break;
        }
        return shouldEscape;
    }

    String getEscapeSequence(char c) {
        String sequence = null;
        if (c == this.mEscapeChar) {
            sequence = "" + this.mEscapeChar + this.mEscapeChar;
        } else if (c == '\n') {
            sequence = this.mEscapeChar + "n";
        } else if (c == '\r') {
            sequence = this.mEscapeChar + "r";
        } else if (c == '\t') {
            sequence = this.mEscapeChar + "t";
        } else if (c == ' ') {
            sequence = this.mEscapeChar + "s";
        } else {
            char numericValue = c;
            String valueString = "" + Integer.toHexString(numericValue);
            while (valueString.length() != 4) {
                valueString = "0" + valueString;
            }
            sequence = "" + this.mEscapeChar + 'u' + valueString;
        }
        return sequence;
    }

    public String escape(String s) {
        StringBuffer buf = new StringBuffer();
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (this.shouldEscape(c)) {
                buf.append(this.getEscapeSequence(c));
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    boolean hasMoreChars() {
        return this.mCharIter.current() != '\uffff';
    }

    char peekNextChar() {
        return this.mCharIter.current();
    }

    char nextChar() {
        char theChar = this.mCharIter.current();
        this.mCharIter.next();
        if (theChar == '\uffff') {
            throw new ArrayIndexOutOfBoundsException();
        }
        return theChar;
    }

    char escapeSequenceToChar() {
        char c = this.nextChar();
        int result = '\u0000';
        if (c == this.mEscapeChar) {
            result = this.mEscapeChar;
        } else if (c == 'n') {
            result = 10;
        } else if (c == 'r') {
            result = 13;
        } else if (c == 't') {
            result = 9;
        } else if (c == 's') {
            result = 32;
        } else if (c == 'u') {
            String unicodeSequence = "" + this.nextChar() + this.nextChar() + this.nextChar() + this.nextChar();
            int intValue = Integer.parseInt(unicodeSequence, 16);
            result = (char)intValue;
        } else {
            throw new IllegalArgumentException("Illegal escape sequence");
        }
        return (char)result;
    }

    public String unescape(String s) {
        StringBuffer buf = new StringBuffer();
        this.mCharIter = new StringCharacterIterator(s);
        while (this.hasMoreChars()) {
            char c = this.nextChar();
            assert (c != '\uffff');
            if (c == this.mEscapeChar) {
                char newChar = this.escapeSequenceToChar();
                buf.append(newChar);
                continue;
            }
            buf.append(c);
        }
        this.mCharIter = null;
        return buf.toString();
    }
}

