// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SMLAL_4S_4H_H_TRACE_AARCH64_H_
#define VIXL_SIM_SMLAL_4S_4H_H_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_smlal_4S_4H_H[] = {
  0x00003e04, 0x00003e83, 0x0019331c, 0x0029fff6,
  0x00007c86, 0x00007d84, 0x00329969, 0x00545521,
  0x0019afa0, 0x0019e3d1, 0x0a6ff592, 0x11654410,
  0x0043af76, 0x004438fc, 0x1b80e481, 0x2dd6d249,
  0x0082adfc, 0x0083b77f, 0x3519cae8, 0x5880524a,
  0x00c1ad00, 0x00c33681, 0x4eb2e482, 0x832a27a0,
  0x0100ac82, 0x0102b602, 0x684c314f, 0xadd4524b,
  0x0100ac82, 0x0102b602, 0x684c314f, 0xadd4524b,
  0x00003e82, 0x00003f02, 0x0019664f, 0x002a554b,
  0x0019719c, 0x0019a54f, 0x0a56c278, 0x113b443a,
  0x00437172, 0x0043fa7a, 0x1b67b167, 0x2dacd273,
  0x00826ff8, 0x008378fd, 0x350097ce, 0x58565274,
  0x00c16efc, 0x00c2f7ff, 0x4e99b168, 0x830027ca,
  0x01006e7e, 0x01027780, 0x6832fe35, 0xadaa5275,
  0x01006e7e, 0x01027780, 0x6832fe35, 0xadaa5275,
  0x01006efc, 0x010277ff, 0x68333168, 0xadaaa7ca,
  0x0019331a, 0x0019664e, 0x0a3d5c2b, 0x1110ef0f,
  0x004332f0, 0x0043bb79, 0x1b4e4b1a, 0x2d827d48,
  0x00823176, 0x008339fc, 0x34e73181, 0x582bfd49,
  0x00c1307a, 0x00c2b8fe, 0x4e804b1b, 0x82d5d29f,
  0x01002ffc, 0x0102387f, 0x681997e8, 0xad7ffd4a,
  0x01002ffc, 0x0102387f, 0x681997e8, 0xad7ffd4a,
  0x0100307a, 0x010238fe, 0x6819cb1b, 0xad80529f,
  0x01003176, 0x010239fc, 0x681a3181, 0xad80fd49,
  0x0029ffd6, 0x002a552c, 0x1110eef1, 0x1c718e59,
  0x0068fe5c, 0x0069d3af, 0x2aa9d558, 0x471b0e5a,
  0x00a7fd60, 0x00a952b1, 0x4442eef2, 0x71c4e3b0,
  0x00e6fce2, 0x00e8d232, 0x5ddc3bbf, 0x9c6f0e5b,
  0x00e6fce2, 0x00e8d232, 0x5ddc3bbf, 0x9c6f0e5b,
  0x00e6fd60, 0x00e8d2b1, 0x5ddc6ef2, 0x9c6f63b0,
  0x00e6fe5c, 0x00e8d3af, 0x5ddcd558, 0x9c700e5a,
  0x00e7063c, 0x00e8db9f, 0x5de00888, 0x9c7563aa,
  0x003efe86, 0x003f7e84, 0x1998e669, 0x2aa98021,
  0x007dfd8a, 0x007efd86, 0x33320003, 0x55535577,
  0x00bcfd0c, 0x00be7d07, 0x4ccb4cd0, 0x7ffd8022,
  0x00bcfd0c, 0x00be7d07, 0x4ccb4cd0, 0x7ffd8022,
  0x00bcfd8a, 0x00be7d86, 0x4ccb8003, 0x7ffdd577,
  0x00bcfe86, 0x00be7e84, 0x4ccbe669, 0x7ffe8021,
  0x00bd0666, 0x00be8674, 0x4ccf1999, 0x8003d571,
  0x00bd43ec, 0x00bec477, 0x4ce81980, 0x802d7ff2,
  0x003eff04, 0x003f7f03, 0x1999199c, 0x2aa9d576,
  0x007dfe86, 0x007efe84, 0x33326669, 0x55540021,
  0x007dfe86, 0x007efe84, 0x33326669, 0x55540021,
  0x007dff04, 0x007eff03, 0x3332999c, 0x55545576,
  0x007e0000, 0x007f0001, 0x33330002, 0x55550020,
  0x007e07e0, 0x007f07f1, 0x33363332, 0x555a5570,
  0x007e4566, 0x007f45f4, 0x334f3319, 0x5583fff1,
  0x007e836a, 0x007f8476, 0x33686633, 0x55adffc7,
  0x003eff82, 0x003f7f82, 0x19994ccf, 0x2aaa2acb,
  0x003eff82, 0x003f7f82, 0x19994ccf, 0x2aaa2acb,
  0x003f0000, 0x003f8001, 0x19998002, 0x2aaa8020,
  0x003f00fc, 0x003f80ff, 0x1999e668, 0x2aab2aca,
  0x003f08dc, 0x003f88ef, 0x199d1998, 0x2ab0801a,
  0x003f4662, 0x003fc6f2, 0x19b6197f, 0x2ada2a9b,
  0x003f8466, 0x00400574, 0x19cf4c99, 0x2b042a71,
  0x003fc2e8, 0x00404475, 0x19e8b2e6, 0x2b2e7f9c,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000007e, 0x00000080, 0x00003335, 0x00005575,
  0x0000017a, 0x0000017e, 0x0000999b, 0x0001001f,
  0x0000095a, 0x0000096e, 0x0003cccb, 0x0006556f,
  0x000046e0, 0x00004771, 0x001cccb2, 0x002ffff0,
  0x000084e4, 0x000085f3, 0x0035ffcc, 0x0059ffc6,
  0x0000c366, 0x0000c4f4, 0x004f6619, 0x008454f1,
  0x0019f680, 0x001a2b41, 0x0a8cc242, 0x119543e0,
  0x0000007e, 0x00000080, 0x00003335, 0x00005575,
  0x0000017a, 0x0000017e, 0x0000999b, 0x0001001f,
  0x0000095a, 0x0000096e, 0x0003cccb, 0x0006556f,
  0x000046e0, 0x00004771, 0x001cccb2, 0x002ffff0,
  0x000084e4, 0x000085f3, 0x0035ffcc, 0x0059ffc6,
  0x0000c366, 0x0000c4f4, 0x004f6619, 0x008454f1,
  0x0019f680, 0x001a2b41, 0x0a8cc242, 0x119543e0,
  0x0043f656, 0x0044806c, 0x1b9db131, 0x2e06d219,
  0x000000fc, 0x000000ff, 0x00006668, 0x0000aaca,
  0x000008dc, 0x000008ef, 0x00039998, 0x0006001a,
  0x00004662, 0x000046f2, 0x001c997f, 0x002faa9b,
  0x00008466, 0x00008574, 0x0035cc99, 0x0059aa71,
  0x0000c2e8, 0x0000c475, 0x004f32e6, 0x0083ff9c,
  0x0019f602, 0x001a2ac2, 0x0a8c8f0f, 0x1194ee8b,
  0x0043f5d8, 0x00447fed, 0x1b9d7dfe, 0x2e067cc4,
  0x0082f45e, 0x0083fe70, 0x35366465, 0x58affcc5,
  0x000007e0, 0x000007f1, 0x00033332, 0x00055570,
  0x00004566, 0x000045f4, 0x001c3319, 0x002efff1,
  0x0000836a, 0x00008476, 0x00356633, 0x0058ffc7,
  0x0000c1ec, 0x0000c377, 0x004ecc80, 0x008354f2,
  0x0019f506, 0x001a29c4, 0x0a8c28a9, 0x119443e1,
  0x0043f4dc, 0x00447eef, 0x1b9d1798, 0x2e05d21a,
  0x0082f362, 0x0083fd72, 0x3535fdff, 0x58af521b,
  0x00c1f266, 0x00c37c74, 0x4ecf1799, 0x83592771,
  0x00003d86, 0x00003e04, 0x0018ffe9, 0x0029aaa1,
  0x00007b8a, 0x00007c86, 0x00323303, 0x0053aa77,
  0x0000ba0c, 0x0000bb87, 0x004b9950, 0x007dffa2,
  0x0019ed26, 0x001a21d4, 0x0a88f579, 0x118eee91,
  0x0043ecfc, 0x004476ff, 0x1b99e468, 0x2e007cca,
  0x0082eb82, 0x0083f582, 0x3532cacf, 0x58a9fccb,
  0x00c1ea86, 0x00c37484, 0x4ecbe469, 0x8353d221,
  0x0100ea08, 0x0102f405, 0x68653136, 0xadfdfccc,
  0x00003e04, 0x00003e83, 0x0019331c, 0x0029fff6,
  0x00007c86, 0x00007d84, 0x00329969, 0x00545521,
  0x0019afa0, 0x0019e3d1, 0x0a6ff592, 0x11654410,
  0x0043af76, 0x004438fc, 0x1b80e481, 0x2dd6d249,
  0x0082adfc, 0x0083b77f, 0x3519cae8, 0x5880524a,
  0x00c1ad00, 0x00c33681, 0x4eb2e482, 0x832a27a0,
  0x0100ac82, 0x0102b602, 0x684c314f, 0xadd4524b,
  0x00c1ac82, 0x00c33602, 0x4eb2b14f, 0x8329d24b,
  0x00003e82, 0x00003f02, 0x0019664f, 0x002a554b,
  0x0019719c, 0x0019a54f, 0x0a56c278, 0x113b443a,
  0x00437172, 0x0043fa7a, 0x1b67b167, 0x2dacd273,
  0x00826ff8, 0x008378fd, 0x350097ce, 0x58565274,
  0x00c16efc, 0x00c2f7ff, 0x4e99b168, 0x830027ca,
  0x01006e7e, 0x01027780, 0x6832fe35, 0xadaa5275,
  0x00c16e7e, 0x00c2f780, 0x4e997e35, 0x82ffd275,
  0x00826efc, 0x008377ff, 0x35003168, 0x5855a7ca,
  0x0019331a, 0x0019664e, 0x0a3d5c2b, 0x1110ef0f,
  0x004332f0, 0x0043bb79, 0x1b4e4b1a, 0x2d827d48,
  0x00823176, 0x008339fc, 0x34e73181, 0x582bfd49,
  0x00c1307a, 0x00c2b8fe, 0x4e804b1b, 0x82d5d29f,
  0x01002ffc, 0x0102387f, 0x681997e8, 0xad7ffd4a,
  0x00c12ffc, 0x00c2b87f, 0x4e8017e8, 0x82d57d4a,
  0x0082307a, 0x008338fe, 0x34e6cb1b, 0x582b529f,
  0x00583026, 0x0058e354, 0x23d5a8f9, 0x3bb96f11,
  0x0029ffd6, 0x002a552c, 0x1110eef1, 0x1c718e59,
  0x0068fe5c, 0x0069d3af, 0x2aa9d558, 0x471b0e5a,
  0x00a7fd60, 0x00a952b1, 0x4442eef2, 0x71c4e3b0,
  0x00e6fce2, 0x00e8d232, 0x5ddc3bbf, 0x9c6f0e5b,
  0x00a7fce2, 0x00a95232, 0x4442bbbf, 0x71c48e5b,
  0x0068fd60, 0x0069d2b1, 0x2aa96ef2, 0x471a63b0,
  0x003efd0c, 0x003f7d07, 0x19984cd0, 0x2aa88022,
  0x0025c974, 0x0026163b, 0x0f5abd74, 0x19973bde,
  0x003efe86, 0x003f7e84, 0x1998e669, 0x2aa98021,
  0x007dfd8a, 0x007efd86, 0x33320003, 0x55535577,
  0x00bcfd0c, 0x00be7d07, 0x4ccb4cd0, 0x7ffd8022,
  0x007dfd0c, 0x007efd07, 0x3331ccd0, 0x55530022,
  0x003efd8a, 0x003f7d86, 0x19988003, 0x2aa8d577,
  0x0014fd36, 0x001527dc, 0x08875de1, 0x0e36f1e9,
  0xfffbc99e, 0xfffbc110, 0xfe49ce85, 0xfd25ada5,
  0xfffb8a9e, 0xfffb8190, 0xfe303505, 0xfcfb0325,
  0x003eff04, 0x003f7f03, 0x1999199c, 0x2aa9d576,
  0x007dfe86, 0x007efe84, 0x33326669, 0x55540021,
  0x003efe86, 0x003f7e84, 0x1998e669, 0x2aa98021,
  0xffffff04, 0xffffff03, 0xffff999c, 0xffff5576,
  0xffd5feb0, 0xffd5a959, 0xeeee777a, 0xe38d71e8,
  0xffbccb18, 0xffbc428d, 0xe4b0e81e, 0xd27c2da4,
  0xffbc8c18, 0xffbc030d, 0xe4974e9e, 0xd2518324,
  0xffbc4d96, 0xffbbc40c, 0xe47de851, 0xd2272df9,
  0x003eff82, 0x003f7f82, 0x19994ccf, 0x2aaa2acb,
  0xffffff82, 0xffffff82, 0xffffcccf, 0xffffaacb,
  0xffc10000, 0xffc08001, 0xe6668002, 0xd5558020,
  0xff96ffac, 0xff962a57, 0xd5555de0, 0xb8e39c92,
  0xff7dcc14, 0xff7cc38b, 0xcb17ce84, 0xa7d2584e,
  0xff7d8d14, 0xff7c840b, 0xcafe3504, 0xa7a7adce,
  0xff7d4e92, 0xff7c450a, 0xcae4ceb7, 0xa77d58a3,
  0xff7d108e, 0xff7c0688, 0xcacb9b9d, 0xa75358cd,
  0xffc10000, 0xffc08001, 0xe6668002, 0xd5558020,
  0xff82007e, 0xff810080, 0xcccd3335, 0xaaab5575,
  0xff58002a, 0xff56aad6, 0xbbbc1113, 0x8e3971e7,
  0xff3ecc92, 0xff3d440a, 0xb17e81b7, 0x7d282da3,
  0xff3e8d92, 0xff3d048a, 0xb164e837, 0x7cfd8323,
  0xff3e4f10, 0xff3cc589, 0xb14b81ea, 0x7cd32df8,
  0xff3e110c, 0xff3c8707, 0xb1324ed0, 0x7ca92e22,
  0xff3dd386, 0xff3c4904, 0xb1194ee9, 0x7c7f83a1,
  0xffc1007e, 0xffc08080, 0xe666b335, 0xd555d575,
  0xff97002a, 0xff962ad6, 0xd5559113, 0xb8e3f1e7,
  0xff7dcc92, 0xff7cc40a, 0xcb1801b7, 0xa7d2ada3,
  0xff7d8d92, 0xff7c848a, 0xcafe6837, 0xa7a80323,
  0xff7d4f10, 0xff7c4589, 0xcae501ea, 0xa77dadf8,
  0xff7d110c, 0xff7c0707, 0xcacbced0, 0xa753ae22,
  0xff7cd386, 0xff7bc904, 0xcab2cee9, 0xa72a03a1,
  0xff7ccba6, 0xff7bc114, 0xcaaf9bb9, 0xa724ae51,
  0xffd5ffac, 0xffd5aa57, 0xeeeedde0, 0xe38e1c92,
  0xffbccc14, 0xffbc438b, 0xe4b14e84, 0xd27cd84e,
  0xffbc8d14, 0xffbc040b, 0xe497b504, 0xd2522dce,
  0xffbc4e92, 0xffbbc50a, 0xe47e4eb7, 0xd227d8a3,
  0xffbc108e, 0xffbb8688, 0xe4651b9d, 0xd1fdd8cd,
  0xffbbd308, 0xffbb4885, 0xe44c1bb6, 0xd1d42e4c,
  0xffbbcb28, 0xffbb4095, 0xe448e886, 0xd1ced8fc,
  0xffbbc9ae, 0xffbb3f18, 0xe4484eed, 0xd1cdd8fd,
  0xffe6cc68, 0xffe69935, 0xf5c270a6, 0xeeeebbdc,
  0xffe68d68, 0xffe659b5, 0xf5a8d726, 0xeec4115c,
  0xffe64ee6, 0xffe61ab4, 0xf58f70d9, 0xee99bc31,
  0xffe610e2, 0xffe5dc32, 0xf5763dbf, 0xee6fbc5b,
  0xffe5d35c, 0xffe59e2f, 0xf55d3dd8, 0xee4611da,
  0xffe5cb7c, 0xffe5963f, 0xf55a0aa8, 0xee40bc8a,
  0xffe5ca02, 0xffe594c2, 0xf559710f, 0xee3fbc8b,
  0xffe5c906, 0xffe593c4, 0xf5590aa9, 0xee3f11e1,
  0xffffc100, 0xffffc081, 0xffe66682, 0xffd555a0,
  0xffff827e, 0xffff8180, 0xffcd0035, 0xffab0075,
  0xffff447a, 0xffff42fe, 0xffb3cd1b, 0xff81009f,
  0xffff06f4, 0xffff04fb, 0xff9acd34, 0xff57561e,
  0xfffeff14, 0xfffefd0b, 0xff979a04, 0xff5200ce,
  0xfffefd9a, 0xfffefb8e, 0xff97006b, 0xff5100cf,
  0xfffefc9e, 0xfffefa90, 0xff969a05, 0xff505625,
  0xfffefc20, 0xfffefa11, 0xff9666d2, 0xff5000d0,
  0xffffc0ff, 0xffe699b4, 0xffd5aad7, 0xffc0819d,
  0xffff827d, 0xffcd669a, 0xffabab01, 0xff818317,
  0xffff447a, 0xffb466b3, 0xff820080, 0xff43048e,
  0xffff3c8a, 0xffb13383, 0xff7cab30, 0xff3b04be,
  0xffff3b0d, 0xffb099ea, 0xff7bab31, 0xff3984c7,
  0xffff3a0f, 0xffb03384, 0xff7b0087, 0xff3884cd,
  0xffff3990, 0xffb00051, 0xff7aab32, 0xff3804d0,
  0xffff3990, 0xffb00051, 0xff7aab32, 0xff3804d0,
  0xffffc17e, 0xffe6cce7, 0xffd6002c, 0xffc1019a,
  0xffff837b, 0xffcdcd00, 0xffac55ab, 0xff828311,
  0xffff7b8b, 0xffca99d0, 0xffa7005b, 0xff7a8341,
  0xffff7a0e, 0xffca0037, 0xffa6005c, 0xff79034a,
  0xffff7910, 0xffc999d1, 0xffa555b2, 0xff780350,
  0xffff7891, 0xffc9669e, 0xffa5005d, 0xff778353,
  0xffff7891, 0xffc9669e, 0xffa5005d, 0xff778353,
  0xffff7910, 0xffc999d1, 0xffa555b2, 0xff780350,
  0xffffc1fd, 0xffe7001a, 0xffd65581, 0xffc18197,
  0xffffba0d, 0xffe3ccea, 0xffd10031, 0xffb981c7,
  0xffffb890, 0xffe33351, 0xffd00032, 0xffb801d0,
  0xffffb792, 0xffe2cceb, 0xffcf5588, 0xffb701d6,
  0xffffb713, 0xffe299b8, 0xffcf0033, 0xffb681d9,
  0xffffb713, 0xffe299b8, 0xffcf0033, 0xffb681d9,
  0xffffb792, 0xffe2cceb, 0xffcf5588, 0xffb701d6,
  0xffffb890, 0xffe33351, 0xffd00032, 0xffb801d0,
  0xfffff810, 0xfffcccd1, 0xfffaaab2, 0xfff80050,
  0xfffff693, 0xfffc3338, 0xfff9aab3, 0xfff68059,
  0xfffff595, 0xfffbccd2, 0xfff90009, 0xfff5805f,
  0xfffff516, 0xfffb999f, 0xfff8aab4, 0xfff50062,
  0xfffff516, 0xfffb999f, 0xfff8aab4, 0xfff50062,
  0xfffff595, 0xfffbccd2, 0xfff90009, 0xfff5805f,
  0xfffff693, 0xfffc3338, 0xfff9aab3, 0xfff68059,
  0xfffffe83, 0xffff6668, 0xffff0003, 0xfffe8029,
  0xfffffe83, 0xffff6668, 0xffff0003, 0xfffe8029,
  0xfffffd85, 0xffff0002, 0xfffe5559, 0xfffd802f,
  0xfffffd06, 0xfffecccf, 0xfffe0004, 0xfffd0032,
  0xfffffd06, 0xfffecccf, 0xfffe0004, 0xfffd0032,
  0xfffffd85, 0xffff0002, 0xfffe5559, 0xfffd802f,
  0xfffffe83, 0xffff6668, 0xffff0003, 0xfffe8029,
  0x00000673, 0x00029998, 0x00045553, 0x00067ff9,
  0x00004476, 0x001b997f, 0x002dffd4, 0x0044fe82,
  0xffffff02, 0xffff999b, 0xffff5558, 0xffff0026,
  0xfffffe83, 0xffff6668, 0xffff0003, 0xfffe8029,
  0xfffffe83, 0xffff6668, 0xffff0003, 0xfffe8029,
  0xffffff02, 0xffff999b, 0xffff5558, 0xffff0026,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x000007f0, 0x00033331, 0x00055552, 0x0007fff0,
  0x000045f3, 0x001c3318, 0x002effd3, 0x00467e79,
  0x00008475, 0x00356632, 0x0058ffa9, 0x00857cff,
  0xffffff81, 0xffffccce, 0xffffaaad, 0xffff8023,
  0xffffff81, 0xffffccce, 0xffffaaad, 0xffff8023,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x000000fe, 0x00006667, 0x0000aaac, 0x0001001a,
  0x000008ee, 0x00039997, 0x0005fffc, 0x0008ffea,
  0x000046f1, 0x001c997e, 0x002faa7d, 0x00477e73,
  0x00008573, 0x0035cc98, 0x0059aa53, 0x00867cf9,
  0x0000c474, 0x004f32e5, 0x0083ff7e, 0x00c5fb7c,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000007f, 0x00003334, 0x00005557, 0x0000801d,
  0x0000017d, 0x0000999a, 0x00010001, 0x00018017,
  0x0000096d, 0x0003ccca, 0x00065551, 0x00097fe7,
  0x00004770, 0x001cccb1, 0x002fffd2, 0x0047fe70,
  0x000085f2, 0x0035ffcb, 0x0059ffa8, 0x0086fcf6,
  0x0000c4f3, 0x004f6618, 0x008454d3, 0x00c67b79,
  0x001a2b40, 0x0a8cc241, 0x119543c2, 0x1a5f61e0,
  0x0000007f, 0x00003334, 0x00005557, 0x0000801d,
  0x0000017d, 0x0000999a, 0x00010001, 0x00018017,
  0x0000096d, 0x0003ccca, 0x00065551, 0x00097fe7,
  0x00004770, 0x001cccb1, 0x002fffd2, 0x0047fe70,
  0x000085f2, 0x0035ffcb, 0x0059ffa8, 0x0086fcf6,
  0x0000c4f3, 0x004f6618, 0x008454d3, 0x00c67b79,
  0x001a2b40, 0x0a8cc241, 0x119543c2, 0x1a5f61e0,
  0x0044806b, 0x1b9db130, 0x2e06d1fb, 0x4508e1e1,
  0x000000fe, 0x00006667, 0x0000aaac, 0x0001001a,
  0x000008ee, 0x00039997, 0x0005fffc, 0x0008ffea,
  0x000046f1, 0x001c997e, 0x002faa7d, 0x00477e73,
  0x00008573, 0x0035cc98, 0x0059aa53, 0x00867cf9,
  0x0000c474, 0x004f32e5, 0x0083ff7e, 0x00c5fb7c,
  0x001a2ac1, 0x0a8c8f0e, 0x1194ee6d, 0x1a5ee1e3,
  0x00447fec, 0x1b9d7dfd, 0x2e067ca6, 0x450861e4,
  0x0083fe6f, 0x35366464, 0x58affca7, 0x850561ed,
  0x000007f0, 0x00033331, 0x00055552, 0x0007fff0,
  0x000045f3, 0x001c3318, 0x002effd3, 0x00467e79,
  0x00008475, 0x00356632, 0x0058ffa9, 0x00857cff,
  0x0000c376, 0x004ecc7f, 0x008354d4, 0x00c4fb82,
  0x001a29c3, 0x0a8c28a8, 0x119443c3, 0x1a5de1e9,
  0x00447eee, 0x1b9d1797, 0x2e05d1fc, 0x450761ea,
  0x0083fd71, 0x3535fdfe, 0x58af51fd, 0x850461f3,
  0x00c37c73, 0x4ecf1798, 0x83592753, 0xc501e1f9,
  0x00003e03, 0x0018ffe8, 0x0029aa83, 0x003e7ea9,
  0x00007c85, 0x00323302, 0x0053aa59, 0x007d7d2f,
  0x0000bb86, 0x004b994f, 0x007dff84, 0x00bcfbb2,
  0x001a21d3, 0x0a88f578, 0x118eee73, 0x1a55e219,
  0x004476fe, 0x1b99e467, 0x2e007cac, 0x44ff621a,
  0x0083f581, 0x3532cace, 0x58a9fcad, 0x84fc6223,
  0x00c37483, 0x4ecbe468, 0x8353d203, 0xc4f9e229,
  0x0102f404, 0x68653135, 0xadfdfcae, 0x04f7e22c,
  0x00003e82, 0x0019331b, 0x0029ffd8, 0x003efea6,
  0x00007d83, 0x00329968, 0x00545503, 0x007e7d29,
  0x0019e3d0, 0x0a6ff591, 0x116543f2, 0x1a176390,
  0x004438fb, 0x1b80e480, 0x2dd6d22b, 0x44c0e391,
  0x0083b77e, 0x3519cae7, 0x5880522c, 0x84bde39a,
  0x00c33680, 0x4eb2e481, 0x832a2782, 0xc4bb63a0,
  0x0102b601, 0x684c314e, 0xadd4522d, 0x04b963a3,
  0x00c33601, 0x4eb2b14e, 0x8329d22d, 0xc4bae3a3,
  0x00003f01, 0x0019664e, 0x002a552d, 0x003f7ea3,
  0x0019a54e, 0x0a56c277, 0x113b441c, 0x19d8650a,
  0x0043fa79, 0x1b67b166, 0x2dacd255, 0x4481e50b,
  0x008378fc, 0x350097cd, 0x58565256, 0x847ee514,
  0x00c2f7fe, 0x4e99b167, 0x830027ac, 0xc47c651a,
  0x0102777f, 0x6832fe34, 0xadaa5257, 0x047a651d,
  0x00c2f77f, 0x4e997e34, 0x82ffd257, 0xc47be51d,
  0x008377fe, 0x35003167, 0x5855a7ac, 0x847de51a,
  0x0019664d, 0x0a3d5c2a, 0x1110eef1, 0x1998e687,
  0x0043bb78, 0x1b4e4b19, 0x2d827d2a, 0x44426688,
  0x008339fb, 0x34e73180, 0x582bfd2b, 0x843f6691,
  0x00c2b8fd, 0x4e804b1a, 0x82d5d281, 0xc43ce697,
  0x0102387e, 0x681997e7, 0xad7ffd2c, 0x043ae69a,
  0x00c2b87e, 0x4e8017e7, 0x82d57d2c, 0xc43c669a,
  0x008338fd, 0x34e6cb1a, 0x582b5281, 0x843e6697,
  0x0058e353, 0x23d5a8f8, 0x3bb96ef3, 0x59946699,
  0x002a552b, 0x1110eef0, 0x1c718e3b, 0x2aa98021,
  0x0069d3ae, 0x2aa9d557, 0x471b0e3c, 0x6aa6802a,
  0x00a952b0, 0x4442eef1, 0x71c4e392, 0xaaa40030,
  0x00e8d231, 0x5ddc3bbe, 0x9c6f0e3d, 0xeaa20033,
  0x00a95231, 0x4442bbbe, 0x71c48e3d, 0xaaa38033,
  0x0069d2b0, 0x2aa96ef1, 0x471a6392, 0x6aa58030,
  0x003f7d06, 0x19984ccf, 0x2aa88004, 0x3ffb8032,
  0x0026163a, 0x0f5abd73, 0x19973bc0, 0x266219ce,
  0x003f7e83, 0x1998e668, 0x2aa98003, 0x3ffd0029,
  0x007efd85, 0x33320002, 0x55535559, 0x7ffa802f,
  0x00be7d06, 0x4ccb4ccf, 0x7ffd8004, 0xbff88032,
  0x007efd06, 0x3331cccf, 0x55530004, 0x7ffa0032,
  0x003f7d85, 0x19988002, 0x2aa8d559, 0x3ffc002f,
  0x001527db, 0x08875de0, 0x0e36f1cb, 0x15520031,
  0xfffbc10f, 0xfe49ce84, 0xfd25ad87, 0xfbb899cd,
  0xfffb818f, 0xfe303504, 0xfcfb0307, 0xfb789b4d,
  0x003f7f02, 0x1999199b, 0x2aa9d558, 0x3ffd8026,
  0x007efe83, 0x33326668, 0x55540003, 0x7ffb8029,
  0x003f7e83, 0x1998e668, 0x2aa98003, 0x3ffd0029,
  0xffffff02, 0xffff999b, 0xffff5558, 0xffff0026,
  0xffd5a958, 0xeeee7779, 0xe38d71ca, 0xd5550028,
  0xffbc428c, 0xe4b0e81d, 0xd27c2d86, 0xbbbb99c4,
  0xffbc030c, 0xe4974e9d, 0xd2518306, 0xbb7b9b44,
  0xffbbc40b, 0xe47de850, 0xd2272ddb, 0xbb3c1cc1,
  0x003f7f81, 0x19994cce, 0x2aaa2aad, 0x3ffe0023,
  0xffffff81, 0xffffccce, 0xffffaaad, 0xffff8023,
  0xffc08000, 0xe6668001, 0xd5558002, 0xc0018020,
  0xff962a56, 0xd5555ddf, 0xb8e39c74, 0x95578022,
  0xff7cc38a, 0xcb17ce83, 0xa7d25830, 0x7bbe19be,
  0xff7c840a, 0xcafe3503, 0xa7a7adb0, 0x7b7e1b3e,
  0xff7c4509, 0xcae4ceb6, 0xa77d5885, 0x7b3e9cbb,
  0xff7c0687, 0xcacb9b9c, 0xa75358af, 0x7aff9e35,
  0xffc08000, 0xe6668001, 0xd5558002, 0xc0018020,
  0xff81007f, 0xcccd3334, 0xaaab5557, 0x8003801d,
  0xff56aad5, 0xbbbc1112, 0x8e3971c9, 0x5559801f,
  0xff3d4409, 0xb17e81b6, 0x7d282d85, 0x3bc019bb,
  0xff3d0489, 0xb164e836, 0x7cfd8305, 0x3b801b3b,
  0xff3cc588, 0xb14b81e9, 0x7cd32dda, 0x3b409cb8,
  0xff3c8706, 0xb1324ecf, 0x7ca92e04, 0x3b019e32,
  0xff3c4903, 0xb1194ee8, 0x7c7f8383, 0x3ac31fa9,
  0xffc0807f, 0xe666b334, 0xd555d557, 0xc002001d,
  0xff962ad5, 0xd5559112, 0xb8e3f1c9, 0x9558001f,
  0xff7cc409, 0xcb1801b6, 0xa7d2ad85, 0x7bbe99bb,
  0xff7c8489, 0xcafe6836, 0xa7a80305, 0x7b7e9b3b,
  0xff7c4588, 0xcae501e9, 0xa77dadda, 0x7b3f1cb8,
  0xff7c0706, 0xcacbcecf, 0xa753ae04, 0x7b001e32,
  0xff7bc903, 0xcab2cee8, 0xa72a0383, 0x7ac19fa9,
  0xff7bc113, 0xcaaf9bb8, 0xa724ae33, 0x7ab99fd9,
  0xffd5aa56, 0xeeeedddf, 0xe38e1c74, 0xd5560022,
  0xffbc438a, 0xe4b14e83, 0xd27cd830, 0xbbbc99be,
  0xffbc040a, 0xe497b503, 0xd2522db0, 0xbb7c9b3e,
  0xffbbc509, 0xe47e4eb6, 0xd227d885, 0xbb3d1cbb,
  0xffbb8687, 0xe4651b9c, 0xd1fdd8af, 0xbafe1e35,
  0xffbb4884, 0xe44c1bb5, 0xd1d42e2e, 0xbabf9fac,
  0xffbb4094, 0xe448e885, 0xd1ced8de, 0xbab79fdc,
  0xffbb3f17, 0xe4484eec, 0xd1cdd8df, 0xbab61fe5,
  0xffe69934, 0xf5c270a5, 0xeeeebbbe, 0xe66699bc,
  0xffe659b4, 0xf5a8d725, 0xeec4113e, 0xe6269b3c,
  0xffe61ab3, 0xf58f70d8, 0xee99bc13, 0xe5e71cb9,
  0xffe5dc31, 0xf5763dbe, 0xee6fbc3d, 0xe5a81e33,
  0xffe59e2e, 0xf55d3dd7, 0xee4611bc, 0xe5699faa,
  0xffe5963e, 0xf55a0aa7, 0xee40bc6c, 0xe5619fda,
  0xffe594c1, 0xf559710e, 0xee3fbc6d, 0xe5601fe3,
  0xffe593c3, 0xf5590aa8, 0xee3f11c3, 0xe55f1fe9,
  0xffffc080, 0xffe66681, 0xffd55582, 0xffc001a0,
  0xffff817f, 0xffcd0034, 0xffab0057, 0xff80831d,
  0xffff42fd, 0xffb3cd1a, 0xff810081, 0xff418497,
  0xffff04fa, 0xff9acd33, 0xff575600, 0xff03060e,
  0xfffefd0a, 0xff979a03, 0xff5200b0, 0xfefb063e,
  0xfffefb8d, 0xff97006a, 0xff5100b1, 0xfef98647,
  0xfffefa8f, 0xff969a04, 0xff505607, 0xfef8864d,
  0xfffefa10, 0xff9666d1, 0xff5000b2, 0xfef80650,
  0xffe699b3, 0xffd5aad6, 0xffc0817f, 0xffc0811e,
  0xffcd6699, 0xffabab00, 0xff8182f9, 0xff81821a,
  0xffb466b2, 0xff82007f, 0xff430470, 0xff430314,
  0xffb13382, 0xff7cab2f, 0xff3b04a0, 0xff3b0334,
  0xffb099e9, 0xff7bab30, 0xff3984a9, 0xff39833a,
  0xffb03383, 0xff7b0086, 0xff3884af, 0xff38833e,
  0xffb00050, 0xff7aab31, 0xff3804b2, 0xff380340,
  0xffb00050, 0xff7aab31, 0xff3804b2, 0xff380340,
  0xffe6cce6, 0xffd6002b, 0xffc1017c, 0xffc1011c,
  0xffcdccff, 0xffac55aa, 0xff8282f3, 0xff828216,
  0xffca99cf, 0xffa7005a, 0xff7a8323, 0xff7a8236,
  0xffca0036, 0xffa6005b, 0xff79032c, 0xff79023c,
  0xffc999d0, 0xffa555b1, 0xff780332, 0xff780240,
  0xffc9669d, 0xffa5005c, 0xff778335, 0xff778242,
  0xffc9669d, 0xffa5005c, 0xff778335, 0xff778242,
  0xffc999d0, 0xffa555b1, 0xff780332, 0xff780240,
  0xffe70019, 0xffd65580, 0xffc18179, 0xffc1811a,
  0xffe3cce9, 0xffd10030, 0xffb981a9, 0xffb9813a,
  0xffe33350, 0xffd00031, 0xffb801b2, 0xffb80140,
  0xffe2ccea, 0xffcf5587, 0xffb701b8, 0xffb70144,
  0xffe299b7, 0xffcf0032, 0xffb681bb, 0xffb68146,
  0xffe299b7, 0xffcf0032, 0xffb681bb, 0xffb68146,
  0xffe2ccea, 0xffcf5587, 0xffb701b8, 0xffb70144,
  0xffe33350, 0xffd00031, 0xffb801b2, 0xffb80140,
  0xfffcccd0, 0xfffaaab1, 0xfff80032, 0xfff80040,
  0xfffc3337, 0xfff9aab2, 0xfff6803b, 0xfff68046,
  0xfffbccd1, 0xfff90008, 0xfff58041, 0xfff5804a,
  0xfffb999e, 0xfff8aab3, 0xfff50044, 0xfff5004c,
  0xfffb999e, 0xfff8aab3, 0xfff50044, 0xfff5004c,
  0xfffbccd1, 0xfff90008, 0xfff58041, 0xfff5804a,
  0xfffc3337, 0xfff9aab2, 0xfff6803b, 0xfff68046,
  0xffff6667, 0xffff0002, 0xfffe800b, 0xfffe8026,
  0xffff6667, 0xffff0002, 0xfffe800b, 0xfffe8026,
  0xffff0001, 0xfffe5558, 0xfffd8011, 0xfffd802a,
  0xfffeccce, 0xfffe0003, 0xfffd0014, 0xfffd002c,
  0xfffeccce, 0xfffe0003, 0xfffd0014, 0xfffd002c,
  0xffff0001, 0xfffe5558, 0xfffd8011, 0xfffd802a,
  0xffff6667, 0xffff0002, 0xfffe800b, 0xfffe8026,
  0x00029997, 0x00045552, 0x00067fdb, 0x00068006,
  0x001b997e, 0x002dffd3, 0x0044fe64, 0x0044ff0c,
  0xffff999a, 0xffff5557, 0xffff0008, 0xffff0024,
  0xffff6667, 0xffff0002, 0xfffe800b, 0xfffe8026,
  0xffff6667, 0xffff0002, 0xfffe800b, 0xfffe8026,
  0xffff999a, 0xffff5557, 0xffff0008, 0xffff0024,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00033330, 0x00055551, 0x0007ffd2, 0x00080000,
  0x001c3317, 0x002effd2, 0x00467e5b, 0x00467f06,
  0x00356631, 0x0058ffa8, 0x00857ce1, 0x00857e0a,
  0xffffcccd, 0xffffaaac, 0xffff8005, 0xffff8022,
  0xffffcccd, 0xffffaaac, 0xffff8005, 0xffff8022,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00006666, 0x0000aaab, 0x0000fffc, 0x0001001c,
  0x00039996, 0x0005fffb, 0x0008ffcc, 0x0008fffc,
  0x001c997d, 0x002faa7c, 0x00477e55, 0x00477f02,
  0x0035cc97, 0x0059aa52, 0x00867cdb, 0x00867e06,
  0x004f32e4, 0x0083ff7d, 0x00c5fb5e, 0x00c5fd08,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00003333, 0x00005556, 0x00007fff, 0x0000801e,
  0x00009999, 0x00010000, 0x00017ff9, 0x0001801a,
  0x0003ccc9, 0x00065550, 0x00097fc9, 0x00097ffa,
  0x001cccb0, 0x002fffd1, 0x0047fe52, 0x0047ff00,
  0x0035ffca, 0x0059ffa7, 0x0086fcd8, 0x0086fe04,
  0x004f6617, 0x008454d2, 0x00c67b5b, 0x00c67d06,
  0x0a8cc240, 0x119543c1, 0x1a5f61c2, 0x1a5f96a0,
  0x00003333, 0x00005556, 0x00007fff, 0x0000801e,
  0x00009999, 0x00010000, 0x00017ff9, 0x0001801a,
  0x0003ccc9, 0x00065550, 0x00097fc9, 0x00097ffa,
  0x001cccb0, 0x002fffd1, 0x0047fe52, 0x0047ff00,
  0x0035ffca, 0x0059ffa7, 0x0086fcd8, 0x0086fe04,
  0x004f6617, 0x008454d2, 0x00c67b5b, 0x00c67d06,
  0x0a8cc240, 0x119543c1, 0x1a5f61c2, 0x1a5f96a0,
  0x1b9db12f, 0x2e06d1fa, 0x4508e1c3, 0x45096bf6,
  0x00006666, 0x0000aaab, 0x0000fffc, 0x0001001c,
  0x00039996, 0x0005fffb, 0x0008ffcc, 0x0008fffc,
  0x001c997d, 0x002faa7c, 0x00477e55, 0x00477f02,
  0x0035cc97, 0x0059aa52, 0x00867cdb, 0x00867e06,
  0x004f32e4, 0x0083ff7d, 0x00c5fb5e, 0x00c5fd08,
  0x0a8c8f0d, 0x1194ee6c, 0x1a5ee1c5, 0x1a5f16a2,
  0x1b9d7dfc, 0x2e067ca5, 0x450861c6, 0x4508ebf8,
  0x35366463, 0x58affca6, 0x850561cf, 0x85066bfe,
  0x00033330, 0x00055551, 0x0007ffd2, 0x00080000,
  0x001c3317, 0x002effd2, 0x00467e5b, 0x00467f06,
  0x00356631, 0x0058ffa8, 0x00857ce1, 0x00857e0a,
  0x004ecc7e, 0x008354d3, 0x00c4fb64, 0x00c4fd0c,
  0x0a8c28a7, 0x119443c2, 0x1a5de1cb, 0x1a5e16a6,
  0x1b9d1796, 0x2e05d1fb, 0x450761cc, 0x4507ebfc,
  0x3535fdfd, 0x58af51fc, 0x850461d5, 0x85056c02,
  0x4ecf1797, 0x83592752, 0xc501e1db, 0xc5036c06,
  0x0018ffe7, 0x0029aa82, 0x003e7e8b, 0x003e7f26,
  0x00323301, 0x0053aa58, 0x007d7d11, 0x007d7e2a,
  0x004b994e, 0x007dff83, 0x00bcfb94, 0x00bcfd2c,
  0x0a88f577, 0x118eee72, 0x1a55e1fb, 0x1a5616c6,
  0x1b99e466, 0x2e007cab, 0x44ff61fc, 0x44ffec1c,
  0x3532cacd, 0x58a9fcac, 0x84fc6205, 0x84fd6c22,
  0x4ecbe467, 0x8353d202, 0xc4f9e20b, 0xc4fb6c26,
  0x68653134, 0xadfdfcad, 0x04f7e20e, 0x04f9ec28,
  0x0019331a, 0x0029ffd7, 0x003efe88, 0x003eff24,
  0x00329967, 0x00545502, 0x007e7d0b, 0x007e7e26,
  0x0a6ff590, 0x116543f1, 0x1a176372, 0x1a1797c0,
  0x1b80e47f, 0x2dd6d22a, 0x44c0e373, 0x44c16d16,
  0x3519cae6, 0x5880522b, 0x84bde37c, 0x84beed1c,
  0x4eb2e480, 0x832a2781, 0xc4bb6382, 0xc4bced20,
  0x684c314d, 0xadd4522c, 0x04b96385, 0x04bb6d22,
  0x4eb2b14d, 0x8329d22c, 0xc4bae385, 0xc4bc6d22,
  0x0019664d, 0x002a552c, 0x003f7e85, 0x003f7f22,
  0x0a56c276, 0x113b441b, 0x19d864ec, 0x19d898bc,
  0x1b67b165, 0x2dacd254, 0x4481e4ed, 0x44826e12,
  0x350097cc, 0x58565255, 0x847ee4f6, 0x847fee18,
  0x4e99b166, 0x830027ab, 0xc47c64fc, 0xc47dee1c,
  0x6832fe33, 0xadaa5256, 0x047a64ff, 0x047c6e1e,
  0x4e997e33, 0x82ffd256, 0xc47be4ff, 0xc47d6e1e,
  0x35003166, 0x5855a7ab, 0x847de4fc, 0x847eee1c,
  0x0a3d5c29, 0x1110eef0, 0x1998e669, 0x199919ba,
  0x1b4e4b18, 0x2d827d29, 0x4442666a, 0x4442ef10,
  0x34e7317f, 0x582bfd2a, 0x843f6673, 0x84406f16,
  0x4e804b19, 0x82d5d280, 0xc43ce679, 0xc43e6f1a,
  0x681997e6, 0xad7ffd2b, 0x043ae67c, 0x043cef1c,
  0x4e8017e6, 0x82d57d2b, 0xc43c667c, 0xc43def1c,
  0x34e6cb19, 0x582b5280, 0x843e6679, 0x843f6f1a,
  0x23d5a8f7, 0x3bb96ef2, 0x5994667b, 0x599519c6,
  0x1110eeef, 0x1c718e3a, 0x2aa98003, 0x2aa9d576,
  0x2aa9d556, 0x471b0e3b, 0x6aa6800c, 0x6aa7557c,
  0x4442eef0, 0x71c4e391, 0xaaa40012, 0xaaa55580,
  0x5ddc3bbd, 0x9c6f0e3c, 0xeaa20015, 0xeaa3d582,
  0x4442bbbd, 0x71c48e3c, 0xaaa38015, 0xaaa4d582,
  0x2aa96ef0, 0x471a6391, 0x6aa58012, 0x6aa65580,
  0x19984cce, 0x2aa88003, 0x3ffb8014, 0x3ffc002c,
  0x0f5abd72, 0x19973bbf, 0x266219b0, 0x26626694,
  0x1998e667, 0x2aa98002, 0x3ffd000b, 0x3ffd8026,
  0x33320001, 0x55535558, 0x7ffa8011, 0x7ffb802a,
  0x4ccb4cce, 0x7ffd8003, 0xbff88014, 0xbffa002c,
  0x3331ccce, 0x55530003, 0x7ffa0014, 0x7ffb002c,
  0x19988001, 0x2aa8d558, 0x3ffc0011, 0x3ffc802a,
  0x08875ddf, 0x0e36f1ca, 0x15520013, 0x15522ad6,
  0xfe49ce83, 0xfd25ad86, 0xfbb899af, 0xfbb8913e,
  0xfe303503, 0xfcfb0306, 0xfb789b2f, 0xfb78923e,
  0x1999199a, 0x2aa9d557, 0x3ffd8008, 0x3ffe0024,
  0x33326667, 0x55540002, 0x7ffb800b, 0x7ffc8026,
  0x1998e667, 0x2aa98002, 0x3ffd000b, 0x3ffd8026,
  0xffff999a, 0xffff5557, 0xffff0008, 0xffff0024,
  0xeeee7778, 0xe38d71c9, 0xd555000a, 0xd554aad0,
  0xe4b0e81c, 0xd27c2d85, 0xbbbb99a6, 0xbbbb1138,
  0xe4974e9c, 0xd2518305, 0xbb7b9b26, 0xbb7b1238,
  0xe47de84f, 0xd2272dda, 0xbb3c1ca3, 0xbb3b9336,
  0x19994ccd, 0x2aaa2aac, 0x3ffe0005, 0x3ffe8022,
  0xffffcccd, 0xffffaaac, 0xffff8005, 0xffff8022,
  0xe6668000, 0xd5558001, 0xc0018002, 0xc0010020,
  0xd5555dde, 0xb8e39c73, 0x95578004, 0x9556aacc,
  0xcb17ce82, 0xa7d2582f, 0x7bbe19a0, 0x7bbd1134,
  0xcafe3502, 0xa7a7adaf, 0x7b7e1b20, 0x7b7d1234,
  0xcae4ceb5, 0xa77d5884, 0x7b3e9c9d, 0x7b3d9332,
  0xcacb9b9b, 0xa75358ae, 0x7aff9e17, 0x7afe942e,
  0xe6668000, 0xd5558001, 0xc0018002, 0xc0010020,
  0xcccd3333, 0xaaab5556, 0x80037fff, 0x8002801e,
  0xbbbc1111, 0x8e3971c8, 0x55598001, 0x55582aca,
  0xb17e81b5, 0x7d282d84, 0x3bc0199d, 0x3bbe9132,
  0xb164e835, 0x7cfd8304, 0x3b801b1d, 0x3b7e9232,
  0xb14b81e8, 0x7cd32dd9, 0x3b409c9a, 0x3b3f1330,
  0xb1324ece, 0x7ca92e03, 0x3b019e14, 0x3b00142c,
  0xb1194ee7, 0x7c7f8382, 0x3ac31f8b, 0x3ac19526,
  0xe666b333, 0xd555d556, 0xc001ffff, 0xc001801e,
  0xd5559111, 0xb8e3f1c8, 0x95580001, 0x95572aca,
  0xcb1801b5, 0xa7d2ad84, 0x7bbe999d, 0x7bbd9132,
  0xcafe6835, 0xa7a80304, 0x7b7e9b1d, 0x7b7d9232,
  0xcae501e8, 0xa77dadd9, 0x7b3f1c9a, 0x7b3e1330,
  0xcacbcece, 0xa753ae03, 0x7b001e14, 0x7aff142c,
  0xcab2cee7, 0xa72a0382, 0x7ac19f8b, 0x7ac09526,
  0xcaaf9bb7, 0xa724ae32, 0x7ab99fbb, 0x7ab89546,
  0xeeeeddde, 0xe38e1c73, 0xd5560004, 0xd555aacc,
  0xe4b14e82, 0xd27cd82f, 0xbbbc99a0, 0xbbbc1134,
  0xe497b502, 0xd2522daf, 0xbb7c9b20, 0xbb7c1234,
  0xe47e4eb5, 0xd227d884, 0xbb3d1c9d, 0xbb3c9332,
  0xe4651b9b, 0xd1fdd8ae, 0xbafe1e17, 0xbafd942e,
  0xe44c1bb4, 0xd1d42e2d, 0xbabf9f8e, 0xbabf1528,
  0xe448e884, 0xd1ced8dd, 0xbab79fbe, 0xbab71548,
  0xe4484eeb, 0xd1cdd8de, 0xbab61fc7, 0xbab5954e,
  0xf5c270a4, 0xeeeebbbd, 0xe666999e, 0xe6666688,
  0xf5a8d724, 0xeec4113d, 0xe6269b1e, 0xe6266788,
  0xf58f70d7, 0xee99bc12, 0xe5e71c9b, 0xe5e6e886,
  0xf5763dbd, 0xee6fbc3c, 0xe5a81e15, 0xe5a7e982,
  0xf55d3dd6, 0xee4611bb, 0xe5699f8c, 0xe5696a7c,
  0xf55a0aa6, 0xee40bc6b, 0xe5619fbc, 0xe5616a9c,
  0xf559710d, 0xee3fbc6c, 0xe5601fc5, 0xe55feaa2,
  0xf5590aa7, 0xee3f11c2, 0xe55f1fcb, 0xe55eeaa6,
  0xffe66680, 0xffd55581, 0xffc00182, 0xffc00120,
  0xffcd0033, 0xffab0056, 0xff8082ff, 0xff80821e,
  0xffb3cd19, 0xff810080, 0xff418479, 0xff41831a,
  0xff9acd32, 0xff5755ff, 0xff0305f0, 0xff030414,
  0xff979a02, 0xff5200af, 0xfefb0620, 0xfefb0434,
  0xff970069, 0xff5100b0, 0xfef98629, 0xfef9843a,
  0xff969a03, 0xff505606, 0xfef8862f, 0xfef8843e,
  0xff9666d0, 0xff5000b1, 0xfef80632, 0xfef80440,
  0xffd5aad5, 0xffc0817e, 0xffc08100, 0xffc0809f,
  0xffabaaff, 0xff8182f8, 0xff8181fc, 0xff81811d,
  0xff82007e, 0xff43046f, 0xff4302f6, 0xff43019a,
  0xff7cab2e, 0xff3b049f, 0xff3b0316, 0xff3b01aa,
  0xff7bab2f, 0xff3984a8, 0xff39831c, 0xff3981ad,
  0xff7b0085, 0xff3884ae, 0xff388320, 0xff3881af,
  0xff7aab30, 0xff3804b1, 0xff380322, 0xff3801b0,
  0xff7aab30, 0xff3804b1, 0xff380322, 0xff3801b0,
  0xffd6002a, 0xffc1017b, 0xffc100fe, 0xffc1009e,
  0xffac55a9, 0xff8282f2, 0xff8281f8, 0xff82811b,
  0xffa70059, 0xff7a8322, 0xff7a8218, 0xff7a812b,
  0xffa6005a, 0xff79032b, 0xff79021e, 0xff79012e,
  0xffa555b0, 0xff780331, 0xff780222, 0xff780130,
  0xffa5005b, 0xff778334, 0xff778224, 0xff778131,
  0xffa5005b, 0xff778334, 0xff778224, 0xff778131,
  0xffa555b0, 0xff780331, 0xff780222, 0xff780130,
  0xffd6557f, 0xffc18178, 0xffc180fc, 0xffc1809d,
  0xffd1002f, 0xffb981a8, 0xffb9811c, 0xffb980ad,
  0xffd00030, 0xffb801b1, 0xffb80122, 0xffb800b0,
  0xffcf5586, 0xffb701b7, 0xffb70126, 0xffb700b2,
  0xffcf0031, 0xffb681ba, 0xffb68128, 0xffb680b3,
  0xffcf0031, 0xffb681ba, 0xffb68128, 0xffb680b3,
  0xffcf5586, 0xffb701b7, 0xffb70126, 0xffb700b2,
  0xffd00030, 0xffb801b1, 0xffb80122, 0xffb800b0,
  0xfffaaab0, 0xfff80031, 0xfff80022, 0xfff80030,
  0xfff9aab1, 0xfff6803a, 0xfff68028, 0xfff68033,
  0xfff90007, 0xfff58040, 0xfff5802c, 0xfff58035,
  0xfff8aab2, 0xfff50043, 0xfff5002e, 0xfff50036,
  0xfff8aab2, 0xfff50043, 0xfff5002e, 0xfff50036,
  0xfff90007, 0xfff58040, 0xfff5802c, 0xfff58035,
  0xfff9aab1, 0xfff6803a, 0xfff68028, 0xfff68033,
  0xffff0001, 0xfffe800a, 0xfffe8008, 0xfffe8023,
  0xffff0001, 0xfffe800a, 0xfffe8008, 0xfffe8023,
  0xfffe5557, 0xfffd8010, 0xfffd800c, 0xfffd8025,
  0xfffe0002, 0xfffd0013, 0xfffd000e, 0xfffd0026,
  0xfffe0002, 0xfffd0013, 0xfffd000e, 0xfffd0026,
  0xfffe5557, 0xfffd8010, 0xfffd800c, 0xfffd8025,
  0xffff0001, 0xfffe800a, 0xfffe8008, 0xfffe8023,
  0x00045551, 0x00067fda, 0x00067fe8, 0x00068013,
  0x002dffd2, 0x0044fe63, 0x0044feee, 0x0044ff96,
  0xffff5556, 0xffff0007, 0xffff0006, 0xffff0022,
  0xffff0001, 0xfffe800a, 0xfffe8008, 0xfffe8023,
  0xffff0001, 0xfffe800a, 0xfffe8008, 0xfffe8023,
  0xffff5556, 0xffff0007, 0xffff0006, 0xffff0022,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00055550, 0x0007ffd1, 0x0007ffe2, 0x00080010,
  0x002effd1, 0x00467e5a, 0x00467ee8, 0x00467f93,
  0x0058ffa7, 0x00857ce0, 0x00857dec, 0x00857f15,
  0xffffaaab, 0xffff8004, 0xffff8004, 0xffff8021,
  0xffffaaab, 0xffff8004, 0xffff8004, 0xffff8021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000aaaa, 0x0000fffb, 0x0000fffe, 0x0001001e,
  0x0005fffa, 0x0008ffcb, 0x0008ffde, 0x0009000e,
  0x002faa7b, 0x00477e54, 0x00477ee4, 0x00477f91,
  0x0059aa51, 0x00867cda, 0x00867de8, 0x00867f13,
  0x0083ff7c, 0x00c5fb5d, 0x00c5fcea, 0x00c5fe94,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00005555, 0x00007ffe, 0x00008000, 0x0000801f,
  0x0000ffff, 0x00017ff8, 0x00017ffc, 0x0001801d,
  0x0006554f, 0x00097fc8, 0x00097fdc, 0x0009800d,
  0x002fffd0, 0x0047fe51, 0x0047fee2, 0x0047ff90,
  0x0059ffa6, 0x0086fcd7, 0x0086fde6, 0x0086ff12,
  0x008454d1, 0x00c67b5a, 0x00c67ce8, 0x00c67e93,
  0x119543c0, 0x1a5f61c1, 0x1a5f9682, 0x1a5fcb60,
  0x00005555, 0x00007ffe, 0x00008000, 0x0000801f,
  0x0000ffff, 0x00017ff8, 0x00017ffc, 0x0001801d,
  0x0006554f, 0x00097fc8, 0x00097fdc, 0x0009800d,
  0x002fffd0, 0x0047fe51, 0x0047fee2, 0x0047ff90,
  0x0059ffa6, 0x0086fcd7, 0x0086fde6, 0x0086ff12,
  0x008454d1, 0x00c67b5a, 0x00c67ce8, 0x00c67e93,
  0x119543c0, 0x1a5f61c1, 0x1a5f9682, 0x1a5fcb60,
  0x2e06d1f9, 0x4508e1c2, 0x45096bd8, 0x4509f60b,
  0x0000aaaa, 0x0000fffb, 0x0000fffe, 0x0001001e,
  0x0005fffa, 0x0008ffcb, 0x0008ffde, 0x0009000e,
  0x002faa7b, 0x00477e54, 0x00477ee4, 0x00477f91,
  0x0059aa51, 0x00867cda, 0x00867de8, 0x00867f13,
  0x0083ff7c, 0x00c5fb5d, 0x00c5fcea, 0x00c5fe94,
  0x1194ee6b, 0x1a5ee1c4, 0x1a5f1684, 0x1a5f4b61,
  0x2e067ca4, 0x450861c5, 0x4508ebda, 0x4509760c,
  0x58affca5, 0x850561ce, 0x85066be0, 0x8507760f,
  0x00055550, 0x0007ffd1, 0x0007ffe2, 0x00080010,
  0x002effd1, 0x00467e5a, 0x00467ee8, 0x00467f93,
  0x0058ffa7, 0x00857ce0, 0x00857dec, 0x00857f15,
  0x008354d2, 0x00c4fb63, 0x00c4fcee, 0x00c4fe96,
  0x119443c1, 0x1a5de1ca, 0x1a5e1688, 0x1a5e4b63,
  0x2e05d1fa, 0x450761cb, 0x4507ebde, 0x4508760e,
  0x58af51fb, 0x850461d4, 0x85056be4, 0x85067611,
  0x83592751, 0xc501e1da, 0xc5036be8, 0xc504f613,
  0x0029aa81, 0x003e7e8a, 0x003e7f08, 0x003e7fa3,
  0x0053aa57, 0x007d7d10, 0x007d7e0c, 0x007d7f25,
  0x007dff82, 0x00bcfb93, 0x00bcfd0e, 0x00bcfea6,
  0x118eee71, 0x1a55e1fa, 0x1a5616a8, 0x1a564b73,
  0x2e007caa, 0x44ff61fb, 0x44ffebfe, 0x4500761e,
  0x58a9fcab, 0x84fc6204, 0x84fd6c04, 0x84fe7621,
  0x8353d201, 0xc4f9e20a, 0xc4fb6c08, 0xc4fcf623,
  0xadfdfcac, 0x04f7e20d, 0x04f9ec0a, 0x04fbf624,
  0x0029ffd6, 0x003efe87, 0x003eff06, 0x003effa2,
  0x00545501, 0x007e7d0a, 0x007e7e08, 0x007e7f23,
  0x116543f0, 0x1a176371, 0x1a1797a2, 0x1a17cbf0,
  0x2dd6d229, 0x44c0e372, 0x44c16cf8, 0x44c1f69b,
  0x5880522a, 0x84bde37b, 0x84beecfe, 0x84bff69e,
  0x832a2780, 0xc4bb6381, 0xc4bced02, 0xc4be76a0,
  0xadd4522b, 0x04b96384, 0x04bb6d04, 0x04bd76a1,
  0x8329d22b, 0xc4bae384, 0xc4bc6d04, 0xc4bdf6a1,
  0x002a552b, 0x003f7e84, 0x003f7f04, 0x003f7fa1,
  0x113b441a, 0x19d864eb, 0x19d8989e, 0x19d8cc6e,
  0x2dacd253, 0x4481e4ec, 0x44826df4, 0x4482f719,
  0x58565254, 0x847ee4f5, 0x847fedfa, 0x8480f71c,
  0x830027aa, 0xc47c64fb, 0xc47dedfe, 0xc47f771e,
  0xadaa5255, 0x047a64fe, 0x047c6e00, 0x047e771f,
  0x82ffd255, 0xc47be4fe, 0xc47d6e00, 0xc47ef71f,
  0x5855a7aa, 0x847de4fb, 0x847eedfe, 0x847ff71e,
  0x1110eeef, 0x1998e668, 0x1999199c, 0x19994ced,
  0x2d827d28, 0x44426669, 0x4442eef2, 0x44437798,
  0x582bfd29, 0x843f6672, 0x84406ef8, 0x8441779b,
  0x82d5d27f, 0xc43ce678, 0xc43e6efc, 0xc43ff79d,
  0xad7ffd2a, 0x043ae67b, 0x043ceefe, 0x043ef79e,
  0x82d57d2a, 0xc43c667b, 0xc43deefe, 0xc43f779e,
  0x582b527f, 0x843e6678, 0x843f6efc, 0x8440779d,
  0x3bb96ef1, 0x5994667a, 0x599519a8, 0x5995ccf3,
  0x1c718e39, 0x2aa98002, 0x2aa9d558, 0x2aaa2acb,
  0x471b0e3a, 0x6aa6800b, 0x6aa7555e, 0x6aa82ace,
  0x71c4e390, 0xaaa40011, 0xaaa55562, 0xaaa6aad0,
  0x9c6f0e3b, 0xeaa20014, 0xeaa3d564, 0xeaa5aad1,
  0x71c48e3b, 0xaaa38014, 0xaaa4d564, 0xaaa62ad1,
  0x471a6390, 0x6aa58011, 0x6aa65562, 0x6aa72ad0,
  0x2aa88002, 0x3ffb8013, 0x3ffc000e, 0x3ffc8026,
  0x19973bbe, 0x266219af, 0x26626676, 0x2662b35a,
  0x2aa98001, 0x3ffd000a, 0x3ffd8008, 0x3ffe0023,
  0x55535557, 0x7ffa8010, 0x7ffb800c, 0x7ffc8025,
  0x7ffd8002, 0xbff88013, 0xbffa000e, 0xbffb8026,
  0x55530002, 0x7ffa0013, 0x7ffb000e, 0x7ffc0026,
  0x2aa8d557, 0x3ffc0010, 0x3ffc800c, 0x3ffd0025,
  0x0e36f1c9, 0x15520012, 0x15522ab8, 0x1552557b,
  0xfd25ad85, 0xfbb899ae, 0xfbb89120, 0xfbb888af,
  0xfcfb0305, 0xfb789b2e, 0xfb789220, 0xfb78892f,
  0x2aa9d556, 0x3ffd8007, 0x3ffe0006, 0x3ffe8022,
  0x55540001, 0x7ffb800a, 0x7ffc8008, 0x7ffd8023,
  0x2aa98001, 0x3ffd000a, 0x3ffd8008, 0x3ffe0023,
  0xffff5556, 0xffff0007, 0xffff0006, 0xffff0022,
  0xe38d71c8, 0xd5550009, 0xd554aab2, 0xd5545578,
  0xd27c2d84, 0xbbbb99a5, 0xbbbb111a, 0xbbba88ac,
  0xd2518304, 0xbb7b9b25, 0xbb7b121a, 0xbb7a892c,
  0xd2272dd9, 0xbb3c1ca2, 0xbb3b9318, 0xbb3b09ab,
  0x2aaa2aab, 0x3ffe0004, 0x3ffe8004, 0x3fff0021,
  0xffffaaab, 0xffff8004, 0xffff8004, 0xffff8021,
  0xd5558000, 0xc0018001, 0xc0010002, 0xc0008020,
  0xb8e39c72, 0x95578003, 0x9556aaae, 0x9555d576,
  0xa7d2582e, 0x7bbe199f, 0x7bbd1116, 0x7bbc08aa,
  0xa7a7adae, 0x7b7e1b1f, 0x7b7d1216, 0x7b7c092a,
  0xa77d5883, 0x7b3e9c9c, 0x7b3d9314, 0x7b3c89a9,
  0xa75358ad, 0x7aff9e16, 0x7afe9410, 0x7afd8a27,
  0xd5558000, 0xc0018001, 0xc0010002, 0xc0008020,
  0xaaab5555, 0x80037ffe, 0x80028000, 0x8001801f,
  0x8e3971c7, 0x55598000, 0x55582aac, 0x5556d575,
  0x7d282d83, 0x3bc0199c, 0x3bbe9114, 0x3bbd08a9,
  0x7cfd8303, 0x3b801b1c, 0x3b7e9214, 0x3b7d0929,
  0x7cd32dd8, 0x3b409c99, 0x3b3f1312, 0x3b3d89a8,
  0x7ca92e02, 0x3b019e13, 0x3b00140e, 0x3afe8a26,
  0x7c7f8381, 0x3ac31f8a, 0x3ac19508, 0x3ac00aa3,
  0xd555d555, 0xc001fffe, 0xc0018000, 0xc001001f,
  0xb8e3f1c7, 0x95580000, 0x95572aac, 0x95565575,
  0xa7d2ad83, 0x7bbe999c, 0x7bbd9114, 0x7bbc88a9,
  0xa7a80303, 0x7b7e9b1c, 0x7b7d9214, 0x7b7c8929,
  0xa77dadd8, 0x7b3f1c99, 0x7b3e1312, 0x7b3d09a8,
  0xa753ae02, 0x7b001e13, 0x7aff140e, 0x7afe0a26,
  0xa72a0381, 0x7ac19f8a, 0x7ac09508, 0x7abf8aa3,
  0xa724ae31, 0x7ab99fba, 0x7ab89528, 0x7ab78ab3,
  0xe38e1c72, 0xd5560003, 0xd555aaae, 0xd5555576,
  0xd27cd82e, 0xbbbc999f, 0xbbbc1116, 0xbbbb88aa,
  0xd2522dae, 0xbb7c9b1f, 0xbb7c1216, 0xbb7b892a,
  0xd227d883, 0xbb3d1c9c, 0xbb3c9314, 0xbb3c09a9,
  0xd1fdd8ad, 0xbafe1e16, 0xbafd9410, 0xbafd0a27,
  0xd1d42e2c, 0xbabf9f8d, 0xbabf150a, 0xbabe8aa4,
  0xd1ced8dc, 0xbab79fbd, 0xbab7152a, 0xbab68ab4,
  0xd1cdd8dd, 0xbab61fc6, 0xbab59530, 0xbab50ab7,
  0xeeeebbbc, 0xe666999d, 0xe666666a, 0xe6663354,
  0xeec4113c, 0xe6269b1d, 0xe626676a, 0xe62633d4,
  0xee99bc11, 0xe5e71c9a, 0xe5e6e868, 0xe5e6b453,
  0xee6fbc3b, 0xe5a81e14, 0xe5a7e964, 0xe5a7b4d1,
  0xee4611ba, 0xe5699f8b, 0xe5696a5e, 0xe569354e,
  0xee40bc6a, 0xe5619fbb, 0xe5616a7e, 0xe561355e,
  0xee3fbc6b, 0xe5601fc4, 0xe55fea84, 0xe55fb561,
  0xee3f11c1, 0xe55f1fca, 0xe55eea88, 0xe55eb563,
  0xffd55580, 0xffc00181, 0xffc00102, 0xffc000a0,
  0xffab0055, 0xff8082fe, 0xff808200, 0xff80811f,
  0xff81007f, 0xff418478, 0xff4182fc, 0xff41819d,
  0xff5755fe, 0xff0305ef, 0xff0303f6, 0xff03021a,
  0xff5200ae, 0xfefb061f, 0xfefb0416, 0xfefb022a,
  0xff5100af, 0xfef98628, 0xfef9841c, 0xfef9822d,
  0xff505605, 0xfef8862e, 0xfef88420, 0xfef8822f,
  0xff5000b0, 0xfef80631, 0xfef80422, 0xfef80230,
  0xffc0817d, 0xffc080ff, 0xffc08081, 0x00000020,
  0xff8182f7, 0xff8181fb, 0xff8180ff, 0x00000020,
  0xff43046e, 0xff4302f5, 0xff43017c, 0x00000020,
  0xff3b049e, 0xff3b0315, 0xff3b018c, 0x00000020,
  0xff3984a7, 0xff39831b, 0xff39818f, 0x00000020,
  0xff3884ad, 0xff38831f, 0xff388191, 0x00000020,
  0xff3804b0, 0xff380321, 0xff380192, 0x00000020,
  0xff3804b0, 0xff380321, 0xff380192, 0x00000020,
  0xffc1017a, 0xffc100fd, 0xffc10080, 0x00000020,
  0xff8282f1, 0xff8281f7, 0xff8280fd, 0x00000020,
  0xff7a8321, 0xff7a8217, 0xff7a810d, 0x00000020,
  0xff79032a, 0xff79021d, 0xff790110, 0x00000020,
  0xff780330, 0xff780221, 0xff780112, 0x00000020,
  0xff778333, 0xff778223, 0xff778113, 0x00000020,
  0xff778333, 0xff778223, 0xff778113, 0x00000020,
  0xff780330, 0xff780221, 0xff780112, 0x00000020,
  0xffc18177, 0xffc180fb, 0xffc1807f, 0x00000020,
  0xffb981a7, 0xffb9811b, 0xffb9808f, 0x00000020,
  0xffb801b0, 0xffb80121, 0xffb80092, 0x00000020,
  0xffb701b6, 0xffb70125, 0xffb70094, 0x00000020,
  0xffb681b9, 0xffb68127, 0xffb68095, 0x00000020,
  0xffb681b9, 0xffb68127, 0xffb68095, 0x00000020,
  0xffb701b6, 0xffb70125, 0xffb70094, 0x00000020,
  0xffb801b0, 0xffb80121, 0xffb80092, 0x00000020,
  0xfff80030, 0xfff80021, 0xfff80012, 0x00000020,
  0xfff68039, 0xfff68027, 0xfff68015, 0x00000020,
  0xfff5803f, 0xfff5802b, 0xfff58017, 0x00000020,
  0xfff50042, 0xfff5002d, 0xfff50018, 0x00000020,
  0xfff50042, 0xfff5002d, 0xfff50018, 0x00000020,
  0xfff5803f, 0xfff5802b, 0xfff58017, 0x00000020,
  0xfff68039, 0xfff68027, 0xfff68015, 0x00000020,
  0xfffe8009, 0xfffe8007, 0xfffe8005, 0x00000020,
  0xfffe8009, 0xfffe8007, 0xfffe8005, 0x00000020,
  0xfffd800f, 0xfffd800b, 0xfffd8007, 0x00000020,
  0xfffd0012, 0xfffd000d, 0xfffd0008, 0x00000020,
  0xfffd0012, 0xfffd000d, 0xfffd0008, 0x00000020,
  0xfffd800f, 0xfffd800b, 0xfffd8007, 0x00000020,
  0xfffe8009, 0xfffe8007, 0xfffe8005, 0x00000020,
  0x00067fd9, 0x00067fe7, 0x00067ff5, 0x00000020,
  0x0044fe62, 0x0044feed, 0x0044ff78, 0x00000020,
  0xffff0006, 0xffff0005, 0xffff0004, 0x00000020,
  0xfffe8009, 0xfffe8007, 0xfffe8005, 0x00000020,
  0xfffe8009, 0xfffe8007, 0xfffe8005, 0x00000020,
  0xffff0006, 0xffff0005, 0xffff0004, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0007ffd0, 0x0007ffe1, 0x0007fff2, 0x00000020,
  0x00467e59, 0x00467ee7, 0x00467f75, 0x00000020,
  0x00857cdf, 0x00857deb, 0x00857ef7, 0x00000020,
  0xffff8003, 0xffff8003, 0xffff8003, 0x00000020,
  0xffff8003, 0xffff8003, 0xffff8003, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000fffa, 0x0000fffd, 0x00010000, 0x00000020,
  0x0008ffca, 0x0008ffdd, 0x0008fff0, 0x00000020,
  0x00477e53, 0x00477ee3, 0x00477f73, 0x00000020,
  0x00867cd9, 0x00867de7, 0x00867ef5, 0x00000020,
  0x00c5fb5c, 0x00c5fce9, 0x00c5fe76, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00007ffd, 0x00007fff, 0x00008001, 0x00000020,
  0x00017ff7, 0x00017ffb, 0x00017fff, 0x00000020,
  0x00097fc7, 0x00097fdb, 0x00097fef, 0x00000020,
  0x0047fe50, 0x0047fee1, 0x0047ff72, 0x00000020,
  0x0086fcd6, 0x0086fde5, 0x0086fef4, 0x00000020,
  0x00c67b59, 0x00c67ce7, 0x00c67e75, 0x00000020,
  0x1a5f61c0, 0x1a5f9681, 0x1a5fcb42, 0x00000020,
  0x00007ffd, 0x00007fff, 0x00008001, 0x00000020,
  0x00017ff7, 0x00017ffb, 0x00017fff, 0x00000020,
  0x00097fc7, 0x00097fdb, 0x00097fef, 0x00000020,
  0x0047fe50, 0x0047fee1, 0x0047ff72, 0x00000020,
  0x0086fcd6, 0x0086fde5, 0x0086fef4, 0x00000020,
  0x00c67b59, 0x00c67ce7, 0x00c67e75, 0x00000020,
  0x1a5f61c0, 0x1a5f9681, 0x1a5fcb42, 0x00000020,
  0x4508e1c1, 0x45096bd7, 0x4509f5ed, 0x00000020,
  0x0000fffa, 0x0000fffd, 0x00010000, 0x00000020,
  0x0008ffca, 0x0008ffdd, 0x0008fff0, 0x00000020,
  0x00477e53, 0x00477ee3, 0x00477f73, 0x00000020,
  0x00867cd9, 0x00867de7, 0x00867ef5, 0x00000020,
  0x00c5fb5c, 0x00c5fce9, 0x00c5fe76, 0x00000020,
  0x1a5ee1c3, 0x1a5f1683, 0x1a5f4b43, 0x00000020,
  0x450861c4, 0x4508ebd9, 0x450975ee, 0x00000020,
  0x850561cd, 0x85066bdf, 0x850775f1, 0x00000020,
  0x0007ffd0, 0x0007ffe1, 0x0007fff2, 0x00000020,
  0x00467e59, 0x00467ee7, 0x00467f75, 0x00000020,
  0x00857cdf, 0x00857deb, 0x00857ef7, 0x00000020,
  0x00c4fb62, 0x00c4fced, 0x00c4fe78, 0x00000020,
  0x1a5de1c9, 0x1a5e1687, 0x1a5e4b45, 0x00000020,
  0x450761ca, 0x4507ebdd, 0x450875f0, 0x00000020,
  0x850461d3, 0x85056be3, 0x850675f3, 0x00000020,
  0xc501e1d9, 0xc5036be7, 0xc504f5f5, 0x00000020,
  0x003e7e89, 0x003e7f07, 0x003e7f85, 0x00000020,
  0x007d7d0f, 0x007d7e0b, 0x007d7f07, 0x00000020,
  0x00bcfb92, 0x00bcfd0d, 0x00bcfe88, 0x00000020,
  0x1a55e1f9, 0x1a5616a7, 0x1a564b55, 0x00000020,
  0x44ff61fa, 0x44ffebfd, 0x45007600, 0x00000020,
  0x84fc6203, 0x84fd6c03, 0x84fe7603, 0x00000020,
  0xc4f9e209, 0xc4fb6c07, 0xc4fcf605, 0x00000020,
  0x04f7e20c, 0x04f9ec09, 0x04fbf606, 0x00000020,
  0x003efe86, 0x003eff05, 0x003eff84, 0x00000020,
  0x007e7d09, 0x007e7e07, 0x007e7f05, 0x00000020,
  0x1a176370, 0x1a1797a1, 0x1a17cbd2, 0x00000020,
  0x44c0e371, 0x44c16cf7, 0x44c1f67d, 0x00000020,
  0x84bde37a, 0x84beecfd, 0x84bff680, 0x00000020,
  0xc4bb6380, 0xc4bced01, 0xc4be7682, 0x00000020,
  0x04b96383, 0x04bb6d03, 0x04bd7683, 0x00000020,
  0xc4bae383, 0xc4bc6d03, 0xc4bdf683, 0x00000020,
  0x003f7e83, 0x003f7f03, 0x003f7f83, 0x00000020,
  0x19d864ea, 0x19d8989d, 0x19d8cc50, 0x00000020,
  0x4481e4eb, 0x44826df3, 0x4482f6fb, 0x00000020,
  0x847ee4f4, 0x847fedf9, 0x8480f6fe, 0x00000020,
  0xc47c64fa, 0xc47dedfd, 0xc47f7700, 0x00000020,
  0x047a64fd, 0x047c6dff, 0x047e7701, 0x00000020,
  0xc47be4fd, 0xc47d6dff, 0xc47ef701, 0x00000020,
  0x847de4fa, 0x847eedfd, 0x847ff700, 0x00000020,
  0x1998e667, 0x1999199b, 0x19994ccf, 0x00000020,
  0x44426668, 0x4442eef1, 0x4443777a, 0x00000020,
  0x843f6671, 0x84406ef7, 0x8441777d, 0x00000020,
  0xc43ce677, 0xc43e6efb, 0xc43ff77f, 0x00000020,
  0x043ae67a, 0x043ceefd, 0x043ef780, 0x00000020,
  0xc43c667a, 0xc43deefd, 0xc43f7780, 0x00000020,
  0x843e6677, 0x843f6efb, 0x8440777f, 0x00000020,
  0x59946679, 0x599519a7, 0x5995ccd5, 0x00000020,
  0x2aa98001, 0x2aa9d557, 0x2aaa2aad, 0x00000020,
  0x6aa6800a, 0x6aa7555d, 0x6aa82ab0, 0x00000020,
  0xaaa40010, 0xaaa55561, 0xaaa6aab2, 0x00000020,
  0xeaa20013, 0xeaa3d563, 0xeaa5aab3, 0x00000020,
  0xaaa38013, 0xaaa4d563, 0xaaa62ab3, 0x00000020,
  0x6aa58010, 0x6aa65561, 0x6aa72ab2, 0x00000020,
  0x3ffb8012, 0x3ffc000d, 0x3ffc8008, 0x00000020,
  0x266219ae, 0x26626675, 0x2662b33c, 0x00000020,
  0x3ffd0009, 0x3ffd8007, 0x3ffe0005, 0x00000020,
  0x7ffa800f, 0x7ffb800b, 0x7ffc8007, 0x00000020,
  0xbff88012, 0xbffa000d, 0xbffb8008, 0x00000020,
  0x7ffa0012, 0x7ffb000d, 0x7ffc0008, 0x00000020,
  0x3ffc000f, 0x3ffc800b, 0x3ffd0007, 0x00000020,
  0x15520011, 0x15522ab7, 0x1552555d, 0x00000020,
  0xfbb899ad, 0xfbb8911f, 0xfbb88891, 0x00000020,
  0xfb789b2d, 0xfb78921f, 0xfb788911, 0x00000020,
  0x3ffd8006, 0x3ffe0005, 0x3ffe8004, 0x00000020,
  0x7ffb8009, 0x7ffc8007, 0x7ffd8005, 0x00000020,
  0x3ffd0009, 0x3ffd8007, 0x3ffe0005, 0x00000020,
  0xffff0006, 0xffff0005, 0xffff0004, 0x00000020,
  0xd5550008, 0xd554aab1, 0xd554555a, 0x00000020,
  0xbbbb99a4, 0xbbbb1119, 0xbbba888e, 0x00000020,
  0xbb7b9b24, 0xbb7b1219, 0xbb7a890e, 0x00000020,
  0xbb3c1ca1, 0xbb3b9317, 0xbb3b098d, 0x00000020,
  0x3ffe0003, 0x3ffe8003, 0x3fff0003, 0x00000020,
  0xffff8003, 0xffff8003, 0xffff8003, 0x00000020,
  0xc0018000, 0xc0010001, 0xc0008002, 0x00000020,
  0x95578002, 0x9556aaad, 0x9555d558, 0x00000020,
  0x7bbe199e, 0x7bbd1115, 0x7bbc088c, 0x00000020,
  0x7b7e1b1e, 0x7b7d1215, 0x7b7c090c, 0x00000020,
  0x7b3e9c9b, 0x7b3d9313, 0x7b3c898b, 0x00000020,
  0x7aff9e15, 0x7afe940f, 0x7afd8a09, 0x00000020,
  0xc0018000, 0xc0010001, 0xc0008002, 0x00000020,
  0x80037ffd, 0x80027fff, 0x80018001, 0x00000020,
  0x55597fff, 0x55582aab, 0x5556d557, 0x00000020,
  0x3bc0199b, 0x3bbe9113, 0x3bbd088b, 0x00000020,
  0x3b801b1b, 0x3b7e9213, 0x3b7d090b, 0x00000020,
  0x3b409c98, 0x3b3f1311, 0x3b3d898a, 0x00000020,
  0x3b019e12, 0x3b00140d, 0x3afe8a08, 0x00000020,
  0x3ac31f89, 0x3ac19507, 0x3ac00a85, 0x00000020,
  0xc001fffd, 0xc0017fff, 0xc0010001, 0x00000020,
  0x9557ffff, 0x95572aab, 0x95565557, 0x00000020,
  0x7bbe999b, 0x7bbd9113, 0x7bbc888b, 0x00000020,
  0x7b7e9b1b, 0x7b7d9213, 0x7b7c890b, 0x00000020,
  0x7b3f1c98, 0x7b3e1311, 0x7b3d098a, 0x00000020,
  0x7b001e12, 0x7aff140d, 0x7afe0a08, 0x00000020,
  0x7ac19f89, 0x7ac09507, 0x7abf8a85, 0x00000020,
  0x7ab99fb9, 0x7ab89527, 0x7ab78a95, 0x00000020,
  0xd5560002, 0xd555aaad, 0xd5555558, 0x00000020,
  0xbbbc999e, 0xbbbc1115, 0xbbbb888c, 0x00000020,
  0xbb7c9b1e, 0xbb7c1215, 0xbb7b890c, 0x00000020,
  0xbb3d1c9b, 0xbb3c9313, 0xbb3c098b, 0x00000020,
  0xbafe1e15, 0xbafd940f, 0xbafd0a09, 0x00000020,
  0xbabf9f8c, 0xbabf1509, 0xbabe8a86, 0x00000020,
  0xbab79fbc, 0xbab71529, 0xbab68a96, 0x00000020,
  0xbab61fc5, 0xbab5952f, 0xbab50a99, 0x00000020,
  0xe666999c, 0xe6666669, 0xe6663336, 0x00000020,
  0xe6269b1c, 0xe6266769, 0xe62633b6, 0x00000020,
  0xe5e71c99, 0xe5e6e867, 0xe5e6b435, 0x00000020,
  0xe5a81e13, 0xe5a7e963, 0xe5a7b4b3, 0x00000020,
  0xe5699f8a, 0xe5696a5d, 0xe5693530, 0x00000020,
  0xe5619fba, 0xe5616a7d, 0xe5613540, 0x00000020,
  0xe5601fc3, 0xe55fea83, 0xe55fb543, 0x00000020,
  0xe55f1fc9, 0xe55eea87, 0xe55eb545, 0x00000020,
  0xffc00180, 0xffc00101, 0xffc00082, 0x00000020,
  0xff8082fd, 0xff8081ff, 0xff808101, 0x00000020,
  0xff418477, 0xff4182fb, 0xff41817f, 0x00000020,
  0xff0305ee, 0xff0303f5, 0xff0301fc, 0x00000020,
  0xfefb061e, 0xfefb0415, 0xfefb020c, 0x00000020,
  0xfef98627, 0xfef9841b, 0xfef9820f, 0x00000020,
  0xfef8862d, 0xfef8841f, 0xfef88211, 0x00000020,
  0xfef80630, 0xfef80421, 0xfef80212, 0x00000020,
  0xffc080fe, 0xffc08080, 0x00000002, 0xffffffa1,
  0xff8181fa, 0xff8180fe, 0x00000002, 0xffffff23,
  0xff4302f4, 0xff43017b, 0x00000002, 0xfffffea6,
  0xff3b0314, 0xff3b018b, 0x00000002, 0xfffffe96,
  0xff39831a, 0xff39818e, 0x00000002, 0xfffffe93,
  0xff38831e, 0xff388190, 0x00000002, 0xfffffe91,
  0xff380320, 0xff380191, 0x00000002, 0xfffffe90,
  0xff380320, 0xff380191, 0x00000002, 0xfffffe90,
  0xffc100fc, 0xffc1007f, 0x00000002, 0xffffffa2,
  0xff8281f6, 0xff8280fc, 0x00000002, 0xffffff25,
  0xff7a8216, 0xff7a810c, 0x00000002, 0xffffff15,
  0xff79021c, 0xff79010f, 0x00000002, 0xffffff12,
  0xff780220, 0xff780111, 0x00000002, 0xffffff10,
  0xff778222, 0xff778112, 0x00000002, 0xffffff0f,
  0xff778222, 0xff778112, 0x00000002, 0xffffff0f,
  0xff780220, 0xff780111, 0x00000002, 0xffffff10,
  0xffc180fa, 0xffc1807e, 0x00000002, 0xffffffa3,
  0xffb9811a, 0xffb9808e, 0x00000002, 0xffffff93,
  0xffb80120, 0xffb80091, 0x00000002, 0xffffff90,
  0xffb70124, 0xffb70093, 0x00000002, 0xffffff8e,
  0xffb68126, 0xffb68094, 0x00000002, 0xffffff8d,
  0xffb68126, 0xffb68094, 0x00000002, 0xffffff8d,
  0xffb70124, 0xffb70093, 0x00000002, 0xffffff8e,
  0xffb80120, 0xffb80091, 0x00000002, 0xffffff90,
  0xfff80020, 0xfff80011, 0x00000002, 0x00000010,
  0xfff68026, 0xfff68014, 0x00000002, 0x0000000d,
  0xfff5802a, 0xfff58016, 0x00000002, 0x0000000b,
  0xfff5002c, 0xfff50017, 0x00000002, 0x0000000a,
  0xfff5002c, 0xfff50017, 0x00000002, 0x0000000a,
  0xfff5802a, 0xfff58016, 0x00000002, 0x0000000b,
  0xfff68026, 0xfff68014, 0x00000002, 0x0000000d,
  0xfffe8006, 0xfffe8004, 0x00000002, 0x0000001d,
  0xfffe8006, 0xfffe8004, 0x00000002, 0x0000001d,
  0xfffd800a, 0xfffd8006, 0x00000002, 0x0000001b,
  0xfffd000c, 0xfffd0007, 0x00000002, 0x0000001a,
  0xfffd000c, 0xfffd0007, 0x00000002, 0x0000001a,
  0xfffd800a, 0xfffd8006, 0x00000002, 0x0000001b,
  0xfffe8006, 0xfffe8004, 0x00000002, 0x0000001d,
  0x00067fe6, 0x00067ff4, 0x00000002, 0x0000002d,
  0x0044feec, 0x0044ff77, 0x00000002, 0x000000aa,
  0xffff0004, 0xffff0003, 0x00000002, 0x0000001e,
  0xfffe8006, 0xfffe8004, 0x00000002, 0x0000001d,
  0xfffe8006, 0xfffe8004, 0x00000002, 0x0000001d,
  0xffff0004, 0xffff0003, 0x00000002, 0x0000001e,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0007ffe0, 0x0007fff1, 0x00000002, 0x00000030,
  0x00467ee6, 0x00467f74, 0x00000002, 0x000000ad,
  0x00857dea, 0x00857ef6, 0x00000002, 0x0000012b,
  0xffff8002, 0xffff8002, 0x00000002, 0x0000001f,
  0xffff8002, 0xffff8002, 0x00000002, 0x0000001f,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000fffc, 0x0000ffff, 0x00000002, 0x00000022,
  0x0008ffdc, 0x0008ffef, 0x00000002, 0x00000032,
  0x00477ee2, 0x00477f72, 0x00000002, 0x000000af,
  0x00867de6, 0x00867ef4, 0x00000002, 0x0000012d,
  0x00c5fce8, 0x00c5fe75, 0x00000002, 0x000001ac,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00007ffe, 0x00008000, 0x00000002, 0x00000021,
  0x00017ffa, 0x00017ffe, 0x00000002, 0x00000023,
  0x00097fda, 0x00097fee, 0x00000002, 0x00000033,
  0x0047fee0, 0x0047ff71, 0x00000002, 0x000000b0,
  0x0086fde4, 0x0086fef3, 0x00000002, 0x0000012e,
  0x00c67ce6, 0x00c67e74, 0x00000002, 0x000001ad,
  0x1a5f9680, 0x1a5fcb41, 0x00000002, 0x000034e0,
  0x00007ffe, 0x00008000, 0x00000002, 0x00000021,
  0x00017ffa, 0x00017ffe, 0x00000002, 0x00000023,
  0x00097fda, 0x00097fee, 0x00000002, 0x00000033,
  0x0047fee0, 0x0047ff71, 0x00000002, 0x000000b0,
  0x0086fde4, 0x0086fef3, 0x00000002, 0x0000012e,
  0x00c67ce6, 0x00c67e74, 0x00000002, 0x000001ad,
  0x1a5f9680, 0x1a5fcb41, 0x00000002, 0x000034e0,
  0x45096bd6, 0x4509f5ec, 0x00000002, 0x00008a35,
  0x0000fffc, 0x0000ffff, 0x00000002, 0x00000022,
  0x0008ffdc, 0x0008ffef, 0x00000002, 0x00000032,
  0x00477ee2, 0x00477f72, 0x00000002, 0x000000af,
  0x00867de6, 0x00867ef4, 0x00000002, 0x0000012d,
  0x00c5fce8, 0x00c5fe75, 0x00000002, 0x000001ac,
  0x1a5f1682, 0x1a5f4b42, 0x00000002, 0x000034df,
  0x4508ebd8, 0x450975ed, 0x00000002, 0x00008a34,
  0x85066bde, 0x850775f0, 0x00000002, 0x00010a31,
  0x0007ffe0, 0x0007fff1, 0x00000002, 0x00000030,
  0x00467ee6, 0x00467f74, 0x00000002, 0x000000ad,
  0x00857dea, 0x00857ef6, 0x00000002, 0x0000012b,
  0x00c4fcec, 0x00c4fe77, 0x00000002, 0x000001aa,
  0x1a5e1686, 0x1a5e4b44, 0x00000002, 0x000034dd,
  0x4507ebdc, 0x450875ef, 0x00000002, 0x00008a32,
  0x85056be2, 0x850675f2, 0x00000002, 0x00010a2f,
  0xc5036be6, 0xc504f5f4, 0x00000002, 0x00018a2d,
  0x003e7f06, 0x003e7f84, 0x00000002, 0x0000009d,
  0x007d7e0a, 0x007d7f06, 0x00000002, 0x0000011b,
  0x00bcfd0c, 0x00bcfe87, 0x00000002, 0x0000019a,
  0x1a5616a6, 0x1a564b54, 0x00000002, 0x000034cd,
  0x44ffebfc, 0x450075ff, 0x00000002, 0x00008a22,
  0x84fd6c02, 0x84fe7602, 0x00000002, 0x00010a1f,
  0xc4fb6c06, 0xc4fcf604, 0x00000002, 0x00018a1d,
  0x04f9ec08, 0x04fbf605, 0x00000002, 0x00020a1c,
  0x003eff04, 0x003eff83, 0x00000002, 0x0000009e,
  0x007e7e06, 0x007e7f04, 0x00000002, 0x0000011d,
  0x1a1797a0, 0x1a17cbd1, 0x00000002, 0x00003450,
  0x44c16cf6, 0x44c1f67c, 0x00000002, 0x000089a5,
  0x84beecfc, 0x84bff67f, 0x00000002, 0x000109a2,
  0xc4bced00, 0xc4be7681, 0x00000002, 0x000189a0,
  0x04bb6d02, 0x04bd7682, 0x00000002, 0x0002099f,
  0xc4bc6d02, 0xc4bdf682, 0x00000002, 0x0001899f,
  0x003f7f02, 0x003f7f82, 0x00000002, 0x0000009f,
  0x19d8989c, 0x19d8cc4f, 0x00000002, 0x000033d2,
  0x44826df2, 0x4482f6fa, 0x00000002, 0x00008927,
  0x847fedf8, 0x8480f6fd, 0x00000002, 0x00010924,
  0xc47dedfc, 0xc47f76ff, 0x00000002, 0x00018922,
  0x047c6dfe, 0x047e7700, 0x00000002, 0x00020921,
  0xc47d6dfe, 0xc47ef700, 0x00000002, 0x00018921,
  0x847eedfc, 0x847ff6ff, 0x00000002, 0x00010922,
  0x1999199a, 0x19994cce, 0x00000002, 0x00003353,
  0x4442eef0, 0x44437779, 0x00000002, 0x000088a8,
  0x84406ef6, 0x8441777c, 0x00000002, 0x000108a5,
  0xc43e6efa, 0xc43ff77e, 0x00000002, 0x000188a3,
  0x043ceefc, 0x043ef77f, 0x00000002, 0x000208a2,
  0xc43deefc, 0xc43f777f, 0x00000002, 0x000188a2,
  0x843f6efa, 0x8440777e, 0x00000002, 0x000108a3,
  0x599519a6, 0x5995ccd4, 0x00000002, 0x0000b34d,
  0x2aa9d556, 0x2aaa2aac, 0x00000002, 0x00005575,
  0x6aa7555c, 0x6aa82aaf, 0x00000002, 0x0000d572,
  0xaaa55560, 0xaaa6aab1, 0x00000002, 0x00015570,
  0xeaa3d562, 0xeaa5aab2, 0x00000002, 0x0001d56f,
  0xaaa4d562, 0xaaa62ab2, 0x00000002, 0x0001556f,
  0x6aa65560, 0x6aa72ab1, 0x00000002, 0x0000d570,
  0x3ffc000c, 0x3ffc8007, 0x00000002, 0x0000801a,
  0x26626674, 0x2662b33b, 0x00000002, 0x00004ce6,
  0x3ffd8006, 0x3ffe0004, 0x00000002, 0x0000801d,
  0x7ffb800a, 0x7ffc8006, 0x00000002, 0x0001001b,
  0xbffa000c, 0xbffb8007, 0x00000002, 0x0001801a,
  0x7ffb000c, 0x7ffc0007, 0x00000002, 0x0001001a,
  0x3ffc800a, 0x3ffd0006, 0x00000002, 0x0000801b,
  0x15522ab6, 0x1552555c, 0x00000002, 0x00002ac5,
  0xfbb8911e, 0xfbb88890, 0x00000002, 0xfffff791,
  0xfb78921e, 0xfb788910, 0x00000002, 0xfffff711,
  0x3ffe0004, 0x3ffe8003, 0x00000002, 0x0000801e,
  0x7ffc8006, 0x7ffd8004, 0x00000002, 0x0001001d,
  0x3ffd8006, 0x3ffe0004, 0x00000002, 0x0000801d,
  0xffff0004, 0xffff0003, 0x00000002, 0x0000001e,
  0xd554aab0, 0xd5545559, 0x00000002, 0xffffaac8,
  0xbbbb1118, 0xbbba888d, 0x00000002, 0xffff7794,
  0xbb7b1218, 0xbb7a890d, 0x00000002, 0xffff7714,
  0xbb3b9316, 0xbb3b098c, 0x00000002, 0xffff7695,
  0x3ffe8002, 0x3fff0002, 0x00000002, 0x0000801f,
  0xffff8002, 0xffff8002, 0x00000002, 0x0000001f,
  0xc0010000, 0xc0008001, 0x00000002, 0xffff8020,
  0x9556aaac, 0x9555d557, 0x00000002, 0xffff2aca,
  0x7bbd1114, 0x7bbc088b, 0x00000002, 0xfffef796,
  0x7b7d1214, 0x7b7c090b, 0x00000002, 0xfffef716,
  0x7b3d9312, 0x7b3c898a, 0x00000002, 0xfffef697,
  0x7afe940e, 0x7afd8a08, 0x00000002, 0xfffef619,
  0xc0010000, 0xc0008001, 0x00000002, 0xffff8020,
  0x80027ffe, 0x80018000, 0x00000002, 0xffff0021,
  0x55582aaa, 0x5556d556, 0x00000002, 0xfffeaacb,
  0x3bbe9112, 0x3bbd088a, 0x00000002, 0xfffe7797,
  0x3b7e9212, 0x3b7d090a, 0x00000002, 0xfffe7717,
  0x3b3f1310, 0x3b3d8989, 0x00000002, 0xfffe7698,
  0x3b00140c, 0x3afe8a07, 0x00000002, 0xfffe761a,
  0x3ac19506, 0x3ac00a84, 0x00000002, 0xfffe759d,
  0xc0017ffe, 0xc0010000, 0x00000002, 0xffff8021,
  0x95572aaa, 0x95565556, 0x00000002, 0xffff2acb,
  0x7bbd9112, 0x7bbc888a, 0x00000002, 0xfffef797,
  0x7b7d9212, 0x7b7c890a, 0x00000002, 0xfffef717,
  0x7b3e1310, 0x7b3d0989, 0x00000002, 0xfffef698,
  0x7aff140c, 0x7afe0a07, 0x00000002, 0xfffef61a,
  0x7ac09506, 0x7abf8a84, 0x00000002, 0xfffef59d,
  0x7ab89526, 0x7ab78a94, 0x00000002, 0xfffef58d,
  0xd555aaac, 0xd5555557, 0x00000002, 0xffffaaca,
  0xbbbc1114, 0xbbbb888b, 0x00000002, 0xffff7796,
  0xbb7c1214, 0xbb7b890b, 0x00000002, 0xffff7716,
  0xbb3c9312, 0xbb3c098a, 0x00000002, 0xffff7697,
  0xbafd940e, 0xbafd0a08, 0x00000002, 0xffff7619,
  0xbabf1508, 0xbabe8a85, 0x00000002, 0xffff759c,
  0xbab71528, 0xbab68a95, 0x00000002, 0xffff758c,
  0xbab5952e, 0xbab50a98, 0x00000002, 0xffff7589,
  0xe6666668, 0xe6663335, 0x00000002, 0xffffccec,
  0xe6266768, 0xe62633b5, 0x00000002, 0xffffcc6c,
  0xe5e6e866, 0xe5e6b434, 0x00000002, 0xffffcbed,
  0xe5a7e962, 0xe5a7b4b2, 0x00000002, 0xffffcb6f,
  0xe5696a5c, 0xe569352f, 0x00000002, 0xffffcaf2,
  0xe5616a7c, 0xe561353f, 0x00000002, 0xffffcae2,
  0xe55fea82, 0xe55fb542, 0x00000002, 0xffffcadf,
  0xe55eea86, 0xe55eb544, 0x00000002, 0xffffcadd,
  0xffc00100, 0xffc00081, 0x00000002, 0xffffffa0,
  0xff8081fe, 0xff808100, 0x00000002, 0xffffff21,
  0xff4182fa, 0xff41817e, 0x00000002, 0xfffffea3,
  0xff0303f4, 0xff0301fb, 0x00000002, 0xfffffe26,
  0xfefb0414, 0xfefb020b, 0x00000002, 0xfffffe16,
  0xfef9841a, 0xfef9820e, 0x00000002, 0xfffffe13,
  0xfef8841e, 0xfef88210, 0x00000002, 0xfffffe11,
  0xfef80420, 0xfef80211, 0x00000002, 0xfffffe10,
  0xffc0807f, 0x00000001, 0xffffff83, 0xffffff22,
  0xff8180fd, 0x00000001, 0xffffff05, 0xfffffe26,
  0xff43017a, 0x00000001, 0xfffffe88, 0xfffffd2c,
  0xff3b018a, 0x00000001, 0xfffffe78, 0xfffffd0c,
  0xff39818d, 0x00000001, 0xfffffe75, 0xfffffd06,
  0xff38818f, 0x00000001, 0xfffffe73, 0xfffffd02,
  0xff380190, 0x00000001, 0xfffffe72, 0xfffffd00,
  0xff380190, 0x00000001, 0xfffffe72, 0xfffffd00,
  0xffc1007e, 0x00000001, 0xffffff84, 0xffffff24,
  0xff8280fb, 0x00000001, 0xffffff07, 0xfffffe2a,
  0xff7a810b, 0x00000001, 0xfffffef7, 0xfffffe0a,
  0xff79010e, 0x00000001, 0xfffffef4, 0xfffffe04,
  0xff780110, 0x00000001, 0xfffffef2, 0xfffffe00,
  0xff778111, 0x00000001, 0xfffffef1, 0xfffffdfe,
  0xff778111, 0x00000001, 0xfffffef1, 0xfffffdfe,
  0xff780110, 0x00000001, 0xfffffef2, 0xfffffe00,
  0xffc1807d, 0x00000001, 0xffffff85, 0xffffff26,
  0xffb9808d, 0x00000001, 0xffffff75, 0xffffff06,
  0xffb80090, 0x00000001, 0xffffff72, 0xffffff00,
  0xffb70092, 0x00000001, 0xffffff70, 0xfffffefc,
  0xffb68093, 0x00000001, 0xffffff6f, 0xfffffefa,
  0xffb68093, 0x00000001, 0xffffff6f, 0xfffffefa,
  0xffb70092, 0x00000001, 0xffffff70, 0xfffffefc,
  0xffb80090, 0x00000001, 0xffffff72, 0xffffff00,
  0xfff80010, 0x00000001, 0xfffffff2, 0x00000000,
  0xfff68013, 0x00000001, 0xffffffef, 0xfffffffa,
  0xfff58015, 0x00000001, 0xffffffed, 0xfffffff6,
  0xfff50016, 0x00000001, 0xffffffec, 0xfffffff4,
  0xfff50016, 0x00000001, 0xffffffec, 0xfffffff4,
  0xfff58015, 0x00000001, 0xffffffed, 0xfffffff6,
  0xfff68013, 0x00000001, 0xffffffef, 0xfffffffa,
  0xfffe8003, 0x00000001, 0xffffffff, 0x0000001a,
  0xfffe8003, 0x00000001, 0xffffffff, 0x0000001a,
  0xfffd8005, 0x00000001, 0xfffffffd, 0x00000016,
  0xfffd0006, 0x00000001, 0xfffffffc, 0x00000014,
  0xfffd0006, 0x00000001, 0xfffffffc, 0x00000014,
  0xfffd8005, 0x00000001, 0xfffffffd, 0x00000016,
  0xfffe8003, 0x00000001, 0xffffffff, 0x0000001a,
  0x00067ff3, 0x00000001, 0x0000000f, 0x0000003a,
  0x0044ff76, 0x00000001, 0x0000008c, 0x00000134,
  0xffff0002, 0x00000001, 0x00000000, 0x0000001c,
  0xfffe8003, 0x00000001, 0xffffffff, 0x0000001a,
  0xfffe8003, 0x00000001, 0xffffffff, 0x0000001a,
  0xffff0002, 0x00000001, 0x00000000, 0x0000001c,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0007fff0, 0x00000001, 0x00000012, 0x00000040,
  0x00467f73, 0x00000001, 0x0000008f, 0x0000013a,
  0x00857ef5, 0x00000001, 0x0000010d, 0x00000236,
  0xffff8001, 0x00000001, 0x00000001, 0x0000001e,
  0xffff8001, 0x00000001, 0x00000001, 0x0000001e,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000fffe, 0x00000001, 0x00000004, 0x00000024,
  0x0008ffee, 0x00000001, 0x00000014, 0x00000044,
  0x00477f71, 0x00000001, 0x00000091, 0x0000013e,
  0x00867ef3, 0x00000001, 0x0000010f, 0x0000023a,
  0x00c5fe74, 0x00000001, 0x0000018e, 0x00000338,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00007fff, 0x00000001, 0x00000003, 0x00000022,
  0x00017ffd, 0x00000001, 0x00000005, 0x00000026,
  0x00097fed, 0x00000001, 0x00000015, 0x00000046,
  0x0047ff70, 0x00000001, 0x00000092, 0x00000140,
  0x0086fef2, 0x00000001, 0x00000110, 0x0000023c,
  0x00c67e73, 0x00000001, 0x0000018f, 0x0000033a,
  0x1a5fcb40, 0x00000001, 0x000034c2, 0x000069a0,
  0x00007fff, 0x00000001, 0x00000003, 0x00000022,
  0x00017ffd, 0x00000001, 0x00000005, 0x00000026,
  0x00097fed, 0x00000001, 0x00000015, 0x00000046,
  0x0047ff70, 0x00000001, 0x00000092, 0x00000140,
  0x0086fef2, 0x00000001, 0x00000110, 0x0000023c,
  0x00c67e73, 0x00000001, 0x0000018f, 0x0000033a,
  0x1a5fcb40, 0x00000001, 0x000034c2, 0x000069a0,
  0x4509f5eb, 0x00000001, 0x00008a17, 0x0001144a,
  0x0000fffe, 0x00000001, 0x00000004, 0x00000024,
  0x0008ffee, 0x00000001, 0x00000014, 0x00000044,
  0x00477f71, 0x00000001, 0x00000091, 0x0000013e,
  0x00867ef3, 0x00000001, 0x0000010f, 0x0000023a,
  0x00c5fe74, 0x00000001, 0x0000018e, 0x00000338,
  0x1a5f4b41, 0x00000001, 0x000034c1, 0x0000699e,
  0x450975ec, 0x00000001, 0x00008a16, 0x00011448,
  0x850775ef, 0x00000001, 0x00010a13, 0x00021442,
  0x0007fff0, 0x00000001, 0x00000012, 0x00000040,
  0x00467f73, 0x00000001, 0x0000008f, 0x0000013a,
  0x00857ef5, 0x00000001, 0x0000010d, 0x00000236,
  0x00c4fe76, 0x00000001, 0x0000018c, 0x00000334,
  0x1a5e4b43, 0x00000001, 0x000034bf, 0x0000699a,
  0x450875ee, 0x00000001, 0x00008a14, 0x00011444,
  0x850675f1, 0x00000001, 0x00010a11, 0x0002143e,
  0xc504f5f3, 0x00000001, 0x00018a0f, 0x0003143a,
  0x003e7f83, 0x00000001, 0x0000007f, 0x0000011a,
  0x007d7f05, 0x00000001, 0x000000fd, 0x00000216,
  0x00bcfe86, 0x00000001, 0x0000017c, 0x00000314,
  0x1a564b53, 0x00000001, 0x000034af, 0x0000697a,
  0x450075fe, 0x00000001, 0x00008a04, 0x00011424,
  0x84fe7601, 0x00000001, 0x00010a01, 0x0002141e,
  0xc4fcf603, 0x00000001, 0x000189ff, 0x0003141a,
  0x04fbf604, 0x00000001, 0x000209fe, 0x00041418,
  0x003eff82, 0x00000001, 0x00000080, 0x0000011c,
  0x007e7f03, 0x00000001, 0x000000ff, 0x0000021a,
  0x1a17cbd0, 0x00000001, 0x00003432, 0x00006880,
  0x44c1f67b, 0x00000001, 0x00008987, 0x0001132a,
  0x84bff67e, 0x00000001, 0x00010984, 0x00021324,
  0xc4be7680, 0x00000001, 0x00018982, 0x00031320,
  0x04bd7681, 0x00000001, 0x00020981, 0x0004131e,
  0xc4bdf681, 0x00000001, 0x00018981, 0x0003131e,
  0x003f7f81, 0x00000001, 0x00000081, 0x0000011e,
  0x19d8cc4e, 0x00000001, 0x000033b4, 0x00006784,
  0x4482f6f9, 0x00000001, 0x00008909, 0x0001122e,
  0x8480f6fc, 0x00000001, 0x00010906, 0x00021228,
  0xc47f76fe, 0x00000001, 0x00018904, 0x00031224,
  0x047e76ff, 0x00000001, 0x00020903, 0x00041222,
  0xc47ef6ff, 0x00000001, 0x00018903, 0x00031222,
  0x847ff6fe, 0x00000001, 0x00010904, 0x00021224,
  0x19994ccd, 0x00000001, 0x00003335, 0x00006686,
  0x44437778, 0x00000001, 0x0000888a, 0x00011130,
  0x8441777b, 0x00000001, 0x00010887, 0x0002112a,
  0xc43ff77d, 0x00000001, 0x00018885, 0x00031126,
  0x043ef77e, 0x00000001, 0x00020884, 0x00041124,
  0xc43f777e, 0x00000001, 0x00018884, 0x00031124,
  0x8440777d, 0x00000001, 0x00010885, 0x00021126,
  0x5995ccd3, 0x00000001, 0x0000b32f, 0x0001667a,
  0x2aaa2aab, 0x00000001, 0x00005557, 0x0000aaca,
  0x6aa82aae, 0x00000001, 0x0000d554, 0x0001aac4,
  0xaaa6aab0, 0x00000001, 0x00015552, 0x0002aac0,
  0xeaa5aab1, 0x00000001, 0x0001d551, 0x0003aabe,
  0xaaa62ab1, 0x00000001, 0x00015551, 0x0002aabe,
  0x6aa72ab0, 0x00000001, 0x0000d552, 0x0001aac0,
  0x3ffc8006, 0x00000001, 0x00007ffc, 0x00010014,
  0x2662b33a, 0x00000001, 0x00004cc8, 0x000099ac,
  0x3ffe0003, 0x00000001, 0x00007fff, 0x0001001a,
  0x7ffc8005, 0x00000001, 0x0000fffd, 0x00020016,
  0xbffb8006, 0x00000001, 0x00017ffc, 0x00030014,
  0x7ffc0006, 0x00000001, 0x0000fffc, 0x00020014,
  0x3ffd0005, 0x00000001, 0x00007ffd, 0x00010016,
  0x1552555b, 0x00000001, 0x00002aa7, 0x0000556a,
  0xfbb8888f, 0x00000001, 0xfffff773, 0xffffef02,
  0xfb78890f, 0x00000001, 0xfffff6f3, 0xffffee02,
  0x3ffe8002, 0x00000001, 0x00008000, 0x0001001c,
  0x7ffd8003, 0x00000001, 0x0000ffff, 0x0002001a,
  0x3ffe0003, 0x00000001, 0x00007fff, 0x0001001a,
  0xffff0002, 0x00000001, 0x00000000, 0x0000001c,
  0xd5545558, 0x00000001, 0xffffaaaa, 0xffff5570,
  0xbbba888c, 0x00000001, 0xffff7776, 0xfffeef08,
  0xbb7a890c, 0x00000001, 0xffff76f6, 0xfffeee08,
  0xbb3b098b, 0x00000001, 0xffff7677, 0xfffeed0a,
  0x3fff0001, 0x00000001, 0x00008001, 0x0001001e,
  0xffff8001, 0x00000001, 0x00000001, 0x0000001e,
  0xc0008000, 0x00000001, 0xffff8002, 0xffff0020,
  0x9555d556, 0x00000001, 0xffff2aac, 0xfffe5574,
  0x7bbc088a, 0x00000001, 0xfffef778, 0xfffdef0c,
  0x7b7c090a, 0x00000001, 0xfffef6f8, 0xfffdee0c,
  0x7b3c8989, 0x00000001, 0xfffef679, 0xfffded0e,
  0x7afd8a07, 0x00000001, 0xfffef5fb, 0xfffdec12,
  0xc0008000, 0x00000001, 0xffff8002, 0xffff0020,
  0x80017fff, 0x00000001, 0xffff0003, 0xfffe0022,
  0x5556d555, 0x00000001, 0xfffeaaad, 0xfffd5576,
  0x3bbd0889, 0x00000001, 0xfffe7779, 0xfffcef0e,
  0x3b7d0909, 0x00000001, 0xfffe76f9, 0xfffcee0e,
  0x3b3d8988, 0x00000001, 0xfffe767a, 0xfffced10,
  0x3afe8a06, 0x00000001, 0xfffe75fc, 0xfffcec14,
  0x3ac00a83, 0x00000001, 0xfffe757f, 0xfffceb1a,
  0xc000ffff, 0x00000001, 0xffff8003, 0xffff0022,
  0x95565555, 0x00000001, 0xffff2aad, 0xfffe5576,
  0x7bbc8889, 0x00000001, 0xfffef779, 0xfffdef0e,
  0x7b7c8909, 0x00000001, 0xfffef6f9, 0xfffdee0e,
  0x7b3d0988, 0x00000001, 0xfffef67a, 0xfffded10,
  0x7afe0a06, 0x00000001, 0xfffef5fc, 0xfffdec14,
  0x7abf8a83, 0x00000001, 0xfffef57f, 0xfffdeb1a,
  0x7ab78a93, 0x00000001, 0xfffef56f, 0xfffdeafa,
  0xd5555556, 0x00000001, 0xffffaaac, 0xffff5574,
  0xbbbb888a, 0x00000001, 0xffff7778, 0xfffeef0c,
  0xbb7b890a, 0x00000001, 0xffff76f8, 0xfffeee0c,
  0xbb3c0989, 0x00000001, 0xffff7679, 0xfffeed0e,
  0xbafd0a07, 0x00000001, 0xffff75fb, 0xfffeec12,
  0xbabe8a84, 0x00000001, 0xffff757e, 0xfffeeb18,
  0xbab68a94, 0x00000001, 0xffff756e, 0xfffeeaf8,
  0xbab50a97, 0x00000001, 0xffff756b, 0xfffeeaf2,
  0xe6663334, 0x00000001, 0xffffccce, 0xffff99b8,
  0xe62633b4, 0x00000001, 0xffffcc4e, 0xffff98b8,
  0xe5e6b433, 0x00000001, 0xffffcbcf, 0xffff97ba,
  0xe5a7b4b1, 0x00000001, 0xffffcb51, 0xffff96be,
  0xe569352e, 0x00000001, 0xffffcad4, 0xffff95c4,
  0xe561353e, 0x00000001, 0xffffcac4, 0xffff95a4,
  0xe55fb541, 0x00000001, 0xffffcac1, 0xffff959e,
  0xe55eb543, 0x00000001, 0xffffcabf, 0xffff959a,
  0xffc00080, 0x00000001, 0xffffff82, 0xffffff20,
  0xff8080ff, 0x00000001, 0xffffff03, 0xfffffe22,
  0xff41817d, 0x00000001, 0xfffffe85, 0xfffffd26,
  0xff0301fa, 0x00000001, 0xfffffe08, 0xfffffc2c,
  0xfefb020a, 0x00000001, 0xfffffdf8, 0xfffffc0c,
  0xfef9820d, 0x00000001, 0xfffffdf5, 0xfffffc06,
  0xfef8820f, 0x00000001, 0xfffffdf3, 0xfffffc02,
  0xfef80210, 0x00000001, 0xfffffdf2, 0xfffffc00,
  0x00000000, 0xffffff82, 0xffffff04, 0xfffff830,
  0x00000000, 0xffffff04, 0xfffffe08, 0xfffff050,
  0x00000000, 0xfffffe87, 0xfffffd0e, 0xffffe880,
  0x00000000, 0xfffffe77, 0xfffffcee, 0xffffe780,
  0x00000000, 0xfffffe74, 0xfffffce8, 0xffffe750,
  0x00000000, 0xfffffe72, 0xfffffce4, 0xffffe730,
  0x00000000, 0xfffffe71, 0xfffffce2, 0xffffe720,
  0x00000000, 0xfffffe71, 0xfffffce2, 0xffffe720,
  0x00000000, 0xffffff83, 0xffffff06, 0xfffff840,
  0x00000000, 0xffffff06, 0xfffffe0c, 0xfffff070,
  0x00000000, 0xfffffef6, 0xfffffdec, 0xffffef70,
  0x00000000, 0xfffffef3, 0xfffffde6, 0xffffef40,
  0x00000000, 0xfffffef1, 0xfffffde2, 0xffffef20,
  0x00000000, 0xfffffef0, 0xfffffde0, 0xffffef10,
  0x00000000, 0xfffffef0, 0xfffffde0, 0xffffef10,
  0x00000000, 0xfffffef1, 0xfffffde2, 0xffffef20,
  0x00000000, 0xffffff84, 0xffffff08, 0xfffff850,
  0x00000000, 0xffffff74, 0xfffffee8, 0xfffff750,
  0x00000000, 0xffffff71, 0xfffffee2, 0xfffff720,
  0x00000000, 0xffffff6f, 0xfffffede, 0xfffff700,
  0x00000000, 0xffffff6e, 0xfffffedc, 0xfffff6f0,
  0x00000000, 0xffffff6e, 0xfffffedc, 0xfffff6f0,
  0x00000000, 0xffffff6f, 0xfffffede, 0xfffff700,
  0x00000000, 0xffffff71, 0xfffffee2, 0xfffff720,
  0x00000000, 0xfffffff1, 0xffffffe2, 0xffffff20,
  0x00000000, 0xffffffee, 0xffffffdc, 0xfffffef0,
  0x00000000, 0xffffffec, 0xffffffd8, 0xfffffed0,
  0x00000000, 0xffffffeb, 0xffffffd6, 0xfffffec0,
  0x00000000, 0xffffffeb, 0xffffffd6, 0xfffffec0,
  0x00000000, 0xffffffec, 0xffffffd8, 0xfffffed0,
  0x00000000, 0xffffffee, 0xffffffdc, 0xfffffef0,
  0x00000000, 0xfffffffe, 0xfffffffc, 0xfffffff0,
  0x00000000, 0xfffffffe, 0xfffffffc, 0xfffffff0,
  0x00000000, 0xfffffffc, 0xfffffff8, 0xffffffd0,
  0x00000000, 0xfffffffb, 0xfffffff6, 0xffffffc0,
  0x00000000, 0xfffffffb, 0xfffffff6, 0xffffffc0,
  0x00000000, 0xfffffffc, 0xfffffff8, 0xffffffd0,
  0x00000000, 0xfffffffe, 0xfffffffc, 0xfffffff0,
  0x00000000, 0x0000000e, 0x0000001c, 0x000000f0,
  0x00000000, 0x0000008b, 0x00000116, 0x000008c0,
  0x00000000, 0xffffffff, 0xfffffffe, 0x00000000,
  0x00000000, 0xfffffffe, 0xfffffffc, 0xfffffff0,
  0x00000000, 0xfffffffe, 0xfffffffc, 0xfffffff0,
  0x00000000, 0xffffffff, 0xfffffffe, 0x00000000,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000011, 0x00000022, 0x00000120,
  0x00000000, 0x0000008e, 0x0000011c, 0x000008f0,
  0x00000000, 0x0000010c, 0x00000218, 0x000010d0,
  0x00000000, 0x00000000, 0x00000000, 0x00000010,
  0x00000000, 0x00000000, 0x00000000, 0x00000010,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000003, 0x00000006, 0x00000040,
  0x00000000, 0x00000013, 0x00000026, 0x00000140,
  0x00000000, 0x00000090, 0x00000120, 0x00000910,
  0x00000000, 0x0000010e, 0x0000021c, 0x000010f0,
  0x00000000, 0x0000018d, 0x0000031a, 0x000018e0,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000002, 0x00000004, 0x00000030,
  0x00000000, 0x00000004, 0x00000008, 0x00000050,
  0x00000000, 0x00000014, 0x00000028, 0x00000150,
  0x00000000, 0x00000091, 0x00000122, 0x00000920,
  0x00000000, 0x0000010f, 0x0000021e, 0x00001100,
  0x00000000, 0x0000018e, 0x0000031c, 0x000018f0,
  0x00000000, 0x000034c1, 0x00006982, 0x00034c20,
  0x00000000, 0x00000002, 0x00000004, 0x00000030,
  0x00000000, 0x00000004, 0x00000008, 0x00000050,
  0x00000000, 0x00000014, 0x00000028, 0x00000150,
  0x00000000, 0x00000091, 0x00000122, 0x00000920,
  0x00000000, 0x0000010f, 0x0000021e, 0x00001100,
  0x00000000, 0x0000018e, 0x0000031c, 0x000018f0,
  0x00000000, 0x000034c1, 0x00006982, 0x00034c20,
  0x00000000, 0x00008a16, 0x0001142c, 0x0008a170,
  0x00000000, 0x00000003, 0x00000006, 0x00000040,
  0x00000000, 0x00000013, 0x00000026, 0x00000140,
  0x00000000, 0x00000090, 0x00000120, 0x00000910,
  0x00000000, 0x0000010e, 0x0000021c, 0x000010f0,
  0x00000000, 0x0000018d, 0x0000031a, 0x000018e0,
  0x00000000, 0x000034c0, 0x00006980, 0x00034c10,
  0x00000000, 0x00008a15, 0x0001142a, 0x0008a160,
  0x00000000, 0x00010a12, 0x00021424, 0x0010a130,
  0x00000000, 0x00000011, 0x00000022, 0x00000120,
  0x00000000, 0x0000008e, 0x0000011c, 0x000008f0,
  0x00000000, 0x0000010c, 0x00000218, 0x000010d0,
  0x00000000, 0x0000018b, 0x00000316, 0x000018c0,
  0x00000000, 0x000034be, 0x0000697c, 0x00034bf0,
  0x00000000, 0x00008a13, 0x00011426, 0x0008a140,
  0x00000000, 0x00010a10, 0x00021420, 0x0010a110,
  0x00000000, 0x00018a0e, 0x0003141c, 0x0018a0f0,
  0x00000000, 0x0000007e, 0x000000fc, 0x000007f0,
  0x00000000, 0x000000fc, 0x000001f8, 0x00000fd0,
  0x00000000, 0x0000017b, 0x000002f6, 0x000017c0,
  0x00000000, 0x000034ae, 0x0000695c, 0x00034af0,
  0x00000000, 0x00008a03, 0x00011406, 0x0008a040,
  0x00000000, 0x00010a00, 0x00021400, 0x0010a010,
  0x00000000, 0x000189fe, 0x000313fc, 0x00189ff0,
  0x00000000, 0x000209fd, 0x000413fa, 0x00209fe0,
  0x00000000, 0x0000007f, 0x000000fe, 0x00000800,
  0x00000000, 0x000000fe, 0x000001fc, 0x00000ff0,
  0x00000000, 0x00003431, 0x00006862, 0x00034320,
  0x00000000, 0x00008986, 0x0001130c, 0x00089870,
  0x00000000, 0x00010983, 0x00021306, 0x00109840,
  0x00000000, 0x00018981, 0x00031302, 0x00189820,
  0x00000000, 0x00020980, 0x00041300, 0x00209810,
  0x00000000, 0x00018980, 0x00031300, 0x00189810,
  0x00000000, 0x00000080, 0x00000100, 0x00000810,
  0x00000000, 0x000033b3, 0x00006766, 0x00033b40,
  0x00000000, 0x00008908, 0x00011210, 0x00089090,
  0x00000000, 0x00010905, 0x0002120a, 0x00109060,
  0x00000000, 0x00018903, 0x00031206, 0x00189040,
  0x00000000, 0x00020902, 0x00041204, 0x00209030,
  0x00000000, 0x00018902, 0x00031204, 0x00189030,
  0x00000000, 0x00010903, 0x00021206, 0x00109040,
  0x00000000, 0x00003334, 0x00006668, 0x00033350,
  0x00000000, 0x00008889, 0x00011112, 0x000888a0,
  0x00000000, 0x00010886, 0x0002110c, 0x00108870,
  0x00000000, 0x00018884, 0x00031108, 0x00188850,
  0x00000000, 0x00020883, 0x00041106, 0x00208840,
  0x00000000, 0x00018883, 0x00031106, 0x00188840,
  0x00000000, 0x00010884, 0x00021108, 0x00108850,
  0x00000000, 0x0000b32e, 0x0001665c, 0x000b32f0,
  0x00000000, 0x00005556, 0x0000aaac, 0x00055570,
  0x00000000, 0x0000d553, 0x0001aaa6, 0x000d5540,
  0x00000000, 0x00015551, 0x0002aaa2, 0x00155520,
  0x00000000, 0x0001d550, 0x0003aaa0, 0x001d5510,
  0x00000000, 0x00015550, 0x0002aaa0, 0x00155510,
  0x00000000, 0x0000d551, 0x0001aaa2, 0x000d5520,
  0x00000000, 0x00007ffb, 0x0000fff6, 0x0007ffc0,
  0x00000000, 0x00004cc7, 0x0000998e, 0x0004cc80,
  0x00000000, 0x00007ffe, 0x0000fffc, 0x0007fff0,
  0x00000000, 0x0000fffc, 0x0001fff8, 0x000fffd0,
  0x00000000, 0x00017ffb, 0x0002fff6, 0x0017ffc0,
  0x00000000, 0x0000fffb, 0x0001fff6, 0x000fffc0,
  0x00000000, 0x00007ffc, 0x0000fff8, 0x0007ffd0,
  0x00000000, 0x00002aa6, 0x0000554c, 0x0002aa70,
  0x00000000, 0xfffff772, 0xffffeee4, 0xffff7730,
  0x00000000, 0xfffff6f2, 0xffffede4, 0xffff6f30,
  0x00000000, 0x00007fff, 0x0000fffe, 0x00080000,
  0x00000000, 0x0000fffe, 0x0001fffc, 0x000ffff0,
  0x00000000, 0x00007ffe, 0x0000fffc, 0x0007fff0,
  0x00000000, 0xffffffff, 0xfffffffe, 0x00000000,
  0x00000000, 0xffffaaa9, 0xffff5552, 0xfffaaaa0,
  0x00000000, 0xffff7775, 0xfffeeeea, 0xfff77760,
  0x00000000, 0xffff76f5, 0xfffeedea, 0xfff76f60,
  0x00000000, 0xffff7676, 0xfffeecec, 0xfff76770,
  0x00000000, 0x00008000, 0x00010000, 0x00080010,
  0x00000000, 0x00000000, 0x00000000, 0x00000010,
  0x00000000, 0xffff8001, 0xffff0002, 0xfff80020,
  0x00000000, 0xffff2aab, 0xfffe5556, 0xfff2aac0,
  0x00000000, 0xfffef777, 0xfffdeeee, 0xffef7780,
  0x00000000, 0xfffef6f7, 0xfffdedee, 0xffef6f80,
  0x00000000, 0xfffef678, 0xfffdecf0, 0xffef6790,
  0x00000000, 0xfffef5fa, 0xfffdebf4, 0xffef5fb0,
  0x00000000, 0xffff8001, 0xffff0002, 0xfff80020,
  0x00000000, 0xffff0002, 0xfffe0004, 0xfff00030,
  0x00000000, 0xfffeaaac, 0xfffd5558, 0xffeaaad0,
  0x00000000, 0xfffe7778, 0xfffceef0, 0xffe77790,
  0x00000000, 0xfffe76f8, 0xfffcedf0, 0xffe76f90,
  0x00000000, 0xfffe7679, 0xfffcecf2, 0xffe767a0,
  0x00000000, 0xfffe75fb, 0xfffcebf6, 0xffe75fc0,
  0x00000000, 0xfffe757e, 0xfffceafc, 0xffe757f0,
  0x00000000, 0xffff8002, 0xffff0004, 0xfff80030,
  0x00000000, 0xffff2aac, 0xfffe5558, 0xfff2aad0,
  0x00000000, 0xfffef778, 0xfffdeef0, 0xffef7790,
  0x00000000, 0xfffef6f8, 0xfffdedf0, 0xffef6f90,
  0x00000000, 0xfffef679, 0xfffdecf2, 0xffef67a0,
  0x00000000, 0xfffef5fb, 0xfffdebf6, 0xffef5fc0,
  0x00000000, 0xfffef57e, 0xfffdeafc, 0xffef57f0,
  0x00000000, 0xfffef56e, 0xfffdeadc, 0xffef56f0,
  0x00000000, 0xffffaaab, 0xffff5556, 0xfffaaac0,
  0x00000000, 0xffff7777, 0xfffeeeee, 0xfff77780,
  0x00000000, 0xffff76f7, 0xfffeedee, 0xfff76f80,
  0x00000000, 0xffff7678, 0xfffeecf0, 0xfff76790,
  0x00000000, 0xffff75fa, 0xfffeebf4, 0xfff75fb0,
  0x00000000, 0xffff757d, 0xfffeeafa, 0xfff757e0,
  0x00000000, 0xffff756d, 0xfffeeada, 0xfff756e0,
  0x00000000, 0xffff756a, 0xfffeead4, 0xfff756b0,
  0x00000000, 0xffffcccd, 0xffff999a, 0xfffccce0,
  0x00000000, 0xffffcc4d, 0xffff989a, 0xfffcc4e0,
  0x00000000, 0xffffcbce, 0xffff979c, 0xfffcbcf0,
  0x00000000, 0xffffcb50, 0xffff96a0, 0xfffcb510,
  0x00000000, 0xffffcad3, 0xffff95a6, 0xfffcad40,
  0x00000000, 0xffffcac3, 0xffff9586, 0xfffcac40,
  0x00000000, 0xffffcac0, 0xffff9580, 0xfffcac10,
  0x00000000, 0xffffcabe, 0xffff957c, 0xfffcabf0,
  0x00000000, 0xffffff81, 0xffffff02, 0xfffff820,
  0x00000000, 0xffffff02, 0xfffffe04, 0xfffff030,
  0x00000000, 0xfffffe84, 0xfffffd08, 0xffffe850,
  0x00000000, 0xfffffe07, 0xfffffc0e, 0xffffe080,
  0x00000000, 0xfffffdf7, 0xfffffbee, 0xffffdf80,
  0x00000000, 0xfffffdf4, 0xfffffbe8, 0xffffdf50,
  0x00000000, 0xfffffdf2, 0xfffffbe4, 0xffffdf30,
  0x00000000, 0xfffffdf1, 0xfffffbe2, 0xffffdf20,
  0xffffff81, 0xffffff03, 0xfffff812, 0xffffc21d,
  0xffffff03, 0xfffffe07, 0xfffff032, 0xffff8497,
  0xfffffe86, 0xfffffd0d, 0xffffe862, 0xffff478e,
  0xfffffe76, 0xfffffced, 0xffffe762, 0xffff3fbe,
  0xfffffe73, 0xfffffce7, 0xffffe732, 0xffff3e47,
  0xfffffe71, 0xfffffce3, 0xffffe712, 0xffff3d4d,
  0xfffffe70, 0xfffffce1, 0xffffe702, 0xffff3cd0,
  0xfffffe70, 0xfffffce1, 0xffffe702, 0xffff3cd0,
  0xffffff82, 0xffffff05, 0xfffff822, 0xffffc29a,
  0xffffff05, 0xfffffe0b, 0xfffff052, 0xffff8591,
  0xfffffef5, 0xfffffdeb, 0xffffef52, 0xffff7dc1,
  0xfffffef2, 0xfffffde5, 0xffffef22, 0xffff7c4a,
  0xfffffef0, 0xfffffde1, 0xffffef02, 0xffff7b50,
  0xfffffeef, 0xfffffddf, 0xffffeef2, 0xffff7ad3,
  0xfffffeef, 0xfffffddf, 0xffffeef2, 0xffff7ad3,
  0xfffffef0, 0xfffffde1, 0xffffef02, 0xffff7b50,
  0xffffff83, 0xffffff07, 0xfffff832, 0xffffc317,
  0xffffff73, 0xfffffee7, 0xfffff732, 0xffffbb47,
  0xffffff70, 0xfffffee1, 0xfffff702, 0xffffb9d0,
  0xffffff6e, 0xfffffedd, 0xfffff6e2, 0xffffb8d6,
  0xffffff6d, 0xfffffedb, 0xfffff6d2, 0xffffb859,
  0xffffff6d, 0xfffffedb, 0xfffff6d2, 0xffffb859,
  0xffffff6e, 0xfffffedd, 0xfffff6e2, 0xffffb8d6,
  0xffffff70, 0xfffffee1, 0xfffff702, 0xffffb9d0,
  0xfffffff0, 0xffffffe1, 0xffffff02, 0xfffff850,
  0xffffffed, 0xffffffdb, 0xfffffed2, 0xfffff6d9,
  0xffffffeb, 0xffffffd7, 0xfffffeb2, 0xfffff5df,
  0xffffffea, 0xffffffd5, 0xfffffea2, 0xfffff562,
  0xffffffea, 0xffffffd5, 0xfffffea2, 0xfffff562,
  0xffffffeb, 0xffffffd7, 0xfffffeb2, 0xfffff5df,
  0xffffffed, 0xffffffdb, 0xfffffed2, 0xfffff6d9,
  0xfffffffd, 0xfffffffb, 0xffffffd2, 0xfffffea9,
  0xfffffffd, 0xfffffffb, 0xffffffd2, 0xfffffea9,
  0xfffffffb, 0xfffffff7, 0xffffffb2, 0xfffffdaf,
  0xfffffffa, 0xfffffff5, 0xffffffa2, 0xfffffd32,
  0xfffffffa, 0xfffffff5, 0xffffffa2, 0xfffffd32,
  0xfffffffb, 0xfffffff7, 0xffffffb2, 0xfffffdaf,
  0xfffffffd, 0xfffffffb, 0xffffffd2, 0xfffffea9,
  0x0000000d, 0x0000001b, 0x000000d2, 0x00000679,
  0x0000008a, 0x00000115, 0x000008a2, 0x00004382,
  0xfffffffe, 0xfffffffd, 0xffffffe2, 0xffffff26,
  0xfffffffd, 0xfffffffb, 0xffffffd2, 0xfffffea9,
  0xfffffffd, 0xfffffffb, 0xffffffd2, 0xfffffea9,
  0xfffffffe, 0xfffffffd, 0xffffffe2, 0xffffff26,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000010, 0x00000021, 0x00000102, 0x000007f0,
  0x0000008d, 0x0000011b, 0x000008d2, 0x000044f9,
  0x0000010b, 0x00000217, 0x000010b2, 0x0000827f,
  0xffffffff, 0xffffffff, 0xfffffff2, 0xffffffa3,
  0xffffffff, 0xffffffff, 0xfffffff2, 0xffffffa3,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000002, 0x00000005, 0x00000022, 0x0000011a,
  0x00000012, 0x00000025, 0x00000122, 0x000008ea,
  0x0000008f, 0x0000011f, 0x000008f2, 0x000045f3,
  0x0000010d, 0x0000021b, 0x000010d2, 0x00008379,
  0x0000018c, 0x00000319, 0x000018c2, 0x0000c17c,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000003, 0x00000012, 0x0000009d,
  0x00000003, 0x00000007, 0x00000032, 0x00000197,
  0x00000013, 0x00000027, 0x00000132, 0x00000967,
  0x00000090, 0x00000121, 0x00000902, 0x00004670,
  0x0000010e, 0x0000021d, 0x000010e2, 0x000083f6,
  0x0000018d, 0x0000031b, 0x000018d2, 0x0000c1f9,
  0x000034c0, 0x00006981, 0x00034c02, 0x0019c1e0,
  0x00000001, 0x00000003, 0x00000012, 0x0000009d,
  0x00000003, 0x00000007, 0x00000032, 0x00000197,
  0x00000013, 0x00000027, 0x00000132, 0x00000967,
  0x00000090, 0x00000121, 0x00000902, 0x00004670,
  0x0000010e, 0x0000021d, 0x000010e2, 0x000083f6,
  0x0000018d, 0x0000031b, 0x000018d2, 0x0000c1f9,
  0x000034c0, 0x00006981, 0x00034c02, 0x0019c1e0,
  0x00008a15, 0x0001142b, 0x0008a152, 0x00436c61,
  0x00000002, 0x00000005, 0x00000022, 0x0000011a,
  0x00000012, 0x00000025, 0x00000122, 0x000008ea,
  0x0000008f, 0x0000011f, 0x000008f2, 0x000045f3,
  0x0000010d, 0x0000021b, 0x000010d2, 0x00008379,
  0x0000018c, 0x00000319, 0x000018c2, 0x0000c17c,
  0x000034bf, 0x0000697f, 0x00034bf2, 0x0019c163,
  0x00008a14, 0x00011429, 0x0008a142, 0x00436be4,
  0x00010a11, 0x00021423, 0x0010a112, 0x0081ea6d,
  0x00000010, 0x00000021, 0x00000102, 0x000007f0,
  0x0000008d, 0x0000011b, 0x000008d2, 0x000044f9,
  0x0000010b, 0x00000217, 0x000010b2, 0x0000827f,
  0x0000018a, 0x00000315, 0x000018a2, 0x0000c082,
  0x000034bd, 0x0000697b, 0x00034bd2, 0x0019c069,
  0x00008a12, 0x00011425, 0x0008a122, 0x00436aea,
  0x00010a0f, 0x0002141f, 0x0010a0f2, 0x0081e973,
  0x00018a0d, 0x0003141b, 0x0018a0d2, 0x00c06879,
  0x0000007d, 0x000000fb, 0x000007d2, 0x00003d29,
  0x000000fb, 0x000001f7, 0x00000fb2, 0x00007aaf,
  0x0000017a, 0x000002f5, 0x000017a2, 0x0000b8b2,
  0x000034ad, 0x0000695b, 0x00034ad2, 0x0019b899,
  0x00008a02, 0x00011405, 0x0008a022, 0x0043631a,
  0x000109ff, 0x000213ff, 0x00109ff2, 0x0081e1a3,
  0x000189fd, 0x000313fb, 0x00189fd2, 0x00c060a9,
  0x000209fc, 0x000413f9, 0x00209fc2, 0x00fee02c,
  0x0000007e, 0x000000fd, 0x000007e2, 0x00003da6,
  0x000000fd, 0x000001fb, 0x00000fd2, 0x00007ba9,
  0x00003430, 0x00006861, 0x00034302, 0x00197b90,
  0x00008985, 0x0001130b, 0x00089852, 0x00432611,
  0x00010982, 0x00021305, 0x00109822, 0x0081a49a,
  0x00018980, 0x00031301, 0x00189802, 0x00c023a0,
  0x0002097f, 0x000412ff, 0x002097f2, 0x00fea323,
  0x0001897f, 0x000312ff, 0x001897f2, 0x00c02323,
  0x0000007f, 0x000000ff, 0x000007f2, 0x00003e23,
  0x000033b2, 0x00006765, 0x00033b22, 0x00193e0a,
  0x00008907, 0x0001120f, 0x00089072, 0x0042e88b,
  0x00010904, 0x00021209, 0x00109042, 0x00816714,
  0x00018902, 0x00031205, 0x00189022, 0x00bfe61a,
  0x00020901, 0x00041203, 0x00209012, 0x00fe659d,
  0x00018901, 0x00031203, 0x00189012, 0x00bfe59d,
  0x00010902, 0x00021205, 0x00109022, 0x0081661a,
  0x00003333, 0x00006667, 0x00033332, 0x00190007,
  0x00008888, 0x00011111, 0x00088882, 0x0042aa88,
  0x00010885, 0x0002110b, 0x00108852, 0x00812911,
  0x00018883, 0x00031107, 0x00188832, 0x00bfa817,
  0x00020882, 0x00041105, 0x00208822, 0x00fe279a,
  0x00018882, 0x00031105, 0x00188822, 0x00bfa79a,
  0x00010883, 0x00021107, 0x00108832, 0x00812817,
  0x0000b32d, 0x0001665b, 0x000b32d2, 0x00577d19,
  0x00005555, 0x0000aaab, 0x00055552, 0x0029aaa1,
  0x0000d552, 0x0001aaa5, 0x000d5522, 0x0068292a,
  0x00015550, 0x0002aaa1, 0x00155502, 0x00a6a830,
  0x0001d54f, 0x0003aa9f, 0x001d54f2, 0x00e527b3,
  0x0001554f, 0x0002aa9f, 0x001554f2, 0x00a6a7b3,
  0x0000d550, 0x0001aaa1, 0x000d5502, 0x00682830,
  0x00007ffa, 0x0000fff5, 0x0007ffa2, 0x003e7d32,
  0x00004cc6, 0x0000998d, 0x0004cc62, 0x00257cce,
  0x00007ffd, 0x0000fffb, 0x0007ffd2, 0x003e7ea9,
  0x0000fffb, 0x0001fff7, 0x000fffb2, 0x007cfdaf,
  0x00017ffa, 0x0002fff5, 0x0017ffa2, 0x00bb7d32,
  0x0000fffa, 0x0001fff5, 0x000fffa2, 0x007cfd32,
  0x00007ffb, 0x0000fff7, 0x0007ffb2, 0x003e7daf,
  0x00002aa5, 0x0000554b, 0x0002aa52, 0x0014d2b1,
  0xfffff771, 0xffffeee3, 0xffff7712, 0xfffbd24d,
  0xfffff6f1, 0xffffede3, 0xffff6f12, 0xfffb93cd,
  0x00007ffe, 0x0000fffd, 0x0007ffe2, 0x003e7f26,
  0x0000fffd, 0x0001fffb, 0x000fffd2, 0x007cfea9,
  0x00007ffd, 0x0000fffb, 0x0007ffd2, 0x003e7ea9,
  0xfffffffe, 0xfffffffd, 0xffffffe2, 0xffffff26,
  0xffffaaa8, 0xffff5551, 0xfffaaa82, 0xffd65428,
  0xffff7774, 0xfffeeee9, 0xfff77742, 0xffbd53c4,
  0xffff76f4, 0xfffeede9, 0xfff76f42, 0xffbd1544,
  0xffff7675, 0xfffeeceb, 0xfff76752, 0xffbcd741,
  0x00007fff, 0x0000ffff, 0x0007fff2, 0x003e7fa3,
  0xffffffff, 0xffffffff, 0xfffffff2, 0xffffffa3,
  0xffff8000, 0xffff0001, 0xfff80002, 0xffc18020,
  0xffff2aaa, 0xfffe5555, 0xfff2aaa2, 0xff97d522,
  0xfffef776, 0xfffdeeed, 0xffef7762, 0xff7ed4be,
  0xfffef6f6, 0xfffdeded, 0xffef6f62, 0xff7e963e,
  0xfffef677, 0xfffdecef, 0xffef6772, 0xff7e583b,
  0xfffef5f9, 0xfffdebf3, 0xffef5f92, 0xff7e1ab5,
  0xffff8000, 0xffff0001, 0xfff80002, 0xffc18020,
  0xffff0001, 0xfffe0003, 0xfff00012, 0xff83009d,
  0xfffeaaab, 0xfffd5557, 0xffeaaab2, 0xff59559f,
  0xfffe7777, 0xfffceeef, 0xffe77772, 0xff40553b,
  0xfffe76f7, 0xfffcedef, 0xffe76f72, 0xff4016bb,
  0xfffe7678, 0xfffcecf1, 0xffe76782, 0xff3fd8b8,
  0xfffe75fa, 0xfffcebf5, 0xffe75fa2, 0xff3f9b32,
  0xfffe757d, 0xfffceafb, 0xffe757d2, 0xff3f5e29,
  0xffff8001, 0xffff0003, 0xfff80012, 0xffc1809d,
  0xffff2aab, 0xfffe5557, 0xfff2aab2, 0xff97d59f,
  0xfffef777, 0xfffdeeef, 0xffef7772, 0xff7ed53b,
  0xfffef6f7, 0xfffdedef, 0xffef6f72, 0xff7e96bb,
  0xfffef678, 0xfffdecf1, 0xffef6782, 0xff7e58b8,
  0xfffef5fa, 0xfffdebf5, 0xffef5fa2, 0xff7e1b32,
  0xfffef57d, 0xfffdeafb, 0xffef57d2, 0xff7dde29,
  0xfffef56d, 0xfffdeadb, 0xffef56d2, 0xff7dd659,
  0xffffaaaa, 0xffff5555, 0xfffaaaa2, 0xffd65522,
  0xffff7776, 0xfffeeeed, 0xfff77762, 0xffbd54be,
  0xffff76f6, 0xfffeeded, 0xfff76f62, 0xffbd163e,
  0xffff7677, 0xfffeecef, 0xfff76772, 0xffbcd83b,
  0xffff75f9, 0xfffeebf3, 0xfff75f92, 0xffbc9ab5,
  0xffff757c, 0xfffeeaf9, 0xfff757c2, 0xffbc5dac,
  0xffff756c, 0xfffeead9, 0xfff756c2, 0xffbc55dc,
  0xffff7569, 0xfffeead3, 0xfff75692, 0xffbc5465,
  0xffffcccc, 0xffff9999, 0xfffcccc2, 0xffe6ffbc,
  0xffffcc4c, 0xffff9899, 0xfffcc4c2, 0xffe6c13c,
  0xffffcbcd, 0xffff979b, 0xfffcbcd2, 0xffe68339,
  0xffffcb4f, 0xffff969f, 0xfffcb4f2, 0xffe645b3,
  0xffffcad2, 0xffff95a5, 0xfffcad22, 0xffe608aa,
  0xffffcac2, 0xffff9585, 0xfffcac22, 0xffe600da,
  0xffffcabf, 0xffff957f, 0xfffcabf2, 0xffe5ff63,
  0xffffcabd, 0xffff957b, 0xfffcabd2, 0xffe5fe69,
  0xffffff80, 0xffffff01, 0xfffff802, 0xffffc1a0,
  0xffffff01, 0xfffffe03, 0xfffff012, 0xffff839d,
  0xfffffe83, 0xfffffd07, 0xffffe832, 0xffff4617,
  0xfffffe06, 0xfffffc0d, 0xffffe062, 0xffff090e,
  0xfffffdf6, 0xfffffbed, 0xffffdf62, 0xffff013e,
  0xfffffdf3, 0xfffffbe7, 0xffffdf32, 0xfffeffc7,
  0xfffffdf1, 0xfffffbe3, 0xffffdf12, 0xfffefecd,
  0xfffffdf0, 0xfffffbe1, 0xffffdf02, 0xfffefe50,
  0xffffff02, 0xfffff811, 0xffffc1ff, 0xffffc19e,
  0xfffffe06, 0xfffff031, 0xffff8479, 0xffff839a,
  0xfffffd0c, 0xffffe861, 0xffff4770, 0xffff4614,
  0xfffffcec, 0xffffe761, 0xffff3fa0, 0xffff3e34,
  0xfffffce6, 0xffffe731, 0xffff3e29, 0xffff3cba,
  0xfffffce2, 0xffffe711, 0xffff3d2f, 0xffff3bbe,
  0xfffffce0, 0xffffe701, 0xffff3cb2, 0xffff3b40,
  0xfffffce0, 0xffffe701, 0xffff3cb2, 0xffff3b40,
  0xffffff04, 0xfffff821, 0xffffc27c, 0xffffc21c,
  0xfffffe0a, 0xfffff051, 0xffff8573, 0xffff8496,
  0xfffffdea, 0xffffef51, 0xffff7da3, 0xffff7cb6,
  0xfffffde4, 0xffffef21, 0xffff7c2c, 0xffff7b3c,
  0xfffffde0, 0xffffef01, 0xffff7b32, 0xffff7a40,
  0xfffffdde, 0xffffeef1, 0xffff7ab5, 0xffff79c2,
  0xfffffdde, 0xffffeef1, 0xffff7ab5, 0xffff79c2,
  0xfffffde0, 0xffffef01, 0xffff7b32, 0xffff7a40,
  0xffffff06, 0xfffff831, 0xffffc2f9, 0xffffc29a,
  0xfffffee6, 0xfffff731, 0xffffbb29, 0xffffbaba,
  0xfffffee0, 0xfffff701, 0xffffb9b2, 0xffffb940,
  0xfffffedc, 0xfffff6e1, 0xffffb8b8, 0xffffb844,
  0xfffffeda, 0xfffff6d1, 0xffffb83b, 0xffffb7c6,
  0xfffffeda, 0xfffff6d1, 0xffffb83b, 0xffffb7c6,
  0xfffffedc, 0xfffff6e1, 0xffffb8b8, 0xffffb844,
  0xfffffee0, 0xfffff701, 0xffffb9b2, 0xffffb940,
  0xffffffe0, 0xffffff01, 0xfffff832, 0xfffff840,
  0xffffffda, 0xfffffed1, 0xfffff6bb, 0xfffff6c6,
  0xffffffd6, 0xfffffeb1, 0xfffff5c1, 0xfffff5ca,
  0xffffffd4, 0xfffffea1, 0xfffff544, 0xfffff54c,
  0xffffffd4, 0xfffffea1, 0xfffff544, 0xfffff54c,
  0xffffffd6, 0xfffffeb1, 0xfffff5c1, 0xfffff5ca,
  0xffffffda, 0xfffffed1, 0xfffff6bb, 0xfffff6c6,
  0xfffffffa, 0xffffffd1, 0xfffffe8b, 0xfffffea6,
  0xfffffffa, 0xffffffd1, 0xfffffe8b, 0xfffffea6,
  0xfffffff6, 0xffffffb1, 0xfffffd91, 0xfffffdaa,
  0xfffffff4, 0xffffffa1, 0xfffffd14, 0xfffffd2c,
  0xfffffff4, 0xffffffa1, 0xfffffd14, 0xfffffd2c,
  0xfffffff6, 0xffffffb1, 0xfffffd91, 0xfffffdaa,
  0xfffffffa, 0xffffffd1, 0xfffffe8b, 0xfffffea6,
  0x0000001a, 0x000000d1, 0x0000065b, 0x00000686,
  0x00000114, 0x000008a1, 0x00004364, 0x0000440c,
  0xfffffffc, 0xffffffe1, 0xffffff08, 0xffffff24,
  0xfffffffa, 0xffffffd1, 0xfffffe8b, 0xfffffea6,
  0xfffffffa, 0xffffffd1, 0xfffffe8b, 0xfffffea6,
  0xfffffffc, 0xffffffe1, 0xffffff08, 0xffffff24,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000020, 0x00000101, 0x000007d2, 0x00000800,
  0x0000011a, 0x000008d1, 0x000044db, 0x00004586,
  0x00000216, 0x000010b1, 0x00008261, 0x0000838a,
  0xfffffffe, 0xfffffff1, 0xffffff85, 0xffffffa2,
  0xfffffffe, 0xfffffff1, 0xffffff85, 0xffffffa2,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000004, 0x00000021, 0x000000fc, 0x0000011c,
  0x00000024, 0x00000121, 0x000008cc, 0x000008fc,
  0x0000011e, 0x000008f1, 0x000045d5, 0x00004682,
  0x0000021a, 0x000010d1, 0x0000835b, 0x00008486,
  0x00000318, 0x000018c1, 0x0000c15e, 0x0000c308,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000002, 0x00000011, 0x0000007f, 0x0000009e,
  0x00000006, 0x00000031, 0x00000179, 0x0000019a,
  0x00000026, 0x00000131, 0x00000949, 0x0000097a,
  0x00000120, 0x00000901, 0x00004652, 0x00004700,
  0x0000021c, 0x000010e1, 0x000083d8, 0x00008504,
  0x0000031a, 0x000018d1, 0x0000c1db, 0x0000c386,
  0x00006980, 0x00034c01, 0x0019c1c2, 0x0019f6a0,
  0x00000002, 0x00000011, 0x0000007f, 0x0000009e,
  0x00000006, 0x00000031, 0x00000179, 0x0000019a,
  0x00000026, 0x00000131, 0x00000949, 0x0000097a,
  0x00000120, 0x00000901, 0x00004652, 0x00004700,
  0x0000021c, 0x000010e1, 0x000083d8, 0x00008504,
  0x0000031a, 0x000018d1, 0x0000c1db, 0x0000c386,
  0x00006980, 0x00034c01, 0x0019c1c2, 0x0019f6a0,
  0x0001142a, 0x0008a151, 0x00436c43, 0x0043f676,
  0x00000004, 0x00000021, 0x000000fc, 0x0000011c,
  0x00000024, 0x00000121, 0x000008cc, 0x000008fc,
  0x0000011e, 0x000008f1, 0x000045d5, 0x00004682,
  0x0000021a, 0x000010d1, 0x0000835b, 0x00008486,
  0x00000318, 0x000018c1, 0x0000c15e, 0x0000c308,
  0x0000697e, 0x00034bf1, 0x0019c145, 0x0019f622,
  0x00011428, 0x0008a141, 0x00436bc6, 0x0043f5f8,
  0x00021422, 0x0010a111, 0x0081ea4f, 0x0082f47e,
  0x00000020, 0x00000101, 0x000007d2, 0x00000800,
  0x0000011a, 0x000008d1, 0x000044db, 0x00004586,
  0x00000216, 0x000010b1, 0x00008261, 0x0000838a,
  0x00000314, 0x000018a1, 0x0000c064, 0x0000c20c,
  0x0000697a, 0x00034bd1, 0x0019c04b, 0x0019f526,
  0x00011424, 0x0008a121, 0x00436acc, 0x0043f4fc,
  0x0002141e, 0x0010a0f1, 0x0081e955, 0x0082f382,
  0x0003141a, 0x0018a0d1, 0x00c0685b, 0x00c1f286,
  0x000000fa, 0x000007d1, 0x00003d0b, 0x00003da6,
  0x000001f6, 0x00000fb1, 0x00007a91, 0x00007baa,
  0x000002f4, 0x000017a1, 0x0000b894, 0x0000ba2c,
  0x0000695a, 0x00034ad1, 0x0019b87b, 0x0019ed46,
  0x00011404, 0x0008a021, 0x004362fc, 0x0043ed1c,
  0x000213fe, 0x00109ff1, 0x0081e185, 0x0082eba2,
  0x000313fa, 0x00189fd1, 0x00c0608b, 0x00c1eaa6,
  0x000413f8, 0x00209fc1, 0x00fee00e, 0x0100ea28,
  0x000000fc, 0x000007e1, 0x00003d88, 0x00003e24,
  0x000001fa, 0x00000fd1, 0x00007b8b, 0x00007ca6,
  0x00006860, 0x00034301, 0x00197b72, 0x0019afc0,
  0x0001130a, 0x00089851, 0x004325f3, 0x0043af96,
  0x00021304, 0x00109821, 0x0081a47c, 0x0082ae1c,
  0x00031300, 0x00189801, 0x00c02382, 0x00c1ad20,
  0x000412fe, 0x002097f1, 0x00fea305, 0x0100aca2,
  0x000312fe, 0x001897f1, 0x00c02305, 0x00c1aca2,
  0x000000fe, 0x000007f1, 0x00003e05, 0x00003ea2,
  0x00006764, 0x00033b21, 0x00193dec, 0x001971bc,
  0x0001120e, 0x00089071, 0x0042e86d, 0x00437192,
  0x00021208, 0x00109041, 0x008166f6, 0x00827018,
  0x00031204, 0x00189021, 0x00bfe5fc, 0x00c16f1c,
  0x00041202, 0x00209011, 0x00fe657f, 0x01006e9e,
  0x00031202, 0x00189011, 0x00bfe57f, 0x00c16e9e,
  0x00021204, 0x00109021, 0x008165fc, 0x00826f1c,
  0x00006666, 0x00033331, 0x0018ffe9, 0x0019333a,
  0x00011110, 0x00088881, 0x0042aa6a, 0x00433310,
  0x0002110a, 0x00108851, 0x008128f3, 0x00823196,
  0x00031106, 0x00188831, 0x00bfa7f9, 0x00c1309a,
  0x00041104, 0x00208821, 0x00fe277c, 0x0100301c,
  0x00031104, 0x00188821, 0x00bfa77c, 0x00c1301c,
  0x00021106, 0x00108831, 0x008127f9, 0x0082309a,
  0x0001665a, 0x000b32d1, 0x00577cfb, 0x00583046,
  0x0000aaaa, 0x00055551, 0x0029aa83, 0x0029fff6,
  0x0001aaa4, 0x000d5521, 0x0068290c, 0x0068fe7c,
  0x0002aaa0, 0x00155501, 0x00a6a812, 0x00a7fd80,
  0x0003aa9e, 0x001d54f1, 0x00e52795, 0x00e6fd02,
  0x0002aa9e, 0x001554f1, 0x00a6a795, 0x00a7fd02,
  0x0001aaa0, 0x000d5501, 0x00682812, 0x0068fd80,
  0x0000fff4, 0x0007ffa1, 0x003e7d14, 0x003efd2c,
  0x0000998c, 0x0004cc61, 0x00257cb0, 0x0025c994,
  0x0000fffa, 0x0007ffd1, 0x003e7e8b, 0x003efea6,
  0x0001fff6, 0x000fffb1, 0x007cfd91, 0x007dfdaa,
  0x0002fff4, 0x0017ffa1, 0x00bb7d14, 0x00bcfd2c,
  0x0001fff4, 0x000fffa1, 0x007cfd14, 0x007dfd2c,
  0x0000fff6, 0x0007ffb1, 0x003e7d91, 0x003efdaa,
  0x0000554a, 0x0002aa51, 0x0014d293, 0x0014fd56,
  0xffffeee2, 0xffff7711, 0xfffbd22f, 0xfffbc9be,
  0xffffede2, 0xffff6f11, 0xfffb93af, 0xfffb8abe,
  0x0000fffc, 0x0007ffe1, 0x003e7f08, 0x003eff24,
  0x0001fffa, 0x000fffd1, 0x007cfe8b, 0x007dfea6,
  0x0000fffa, 0x0007ffd1, 0x003e7e8b, 0x003efea6,
  0xfffffffc, 0xffffffe1, 0xffffff08, 0xffffff24,
  0xffff5550, 0xfffaaa81, 0xffd6540a, 0xffd5fed0,
  0xfffeeee8, 0xfff77741, 0xffbd53a6, 0xffbccb38,
  0xfffeede8, 0xfff76f41, 0xffbd1526, 0xffbc8c38,
  0xfffeecea, 0xfff76751, 0xffbcd723, 0xffbc4db6,
  0x0000fffe, 0x0007fff1, 0x003e7f85, 0x003effa2,
  0xfffffffe, 0xfffffff1, 0xffffff85, 0xffffffa2,
  0xffff0000, 0xfff80001, 0xffc18002, 0xffc10020,
  0xfffe5554, 0xfff2aaa1, 0xff97d504, 0xff96ffcc,
  0xfffdeeec, 0xffef7761, 0xff7ed4a0, 0xff7dcc34,
  0xfffdedec, 0xffef6f61, 0xff7e9620, 0xff7d8d34,
  0xfffdecee, 0xffef6771, 0xff7e581d, 0xff7d4eb2,
  0xfffdebf2, 0xffef5f91, 0xff7e1a97, 0xff7d10ae,
  0xffff0000, 0xfff80001, 0xffc18002, 0xffc10020,
  0xfffe0002, 0xfff00011, 0xff83007f, 0xff82009e,
  0xfffd5556, 0xffeaaab1, 0xff595581, 0xff58004a,
  0xfffceeee, 0xffe77771, 0xff40551d, 0xff3eccb2,
  0xfffcedee, 0xffe76f71, 0xff40169d, 0xff3e8db2,
  0xfffcecf0, 0xffe76781, 0xff3fd89a, 0xff3e4f30,
  0xfffcebf4, 0xffe75fa1, 0xff3f9b14, 0xff3e112c,
  0xfffceafa, 0xffe757d1, 0xff3f5e0b, 0xff3dd3a6,
  0xffff0002, 0xfff80011, 0xffc1807f, 0xffc1009e,
  0xfffe5556, 0xfff2aab1, 0xff97d581, 0xff97004a,
  0xfffdeeee, 0xffef7771, 0xff7ed51d, 0xff7dccb2,
  0xfffdedee, 0xffef6f71, 0xff7e969d, 0xff7d8db2,
  0xfffdecf0, 0xffef6781, 0xff7e589a, 0xff7d4f30,
  0xfffdebf4, 0xffef5fa1, 0xff7e1b14, 0xff7d112c,
  0xfffdeafa, 0xffef57d1, 0xff7dde0b, 0xff7cd3a6,
  0xfffdeada, 0xffef56d1, 0xff7dd63b, 0xff7ccbc6,
  0xffff5554, 0xfffaaaa1, 0xffd65504, 0xffd5ffcc,
  0xfffeeeec, 0xfff77761, 0xffbd54a0, 0xffbccc34,
  0xfffeedec, 0xfff76f61, 0xffbd1620, 0xffbc8d34,
  0xfffeecee, 0xfff76771, 0xffbcd81d, 0xffbc4eb2,
  0xfffeebf2, 0xfff75f91, 0xffbc9a97, 0xffbc10ae,
  0xfffeeaf8, 0xfff757c1, 0xffbc5d8e, 0xffbbd328,
  0xfffeead8, 0xfff756c1, 0xffbc55be, 0xffbbcb48,
  0xfffeead2, 0xfff75691, 0xffbc5447, 0xffbbc9ce,
  0xffff9998, 0xfffcccc1, 0xffe6ff9e, 0xffe6cc88,
  0xffff9898, 0xfffcc4c1, 0xffe6c11e, 0xffe68d88,
  0xffff979a, 0xfffcbcd1, 0xffe6831b, 0xffe64f06,
  0xffff969e, 0xfffcb4f1, 0xffe64595, 0xffe61102,
  0xffff95a4, 0xfffcad21, 0xffe6088c, 0xffe5d37c,
  0xffff9584, 0xfffcac21, 0xffe600bc, 0xffe5cb9c,
  0xffff957e, 0xfffcabf1, 0xffe5ff45, 0xffe5ca22,
  0xffff957a, 0xfffcabd1, 0xffe5fe4b, 0xffe5c926,
  0xffffff00, 0xfffff801, 0xffffc182, 0xffffc120,
  0xfffffe02, 0xfffff011, 0xffff837f, 0xffff829e,
  0xfffffd06, 0xffffe831, 0xffff45f9, 0xffff449a,
  0xfffffc0c, 0xffffe061, 0xffff08f0, 0xffff0714,
  0xfffffbec, 0xffffdf61, 0xffff0120, 0xfffeff34,
  0xfffffbe6, 0xffffdf31, 0xfffeffa9, 0xfffefdba,
  0xfffffbe2, 0xffffdf11, 0xfffefeaf, 0xfffefcbe,
  0xfffffbe0, 0xffffdf01, 0xfffefe32, 0xfffefc40,
  0xfffff810, 0xffffc1fe, 0xffffc180, 0xffffc11f,
  0xfffff030, 0xffff8478, 0xffff837c, 0xffff829d,
  0xffffe860, 0xffff476f, 0xffff45f6, 0xffff449a,
  0xffffe760, 0xffff3f9f, 0xffff3e16, 0xffff3caa,
  0xffffe730, 0xffff3e28, 0xffff3c9c, 0xffff3b2d,
  0xffffe710, 0xffff3d2e, 0xffff3ba0, 0xffff3a2f,
  0xffffe700, 0xffff3cb1, 0xffff3b22, 0xffff39b0,
  0xffffe700, 0xffff3cb1, 0xffff3b22, 0xffff39b0,
  0xfffff820, 0xffffc27b, 0xffffc1fe, 0xffffc19e,
  0xfffff050, 0xffff8572, 0xffff8478, 0xffff839b,
  0xffffef50, 0xffff7da2, 0xffff7c98, 0xffff7bab,
  0xffffef20, 0xffff7c2b, 0xffff7b1e, 0xffff7a2e,
  0xffffef00, 0xffff7b31, 0xffff7a22, 0xffff7930,
  0xffffeef0, 0xffff7ab4, 0xffff79a4, 0xffff78b1,
  0xffffeef0, 0xffff7ab4, 0xffff79a4, 0xffff78b1,
  0xffffef00, 0xffff7b31, 0xffff7a22, 0xffff7930,
  0xfffff830, 0xffffc2f8, 0xffffc27c, 0xffffc21d,
  0xfffff730, 0xffffbb28, 0xffffba9c, 0xffffba2d,
  0xfffff700, 0xffffb9b1, 0xffffb922, 0xffffb8b0,
  0xfffff6e0, 0xffffb8b7, 0xffffb826, 0xffffb7b2,
  0xfffff6d0, 0xffffb83a, 0xffffb7a8, 0xffffb733,
  0xfffff6d0, 0xffffb83a, 0xffffb7a8, 0xffffb733,
  0xfffff6e0, 0xffffb8b7, 0xffffb826, 0xffffb7b2,
  0xfffff700, 0xffffb9b1, 0xffffb922, 0xffffb8b0,
  0xffffff00, 0xfffff831, 0xfffff822, 0xfffff830,
  0xfffffed0, 0xfffff6ba, 0xfffff6a8, 0xfffff6b3,
  0xfffffeb0, 0xfffff5c0, 0xfffff5ac, 0xfffff5b5,
  0xfffffea0, 0xfffff543, 0xfffff52e, 0xfffff536,
  0xfffffea0, 0xfffff543, 0xfffff52e, 0xfffff536,
  0xfffffeb0, 0xfffff5c0, 0xfffff5ac, 0xfffff5b5,
  0xfffffed0, 0xfffff6ba, 0xfffff6a8, 0xfffff6b3,
  0xffffffd0, 0xfffffe8a, 0xfffffe88, 0xfffffea3,
  0xffffffd0, 0xfffffe8a, 0xfffffe88, 0xfffffea3,
  0xffffffb0, 0xfffffd90, 0xfffffd8c, 0xfffffda5,
  0xffffffa0, 0xfffffd13, 0xfffffd0e, 0xfffffd26,
  0xffffffa0, 0xfffffd13, 0xfffffd0e, 0xfffffd26,
  0xffffffb0, 0xfffffd90, 0xfffffd8c, 0xfffffda5,
  0xffffffd0, 0xfffffe8a, 0xfffffe88, 0xfffffea3,
  0x000000d0, 0x0000065a, 0x00000668, 0x00000693,
  0x000008a0, 0x00004363, 0x000043ee, 0x00004496,
  0xffffffe0, 0xffffff07, 0xffffff06, 0xffffff22,
  0xffffffd0, 0xfffffe8a, 0xfffffe88, 0xfffffea3,
  0xffffffd0, 0xfffffe8a, 0xfffffe88, 0xfffffea3,
  0xffffffe0, 0xffffff07, 0xffffff06, 0xffffff22,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000100, 0x000007d1, 0x000007e2, 0x00000810,
  0x000008d0, 0x000044da, 0x00004568, 0x00004613,
  0x000010b0, 0x00008260, 0x0000836c, 0x00008495,
  0xfffffff0, 0xffffff84, 0xffffff84, 0xffffffa1,
  0xfffffff0, 0xffffff84, 0xffffff84, 0xffffffa1,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000020, 0x000000fb, 0x000000fe, 0x0000011e,
  0x00000120, 0x000008cb, 0x000008de, 0x0000090e,
  0x000008f0, 0x000045d4, 0x00004664, 0x00004711,
  0x000010d0, 0x0000835a, 0x00008468, 0x00008593,
  0x000018c0, 0x0000c15d, 0x0000c2ea, 0x0000c494,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000010, 0x0000007e, 0x00000080, 0x0000009f,
  0x00000030, 0x00000178, 0x0000017c, 0x0000019d,
  0x00000130, 0x00000948, 0x0000095c, 0x0000098d,
  0x00000900, 0x00004651, 0x000046e2, 0x00004790,
  0x000010e0, 0x000083d7, 0x000084e6, 0x00008612,
  0x000018d0, 0x0000c1da, 0x0000c368, 0x0000c513,
  0x00034c00, 0x0019c1c1, 0x0019f682, 0x001a2b60,
  0x00000010, 0x0000007e, 0x00000080, 0x0000009f,
  0x00000030, 0x00000178, 0x0000017c, 0x0000019d,
  0x00000130, 0x00000948, 0x0000095c, 0x0000098d,
  0x00000900, 0x00004651, 0x000046e2, 0x00004790,
  0x000010e0, 0x000083d7, 0x000084e6, 0x00008612,
  0x000018d0, 0x0000c1da, 0x0000c368, 0x0000c513,
  0x00034c00, 0x0019c1c1, 0x0019f682, 0x001a2b60,
  0x0008a150, 0x00436c42, 0x0043f658, 0x0044808b,
  0x00000020, 0x000000fb, 0x000000fe, 0x0000011e,
  0x00000120, 0x000008cb, 0x000008de, 0x0000090e,
  0x000008f0, 0x000045d4, 0x00004664, 0x00004711,
  0x000010d0, 0x0000835a, 0x00008468, 0x00008593,
  0x000018c0, 0x0000c15d, 0x0000c2ea, 0x0000c494,
  0x00034bf0, 0x0019c144, 0x0019f604, 0x001a2ae1,
  0x0008a140, 0x00436bc5, 0x0043f5da, 0x0044800c,
  0x0010a110, 0x0081ea4e, 0x0082f460, 0x0083fe8f,
  0x00000100, 0x000007d1, 0x000007e2, 0x00000810,
  0x000008d0, 0x000044da, 0x00004568, 0x00004613,
  0x000010b0, 0x00008260, 0x0000836c, 0x00008495,
  0x000018a0, 0x0000c063, 0x0000c1ee, 0x0000c396,
  0x00034bd0, 0x0019c04a, 0x0019f508, 0x001a29e3,
  0x0008a120, 0x00436acb, 0x0043f4de, 0x00447f0e,
  0x0010a0f0, 0x0081e954, 0x0082f364, 0x0083fd91,
  0x0018a0d0, 0x00c0685a, 0x00c1f268, 0x00c37c93,
  0x000007d0, 0x00003d0a, 0x00003d88, 0x00003e23,
  0x00000fb0, 0x00007a90, 0x00007b8c, 0x00007ca5,
  0x000017a0, 0x0000b893, 0x0000ba0e, 0x0000bba6,
  0x00034ad0, 0x0019b87a, 0x0019ed28, 0x001a21f3,
  0x0008a020, 0x004362fb, 0x0043ecfe, 0x0044771e,
  0x00109ff0, 0x0081e184, 0x0082eb84, 0x0083f5a1,
  0x00189fd0, 0x00c0608a, 0x00c1ea88, 0x00c374a3,
  0x00209fc0, 0x00fee00d, 0x0100ea0a, 0x0102f424,
  0x000007e0, 0x00003d87, 0x00003e06, 0x00003ea2,
  0x00000fd0, 0x00007b8a, 0x00007c88, 0x00007da3,
  0x00034300, 0x00197b71, 0x0019afa2, 0x0019e3f0,
  0x00089850, 0x004325f2, 0x0043af78, 0x0044391b,
  0x00109820, 0x0081a47b, 0x0082adfe, 0x0083b79e,
  0x00189800, 0x00c02381, 0x00c1ad02, 0x00c336a0,
  0x002097f0, 0x00fea304, 0x0100ac84, 0x0102b621,
  0x001897f0, 0x00c02304, 0x00c1ac84, 0x00c33621,
  0x000007f0, 0x00003e04, 0x00003e84, 0x00003f21,
  0x00033b20, 0x00193deb, 0x0019719e, 0x0019a56e,
  0x00089070, 0x0042e86c, 0x00437174, 0x0043fa99,
  0x00109040, 0x008166f5, 0x00826ffa, 0x0083791c,
  0x00189020, 0x00bfe5fb, 0x00c16efe, 0x00c2f81e,
  0x00209010, 0x00fe657e, 0x01006e80, 0x0102779f,
  0x00189010, 0x00bfe57e, 0x00c16e80, 0x00c2f79f,
  0x00109020, 0x008165fb, 0x00826efe, 0x0083781e,
  0x00033330, 0x0018ffe8, 0x0019331c, 0x0019666d,
  0x00088880, 0x0042aa69, 0x004332f2, 0x0043bb98,
  0x00108850, 0x008128f2, 0x00823178, 0x00833a1b,
  0x00188830, 0x00bfa7f8, 0x00c1307c, 0x00c2b91d,
  0x00208820, 0x00fe277b, 0x01002ffe, 0x0102389e,
  0x00188820, 0x00bfa77b, 0x00c12ffe, 0x00c2b89e,
  0x00108830, 0x008127f8, 0x0082307c, 0x0083391d,
  0x000b32d0, 0x00577cfa, 0x00583028, 0x0058e373,
  0x00055550, 0x0029aa82, 0x0029ffd8, 0x002a554b,
  0x000d5520, 0x0068290b, 0x0068fe5e, 0x0069d3ce,
  0x00155500, 0x00a6a811, 0x00a7fd62, 0x00a952d0,
  0x001d54f0, 0x00e52794, 0x00e6fce4, 0x00e8d251,
  0x001554f0, 0x00a6a794, 0x00a7fce4, 0x00a95251,
  0x000d5500, 0x00682811, 0x0068fd62, 0x0069d2d0,
  0x0007ffa0, 0x003e7d13, 0x003efd0e, 0x003f7d26,
  0x0004cc60, 0x00257caf, 0x0025c976, 0x0026165a,
  0x0007ffd0, 0x003e7e8a, 0x003efe88, 0x003f7ea3,
  0x000fffb0, 0x007cfd90, 0x007dfd8c, 0x007efda5,
  0x0017ffa0, 0x00bb7d13, 0x00bcfd0e, 0x00be7d26,
  0x000fffa0, 0x007cfd13, 0x007dfd0e, 0x007efd26,
  0x0007ffb0, 0x003e7d90, 0x003efd8c, 0x003f7da5,
  0x0002aa50, 0x0014d292, 0x0014fd38, 0x001527fb,
  0xffff7710, 0xfffbd22e, 0xfffbc9a0, 0xfffbc12f,
  0xffff6f10, 0xfffb93ae, 0xfffb8aa0, 0xfffb81af,
  0x0007ffe0, 0x003e7f07, 0x003eff06, 0x003f7f22,
  0x000fffd0, 0x007cfe8a, 0x007dfe88, 0x007efea3,
  0x0007ffd0, 0x003e7e8a, 0x003efe88, 0x003f7ea3,
  0xffffffe0, 0xffffff07, 0xffffff06, 0xffffff22,
  0xfffaaa80, 0xffd65409, 0xffd5feb2, 0xffd5a978,
  0xfff77740, 0xffbd53a5, 0xffbccb1a, 0xffbc42ac,
  0xfff76f40, 0xffbd1525, 0xffbc8c1a, 0xffbc032c,
  0xfff76750, 0xffbcd722, 0xffbc4d98, 0xffbbc42b,
  0x0007fff0, 0x003e7f84, 0x003eff84, 0x003f7fa1,
  0xfffffff0, 0xffffff84, 0xffffff84, 0xffffffa1,
  0xfff80000, 0xffc18001, 0xffc10002, 0xffc08020,
  0xfff2aaa0, 0xff97d503, 0xff96ffae, 0xff962a76,
  0xffef7760, 0xff7ed49f, 0xff7dcc16, 0xff7cc3aa,
  0xffef6f60, 0xff7e961f, 0xff7d8d16, 0xff7c842a,
  0xffef6770, 0xff7e581c, 0xff7d4e94, 0xff7c4529,
  0xffef5f90, 0xff7e1a96, 0xff7d1090, 0xff7c06a7,
  0xfff80000, 0xffc18001, 0xffc10002, 0xffc08020,
  0xfff00010, 0xff83007e, 0xff820080, 0xff81009f,
  0xffeaaab0, 0xff595580, 0xff58002c, 0xff56aaf5,
  0xffe77770, 0xff40551c, 0xff3ecc94, 0xff3d4429,
  0xffe76f70, 0xff40169c, 0xff3e8d94, 0xff3d04a9,
  0xffe76780, 0xff3fd899, 0xff3e4f12, 0xff3cc5a8,
  0xffe75fa0, 0xff3f9b13, 0xff3e110e, 0xff3c8726,
  0xffe757d0, 0xff3f5e0a, 0xff3dd388, 0xff3c4923,
  0xfff80010, 0xffc1807e, 0xffc10080, 0xffc0809f,
  0xfff2aab0, 0xff97d580, 0xff97002c, 0xff962af5,
  0xffef7770, 0xff7ed51c, 0xff7dcc94, 0xff7cc429,
  0xffef6f70, 0xff7e969c, 0xff7d8d94, 0xff7c84a9,
  0xffef6780, 0xff7e5899, 0xff7d4f12, 0xff7c45a8,
  0xffef5fa0, 0xff7e1b13, 0xff7d110e, 0xff7c0726,
  0xffef57d0, 0xff7dde0a, 0xff7cd388, 0xff7bc923,
  0xffef56d0, 0xff7dd63a, 0xff7ccba8, 0xff7bc133,
  0xfffaaaa0, 0xffd65503, 0xffd5ffae, 0xffd5aa76,
  0xfff77760, 0xffbd549f, 0xffbccc16, 0xffbc43aa,
  0xfff76f60, 0xffbd161f, 0xffbc8d16, 0xffbc042a,
  0xfff76770, 0xffbcd81c, 0xffbc4e94, 0xffbbc529,
  0xfff75f90, 0xffbc9a96, 0xffbc1090, 0xffbb86a7,
  0xfff757c0, 0xffbc5d8d, 0xffbbd30a, 0xffbb48a4,
  0xfff756c0, 0xffbc55bd, 0xffbbcb2a, 0xffbb40b4,
  0xfff75690, 0xffbc5446, 0xffbbc9b0, 0xffbb3f37,
  0xfffcccc0, 0xffe6ff9d, 0xffe6cc6a, 0xffe69954,
  0xfffcc4c0, 0xffe6c11d, 0xffe68d6a, 0xffe659d4,
  0xfffcbcd0, 0xffe6831a, 0xffe64ee8, 0xffe61ad3,
  0xfffcb4f0, 0xffe64594, 0xffe610e4, 0xffe5dc51,
  0xfffcad20, 0xffe6088b, 0xffe5d35e, 0xffe59e4e,
  0xfffcac20, 0xffe600bb, 0xffe5cb7e, 0xffe5965e,
  0xfffcabf0, 0xffe5ff44, 0xffe5ca04, 0xffe594e1,
  0xfffcabd0, 0xffe5fe4a, 0xffe5c908, 0xffe593e3,
  0xfffff800, 0xffffc181, 0xffffc102, 0xffffc0a0,
  0xfffff010, 0xffff837e, 0xffff8280, 0xffff819f,
  0xffffe830, 0xffff45f8, 0xffff447c, 0xffff431d,
  0xffffe060, 0xffff08ef, 0xffff06f6, 0xffff051a,
  0xffffdf60, 0xffff011f, 0xfffeff16, 0xfffefd2a,
  0xffffdf30, 0xfffeffa8, 0xfffefd9c, 0xfffefbad,
  0xffffdf10, 0xfffefeae, 0xfffefca0, 0xfffefaaf,
  0xffffdf00, 0xfffefe31, 0xfffefc22, 0xfffefa30,
  0xffffc1fd, 0xffffc17f, 0xffffc101, 0xffe699d3,
  0xffff8477, 0xffff837b, 0xffff827f, 0xffcd66b9,
  0xffff476e, 0xffff45f5, 0xffff447c, 0xffb466d2,
  0xffff3f9e, 0xffff3e15, 0xffff3c8c, 0xffb133a2,
  0xffff3e27, 0xffff3c9b, 0xffff3b0f, 0xffb09a09,
  0xffff3d2d, 0xffff3b9f, 0xffff3a11, 0xffb033a3,
  0xffff3cb0, 0xffff3b21, 0xffff3992, 0xffb00070,
  0xffff3cb0, 0xffff3b21, 0xffff3992, 0xffb00070,
  0xffffc27a, 0xffffc1fd, 0xffffc180, 0xffe6cd06,
  0xffff8571, 0xffff8477, 0xffff837d, 0xffcdcd1f,
  0xffff7da1, 0xffff7c97, 0xffff7b8d, 0xffca99ef,
  0xffff7c2a, 0xffff7b1d, 0xffff7a10, 0xffca0056,
  0xffff7b30, 0xffff7a21, 0xffff7912, 0xffc999f0,
  0xffff7ab3, 0xffff79a3, 0xffff7893, 0xffc966bd,
  0xffff7ab3, 0xffff79a3, 0xffff7893, 0xffc966bd,
  0xffff7b30, 0xffff7a21, 0xffff7912, 0xffc999f0,
  0xffffc2f7, 0xffffc27b, 0xffffc1ff, 0xffe70039,
  0xffffbb27, 0xffffba9b, 0xffffba0f, 0xffe3cd09,
  0xffffb9b0, 0xffffb921, 0xffffb892, 0xffe33370,
  0xffffb8b6, 0xffffb825, 0xffffb794, 0xffe2cd0a,
  0xffffb839, 0xffffb7a7, 0xffffb715, 0xffe299d7,
  0xffffb839, 0xffffb7a7, 0xffffb715, 0xffe299d7,
  0xffffb8b6, 0xffffb825, 0xffffb794, 0xffe2cd0a,
  0xffffb9b0, 0xffffb921, 0xffffb892, 0xffe33370,
  0xfffff830, 0xfffff821, 0xfffff812, 0xfffcccf0,
  0xfffff6b9, 0xfffff6a7, 0xfffff695, 0xfffc3357,
  0xfffff5bf, 0xfffff5ab, 0xfffff597, 0xfffbccf1,
  0xfffff542, 0xfffff52d, 0xfffff518, 0xfffb99be,
  0xfffff542, 0xfffff52d, 0xfffff518, 0xfffb99be,
  0xfffff5bf, 0xfffff5ab, 0xfffff597, 0xfffbccf1,
  0xfffff6b9, 0xfffff6a7, 0xfffff695, 0xfffc3357,
  0xfffffe89, 0xfffffe87, 0xfffffe85, 0xffff6687,
  0xfffffe89, 0xfffffe87, 0xfffffe85, 0xffff6687,
  0xfffffd8f, 0xfffffd8b, 0xfffffd87, 0xffff0021,
  0xfffffd12, 0xfffffd0d, 0xfffffd08, 0xfffeccee,
  0xfffffd12, 0xfffffd0d, 0xfffffd08, 0xfffeccee,
  0xfffffd8f, 0xfffffd8b, 0xfffffd87, 0xffff0021,
  0xfffffe89, 0xfffffe87, 0xfffffe85, 0xffff6687,
  0x00000659, 0x00000667, 0x00000675, 0x000299b7,
  0x00004362, 0x000043ed, 0x00004478, 0x001b999e,
  0xffffff06, 0xffffff05, 0xffffff04, 0xffff99ba,
  0xfffffe89, 0xfffffe87, 0xfffffe85, 0xffff6687,
  0xfffffe89, 0xfffffe87, 0xfffffe85, 0xffff6687,
  0xffffff06, 0xffffff05, 0xffffff04, 0xffff99ba,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x000007d0, 0x000007e1, 0x000007f2, 0x00033350,
  0x000044d9, 0x00004567, 0x000045f5, 0x001c3337,
  0x0000825f, 0x0000836b, 0x00008477, 0x00356651,
  0xffffff83, 0xffffff83, 0xffffff83, 0xffffcced,
  0xffffff83, 0xffffff83, 0xffffff83, 0xffffcced,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x000000fa, 0x000000fd, 0x00000100, 0x00006686,
  0x000008ca, 0x000008dd, 0x000008f0, 0x000399b6,
  0x000045d3, 0x00004663, 0x000046f3, 0x001c999d,
  0x00008359, 0x00008467, 0x00008575, 0x0035ccb7,
  0x0000c15c, 0x0000c2e9, 0x0000c476, 0x004f3304,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000007d, 0x0000007f, 0x00000081, 0x00003353,
  0x00000177, 0x0000017b, 0x0000017f, 0x000099b9,
  0x00000947, 0x0000095b, 0x0000096f, 0x0003cce9,
  0x00004650, 0x000046e1, 0x00004772, 0x001cccd0,
  0x000083d6, 0x000084e5, 0x000085f4, 0x0035ffea,
  0x0000c1d9, 0x0000c367, 0x0000c4f5, 0x004f6637,
  0x0019c1c0, 0x0019f681, 0x001a2b42, 0x0a8cc260,
  0x0000007d, 0x0000007f, 0x00000081, 0x00003353,
  0x00000177, 0x0000017b, 0x0000017f, 0x000099b9,
  0x00000947, 0x0000095b, 0x0000096f, 0x0003cce9,
  0x00004650, 0x000046e1, 0x00004772, 0x001cccd0,
  0x000083d6, 0x000084e5, 0x000085f4, 0x0035ffea,
  0x0000c1d9, 0x0000c367, 0x0000c4f5, 0x004f6637,
  0x0019c1c0, 0x0019f681, 0x001a2b42, 0x0a8cc260,
  0x00436c41, 0x0043f657, 0x0044806d, 0x1b9db14f,
  0x000000fa, 0x000000fd, 0x00000100, 0x00006686,
  0x000008ca, 0x000008dd, 0x000008f0, 0x000399b6,
  0x000045d3, 0x00004663, 0x000046f3, 0x001c999d,
  0x00008359, 0x00008467, 0x00008575, 0x0035ccb7,
  0x0000c15c, 0x0000c2e9, 0x0000c476, 0x004f3304,
  0x0019c143, 0x0019f603, 0x001a2ac3, 0x0a8c8f2d,
  0x00436bc4, 0x0043f5d9, 0x00447fee, 0x1b9d7e1c,
  0x0081ea4d, 0x0082f45f, 0x0083fe71, 0x35366483,
  0x000007d0, 0x000007e1, 0x000007f2, 0x00033350,
  0x000044d9, 0x00004567, 0x000045f5, 0x001c3337,
  0x0000825f, 0x0000836b, 0x00008477, 0x00356651,
  0x0000c062, 0x0000c1ed, 0x0000c378, 0x004ecc9e,
  0x0019c049, 0x0019f507, 0x001a29c5, 0x0a8c28c7,
  0x00436aca, 0x0043f4dd, 0x00447ef0, 0x1b9d17b6,
  0x0081e953, 0x0082f363, 0x0083fd73, 0x3535fe1d,
  0x00c06859, 0x00c1f267, 0x00c37c75, 0x4ecf17b7,
  0x00003d09, 0x00003d87, 0x00003e05, 0x00190007,
  0x00007a8f, 0x00007b8b, 0x00007c87, 0x00323321,
  0x0000b892, 0x0000ba0d, 0x0000bb88, 0x004b996e,
  0x0019b879, 0x0019ed27, 0x001a21d5, 0x0a88f597,
  0x004362fa, 0x0043ecfd, 0x00447700, 0x1b99e486,
  0x0081e183, 0x0082eb83, 0x0083f583, 0x3532caed,
  0x00c06089, 0x00c1ea87, 0x00c37485, 0x4ecbe487,
  0x00fee00c, 0x0100ea09, 0x0102f406, 0x68653154,
  0x00003d86, 0x00003e05, 0x00003e84, 0x0019333a,
  0x00007b89, 0x00007c87, 0x00007d85, 0x00329987,
  0x00197b70, 0x0019afa1, 0x0019e3d2, 0x0a6ff5b0,
  0x004325f1, 0x0043af77, 0x004438fd, 0x1b80e49f,
  0x0081a47a, 0x0082adfd, 0x0083b780, 0x3519cb06,
  0x00c02380, 0x00c1ad01, 0x00c33682, 0x4eb2e4a0,
  0x00fea303, 0x0100ac83, 0x0102b603, 0x684c316d,
  0x00c02303, 0x00c1ac83, 0x00c33603, 0x4eb2b16d,
  0x00003e03, 0x00003e83, 0x00003f03, 0x0019666d,
  0x00193dea, 0x0019719d, 0x0019a550, 0x0a56c296,
  0x0042e86b, 0x00437173, 0x0043fa7b, 0x1b67b185,
  0x008166f4, 0x00826ff9, 0x008378fe, 0x350097ec,
  0x00bfe5fa, 0x00c16efd, 0x00c2f800, 0x4e99b186,
  0x00fe657d, 0x01006e7f, 0x01027781, 0x6832fe53,
  0x00bfe57d, 0x00c16e7f, 0x00c2f781, 0x4e997e53,
  0x008165fa, 0x00826efd, 0x00837800, 0x35003186,
  0x0018ffe7, 0x0019331b, 0x0019664f, 0x0a3d5c49,
  0x0042aa68, 0x004332f1, 0x0043bb7a, 0x1b4e4b38,
  0x008128f1, 0x00823177, 0x008339fd, 0x34e7319f,
  0x00bfa7f7, 0x00c1307b, 0x00c2b8ff, 0x4e804b39,
  0x00fe277a, 0x01002ffd, 0x01023880, 0x68199806,
  0x00bfa77a, 0x00c12ffd, 0x00c2b880, 0x4e801806,
  0x008127f7, 0x0082307b, 0x008338ff, 0x34e6cb39,
  0x00577cf9, 0x00583027, 0x0058e355, 0x23d5a917,
  0x0029aa81, 0x0029ffd7, 0x002a552d, 0x1110ef0f,
  0x0068290a, 0x0068fe5d, 0x0069d3b0, 0x2aa9d576,
  0x00a6a810, 0x00a7fd61, 0x00a952b2, 0x4442ef10,
  0x00e52793, 0x00e6fce3, 0x00e8d233, 0x5ddc3bdd,
  0x00a6a793, 0x00a7fce3, 0x00a95233, 0x4442bbdd,
  0x00682810, 0x0068fd61, 0x0069d2b2, 0x2aa96f10,
  0x003e7d12, 0x003efd0d, 0x003f7d08, 0x19984cee,
  0x00257cae, 0x0025c975, 0x0026163c, 0x0f5abd92,
  0x003e7e89, 0x003efe87, 0x003f7e85, 0x1998e687,
  0x007cfd8f, 0x007dfd8b, 0x007efd87, 0x33320021,
  0x00bb7d12, 0x00bcfd0d, 0x00be7d08, 0x4ccb4cee,
  0x007cfd12, 0x007dfd0d, 0x007efd08, 0x3331ccee,
  0x003e7d8f, 0x003efd8b, 0x003f7d87, 0x19988021,
  0x0014d291, 0x0014fd37, 0x001527dd, 0x08875dff,
  0xfffbd22d, 0xfffbc99f, 0xfffbc111, 0xfe49cea3,
  0xfffb93ad, 0xfffb8a9f, 0xfffb8191, 0xfe303523,
  0x003e7f06, 0x003eff05, 0x003f7f04, 0x199919ba,
  0x007cfe89, 0x007dfe87, 0x007efe85, 0x33326687,
  0x003e7e89, 0x003efe87, 0x003f7e85, 0x1998e687,
  0xffffff06, 0xffffff05, 0xffffff04, 0xffff99ba,
  0xffd65408, 0xffd5feb1, 0xffd5a95a, 0xeeee7798,
  0xffbd53a4, 0xffbccb19, 0xffbc428e, 0xe4b0e83c,
  0xffbd1524, 0xffbc8c19, 0xffbc030e, 0xe4974ebc,
  0xffbcd721, 0xffbc4d97, 0xffbbc40d, 0xe47de86f,
  0x003e7f83, 0x003eff83, 0x003f7f83, 0x19994ced,
  0xffffff83, 0xffffff83, 0xffffff83, 0xffffcced,
  0xffc18000, 0xffc10001, 0xffc08002, 0xe6668020,
  0xff97d502, 0xff96ffad, 0xff962a58, 0xd5555dfe,
  0xff7ed49e, 0xff7dcc15, 0xff7cc38c, 0xcb17cea2,
  0xff7e961e, 0xff7d8d15, 0xff7c840c, 0xcafe3522,
  0xff7e581b, 0xff7d4e93, 0xff7c450b, 0xcae4ced5,
  0xff7e1a95, 0xff7d108f, 0xff7c0689, 0xcacb9bbb,
  0xffc18000, 0xffc10001, 0xffc08002, 0xe6668020,
  0xff83007d, 0xff82007f, 0xff810081, 0xcccd3353,
  0xff59557f, 0xff58002b, 0xff56aad7, 0xbbbc1131,
  0xff40551b, 0xff3ecc93, 0xff3d440b, 0xb17e81d5,
  0xff40169b, 0xff3e8d93, 0xff3d048b, 0xb164e855,
  0xff3fd898, 0xff3e4f11, 0xff3cc58a, 0xb14b8208,
  0xff3f9b12, 0xff3e110d, 0xff3c8708, 0xb1324eee,
  0xff3f5e09, 0xff3dd387, 0xff3c4905, 0xb1194f07,
  0xffc1807d, 0xffc1007f, 0xffc08081, 0xe666b353,
  0xff97d57f, 0xff97002b, 0xff962ad7, 0xd5559131,
  0xff7ed51b, 0xff7dcc93, 0xff7cc40b, 0xcb1801d5,
  0xff7e969b, 0xff7d8d93, 0xff7c848b, 0xcafe6855,
  0xff7e5898, 0xff7d4f11, 0xff7c458a, 0xcae50208,
  0xff7e1b12, 0xff7d110d, 0xff7c0708, 0xcacbceee,
  0xff7dde09, 0xff7cd387, 0xff7bc905, 0xcab2cf07,
  0xff7dd639, 0xff7ccba7, 0xff7bc115, 0xcaaf9bd7,
  0xffd65502, 0xffd5ffad, 0xffd5aa58, 0xeeeeddfe,
  0xffbd549e, 0xffbccc15, 0xffbc438c, 0xe4b14ea2,
  0xffbd161e, 0xffbc8d15, 0xffbc040c, 0xe497b522,
  0xffbcd81b, 0xffbc4e93, 0xffbbc50b, 0xe47e4ed5,
  0xffbc9a95, 0xffbc108f, 0xffbb8689, 0xe4651bbb,
  0xffbc5d8c, 0xffbbd309, 0xffbb4886, 0xe44c1bd4,
  0xffbc55bc, 0xffbbcb29, 0xffbb4096, 0xe448e8a4,
  0xffbc5445, 0xffbbc9af, 0xffbb3f19, 0xe4484f0b,
  0xffe6ff9c, 0xffe6cc69, 0xffe69936, 0xf5c270c4,
  0xffe6c11c, 0xffe68d69, 0xffe659b6, 0xf5a8d744,
  0xffe68319, 0xffe64ee7, 0xffe61ab5, 0xf58f70f7,
  0xffe64593, 0xffe610e3, 0xffe5dc33, 0xf5763ddd,
  0xffe6088a, 0xffe5d35d, 0xffe59e30, 0xf55d3df6,
  0xffe600ba, 0xffe5cb7d, 0xffe59640, 0xf55a0ac6,
  0xffe5ff43, 0xffe5ca03, 0xffe594c3, 0xf559712d,
  0xffe5fe49, 0xffe5c907, 0xffe593c5, 0xf5590ac7,
  0xffffc180, 0xffffc101, 0xffffc082, 0xffe666a0,
  0xffff837d, 0xffff827f, 0xffff8181, 0xffcd0053,
  0xffff45f7, 0xffff447b, 0xffff42ff, 0xffb3cd39,
  0xffff08ee, 0xffff06f5, 0xffff04fc, 0xff9acd52,
  0xffff011e, 0xfffeff15, 0xfffefd0c, 0xff979a22,
  0xfffeffa7, 0xfffefd9b, 0xfffefb8f, 0xff970089,
  0xfffefead, 0xfffefc9f, 0xfffefa91, 0xff969a23,
  0xfffefe30, 0xfffefc21, 0xfffefa12, 0xff9666f0,
  0xffffc17e, 0xffffc100, 0xffe699b5, 0xffd5aaf5,
  0xffff837a, 0xffff827e, 0xffcd669b, 0xffabab1f,
  0xffff45f4, 0xffff447b, 0xffb466b4, 0xff82009e,
  0xffff3e14, 0xffff3c8b, 0xffb13384, 0xff7cab4e,
  0xffff3c9a, 0xffff3b0e, 0xffb099eb, 0xff7bab4f,
  0xffff3b9e, 0xffff3a10, 0xffb03385, 0xff7b00a5,
  0xffff3b20, 0xffff3991, 0xffb00052, 0xff7aab50,
  0xffff3b20, 0xffff3991, 0xffb00052, 0xff7aab50,
  0xffffc1fc, 0xffffc17f, 0xffe6cce8, 0xffd6004a,
  0xffff8476, 0xffff837c, 0xffcdcd01, 0xffac55c9,
  0xffff7c96, 0xffff7b8c, 0xffca99d1, 0xffa70079,
  0xffff7b1c, 0xffff7a0f, 0xffca0038, 0xffa6007a,
  0xffff7a20, 0xffff7911, 0xffc999d2, 0xffa555d0,
  0xffff79a2, 0xffff7892, 0xffc9669f, 0xffa5007b,
  0xffff79a2, 0xffff7892, 0xffc9669f, 0xffa5007b,
  0xffff7a20, 0xffff7911, 0xffc999d2, 0xffa555d0,
  0xffffc27a, 0xffffc1fe, 0xffe7001b, 0xffd6559f,
  0xffffba9a, 0xffffba0e, 0xffe3cceb, 0xffd1004f,
  0xffffb920, 0xffffb891, 0xffe33352, 0xffd00050,
  0xffffb824, 0xffffb793, 0xffe2ccec, 0xffcf55a6,
  0xffffb7a6, 0xffffb714, 0xffe299b9, 0xffcf0051,
  0xffffb7a6, 0xffffb714, 0xffe299b9, 0xffcf0051,
  0xffffb824, 0xffffb793, 0xffe2ccec, 0xffcf55a6,
  0xffffb920, 0xffffb891, 0xffe33352, 0xffd00050,
  0xfffff820, 0xfffff811, 0xfffcccd2, 0xfffaaad0,
  0xfffff6a6, 0xfffff694, 0xfffc3339, 0xfff9aad1,
  0xfffff5aa, 0xfffff596, 0xfffbccd3, 0xfff90027,
  0xfffff52c, 0xfffff517, 0xfffb99a0, 0xfff8aad2,
  0xfffff52c, 0xfffff517, 0xfffb99a0, 0xfff8aad2,
  0xfffff5aa, 0xfffff596, 0xfffbccd3, 0xfff90027,
  0xfffff6a6, 0xfffff694, 0xfffc3339, 0xfff9aad1,
  0xfffffe86, 0xfffffe84, 0xffff6669, 0xffff0021,
  0xfffffe86, 0xfffffe84, 0xffff6669, 0xffff0021,
  0xfffffd8a, 0xfffffd86, 0xffff0003, 0xfffe5577,
  0xfffffd0c, 0xfffffd07, 0xfffeccd0, 0xfffe0022,
  0xfffffd0c, 0xfffffd07, 0xfffeccd0, 0xfffe0022,
  0xfffffd8a, 0xfffffd86, 0xffff0003, 0xfffe5577,
  0xfffffe86, 0xfffffe84, 0xffff6669, 0xffff0021,
  0x00000666, 0x00000674, 0x00029999, 0x00045571,
  0x000043ec, 0x00004477, 0x001b9980, 0x002dfff2,
  0xffffff04, 0xffffff03, 0xffff999c, 0xffff5576,
  0xfffffe86, 0xfffffe84, 0xffff6669, 0xffff0021,
  0xfffffe86, 0xfffffe84, 0xffff6669, 0xffff0021,
  0xffffff04, 0xffffff03, 0xffff999c, 0xffff5576,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x000007e0, 0x000007f1, 0x00033332, 0x00055570,
  0x00004566, 0x000045f4, 0x001c3319, 0x002efff1,
  0x0000836a, 0x00008476, 0x00356633, 0x0058ffc7,
  0xffffff82, 0xffffff82, 0xffffcccf, 0xffffaacb,
  0xffffff82, 0xffffff82, 0xffffcccf, 0xffffaacb,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x000000fc, 0x000000ff, 0x00006668, 0x0000aaca,
  0x000008dc, 0x000008ef, 0x00039998, 0x0006001a,
  0x00004662, 0x000046f2, 0x001c997f, 0x002faa9b,
  0x00008466, 0x00008574, 0x0035cc99, 0x0059aa71,
  0x0000c2e8, 0x0000c475, 0x004f32e6, 0x0083ff9c,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000007e, 0x00000080, 0x00003335, 0x00005575,
  0x0000017a, 0x0000017e, 0x0000999b, 0x0001001f,
  0x0000095a, 0x0000096e, 0x0003cccb, 0x0006556f,
  0x000046e0, 0x00004771, 0x001cccb2, 0x002ffff0,
  0x000084e4, 0x000085f3, 0x0035ffcc, 0x0059ffc6,
  0x0000c366, 0x0000c4f4, 0x004f6619, 0x008454f1,
  0x0019f680, 0x001a2b41, 0x0a8cc242, 0x119543e0,
  0x0000007e, 0x00000080, 0x00003335, 0x00005575,
  0x0000017a, 0x0000017e, 0x0000999b, 0x0001001f,
  0x0000095a, 0x0000096e, 0x0003cccb, 0x0006556f,
  0x000046e0, 0x00004771, 0x001cccb2, 0x002ffff0,
  0x000084e4, 0x000085f3, 0x0035ffcc, 0x0059ffc6,
  0x0000c366, 0x0000c4f4, 0x004f6619, 0x008454f1,
  0x0019f680, 0x001a2b41, 0x0a8cc242, 0x119543e0,
  0x0043f656, 0x0044806c, 0x1b9db131, 0x2e06d219,
  0x000000fc, 0x000000ff, 0x00006668, 0x0000aaca,
  0x000008dc, 0x000008ef, 0x00039998, 0x0006001a,
  0x00004662, 0x000046f2, 0x001c997f, 0x002faa9b,
  0x00008466, 0x00008574, 0x0035cc99, 0x0059aa71,
  0x0000c2e8, 0x0000c475, 0x004f32e6, 0x0083ff9c,
  0x0019f602, 0x001a2ac2, 0x0a8c8f0f, 0x1194ee8b,
  0x0043f5d8, 0x00447fed, 0x1b9d7dfe, 0x2e067cc4,
  0x0082f45e, 0x0083fe70, 0x35366465, 0x58affcc5,
  0x000007e0, 0x000007f1, 0x00033332, 0x00055570,
  0x00004566, 0x000045f4, 0x001c3319, 0x002efff1,
  0x0000836a, 0x00008476, 0x00356633, 0x0058ffc7,
  0x0000c1ec, 0x0000c377, 0x004ecc80, 0x008354f2,
  0x0019f506, 0x001a29c4, 0x0a8c28a9, 0x119443e1,
  0x0043f4dc, 0x00447eef, 0x1b9d1798, 0x2e05d21a,
  0x0082f362, 0x0083fd72, 0x3535fdff, 0x58af521b,
  0x00c1f266, 0x00c37c74, 0x4ecf1799, 0x83592771,
  0x00003d86, 0x00003e04, 0x0018ffe9, 0x0029aaa1,
  0x00007b8a, 0x00007c86, 0x00323303, 0x0053aa77,
  0x0000ba0c, 0x0000bb87, 0x004b9950, 0x007dffa2,
  0x0019ed26, 0x001a21d4, 0x0a88f579, 0x118eee91,
  0x0043ecfc, 0x004476ff, 0x1b99e468, 0x2e007cca,
  0x0082eb82, 0x0083f582, 0x3532cacf, 0x58a9fccb,
  0x00c1ea86, 0x00c37484, 0x4ecbe469, 0x8353d221,
  0x0100ea08, 0x0102f405, 0x68653136, 0xadfdfccc,
  0x00003e04, 0x00003e83, 0x0019331c, 0x0029fff6,
  0x00007c86, 0x00007d84, 0x00329969, 0x00545521,
  0x0019afa0, 0x0019e3d1, 0x0a6ff592, 0x11654410,
  0x0043af76, 0x004438fc, 0x1b80e481, 0x2dd6d249,
  0x0082adfc, 0x0083b77f, 0x3519cae8, 0x5880524a,
  0x00c1ad00, 0x00c33681, 0x4eb2e482, 0x832a27a0,
  0x0100ac82, 0x0102b602, 0x684c314f, 0xadd4524b,
  0x00c1ac82, 0x00c33602, 0x4eb2b14f, 0x8329d24b,
  0x00003e82, 0x00003f02, 0x0019664f, 0x002a554b,
  0x0019719c, 0x0019a54f, 0x0a56c278, 0x113b443a,
  0x00437172, 0x0043fa7a, 0x1b67b167, 0x2dacd273,
  0x00826ff8, 0x008378fd, 0x350097ce, 0x58565274,
  0x00c16efc, 0x00c2f7ff, 0x4e99b168, 0x830027ca,
  0x01006e7e, 0x01027780, 0x6832fe35, 0xadaa5275,
  0x00c16e7e, 0x00c2f780, 0x4e997e35, 0x82ffd275,
  0x00826efc, 0x008377ff, 0x35003168, 0x5855a7ca,
  0x0019331a, 0x0019664e, 0x0a3d5c2b, 0x1110ef0f,
  0x004332f0, 0x0043bb79, 0x1b4e4b1a, 0x2d827d48,
  0x00823176, 0x008339fc, 0x34e73181, 0x582bfd49,
  0x00c1307a, 0x00c2b8fe, 0x4e804b1b, 0x82d5d29f,
  0x01002ffc, 0x0102387f, 0x681997e8, 0xad7ffd4a,
  0x00c12ffc, 0x00c2b87f, 0x4e8017e8, 0x82d57d4a,
  0x0082307a, 0x008338fe, 0x34e6cb1b, 0x582b529f,
  0x00583026, 0x0058e354, 0x23d5a8f9, 0x3bb96f11,
  0x0029ffd6, 0x002a552c, 0x1110eef1, 0x1c718e59,
  0x0068fe5c, 0x0069d3af, 0x2aa9d558, 0x471b0e5a,
  0x00a7fd60, 0x00a952b1, 0x4442eef2, 0x71c4e3b0,
  0x00e6fce2, 0x00e8d232, 0x5ddc3bbf, 0x9c6f0e5b,
  0x00a7fce2, 0x00a95232, 0x4442bbbf, 0x71c48e5b,
  0x0068fd60, 0x0069d2b1, 0x2aa96ef2, 0x471a63b0,
  0x003efd0c, 0x003f7d07, 0x19984cd0, 0x2aa88022,
  0x0025c974, 0x0026163b, 0x0f5abd74, 0x19973bde,
  0x003efe86, 0x003f7e84, 0x1998e669, 0x2aa98021,
  0x007dfd8a, 0x007efd86, 0x33320003, 0x55535577,
  0x00bcfd0c, 0x00be7d07, 0x4ccb4cd0, 0x7ffd8022,
  0x007dfd0c, 0x007efd07, 0x3331ccd0, 0x55530022,
  0x003efd8a, 0x003f7d86, 0x19988003, 0x2aa8d577,
  0x0014fd36, 0x001527dc, 0x08875de1, 0x0e36f1e9,
  0xfffbc99e, 0xfffbc110, 0xfe49ce85, 0xfd25ada5,
  0xfffb8a9e, 0xfffb8190, 0xfe303505, 0xfcfb0325,
  0x003eff04, 0x003f7f03, 0x1999199c, 0x2aa9d576,
  0x007dfe86, 0x007efe84, 0x33326669, 0x55540021,
  0x003efe86, 0x003f7e84, 0x1998e669, 0x2aa98021,
  0xffffff04, 0xffffff03, 0xffff999c, 0xffff5576,
  0xffd5feb0, 0xffd5a959, 0xeeee777a, 0xe38d71e8,
  0xffbccb18, 0xffbc428d, 0xe4b0e81e, 0xd27c2da4,
  0xffbc8c18, 0xffbc030d, 0xe4974e9e, 0xd2518324,
  0xffbc4d96, 0xffbbc40c, 0xe47de851, 0xd2272df9,
  0x003eff82, 0x003f7f82, 0x19994ccf, 0x2aaa2acb,
  0xffffff82, 0xffffff82, 0xffffcccf, 0xffffaacb,
  0xffc10000, 0xffc08001, 0xe6668002, 0xd5558020,
  0xff96ffac, 0xff962a57, 0xd5555de0, 0xb8e39c92,
  0xff7dcc14, 0xff7cc38b, 0xcb17ce84, 0xa7d2584e,
  0xff7d8d14, 0xff7c840b, 0xcafe3504, 0xa7a7adce,
  0xff7d4e92, 0xff7c450a, 0xcae4ceb7, 0xa77d58a3,
  0xff7d108e, 0xff7c0688, 0xcacb9b9d, 0xa75358cd,
  0xffc10000, 0xffc08001, 0xe6668002, 0xd5558020,
  0xff82007e, 0xff810080, 0xcccd3335, 0xaaab5575,
  0xff58002a, 0xff56aad6, 0xbbbc1113, 0x8e3971e7,
  0xff3ecc92, 0xff3d440a, 0xb17e81b7, 0x7d282da3,
  0xff3e8d92, 0xff3d048a, 0xb164e837, 0x7cfd8323,
  0xff3e4f10, 0xff3cc589, 0xb14b81ea, 0x7cd32df8,
  0xff3e110c, 0xff3c8707, 0xb1324ed0, 0x7ca92e22,
  0xff3dd386, 0xff3c4904, 0xb1194ee9, 0x7c7f83a1,
  0xffc1007e, 0xffc08080, 0xe666b335, 0xd555d575,
  0xff97002a, 0xff962ad6, 0xd5559113, 0xb8e3f1e7,
  0xff7dcc92, 0xff7cc40a, 0xcb1801b7, 0xa7d2ada3,
  0xff7d8d92, 0xff7c848a, 0xcafe6837, 0xa7a80323,
  0xff7d4f10, 0xff7c4589, 0xcae501ea, 0xa77dadf8,
  0xff7d110c, 0xff7c0707, 0xcacbced0, 0xa753ae22,
  0xff7cd386, 0xff7bc904, 0xcab2cee9, 0xa72a03a1,
  0xff7ccba6, 0xff7bc114, 0xcaaf9bb9, 0xa724ae51,
  0xffd5ffac, 0xffd5aa57, 0xeeeedde0, 0xe38e1c92,
  0xffbccc14, 0xffbc438b, 0xe4b14e84, 0xd27cd84e,
  0xffbc8d14, 0xffbc040b, 0xe497b504, 0xd2522dce,
  0xffbc4e92, 0xffbbc50a, 0xe47e4eb7, 0xd227d8a3,
  0xffbc108e, 0xffbb8688, 0xe4651b9d, 0xd1fdd8cd,
  0xffbbd308, 0xffbb4885, 0xe44c1bb6, 0xd1d42e4c,
  0xffbbcb28, 0xffbb4095, 0xe448e886, 0xd1ced8fc,
  0xffbbc9ae, 0xffbb3f18, 0xe4484eed, 0xd1cdd8fd,
  0xffe6cc68, 0xffe69935, 0xf5c270a6, 0xeeeebbdc,
  0xffe68d68, 0xffe659b5, 0xf5a8d726, 0xeec4115c,
  0xffe64ee6, 0xffe61ab4, 0xf58f70d9, 0xee99bc31,
  0xffe610e2, 0xffe5dc32, 0xf5763dbf, 0xee6fbc5b,
  0xffe5d35c, 0xffe59e2f, 0xf55d3dd8, 0xee4611da,
  0xffe5cb7c, 0xffe5963f, 0xf55a0aa8, 0xee40bc8a,
  0xffe5ca02, 0xffe594c2, 0xf559710f, 0xee3fbc8b,
  0xffe5c906, 0xffe593c4, 0xf5590aa9, 0xee3f11e1,
  0xffffc100, 0xffffc081, 0xffe66682, 0xffd555a0,
  0xffff827e, 0xffff8180, 0xffcd0035, 0xffab0075,
  0xffff447a, 0xffff42fe, 0xffb3cd1b, 0xff81009f,
  0xffff06f4, 0xffff04fb, 0xff9acd34, 0xff57561e,
  0xfffeff14, 0xfffefd0b, 0xff979a04, 0xff5200ce,
  0xfffefd9a, 0xfffefb8e, 0xff97006b, 0xff5100cf,
  0xfffefc9e, 0xfffefa90, 0xff969a05, 0xff505625,
  0xfffefc20, 0xfffefa11, 0xff9666d2, 0xff5000d0,
  0xffffc0ff, 0xffe699b4, 0xffd5aad7, 0xffc0819d,
  0xffff827d, 0xffcd669a, 0xffabab01, 0xff818317,
  0xffff447a, 0xffb466b3, 0xff820080, 0xff43048e,
  0xffff3c8a, 0xffb13383, 0xff7cab30, 0xff3b04be,
  0xffff3b0d, 0xffb099ea, 0xff7bab31, 0xff3984c7,
  0xffff3a0f, 0xffb03384, 0xff7b0087, 0xff3884cd,
  0xffff3990, 0xffb00051, 0xff7aab32, 0xff3804d0,
  0xffff3990, 0xffb00051, 0xff7aab32, 0xff3804d0,
  0xffffc17e, 0xffe6cce7, 0xffd6002c, 0xffc1019a,
  0xffff837b, 0xffcdcd00, 0xffac55ab, 0xff828311,
  0xffff7b8b, 0xffca99d0, 0xffa7005b, 0xff7a8341,
  0xffff7a0e, 0xffca0037, 0xffa6005c, 0xff79034a,
  0xffff7910, 0xffc999d1, 0xffa555b2, 0xff780350,
  0xffff7891, 0xffc9669e, 0xffa5005d, 0xff778353,
  0xffff7891, 0xffc9669e, 0xffa5005d, 0xff778353,
  0xffff7910, 0xffc999d1, 0xffa555b2, 0xff780350,
  0xffffc1fd, 0xffe7001a, 0xffd65581, 0xffc18197,
  0xffffba0d, 0xffe3ccea, 0xffd10031, 0xffb981c7,
  0xffffb890, 0xffe33351, 0xffd00032, 0xffb801d0,
  0xffffb792, 0xffe2cceb, 0xffcf5588, 0xffb701d6,
  0xffffb713, 0xffe299b8, 0xffcf0033, 0xffb681d9,
  0xffffb713, 0xffe299b8, 0xffcf0033, 0xffb681d9,
  0xffffb792, 0xffe2cceb, 0xffcf5588, 0xffb701d6,
  0xffffb890, 0xffe33351, 0xffd00032, 0xffb801d0,
  0xfffff810, 0xfffcccd1, 0xfffaaab2, 0xfff80050,
  0xfffff693, 0xfffc3338, 0xfff9aab3, 0xfff68059,
  0xfffff595, 0xfffbccd2, 0xfff90009, 0xfff5805f,
  0xfffff516, 0xfffb999f, 0xfff8aab4, 0xfff50062,
  0xfffff516, 0xfffb999f, 0xfff8aab4, 0xfff50062,
  0xfffff595, 0xfffbccd2, 0xfff90009, 0xfff5805f,
  0xfffff693, 0xfffc3338, 0xfff9aab3, 0xfff68059,
  0xfffffe83, 0xffff6668, 0xffff0003, 0xfffe8029,
  0xfffffe83, 0xffff6668, 0xffff0003, 0xfffe8029,
  0xfffffd85, 0xffff0002, 0xfffe5559, 0xfffd802f,
  0xfffffd06, 0xfffecccf, 0xfffe0004, 0xfffd0032,
  0xfffffd06, 0xfffecccf, 0xfffe0004, 0xfffd0032,
  0xfffffd85, 0xffff0002, 0xfffe5559, 0xfffd802f,
  0xfffffe83, 0xffff6668, 0xffff0003, 0xfffe8029,
  0x00000673, 0x00029998, 0x00045553, 0x00067ff9,
  0x00004476, 0x001b997f, 0x002dffd4, 0x0044fe82,
  0xffffff02, 0xffff999b, 0xffff5558, 0xffff0026,
  0xfffffe83, 0xffff6668, 0xffff0003, 0xfffe8029,
  0xfffffe83, 0xffff6668, 0xffff0003, 0xfffe8029,
  0xffffff02, 0xffff999b, 0xffff5558, 0xffff0026,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x000007f0, 0x00033331, 0x00055552, 0x0007fff0,
  0x000045f3, 0x001c3318, 0x002effd3, 0x00467e79,
  0x00008475, 0x00356632, 0x0058ffa9, 0x00857cff,
  0xffffff81, 0xffffccce, 0xffffaaad, 0xffff8023,
  0xffffff81, 0xffffccce, 0xffffaaad, 0xffff8023,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x000000fe, 0x00006667, 0x0000aaac, 0x0001001a,
  0x000008ee, 0x00039997, 0x0005fffc, 0x0008ffea,
  0x000046f1, 0x001c997e, 0x002faa7d, 0x00477e73,
  0x00008573, 0x0035cc98, 0x0059aa53, 0x00867cf9,
  0x0000c474, 0x004f32e5, 0x0083ff7e, 0x00c5fb7c,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000007f, 0x00003334, 0x00005557, 0x0000801d,
  0x0000017d, 0x0000999a, 0x00010001, 0x00018017,
  0x0000096d, 0x0003ccca, 0x00065551, 0x00097fe7,
  0x00004770, 0x001cccb1, 0x002fffd2, 0x0047fe70,
  0x000085f2, 0x0035ffcb, 0x0059ffa8, 0x0086fcf6,
  0x0000c4f3, 0x004f6618, 0x008454d3, 0x00c67b79,
  0x001a2b40, 0x0a8cc241, 0x119543c2, 0x1a5f61e0,
  0x0000007f, 0x00003334, 0x00005557, 0x0000801d,
  0x0000017d, 0x0000999a, 0x00010001, 0x00018017,
  0x0000096d, 0x0003ccca, 0x00065551, 0x00097fe7,
  0x00004770, 0x001cccb1, 0x002fffd2, 0x0047fe70,
  0x000085f2, 0x0035ffcb, 0x0059ffa8, 0x0086fcf6,
  0x0000c4f3, 0x004f6618, 0x008454d3, 0x00c67b79,
  0x001a2b40, 0x0a8cc241, 0x119543c2, 0x1a5f61e0,
  0x0044806b, 0x1b9db130, 0x2e06d1fb, 0x4508e1e1,
  0x000000fe, 0x00006667, 0x0000aaac, 0x0001001a,
  0x000008ee, 0x00039997, 0x0005fffc, 0x0008ffea,
  0x000046f1, 0x001c997e, 0x002faa7d, 0x00477e73,
  0x00008573, 0x0035cc98, 0x0059aa53, 0x00867cf9,
  0x0000c474, 0x004f32e5, 0x0083ff7e, 0x00c5fb7c,
  0x001a2ac1, 0x0a8c8f0e, 0x1194ee6d, 0x1a5ee1e3,
  0x00447fec, 0x1b9d7dfd, 0x2e067ca6, 0x450861e4,
  0x0083fe6f, 0x35366464, 0x58affca7, 0x850561ed,
  0x000007f0, 0x00033331, 0x00055552, 0x0007fff0,
  0x000045f3, 0x001c3318, 0x002effd3, 0x00467e79,
  0x00008475, 0x00356632, 0x0058ffa9, 0x00857cff,
  0x0000c376, 0x004ecc7f, 0x008354d4, 0x00c4fb82,
  0x001a29c3, 0x0a8c28a8, 0x119443c3, 0x1a5de1e9,
  0x00447eee, 0x1b9d1797, 0x2e05d1fc, 0x450761ea,
  0x0083fd71, 0x3535fdfe, 0x58af51fd, 0x850461f3,
  0x00c37c73, 0x4ecf1798, 0x83592753, 0xc501e1f9,
  0x00003e03, 0x0018ffe8, 0x0029aa83, 0x003e7ea9,
  0x00007c85, 0x00323302, 0x0053aa59, 0x007d7d2f,
  0x0000bb86, 0x004b994f, 0x007dff84, 0x00bcfbb2,
  0x001a21d3, 0x0a88f578, 0x118eee73, 0x1a55e219,
  0x004476fe, 0x1b99e467, 0x2e007cac, 0x44ff621a,
  0x0083f581, 0x3532cace, 0x58a9fcad, 0x84fc6223,
  0x00c37483, 0x4ecbe468, 0x8353d203, 0xc4f9e229,
  0x0102f404, 0x68653135, 0xadfdfcae, 0x04f7e22c,
  0x00003e82, 0x0019331b, 0x0029ffd8, 0x003efea6,
  0x00007d83, 0x00329968, 0x00545503, 0x007e7d29,
  0x0019e3d0, 0x0a6ff591, 0x116543f2, 0x1a176390,
  0x004438fb, 0x1b80e480, 0x2dd6d22b, 0x44c0e391,
  0x0083b77e, 0x3519cae7, 0x5880522c, 0x84bde39a,
  0x00c33680, 0x4eb2e481, 0x832a2782, 0xc4bb63a0,
  0x0102b601, 0x684c314e, 0xadd4522d, 0x04b963a3,
  0x00c33601, 0x4eb2b14e, 0x8329d22d, 0xc4bae3a3,
  0x00003f01, 0x0019664e, 0x002a552d, 0x003f7ea3,
  0x0019a54e, 0x0a56c277, 0x113b441c, 0x19d8650a,
  0x0043fa79, 0x1b67b166, 0x2dacd255, 0x4481e50b,
  0x008378fc, 0x350097cd, 0x58565256, 0x847ee514,
  0x00c2f7fe, 0x4e99b167, 0x830027ac, 0xc47c651a,
  0x0102777f, 0x6832fe34, 0xadaa5257, 0x047a651d,
  0x00c2f77f, 0x4e997e34, 0x82ffd257, 0xc47be51d,
  0x008377fe, 0x35003167, 0x5855a7ac, 0x847de51a,
  0x0019664d, 0x0a3d5c2a, 0x1110eef1, 0x1998e687,
  0x0043bb78, 0x1b4e4b19, 0x2d827d2a, 0x44426688,
  0x008339fb, 0x34e73180, 0x582bfd2b, 0x843f6691,
  0x00c2b8fd, 0x4e804b1a, 0x82d5d281, 0xc43ce697,
  0x0102387e, 0x681997e7, 0xad7ffd2c, 0x043ae69a,
  0x00c2b87e, 0x4e8017e7, 0x82d57d2c, 0xc43c669a,
  0x008338fd, 0x34e6cb1a, 0x582b5281, 0x843e6697,
  0x0058e353, 0x23d5a8f8, 0x3bb96ef3, 0x59946699,
  0x002a552b, 0x1110eef0, 0x1c718e3b, 0x2aa98021,
  0x0069d3ae, 0x2aa9d557, 0x471b0e3c, 0x6aa6802a,
  0x00a952b0, 0x4442eef1, 0x71c4e392, 0xaaa40030,
  0x00e8d231, 0x5ddc3bbe, 0x9c6f0e3d, 0xeaa20033,
  0x00a95231, 0x4442bbbe, 0x71c48e3d, 0xaaa38033,
  0x0069d2b0, 0x2aa96ef1, 0x471a6392, 0x6aa58030,
  0x003f7d06, 0x19984ccf, 0x2aa88004, 0x3ffb8032,
  0x0026163a, 0x0f5abd73, 0x19973bc0, 0x266219ce,
  0x003f7e83, 0x1998e668, 0x2aa98003, 0x3ffd0029,
  0x007efd85, 0x33320002, 0x55535559, 0x7ffa802f,
  0x00be7d06, 0x4ccb4ccf, 0x7ffd8004, 0xbff88032,
  0x007efd06, 0x3331cccf, 0x55530004, 0x7ffa0032,
  0x003f7d85, 0x19988002, 0x2aa8d559, 0x3ffc002f,
  0x001527db, 0x08875de0, 0x0e36f1cb, 0x15520031,
  0xfffbc10f, 0xfe49ce84, 0xfd25ad87, 0xfbb899cd,
  0xfffb818f, 0xfe303504, 0xfcfb0307, 0xfb789b4d,
  0x003f7f02, 0x1999199b, 0x2aa9d558, 0x3ffd8026,
  0x007efe83, 0x33326668, 0x55540003, 0x7ffb8029,
  0x003f7e83, 0x1998e668, 0x2aa98003, 0x3ffd0029,
  0xffffff02, 0xffff999b, 0xffff5558, 0xffff0026,
  0xffd5a958, 0xeeee7779, 0xe38d71ca, 0xd5550028,
  0xffbc428c, 0xe4b0e81d, 0xd27c2d86, 0xbbbb99c4,
  0xffbc030c, 0xe4974e9d, 0xd2518306, 0xbb7b9b44,
  0xffbbc40b, 0xe47de850, 0xd2272ddb, 0xbb3c1cc1,
  0x003f7f81, 0x19994cce, 0x2aaa2aad, 0x3ffe0023,
  0xffffff81, 0xffffccce, 0xffffaaad, 0xffff8023,
  0xffc08000, 0xe6668001, 0xd5558002, 0xc0018020,
  0xff962a56, 0xd5555ddf, 0xb8e39c74, 0x95578022,
  0xff7cc38a, 0xcb17ce83, 0xa7d25830, 0x7bbe19be,
  0xff7c840a, 0xcafe3503, 0xa7a7adb0, 0x7b7e1b3e,
  0xff7c4509, 0xcae4ceb6, 0xa77d5885, 0x7b3e9cbb,
  0xff7c0687, 0xcacb9b9c, 0xa75358af, 0x7aff9e35,
  0xffc08000, 0xe6668001, 0xd5558002, 0xc0018020,
  0xff81007f, 0xcccd3334, 0xaaab5557, 0x8003801d,
  0xff56aad5, 0xbbbc1112, 0x8e3971c9, 0x5559801f,
  0xff3d4409, 0xb17e81b6, 0x7d282d85, 0x3bc019bb,
  0xff3d0489, 0xb164e836, 0x7cfd8305, 0x3b801b3b,
  0xff3cc588, 0xb14b81e9, 0x7cd32dda, 0x3b409cb8,
  0xff3c8706, 0xb1324ecf, 0x7ca92e04, 0x3b019e32,
  0xff3c4903, 0xb1194ee8, 0x7c7f8383, 0x3ac31fa9,
  0xffc0807f, 0xe666b334, 0xd555d557, 0xc002001d,
  0xff962ad5, 0xd5559112, 0xb8e3f1c9, 0x9558001f,
  0xff7cc409, 0xcb1801b6, 0xa7d2ad85, 0x7bbe99bb,
  0xff7c8489, 0xcafe6836, 0xa7a80305, 0x7b7e9b3b,
  0xff7c4588, 0xcae501e9, 0xa77dadda, 0x7b3f1cb8,
  0xff7c0706, 0xcacbcecf, 0xa753ae04, 0x7b001e32,
  0xff7bc903, 0xcab2cee8, 0xa72a0383, 0x7ac19fa9,
  0xff7bc113, 0xcaaf9bb8, 0xa724ae33, 0x7ab99fd9,
  0xffd5aa56, 0xeeeedddf, 0xe38e1c74, 0xd5560022,
  0xffbc438a, 0xe4b14e83, 0xd27cd830, 0xbbbc99be,
  0xffbc040a, 0xe497b503, 0xd2522db0, 0xbb7c9b3e,
  0xffbbc509, 0xe47e4eb6, 0xd227d885, 0xbb3d1cbb,
  0xffbb8687, 0xe4651b9c, 0xd1fdd8af, 0xbafe1e35,
  0xffbb4884, 0xe44c1bb5, 0xd1d42e2e, 0xbabf9fac,
  0xffbb4094, 0xe448e885, 0xd1ced8de, 0xbab79fdc,
  0xffbb3f17, 0xe4484eec, 0xd1cdd8df, 0xbab61fe5,
  0xffe69934, 0xf5c270a5, 0xeeeebbbe, 0xe66699bc,
  0xffe659b4, 0xf5a8d725, 0xeec4113e, 0xe6269b3c,
  0xffe61ab3, 0xf58f70d8, 0xee99bc13, 0xe5e71cb9,
  0xffe5dc31, 0xf5763dbe, 0xee6fbc3d, 0xe5a81e33,
  0xffe59e2e, 0xf55d3dd7, 0xee4611bc, 0xe5699faa,
  0xffe5963e, 0xf55a0aa7, 0xee40bc6c, 0xe5619fda,
  0xffe594c1, 0xf559710e, 0xee3fbc6d, 0xe5601fe3,
  0xffe593c3, 0xf5590aa8, 0xee3f11c3, 0xe55f1fe9,
  0xffffc080, 0xffe66681, 0xffd55582, 0xffc001a0,
  0xffff817f, 0xffcd0034, 0xffab0057, 0xff80831d,
  0xffff42fd, 0xffb3cd1a, 0xff810081, 0xff418497,
  0xffff04fa, 0xff9acd33, 0xff575600, 0xff03060e,
  0xfffefd0a, 0xff979a03, 0xff5200b0, 0xfefb063e,
  0xfffefb8d, 0xff97006a, 0xff5100b1, 0xfef98647,
  0xfffefa8f, 0xff969a04, 0xff505607, 0xfef8864d,
  0xfffefa10, 0xff9666d1, 0xff5000b2, 0xfef80650,
  0xffe699b3, 0xffd5aad6, 0xffc0817f, 0xffc0811e,
  0xffcd6699, 0xffabab00, 0xff8182f9, 0xff81821a,
  0xffb466b2, 0xff82007f, 0xff430470, 0xff430314,
  0xffb13382, 0xff7cab2f, 0xff3b04a0, 0xff3b0334,
  0xffb099e9, 0xff7bab30, 0xff3984a9, 0xff39833a,
  0xffb03383, 0xff7b0086, 0xff3884af, 0xff38833e,
  0xffb00050, 0xff7aab31, 0xff3804b2, 0xff380340,
  0xffb00050, 0xff7aab31, 0xff3804b2, 0xff380340,
  0xffe6cce6, 0xffd6002b, 0xffc1017c, 0xffc1011c,
  0xffcdccff, 0xffac55aa, 0xff8282f3, 0xff828216,
  0xffca99cf, 0xffa7005a, 0xff7a8323, 0xff7a8236,
  0xffca0036, 0xffa6005b, 0xff79032c, 0xff79023c,
  0xffc999d0, 0xffa555b1, 0xff780332, 0xff780240,
  0xffc9669d, 0xffa5005c, 0xff778335, 0xff778242,
  0xffc9669d, 0xffa5005c, 0xff778335, 0xff778242,
  0xffc999d0, 0xffa555b1, 0xff780332, 0xff780240,
  0xffe70019, 0xffd65580, 0xffc18179, 0xffc1811a,
  0xffe3cce9, 0xffd10030, 0xffb981a9, 0xffb9813a,
  0xffe33350, 0xffd00031, 0xffb801b2, 0xffb80140,
  0xffe2ccea, 0xffcf5587, 0xffb701b8, 0xffb70144,
  0xffe299b7, 0xffcf0032, 0xffb681bb, 0xffb68146,
  0xffe299b7, 0xffcf0032, 0xffb681bb, 0xffb68146,
  0xffe2ccea, 0xffcf5587, 0xffb701b8, 0xffb70144,
  0xffe33350, 0xffd00031, 0xffb801b2, 0xffb80140,
  0xfffcccd0, 0xfffaaab1, 0xfff80032, 0xfff80040,
  0xfffc3337, 0xfff9aab2, 0xfff6803b, 0xfff68046,
  0xfffbccd1, 0xfff90008, 0xfff58041, 0xfff5804a,
  0xfffb999e, 0xfff8aab3, 0xfff50044, 0xfff5004c,
  0xfffb999e, 0xfff8aab3, 0xfff50044, 0xfff5004c,
  0xfffbccd1, 0xfff90008, 0xfff58041, 0xfff5804a,
  0xfffc3337, 0xfff9aab2, 0xfff6803b, 0xfff68046,
  0xffff6667, 0xffff0002, 0xfffe800b, 0xfffe8026,
  0xffff6667, 0xffff0002, 0xfffe800b, 0xfffe8026,
  0xffff0001, 0xfffe5558, 0xfffd8011, 0xfffd802a,
  0xfffeccce, 0xfffe0003, 0xfffd0014, 0xfffd002c,
  0xfffeccce, 0xfffe0003, 0xfffd0014, 0xfffd002c,
  0xffff0001, 0xfffe5558, 0xfffd8011, 0xfffd802a,
  0xffff6667, 0xffff0002, 0xfffe800b, 0xfffe8026,
  0x00029997, 0x00045552, 0x00067fdb, 0x00068006,
  0x001b997e, 0x002dffd3, 0x0044fe64, 0x0044ff0c,
  0xffff999a, 0xffff5557, 0xffff0008, 0xffff0024,
  0xffff6667, 0xffff0002, 0xfffe800b, 0xfffe8026,
  0xffff6667, 0xffff0002, 0xfffe800b, 0xfffe8026,
  0xffff999a, 0xffff5557, 0xffff0008, 0xffff0024,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00033330, 0x00055551, 0x0007ffd2, 0x00080000,
  0x001c3317, 0x002effd2, 0x00467e5b, 0x00467f06,
  0x00356631, 0x0058ffa8, 0x00857ce1, 0x00857e0a,
  0xffffcccd, 0xffffaaac, 0xffff8005, 0xffff8022,
  0xffffcccd, 0xffffaaac, 0xffff8005, 0xffff8022,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00006666, 0x0000aaab, 0x0000fffc, 0x0001001c,
  0x00039996, 0x0005fffb, 0x0008ffcc, 0x0008fffc,
  0x001c997d, 0x002faa7c, 0x00477e55, 0x00477f02,
  0x0035cc97, 0x0059aa52, 0x00867cdb, 0x00867e06,
  0x004f32e4, 0x0083ff7d, 0x00c5fb5e, 0x00c5fd08,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00003333, 0x00005556, 0x00007fff, 0x0000801e,
  0x00009999, 0x00010000, 0x00017ff9, 0x0001801a,
  0x0003ccc9, 0x00065550, 0x00097fc9, 0x00097ffa,
  0x001cccb0, 0x002fffd1, 0x0047fe52, 0x0047ff00,
  0x0035ffca, 0x0059ffa7, 0x0086fcd8, 0x0086fe04,
  0x004f6617, 0x008454d2, 0x00c67b5b, 0x00c67d06,
  0x0a8cc240, 0x119543c1, 0x1a5f61c2, 0x1a5f96a0,
  0x00003333, 0x00005556, 0x00007fff, 0x0000801e,
  0x00009999, 0x00010000, 0x00017ff9, 0x0001801a,
  0x0003ccc9, 0x00065550, 0x00097fc9, 0x00097ffa,
  0x001cccb0, 0x002fffd1, 0x0047fe52, 0x0047ff00,
  0x0035ffca, 0x0059ffa7, 0x0086fcd8, 0x0086fe04,
  0x004f6617, 0x008454d2, 0x00c67b5b, 0x00c67d06,
  0x0a8cc240, 0x119543c1, 0x1a5f61c2, 0x1a5f96a0,
  0x1b9db12f, 0x2e06d1fa, 0x4508e1c3, 0x45096bf6,
  0x00006666, 0x0000aaab, 0x0000fffc, 0x0001001c,
  0x00039996, 0x0005fffb, 0x0008ffcc, 0x0008fffc,
  0x001c997d, 0x002faa7c, 0x00477e55, 0x00477f02,
  0x0035cc97, 0x0059aa52, 0x00867cdb, 0x00867e06,
  0x004f32e4, 0x0083ff7d, 0x00c5fb5e, 0x00c5fd08,
  0x0a8c8f0d, 0x1194ee6c, 0x1a5ee1c5, 0x1a5f16a2,
  0x1b9d7dfc, 0x2e067ca5, 0x450861c6, 0x4508ebf8,
  0x35366463, 0x58affca6, 0x850561cf, 0x85066bfe,
  0x00033330, 0x00055551, 0x0007ffd2, 0x00080000,
  0x001c3317, 0x002effd2, 0x00467e5b, 0x00467f06,
  0x00356631, 0x0058ffa8, 0x00857ce1, 0x00857e0a,
  0x004ecc7e, 0x008354d3, 0x00c4fb64, 0x00c4fd0c,
  0x0a8c28a7, 0x119443c2, 0x1a5de1cb, 0x1a5e16a6,
  0x1b9d1796, 0x2e05d1fb, 0x450761cc, 0x4507ebfc,
  0x3535fdfd, 0x58af51fc, 0x850461d5, 0x85056c02,
  0x4ecf1797, 0x83592752, 0xc501e1db, 0xc5036c06,
  0x0018ffe7, 0x0029aa82, 0x003e7e8b, 0x003e7f26,
  0x00323301, 0x0053aa58, 0x007d7d11, 0x007d7e2a,
  0x004b994e, 0x007dff83, 0x00bcfb94, 0x00bcfd2c,
  0x0a88f577, 0x118eee72, 0x1a55e1fb, 0x1a5616c6,
  0x1b99e466, 0x2e007cab, 0x44ff61fc, 0x44ffec1c,
  0x3532cacd, 0x58a9fcac, 0x84fc6205, 0x84fd6c22,
  0x4ecbe467, 0x8353d202, 0xc4f9e20b, 0xc4fb6c26,
  0x68653134, 0xadfdfcad, 0x04f7e20e, 0x04f9ec28,
  0x0019331a, 0x0029ffd7, 0x003efe88, 0x003eff24,
  0x00329967, 0x00545502, 0x007e7d0b, 0x007e7e26,
  0x0a6ff590, 0x116543f1, 0x1a176372, 0x1a1797c0,
  0x1b80e47f, 0x2dd6d22a, 0x44c0e373, 0x44c16d16,
  0x3519cae6, 0x5880522b, 0x84bde37c, 0x84beed1c,
  0x4eb2e480, 0x832a2781, 0xc4bb6382, 0xc4bced20,
  0x684c314d, 0xadd4522c, 0x04b96385, 0x04bb6d22,
  0x4eb2b14d, 0x8329d22c, 0xc4bae385, 0xc4bc6d22,
  0x0019664d, 0x002a552c, 0x003f7e85, 0x003f7f22,
  0x0a56c276, 0x113b441b, 0x19d864ec, 0x19d898bc,
  0x1b67b165, 0x2dacd254, 0x4481e4ed, 0x44826e12,
  0x350097cc, 0x58565255, 0x847ee4f6, 0x847fee18,
  0x4e99b166, 0x830027ab, 0xc47c64fc, 0xc47dee1c,
  0x6832fe33, 0xadaa5256, 0x047a64ff, 0x047c6e1e,
  0x4e997e33, 0x82ffd256, 0xc47be4ff, 0xc47d6e1e,
  0x35003166, 0x5855a7ab, 0x847de4fc, 0x847eee1c,
  0x0a3d5c29, 0x1110eef0, 0x1998e669, 0x199919ba,
  0x1b4e4b18, 0x2d827d29, 0x4442666a, 0x4442ef10,
  0x34e7317f, 0x582bfd2a, 0x843f6673, 0x84406f16,
  0x4e804b19, 0x82d5d280, 0xc43ce679, 0xc43e6f1a,
  0x681997e6, 0xad7ffd2b, 0x043ae67c, 0x043cef1c,
  0x4e8017e6, 0x82d57d2b, 0xc43c667c, 0xc43def1c,
  0x34e6cb19, 0x582b5280, 0x843e6679, 0x843f6f1a,
  0x23d5a8f7, 0x3bb96ef2, 0x5994667b, 0x599519c6,
  0x1110eeef, 0x1c718e3a, 0x2aa98003, 0x2aa9d576,
  0x2aa9d556, 0x471b0e3b, 0x6aa6800c, 0x6aa7557c,
  0x4442eef0, 0x71c4e391, 0xaaa40012, 0xaaa55580,
  0x5ddc3bbd, 0x9c6f0e3c, 0xeaa20015, 0xeaa3d582,
  0x4442bbbd, 0x71c48e3c, 0xaaa38015, 0xaaa4d582,
  0x2aa96ef0, 0x471a6391, 0x6aa58012, 0x6aa65580,
  0x19984cce, 0x2aa88003, 0x3ffb8014, 0x3ffc002c,
  0x0f5abd72, 0x19973bbf, 0x266219b0, 0x26626694,
  0x1998e667, 0x2aa98002, 0x3ffd000b, 0x3ffd8026,
  0x33320001, 0x55535558, 0x7ffa8011, 0x7ffb802a,
  0x4ccb4cce, 0x7ffd8003, 0xbff88014, 0xbffa002c,
  0x3331ccce, 0x55530003, 0x7ffa0014, 0x7ffb002c,
  0x19988001, 0x2aa8d558, 0x3ffc0011, 0x3ffc802a,
  0x08875ddf, 0x0e36f1ca, 0x15520013, 0x15522ad6,
  0xfe49ce83, 0xfd25ad86, 0xfbb899af, 0xfbb8913e,
  0xfe303503, 0xfcfb0306, 0xfb789b2f, 0xfb78923e,
  0x1999199a, 0x2aa9d557, 0x3ffd8008, 0x3ffe0024,
  0x33326667, 0x55540002, 0x7ffb800b, 0x7ffc8026,
  0x1998e667, 0x2aa98002, 0x3ffd000b, 0x3ffd8026,
  0xffff999a, 0xffff5557, 0xffff0008, 0xffff0024,
  0xeeee7778, 0xe38d71c9, 0xd555000a, 0xd554aad0,
  0xe4b0e81c, 0xd27c2d85, 0xbbbb99a6, 0xbbbb1138,
  0xe4974e9c, 0xd2518305, 0xbb7b9b26, 0xbb7b1238,
  0xe47de84f, 0xd2272dda, 0xbb3c1ca3, 0xbb3b9336,
  0x19994ccd, 0x2aaa2aac, 0x3ffe0005, 0x3ffe8022,
  0xffffcccd, 0xffffaaac, 0xffff8005, 0xffff8022,
  0xe6668000, 0xd5558001, 0xc0018002, 0xc0010020,
  0xd5555dde, 0xb8e39c73, 0x95578004, 0x9556aacc,
  0xcb17ce82, 0xa7d2582f, 0x7bbe19a0, 0x7bbd1134,
  0xcafe3502, 0xa7a7adaf, 0x7b7e1b20, 0x7b7d1234,
  0xcae4ceb5, 0xa77d5884, 0x7b3e9c9d, 0x7b3d9332,
  0xcacb9b9b, 0xa75358ae, 0x7aff9e17, 0x7afe942e,
  0xe6668000, 0xd5558001, 0xc0018002, 0xc0010020,
  0xcccd3333, 0xaaab5556, 0x80037fff, 0x8002801e,
  0xbbbc1111, 0x8e3971c8, 0x55598001, 0x55582aca,
  0xb17e81b5, 0x7d282d84, 0x3bc0199d, 0x3bbe9132,
  0xb164e835, 0x7cfd8304, 0x3b801b1d, 0x3b7e9232,
  0xb14b81e8, 0x7cd32dd9, 0x3b409c9a, 0x3b3f1330,
  0xb1324ece, 0x7ca92e03, 0x3b019e14, 0x3b00142c,
  0xb1194ee7, 0x7c7f8382, 0x3ac31f8b, 0x3ac19526,
  0xe666b333, 0xd555d556, 0xc001ffff, 0xc001801e,
  0xd5559111, 0xb8e3f1c8, 0x95580001, 0x95572aca,
  0xcb1801b5, 0xa7d2ad84, 0x7bbe999d, 0x7bbd9132,
  0xcafe6835, 0xa7a80304, 0x7b7e9b1d, 0x7b7d9232,
  0xcae501e8, 0xa77dadd9, 0x7b3f1c9a, 0x7b3e1330,
  0xcacbcece, 0xa753ae03, 0x7b001e14, 0x7aff142c,
  0xcab2cee7, 0xa72a0382, 0x7ac19f8b, 0x7ac09526,
  0xcaaf9bb7, 0xa724ae32, 0x7ab99fbb, 0x7ab89546,
  0xeeeeddde, 0xe38e1c73, 0xd5560004, 0xd555aacc,
  0xe4b14e82, 0xd27cd82f, 0xbbbc99a0, 0xbbbc1134,
  0xe497b502, 0xd2522daf, 0xbb7c9b20, 0xbb7c1234,
  0xe47e4eb5, 0xd227d884, 0xbb3d1c9d, 0xbb3c9332,
  0xe4651b9b, 0xd1fdd8ae, 0xbafe1e17, 0xbafd942e,
  0xe44c1bb4, 0xd1d42e2d, 0xbabf9f8e, 0xbabf1528,
  0xe448e884, 0xd1ced8dd, 0xbab79fbe, 0xbab71548,
  0xe4484eeb, 0xd1cdd8de, 0xbab61fc7, 0xbab5954e,
  0xf5c270a4, 0xeeeebbbd, 0xe666999e, 0xe6666688,
  0xf5a8d724, 0xeec4113d, 0xe6269b1e, 0xe6266788,
  0xf58f70d7, 0xee99bc12, 0xe5e71c9b, 0xe5e6e886,
  0xf5763dbd, 0xee6fbc3c, 0xe5a81e15, 0xe5a7e982,
  0xf55d3dd6, 0xee4611bb, 0xe5699f8c, 0xe5696a7c,
  0xf55a0aa6, 0xee40bc6b, 0xe5619fbc, 0xe5616a9c,
  0xf559710d, 0xee3fbc6c, 0xe5601fc5, 0xe55feaa2,
  0xf5590aa7, 0xee3f11c2, 0xe55f1fcb, 0xe55eeaa6,
  0xffe66680, 0xffd55581, 0xffc00182, 0xffc00120,
  0xffcd0033, 0xffab0056, 0xff8082ff, 0xff80821e,
  0xffb3cd19, 0xff810080, 0xff418479, 0xff41831a,
  0xff9acd32, 0xff5755ff, 0xff0305f0, 0xff030414,
  0xff979a02, 0xff5200af, 0xfefb0620, 0xfefb0434,
  0xff970069, 0xff5100b0, 0xfef98629, 0xfef9843a,
  0xff969a03, 0xff505606, 0xfef8862f, 0xfef8843e,
  0xff9666d0, 0xff5000b1, 0xfef80632, 0xfef80440,
  0xffd5aad5, 0xffc0817e, 0xffc08100, 0xffc0809f,
  0xffabaaff, 0xff8182f8, 0xff8181fc, 0xff81811d,
  0xff82007e, 0xff43046f, 0xff4302f6, 0xff43019a,
  0xff7cab2e, 0xff3b049f, 0xff3b0316, 0xff3b01aa,
  0xff7bab2f, 0xff3984a8, 0xff39831c, 0xff3981ad,
  0xff7b0085, 0xff3884ae, 0xff388320, 0xff3881af,
  0xff7aab30, 0xff3804b1, 0xff380322, 0xff3801b0,
  0xff7aab30, 0xff3804b1, 0xff380322, 0xff3801b0,
  0xffd6002a, 0xffc1017b, 0xffc100fe, 0xffc1009e,
  0xffac55a9, 0xff8282f2, 0xff8281f8, 0xff82811b,
  0xffa70059, 0xff7a8322, 0xff7a8218, 0xff7a812b,
  0xffa6005a, 0xff79032b, 0xff79021e, 0xff79012e,
  0xffa555b0, 0xff780331, 0xff780222, 0xff780130,
  0xffa5005b, 0xff778334, 0xff778224, 0xff778131,
  0xffa5005b, 0xff778334, 0xff778224, 0xff778131,
  0xffa555b0, 0xff780331, 0xff780222, 0xff780130,
  0xffd6557f, 0xffc18178, 0xffc180fc, 0xffc1809d,
  0xffd1002f, 0xffb981a8, 0xffb9811c, 0xffb980ad,
  0xffd00030, 0xffb801b1, 0xffb80122, 0xffb800b0,
  0xffcf5586, 0xffb701b7, 0xffb70126, 0xffb700b2,
  0xffcf0031, 0xffb681ba, 0xffb68128, 0xffb680b3,
  0xffcf0031, 0xffb681ba, 0xffb68128, 0xffb680b3,
  0xffcf5586, 0xffb701b7, 0xffb70126, 0xffb700b2,
  0xffd00030, 0xffb801b1, 0xffb80122, 0xffb800b0,
  0xfffaaab0, 0xfff80031, 0xfff80022, 0xfff80030,
  0xfff9aab1, 0xfff6803a, 0xfff68028, 0xfff68033,
  0xfff90007, 0xfff58040, 0xfff5802c, 0xfff58035,
  0xfff8aab2, 0xfff50043, 0xfff5002e, 0xfff50036,
  0xfff8aab2, 0xfff50043, 0xfff5002e, 0xfff50036,
  0xfff90007, 0xfff58040, 0xfff5802c, 0xfff58035,
  0xfff9aab1, 0xfff6803a, 0xfff68028, 0xfff68033,
  0xffff0001, 0xfffe800a, 0xfffe8008, 0xfffe8023,
  0xffff0001, 0xfffe800a, 0xfffe8008, 0xfffe8023,
  0xfffe5557, 0xfffd8010, 0xfffd800c, 0xfffd8025,
  0xfffe0002, 0xfffd0013, 0xfffd000e, 0xfffd0026,
  0xfffe0002, 0xfffd0013, 0xfffd000e, 0xfffd0026,
  0xfffe5557, 0xfffd8010, 0xfffd800c, 0xfffd8025,
  0xffff0001, 0xfffe800a, 0xfffe8008, 0xfffe8023,
  0x00045551, 0x00067fda, 0x00067fe8, 0x00068013,
  0x002dffd2, 0x0044fe63, 0x0044feee, 0x0044ff96,
  0xffff5556, 0xffff0007, 0xffff0006, 0xffff0022,
  0xffff0001, 0xfffe800a, 0xfffe8008, 0xfffe8023,
  0xffff0001, 0xfffe800a, 0xfffe8008, 0xfffe8023,
  0xffff5556, 0xffff0007, 0xffff0006, 0xffff0022,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00055550, 0x0007ffd1, 0x0007ffe2, 0x00080010,
  0x002effd1, 0x00467e5a, 0x00467ee8, 0x00467f93,
  0x0058ffa7, 0x00857ce0, 0x00857dec, 0x00857f15,
  0xffffaaab, 0xffff8004, 0xffff8004, 0xffff8021,
  0xffffaaab, 0xffff8004, 0xffff8004, 0xffff8021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000aaaa, 0x0000fffb, 0x0000fffe, 0x0001001e,
  0x0005fffa, 0x0008ffcb, 0x0008ffde, 0x0009000e,
  0x002faa7b, 0x00477e54, 0x00477ee4, 0x00477f91,
  0x0059aa51, 0x00867cda, 0x00867de8, 0x00867f13,
  0x0083ff7c, 0x00c5fb5d, 0x00c5fcea, 0x00c5fe94,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00005555, 0x00007ffe, 0x00008000, 0x0000801f,
  0x0000ffff, 0x00017ff8, 0x00017ffc, 0x0001801d,
  0x0006554f, 0x00097fc8, 0x00097fdc, 0x0009800d,
  0x002fffd0, 0x0047fe51, 0x0047fee2, 0x0047ff90,
  0x0059ffa6, 0x0086fcd7, 0x0086fde6, 0x0086ff12,
  0x008454d1, 0x00c67b5a, 0x00c67ce8, 0x00c67e93,
  0x119543c0, 0x1a5f61c1, 0x1a5f9682, 0x1a5fcb60,
  0x00005555, 0x00007ffe, 0x00008000, 0x0000801f,
  0x0000ffff, 0x00017ff8, 0x00017ffc, 0x0001801d,
  0x0006554f, 0x00097fc8, 0x00097fdc, 0x0009800d,
  0x002fffd0, 0x0047fe51, 0x0047fee2, 0x0047ff90,
  0x0059ffa6, 0x0086fcd7, 0x0086fde6, 0x0086ff12,
  0x008454d1, 0x00c67b5a, 0x00c67ce8, 0x00c67e93,
  0x119543c0, 0x1a5f61c1, 0x1a5f9682, 0x1a5fcb60,
  0x2e06d1f9, 0x4508e1c2, 0x45096bd8, 0x4509f60b,
  0x0000aaaa, 0x0000fffb, 0x0000fffe, 0x0001001e,
  0x0005fffa, 0x0008ffcb, 0x0008ffde, 0x0009000e,
  0x002faa7b, 0x00477e54, 0x00477ee4, 0x00477f91,
  0x0059aa51, 0x00867cda, 0x00867de8, 0x00867f13,
  0x0083ff7c, 0x00c5fb5d, 0x00c5fcea, 0x00c5fe94,
  0x1194ee6b, 0x1a5ee1c4, 0x1a5f1684, 0x1a5f4b61,
  0x2e067ca4, 0x450861c5, 0x4508ebda, 0x4509760c,
  0x58affca5, 0x850561ce, 0x85066be0, 0x8507760f,
  0x00055550, 0x0007ffd1, 0x0007ffe2, 0x00080010,
  0x002effd1, 0x00467e5a, 0x00467ee8, 0x00467f93,
  0x0058ffa7, 0x00857ce0, 0x00857dec, 0x00857f15,
  0x008354d2, 0x00c4fb63, 0x00c4fcee, 0x00c4fe96,
  0x119443c1, 0x1a5de1ca, 0x1a5e1688, 0x1a5e4b63,
  0x2e05d1fa, 0x450761cb, 0x4507ebde, 0x4508760e,
  0x58af51fb, 0x850461d4, 0x85056be4, 0x85067611,
  0x83592751, 0xc501e1da, 0xc5036be8, 0xc504f613,
  0x0029aa81, 0x003e7e8a, 0x003e7f08, 0x003e7fa3,
  0x0053aa57, 0x007d7d10, 0x007d7e0c, 0x007d7f25,
  0x007dff82, 0x00bcfb93, 0x00bcfd0e, 0x00bcfea6,
  0x118eee71, 0x1a55e1fa, 0x1a5616a8, 0x1a564b73,
  0x2e007caa, 0x44ff61fb, 0x44ffebfe, 0x4500761e,
  0x58a9fcab, 0x84fc6204, 0x84fd6c04, 0x84fe7621,
  0x8353d201, 0xc4f9e20a, 0xc4fb6c08, 0xc4fcf623,
  0xadfdfcac, 0x04f7e20d, 0x04f9ec0a, 0x04fbf624,
  0x0029ffd6, 0x003efe87, 0x003eff06, 0x003effa2,
  0x00545501, 0x007e7d0a, 0x007e7e08, 0x007e7f23,
  0x116543f0, 0x1a176371, 0x1a1797a2, 0x1a17cbf0,
  0x2dd6d229, 0x44c0e372, 0x44c16cf8, 0x44c1f69b,
  0x5880522a, 0x84bde37b, 0x84beecfe, 0x84bff69e,
  0x832a2780, 0xc4bb6381, 0xc4bced02, 0xc4be76a0,
  0xadd4522b, 0x04b96384, 0x04bb6d04, 0x04bd76a1,
  0x8329d22b, 0xc4bae384, 0xc4bc6d04, 0xc4bdf6a1,
  0x002a552b, 0x003f7e84, 0x003f7f04, 0x003f7fa1,
  0x113b441a, 0x19d864eb, 0x19d8989e, 0x19d8cc6e,
  0x2dacd253, 0x4481e4ec, 0x44826df4, 0x4482f719,
  0x58565254, 0x847ee4f5, 0x847fedfa, 0x8480f71c,
  0x830027aa, 0xc47c64fb, 0xc47dedfe, 0xc47f771e,
  0xadaa5255, 0x047a64fe, 0x047c6e00, 0x047e771f,
  0x82ffd255, 0xc47be4fe, 0xc47d6e00, 0xc47ef71f,
  0x5855a7aa, 0x847de4fb, 0x847eedfe, 0x847ff71e,
  0x1110eeef, 0x1998e668, 0x1999199c, 0x19994ced,
  0x2d827d28, 0x44426669, 0x4442eef2, 0x44437798,
  0x582bfd29, 0x843f6672, 0x84406ef8, 0x8441779b,
  0x82d5d27f, 0xc43ce678, 0xc43e6efc, 0xc43ff79d,
  0xad7ffd2a, 0x043ae67b, 0x043ceefe, 0x043ef79e,
  0x82d57d2a, 0xc43c667b, 0xc43deefe, 0xc43f779e,
  0x582b527f, 0x843e6678, 0x843f6efc, 0x8440779d,
  0x3bb96ef1, 0x5994667a, 0x599519a8, 0x5995ccf3,
  0x1c718e39, 0x2aa98002, 0x2aa9d558, 0x2aaa2acb,
  0x471b0e3a, 0x6aa6800b, 0x6aa7555e, 0x6aa82ace,
  0x71c4e390, 0xaaa40011, 0xaaa55562, 0xaaa6aad0,
  0x9c6f0e3b, 0xeaa20014, 0xeaa3d564, 0xeaa5aad1,
  0x71c48e3b, 0xaaa38014, 0xaaa4d564, 0xaaa62ad1,
  0x471a6390, 0x6aa58011, 0x6aa65562, 0x6aa72ad0,
  0x2aa88002, 0x3ffb8013, 0x3ffc000e, 0x3ffc8026,
  0x19973bbe, 0x266219af, 0x26626676, 0x2662b35a,
  0x2aa98001, 0x3ffd000a, 0x3ffd8008, 0x3ffe0023,
  0x55535557, 0x7ffa8010, 0x7ffb800c, 0x7ffc8025,
  0x7ffd8002, 0xbff88013, 0xbffa000e, 0xbffb8026,
  0x55530002, 0x7ffa0013, 0x7ffb000e, 0x7ffc0026,
  0x2aa8d557, 0x3ffc0010, 0x3ffc800c, 0x3ffd0025,
  0x0e36f1c9, 0x15520012, 0x15522ab8, 0x1552557b,
  0xfd25ad85, 0xfbb899ae, 0xfbb89120, 0xfbb888af,
  0xfcfb0305, 0xfb789b2e, 0xfb789220, 0xfb78892f,
  0x2aa9d556, 0x3ffd8007, 0x3ffe0006, 0x3ffe8022,
  0x55540001, 0x7ffb800a, 0x7ffc8008, 0x7ffd8023,
  0x2aa98001, 0x3ffd000a, 0x3ffd8008, 0x3ffe0023,
  0xffff5556, 0xffff0007, 0xffff0006, 0xffff0022,
  0xe38d71c8, 0xd5550009, 0xd554aab2, 0xd5545578,
  0xd27c2d84, 0xbbbb99a5, 0xbbbb111a, 0xbbba88ac,
  0xd2518304, 0xbb7b9b25, 0xbb7b121a, 0xbb7a892c,
  0xd2272dd9, 0xbb3c1ca2, 0xbb3b9318, 0xbb3b09ab,
  0x2aaa2aab, 0x3ffe0004, 0x3ffe8004, 0x3fff0021,
  0xffffaaab, 0xffff8004, 0xffff8004, 0xffff8021,
  0xd5558000, 0xc0018001, 0xc0010002, 0xc0008020,
  0xb8e39c72, 0x95578003, 0x9556aaae, 0x9555d576,
  0xa7d2582e, 0x7bbe199f, 0x7bbd1116, 0x7bbc08aa,
  0xa7a7adae, 0x7b7e1b1f, 0x7b7d1216, 0x7b7c092a,
  0xa77d5883, 0x7b3e9c9c, 0x7b3d9314, 0x7b3c89a9,
  0xa75358ad, 0x7aff9e16, 0x7afe9410, 0x7afd8a27,
  0xd5558000, 0xc0018001, 0xc0010002, 0xc0008020,
  0xaaab5555, 0x80037ffe, 0x80028000, 0x8001801f,
  0x8e3971c7, 0x55598000, 0x55582aac, 0x5556d575,
  0x7d282d83, 0x3bc0199c, 0x3bbe9114, 0x3bbd08a9,
  0x7cfd8303, 0x3b801b1c, 0x3b7e9214, 0x3b7d0929,
  0x7cd32dd8, 0x3b409c99, 0x3b3f1312, 0x3b3d89a8,
  0x7ca92e02, 0x3b019e13, 0x3b00140e, 0x3afe8a26,
  0x7c7f8381, 0x3ac31f8a, 0x3ac19508, 0x3ac00aa3,
  0xd555d555, 0xc001fffe, 0xc0018000, 0xc001001f,
  0xb8e3f1c7, 0x95580000, 0x95572aac, 0x95565575,
  0xa7d2ad83, 0x7bbe999c, 0x7bbd9114, 0x7bbc88a9,
  0xa7a80303, 0x7b7e9b1c, 0x7b7d9214, 0x7b7c8929,
  0xa77dadd8, 0x7b3f1c99, 0x7b3e1312, 0x7b3d09a8,
  0xa753ae02, 0x7b001e13, 0x7aff140e, 0x7afe0a26,
  0xa72a0381, 0x7ac19f8a, 0x7ac09508, 0x7abf8aa3,
  0xa724ae31, 0x7ab99fba, 0x7ab89528, 0x7ab78ab3,
  0xe38e1c72, 0xd5560003, 0xd555aaae, 0xd5555576,
  0xd27cd82e, 0xbbbc999f, 0xbbbc1116, 0xbbbb88aa,
  0xd2522dae, 0xbb7c9b1f, 0xbb7c1216, 0xbb7b892a,
  0xd227d883, 0xbb3d1c9c, 0xbb3c9314, 0xbb3c09a9,
  0xd1fdd8ad, 0xbafe1e16, 0xbafd9410, 0xbafd0a27,
  0xd1d42e2c, 0xbabf9f8d, 0xbabf150a, 0xbabe8aa4,
  0xd1ced8dc, 0xbab79fbd, 0xbab7152a, 0xbab68ab4,
  0xd1cdd8dd, 0xbab61fc6, 0xbab59530, 0xbab50ab7,
  0xeeeebbbc, 0xe666999d, 0xe666666a, 0xe6663354,
  0xeec4113c, 0xe6269b1d, 0xe626676a, 0xe62633d4,
  0xee99bc11, 0xe5e71c9a, 0xe5e6e868, 0xe5e6b453,
  0xee6fbc3b, 0xe5a81e14, 0xe5a7e964, 0xe5a7b4d1,
  0xee4611ba, 0xe5699f8b, 0xe5696a5e, 0xe569354e,
  0xee40bc6a, 0xe5619fbb, 0xe5616a7e, 0xe561355e,
  0xee3fbc6b, 0xe5601fc4, 0xe55fea84, 0xe55fb561,
  0xee3f11c1, 0xe55f1fca, 0xe55eea88, 0xe55eb563,
  0xffd55580, 0xffc00181, 0xffc00102, 0xffc000a0,
  0xffab0055, 0xff8082fe, 0xff808200, 0xff80811f,
  0xff81007f, 0xff418478, 0xff4182fc, 0xff41819d,
  0xff5755fe, 0xff0305ef, 0xff0303f6, 0xff03021a,
  0xff5200ae, 0xfefb061f, 0xfefb0416, 0xfefb022a,
  0xff5100af, 0xfef98628, 0xfef9841c, 0xfef9822d,
  0xff505605, 0xfef8862e, 0xfef88420, 0xfef8822f,
  0xff5000b0, 0xfef80631, 0xfef80422, 0xfef80230,
  0xffc0817d, 0xffc080ff, 0xffc08081, 0x003f8020,
  0xff8182f7, 0xff8181fb, 0xff8180ff, 0x007e8020,
  0xff43046e, 0xff4302f5, 0xff43017c, 0x00bd0020,
  0xff3b049e, 0xff3b0315, 0xff3b018c, 0x00c50020,
  0xff3984a7, 0xff39831b, 0xff39818f, 0x00c68020,
  0xff3884ad, 0xff38831f, 0xff388191, 0x00c78020,
  0xff3804b0, 0xff380321, 0xff380192, 0x00c80020,
  0xff3804b0, 0xff380321, 0xff380192, 0x00c80020,
  0xffc1017a, 0xffc100fd, 0xffc10080, 0x003f0020,
  0xff8282f1, 0xff8281f7, 0xff8280fd, 0x007d8020,
  0xff7a8321, 0xff7a8217, 0xff7a810d, 0x00858020,
  0xff79032a, 0xff79021d, 0xff790110, 0x00870020,
  0xff780330, 0xff780221, 0xff780112, 0x00880020,
  0xff778333, 0xff778223, 0xff778113, 0x00888020,
  0xff778333, 0xff778223, 0xff778113, 0x00888020,
  0xff780330, 0xff780221, 0xff780112, 0x00880020,
  0xffc18177, 0xffc180fb, 0xffc1807f, 0x003e8020,
  0xffb981a7, 0xffb9811b, 0xffb9808f, 0x00468020,
  0xffb801b0, 0xffb80121, 0xffb80092, 0x00480020,
  0xffb701b6, 0xffb70125, 0xffb70094, 0x00490020,
  0xffb681b9, 0xffb68127, 0xffb68095, 0x00498020,
  0xffb681b9, 0xffb68127, 0xffb68095, 0x00498020,
  0xffb701b6, 0xffb70125, 0xffb70094, 0x00490020,
  0xffb801b0, 0xffb80121, 0xffb80092, 0x00480020,
  0xfff80030, 0xfff80021, 0xfff80012, 0x00080020,
  0xfff68039, 0xfff68027, 0xfff68015, 0x00098020,
  0xfff5803f, 0xfff5802b, 0xfff58017, 0x000a8020,
  0xfff50042, 0xfff5002d, 0xfff50018, 0x000b0020,
  0xfff50042, 0xfff5002d, 0xfff50018, 0x000b0020,
  0xfff5803f, 0xfff5802b, 0xfff58017, 0x000a8020,
  0xfff68039, 0xfff68027, 0xfff68015, 0x00098020,
  0xfffe8009, 0xfffe8007, 0xfffe8005, 0x00018020,
  0xfffe8009, 0xfffe8007, 0xfffe8005, 0x00018020,
  0xfffd800f, 0xfffd800b, 0xfffd8007, 0x00028020,
  0xfffd0012, 0xfffd000d, 0xfffd0008, 0x00030020,
  0xfffd0012, 0xfffd000d, 0xfffd0008, 0x00030020,
  0xfffd800f, 0xfffd800b, 0xfffd8007, 0x00028020,
  0xfffe8009, 0xfffe8007, 0xfffe8005, 0x00018020,
  0x00067fd9, 0x00067fe7, 0x00067ff5, 0xfff98020,
  0x0044fe62, 0x0044feed, 0x0044ff78, 0xffbb0020,
  0xffff0006, 0xffff0005, 0xffff0004, 0x00010020,
  0xfffe8009, 0xfffe8007, 0xfffe8005, 0x00018020,
  0xfffe8009, 0xfffe8007, 0xfffe8005, 0x00018020,
  0xffff0006, 0xffff0005, 0xffff0004, 0x00010020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0007ffd0, 0x0007ffe1, 0x0007fff2, 0xfff80020,
  0x00467e59, 0x00467ee7, 0x00467f75, 0xffb98020,
  0x00857cdf, 0x00857deb, 0x00857ef7, 0xff7a8020,
  0xffff8003, 0xffff8003, 0xffff8003, 0x00008020,
  0xffff8003, 0xffff8003, 0xffff8003, 0x00008020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000fffa, 0x0000fffd, 0x00010000, 0xffff0020,
  0x0008ffca, 0x0008ffdd, 0x0008fff0, 0xfff70020,
  0x00477e53, 0x00477ee3, 0x00477f73, 0xffb88020,
  0x00867cd9, 0x00867de7, 0x00867ef5, 0xff798020,
  0x00c5fb5c, 0x00c5fce9, 0x00c5fe76, 0xff3a0020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00007ffd, 0x00007fff, 0x00008001, 0xffff8020,
  0x00017ff7, 0x00017ffb, 0x00017fff, 0xfffe8020,
  0x00097fc7, 0x00097fdb, 0x00097fef, 0xfff68020,
  0x0047fe50, 0x0047fee1, 0x0047ff72, 0xffb80020,
  0x0086fcd6, 0x0086fde5, 0x0086fef4, 0xff790020,
  0x00c67b59, 0x00c67ce7, 0x00c67e75, 0xff398020,
  0x1a5f61c0, 0x1a5f9681, 0x1a5fcb42, 0xe5a00020,
  0x00007ffd, 0x00007fff, 0x00008001, 0xffff8020,
  0x00017ff7, 0x00017ffb, 0x00017fff, 0xfffe8020,
  0x00097fc7, 0x00097fdb, 0x00097fef, 0xfff68020,
  0x0047fe50, 0x0047fee1, 0x0047ff72, 0xffb80020,
  0x0086fcd6, 0x0086fde5, 0x0086fef4, 0xff790020,
  0x00c67b59, 0x00c67ce7, 0x00c67e75, 0xff398020,
  0x1a5f61c0, 0x1a5f9681, 0x1a5fcb42, 0xe5a00020,
  0x4508e1c1, 0x45096bd7, 0x4509f5ed, 0xbaf58020,
  0x0000fffa, 0x0000fffd, 0x00010000, 0xffff0020,
  0x0008ffca, 0x0008ffdd, 0x0008fff0, 0xfff70020,
  0x00477e53, 0x00477ee3, 0x00477f73, 0xffb88020,
  0x00867cd9, 0x00867de7, 0x00867ef5, 0xff798020,
  0x00c5fb5c, 0x00c5fce9, 0x00c5fe76, 0xff3a0020,
  0x1a5ee1c3, 0x1a5f1683, 0x1a5f4b43, 0xe5a08020,
  0x450861c4, 0x4508ebd9, 0x450975ee, 0xbaf60020,
  0x850561cd, 0x85066bdf, 0x850775f1, 0x7af78020,
  0x0007ffd0, 0x0007ffe1, 0x0007fff2, 0xfff80020,
  0x00467e59, 0x00467ee7, 0x00467f75, 0xffb98020,
  0x00857cdf, 0x00857deb, 0x00857ef7, 0xff7a8020,
  0x00c4fb62, 0x00c4fced, 0x00c4fe78, 0xff3b0020,
  0x1a5de1c9, 0x1a5e1687, 0x1a5e4b45, 0xe5a18020,
  0x450761ca, 0x4507ebdd, 0x450875f0, 0xbaf70020,
  0x850461d3, 0x85056be3, 0x850675f3, 0x7af88020,
  0xc501e1d9, 0xc5036be7, 0xc504f5f5, 0x3af98020,
  0x003e7e89, 0x003e7f07, 0x003e7f85, 0xffc18020,
  0x007d7d0f, 0x007d7e0b, 0x007d7f07, 0xff828020,
  0x00bcfb92, 0x00bcfd0d, 0x00bcfe88, 0xff430020,
  0x1a55e1f9, 0x1a5616a7, 0x1a564b55, 0xe5a98020,
  0x44ff61fa, 0x44ffebfd, 0x45007600, 0xbaff0020,
  0x84fc6203, 0x84fd6c03, 0x84fe7603, 0x7b008020,
  0xc4f9e209, 0xc4fb6c07, 0xc4fcf605, 0x3b018020,
  0x04f7e20c, 0x04f9ec09, 0x04fbf606, 0xfb020020,
  0x003efe86, 0x003eff05, 0x003eff84, 0xffc10020,
  0x007e7d09, 0x007e7e07, 0x007e7f05, 0xff818020,
  0x1a176370, 0x1a1797a1, 0x1a17cbd2, 0xe5e80020,
  0x44c0e371, 0x44c16cf7, 0x44c1f67d, 0xbb3d8020,
  0x84bde37a, 0x84beecfd, 0x84bff680, 0x7b3f0020,
  0xc4bb6380, 0xc4bced01, 0xc4be7682, 0x3b400020,
  0x04b96383, 0x04bb6d03, 0x04bd7683, 0xfb408020,
  0xc4bae383, 0xc4bc6d03, 0xc4bdf683, 0x3b408020,
  0x003f7e83, 0x003f7f03, 0x003f7f83, 0xffc08020,
  0x19d864ea, 0x19d8989d, 0x19d8cc50, 0xe6270020,
  0x4481e4eb, 0x44826df3, 0x4482f6fb, 0xbb7c8020,
  0x847ee4f4, 0x847fedf9, 0x8480f6fe, 0x7b7e0020,
  0xc47c64fa, 0xc47dedfd, 0xc47f7700, 0x3b7f0020,
  0x047a64fd, 0x047c6dff, 0x047e7701, 0xfb7f8020,
  0xc47be4fd, 0xc47d6dff, 0xc47ef701, 0x3b7f8020,
  0x847de4fa, 0x847eedfd, 0x847ff700, 0x7b7f0020,
  0x1998e667, 0x1999199b, 0x19994ccf, 0xe6668020,
  0x44426668, 0x4442eef1, 0x4443777a, 0xbbbc0020,
  0x843f6671, 0x84406ef7, 0x8441777d, 0x7bbd8020,
  0xc43ce677, 0xc43e6efb, 0xc43ff77f, 0x3bbe8020,
  0x043ae67a, 0x043ceefd, 0x043ef780, 0xfbbf0020,
  0xc43c667a, 0xc43deefd, 0xc43f7780, 0x3bbf0020,
  0x843e6677, 0x843f6efb, 0x8440777f, 0x7bbe8020,
  0x59946679, 0x599519a7, 0x5995ccd5, 0xa6698020,
  0x2aa98001, 0x2aa9d557, 0x2aaa2aad, 0xd5558020,
  0x6aa6800a, 0x6aa7555d, 0x6aa82ab0, 0x95570020,
  0xaaa40010, 0xaaa55561, 0xaaa6aab2, 0x55580020,
  0xeaa20013, 0xeaa3d563, 0xeaa5aab3, 0x15588020,
  0xaaa38013, 0xaaa4d563, 0xaaa62ab3, 0x55588020,
  0x6aa58010, 0x6aa65561, 0x6aa72ab2, 0x95580020,
  0x3ffb8012, 0x3ffc000d, 0x3ffc8008, 0xc0030020,
  0x266219ae, 0x26626675, 0x2662b33c, 0xd99d0020,
  0x3ffd0009, 0x3ffd8007, 0x3ffe0005, 0xc0018020,
  0x7ffa800f, 0x7ffb800b, 0x7ffc8007, 0x80028020,
  0xbff88012, 0xbffa000d, 0xbffb8008, 0x40030020,
  0x7ffa0012, 0x7ffb000d, 0x7ffc0008, 0x80030020,
  0x3ffc000f, 0x3ffc800b, 0x3ffd0007, 0xc0028020,
  0x15520011, 0x15522ab7, 0x1552555d, 0xeaad8020,
  0xfbb899ad, 0xfbb8911f, 0xfbb88891, 0x04478020,
  0xfb789b2d, 0xfb78921f, 0xfb788911, 0x04878020,
  0x3ffd8006, 0x3ffe0005, 0x3ffe8004, 0xc0010020,
  0x7ffb8009, 0x7ffc8007, 0x7ffd8005, 0x80018020,
  0x3ffd0009, 0x3ffd8007, 0x3ffe0005, 0xc0018020,
  0xffff0006, 0xffff0005, 0xffff0004, 0x00010020,
  0xd5550008, 0xd554aab1, 0xd554555a, 0x2aac0020,
  0xbbbb99a4, 0xbbbb1119, 0xbbba888e, 0x44460020,
  0xbb7b9b24, 0xbb7b1219, 0xbb7a890e, 0x44860020,
  0xbb3c1ca1, 0xbb3b9317, 0xbb3b098d, 0x44c58020,
  0x3ffe0003, 0x3ffe8003, 0x3fff0003, 0xc0008020,
  0xffff8003, 0xffff8003, 0xffff8003, 0x00008020,
  0xc0018000, 0xc0010001, 0xc0008002, 0x40000020,
  0x95578002, 0x9556aaad, 0x9555d558, 0x6aab0020,
  0x7bbe199e, 0x7bbd1115, 0x7bbc088c, 0x84450020,
  0x7b7e1b1e, 0x7b7d1215, 0x7b7c090c, 0x84850020,
  0x7b3e9c9b, 0x7b3d9313, 0x7b3c898b, 0x84c48020,
  0x7aff9e15, 0x7afe940f, 0x7afd8a09, 0x85038020,
  0xc0018000, 0xc0010001, 0xc0008002, 0x40000020,
  0x80037ffd, 0x80027fff, 0x80018001, 0x7fff8020,
  0x55597fff, 0x55582aab, 0x5556d557, 0xaaaa8020,
  0x3bc0199b, 0x3bbe9113, 0x3bbd088b, 0xc4448020,
  0x3b801b1b, 0x3b7e9213, 0x3b7d090b, 0xc4848020,
  0x3b409c98, 0x3b3f1311, 0x3b3d898a, 0xc4c40020,
  0x3b019e12, 0x3b00140d, 0x3afe8a08, 0xc5030020,
  0x3ac31f89, 0x3ac19507, 0x3ac00a85, 0xc5418020,
  0xc001fffd, 0xc0017fff, 0xc0010001, 0x3fff8020,
  0x9557ffff, 0x95572aab, 0x95565557, 0x6aaa8020,
  0x7bbe999b, 0x7bbd9113, 0x7bbc888b, 0x84448020,
  0x7b7e9b1b, 0x7b7d9213, 0x7b7c890b, 0x84848020,
  0x7b3f1c98, 0x7b3e1311, 0x7b3d098a, 0x84c40020,
  0x7b001e12, 0x7aff140d, 0x7afe0a08, 0x85030020,
  0x7ac19f89, 0x7ac09507, 0x7abf8a85, 0x85418020,
  0x7ab99fb9, 0x7ab89527, 0x7ab78a95, 0x85498020,
  0xd5560002, 0xd555aaad, 0xd5555558, 0x2aab0020,
  0xbbbc999e, 0xbbbc1115, 0xbbbb888c, 0x44450020,
  0xbb7c9b1e, 0xbb7c1215, 0xbb7b890c, 0x44850020,
  0xbb3d1c9b, 0xbb3c9313, 0xbb3c098b, 0x44c48020,
  0xbafe1e15, 0xbafd940f, 0xbafd0a09, 0x45038020,
  0xbabf9f8c, 0xbabf1509, 0xbabe8a86, 0x45420020,
  0xbab79fbc, 0xbab71529, 0xbab68a96, 0x454a0020,
  0xbab61fc5, 0xbab5952f, 0xbab50a99, 0x454b8020,
  0xe666999c, 0xe6666669, 0xe6663336, 0x199a0020,
  0xe6269b1c, 0xe6266769, 0xe62633b6, 0x19da0020,
  0xe5e71c99, 0xe5e6e867, 0xe5e6b435, 0x1a198020,
  0xe5a81e13, 0xe5a7e963, 0xe5a7b4b3, 0x1a588020,
  0xe5699f8a, 0xe5696a5d, 0xe5693530, 0x1a970020,
  0xe5619fba, 0xe5616a7d, 0xe5613540, 0x1a9f0020,
  0xe5601fc3, 0xe55fea83, 0xe55fb543, 0x1aa08020,
  0xe55f1fc9, 0xe55eea87, 0xe55eb545, 0x1aa18020,
  0xffc00180, 0xffc00101, 0xffc00082, 0x00400020,
  0xff8082fd, 0xff8081ff, 0xff808101, 0x007f8020,
  0xff418477, 0xff4182fb, 0xff41817f, 0x00be8020,
  0xff0305ee, 0xff0303f5, 0xff0301fc, 0x00fd0020,
  0xfefb061e, 0xfefb0415, 0xfefb020c, 0x01050020,
  0xfef98627, 0xfef9841b, 0xfef9820f, 0x01068020,
  0xfef8862d, 0xfef8841f, 0xfef88211, 0x01078020,
  0xfef80630, 0xfef80421, 0xfef80212, 0x01080020,
  0xffc080fe, 0xffc08080, 0x003f8002, 0x003f7fa1,
  0xff8181fa, 0xff8180fe, 0x007e8002, 0x007e7f23,
  0xff4302f4, 0xff43017b, 0x00bd0002, 0x00bcfea6,
  0xff3b0314, 0xff3b018b, 0x00c50002, 0x00c4fe96,
  0xff39831a, 0xff39818e, 0x00c68002, 0x00c67e93,
  0xff38831e, 0xff388190, 0x00c78002, 0x00c77e91,
  0xff380320, 0xff380191, 0x00c80002, 0x00c7fe90,
  0xff380320, 0xff380191, 0x00c80002, 0x00c7fe90,
  0xffc100fc, 0xffc1007f, 0x003f0002, 0x003effa2,
  0xff8281f6, 0xff8280fc, 0x007d8002, 0x007d7f25,
  0xff7a8216, 0xff7a810c, 0x00858002, 0x00857f15,
  0xff79021c, 0xff79010f, 0x00870002, 0x0086ff12,
  0xff780220, 0xff780111, 0x00880002, 0x0087ff10,
  0xff778222, 0xff778112, 0x00888002, 0x00887f0f,
  0xff778222, 0xff778112, 0x00888002, 0x00887f0f,
  0xff780220, 0xff780111, 0x00880002, 0x0087ff10,
  0xffc180fa, 0xffc1807e, 0x003e8002, 0x003e7fa3,
  0xffb9811a, 0xffb9808e, 0x00468002, 0x00467f93,
  0xffb80120, 0xffb80091, 0x00480002, 0x0047ff90,
  0xffb70124, 0xffb70093, 0x00490002, 0x0048ff8e,
  0xffb68126, 0xffb68094, 0x00498002, 0x00497f8d,
  0xffb68126, 0xffb68094, 0x00498002, 0x00497f8d,
  0xffb70124, 0xffb70093, 0x00490002, 0x0048ff8e,
  0xffb80120, 0xffb80091, 0x00480002, 0x0047ff90,
  0xfff80020, 0xfff80011, 0x00080002, 0x00080010,
  0xfff68026, 0xfff68014, 0x00098002, 0x0009800d,
  0xfff5802a, 0xfff58016, 0x000a8002, 0x000a800b,
  0xfff5002c, 0xfff50017, 0x000b0002, 0x000b000a,
  0xfff5002c, 0xfff50017, 0x000b0002, 0x000b000a,
  0xfff5802a, 0xfff58016, 0x000a8002, 0x000a800b,
  0xfff68026, 0xfff68014, 0x00098002, 0x0009800d,
  0xfffe8006, 0xfffe8004, 0x00018002, 0x0001801d,
  0xfffe8006, 0xfffe8004, 0x00018002, 0x0001801d,
  0xfffd800a, 0xfffd8006, 0x00028002, 0x0002801b,
  0xfffd000c, 0xfffd0007, 0x00030002, 0x0003001a,
  0xfffd000c, 0xfffd0007, 0x00030002, 0x0003001a,
  0xfffd800a, 0xfffd8006, 0x00028002, 0x0002801b,
  0xfffe8006, 0xfffe8004, 0x00018002, 0x0001801d,
  0x00067fe6, 0x00067ff4, 0xfff98002, 0xfff9802d,
  0x0044feec, 0x0044ff77, 0xffbb0002, 0xffbb00aa,
  0xffff0004, 0xffff0003, 0x00010002, 0x0001001e,
  0xfffe8006, 0xfffe8004, 0x00018002, 0x0001801d,
  0xfffe8006, 0xfffe8004, 0x00018002, 0x0001801d,
  0xffff0004, 0xffff0003, 0x00010002, 0x0001001e,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0007ffe0, 0x0007fff1, 0xfff80002, 0xfff80030,
  0x00467ee6, 0x00467f74, 0xffb98002, 0xffb980ad,
  0x00857dea, 0x00857ef6, 0xff7a8002, 0xff7a812b,
  0xffff8002, 0xffff8002, 0x00008002, 0x0000801f,
  0xffff8002, 0xffff8002, 0x00008002, 0x0000801f,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000fffc, 0x0000ffff, 0xffff0002, 0xffff0022,
  0x0008ffdc, 0x0008ffef, 0xfff70002, 0xfff70032,
  0x00477ee2, 0x00477f72, 0xffb88002, 0xffb880af,
  0x00867de6, 0x00867ef4, 0xff798002, 0xff79812d,
  0x00c5fce8, 0x00c5fe75, 0xff3a0002, 0xff3a01ac,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00007ffe, 0x00008000, 0xffff8002, 0xffff8021,
  0x00017ffa, 0x00017ffe, 0xfffe8002, 0xfffe8023,
  0x00097fda, 0x00097fee, 0xfff68002, 0xfff68033,
  0x0047fee0, 0x0047ff71, 0xffb80002, 0xffb800b0,
  0x0086fde4, 0x0086fef3, 0xff790002, 0xff79012e,
  0x00c67ce6, 0x00c67e74, 0xff398002, 0xff3981ad,
  0x1a5f9680, 0x1a5fcb41, 0xe5a00002, 0xe5a034e0,
  0x00007ffe, 0x00008000, 0xffff8002, 0xffff8021,
  0x00017ffa, 0x00017ffe, 0xfffe8002, 0xfffe8023,
  0x00097fda, 0x00097fee, 0xfff68002, 0xfff68033,
  0x0047fee0, 0x0047ff71, 0xffb80002, 0xffb800b0,
  0x0086fde4, 0x0086fef3, 0xff790002, 0xff79012e,
  0x00c67ce6, 0x00c67e74, 0xff398002, 0xff3981ad,
  0x1a5f9680, 0x1a5fcb41, 0xe5a00002, 0xe5a034e0,
  0x45096bd6, 0x4509f5ec, 0xbaf58002, 0xbaf60a35,
  0x0000fffc, 0x0000ffff, 0xffff0002, 0xffff0022,
  0x0008ffdc, 0x0008ffef, 0xfff70002, 0xfff70032,
  0x00477ee2, 0x00477f72, 0xffb88002, 0xffb880af,
  0x00867de6, 0x00867ef4, 0xff798002, 0xff79812d,
  0x00c5fce8, 0x00c5fe75, 0xff3a0002, 0xff3a01ac,
  0x1a5f1682, 0x1a5f4b42, 0xe5a08002, 0xe5a0b4df,
  0x4508ebd8, 0x450975ed, 0xbaf60002, 0xbaf68a34,
  0x85066bde, 0x850775f0, 0x7af78002, 0x7af88a31,
  0x0007ffe0, 0x0007fff1, 0xfff80002, 0xfff80030,
  0x00467ee6, 0x00467f74, 0xffb98002, 0xffb980ad,
  0x00857dea, 0x00857ef6, 0xff7a8002, 0xff7a812b,
  0x00c4fcec, 0x00c4fe77, 0xff3b0002, 0xff3b01aa,
  0x1a5e1686, 0x1a5e4b44, 0xe5a18002, 0xe5a1b4dd,
  0x4507ebdc, 0x450875ef, 0xbaf70002, 0xbaf78a32,
  0x85056be2, 0x850675f2, 0x7af88002, 0x7af98a2f,
  0xc5036be6, 0xc504f5f4, 0x3af98002, 0x3afb0a2d,
  0x003e7f06, 0x003e7f84, 0xffc18002, 0xffc1809d,
  0x007d7e0a, 0x007d7f06, 0xff828002, 0xff82811b,
  0x00bcfd0c, 0x00bcfe87, 0xff430002, 0xff43019a,
  0x1a5616a6, 0x1a564b54, 0xe5a98002, 0xe5a9b4cd,
  0x44ffebfc, 0x450075ff, 0xbaff0002, 0xbaff8a22,
  0x84fd6c02, 0x84fe7602, 0x7b008002, 0x7b018a1f,
  0xc4fb6c06, 0xc4fcf604, 0x3b018002, 0x3b030a1d,
  0x04f9ec08, 0x04fbf605, 0xfb020002, 0xfb040a1c,
  0x003eff04, 0x003eff83, 0xffc10002, 0xffc1009e,
  0x007e7e06, 0x007e7f04, 0xff818002, 0xff81811d,
  0x1a1797a0, 0x1a17cbd1, 0xe5e80002, 0xe5e83450,
  0x44c16cf6, 0x44c1f67c, 0xbb3d8002, 0xbb3e09a5,
  0x84beecfc, 0x84bff67f, 0x7b3f0002, 0x7b4009a2,
  0xc4bced00, 0xc4be7681, 0x3b400002, 0x3b4189a0,
  0x04bb6d02, 0x04bd7682, 0xfb408002, 0xfb42899f,
  0xc4bc6d02, 0xc4bdf682, 0x3b408002, 0x3b42099f,
  0x003f7f02, 0x003f7f82, 0xffc08002, 0xffc0809f,
  0x19d8989c, 0x19d8cc4f, 0xe6270002, 0xe62733d2,
  0x44826df2, 0x4482f6fa, 0xbb7c8002, 0xbb7d0927,
  0x847fedf8, 0x8480f6fd, 0x7b7e0002, 0x7b7f0924,
  0xc47dedfc, 0xc47f76ff, 0x3b7f0002, 0x3b808922,
  0x047c6dfe, 0x047e7700, 0xfb7f8002, 0xfb818921,
  0xc47d6dfe, 0xc47ef700, 0x3b7f8002, 0x3b810921,
  0x847eedfc, 0x847ff6ff, 0x7b7f0002, 0x7b800922,
  0x1999199a, 0x19994cce, 0xe6668002, 0xe666b353,
  0x4442eef0, 0x44437779, 0xbbbc0002, 0xbbbc88a8,
  0x84406ef6, 0x8441777c, 0x7bbd8002, 0x7bbe88a5,
  0xc43e6efa, 0xc43ff77e, 0x3bbe8002, 0x3bc008a3,
  0x043ceefc, 0x043ef77f, 0xfbbf0002, 0xfbc108a2,
  0xc43deefc, 0xc43f777f, 0x3bbf0002, 0x3bc088a2,
  0x843f6efa, 0x8440777e, 0x7bbe8002, 0x7bbf88a3,
  0x599519a6, 0x5995ccd4, 0xa6698002, 0xa66a334d,
  0x2aa9d556, 0x2aaa2aac, 0xd5558002, 0xd555d575,
  0x6aa7555c, 0x6aa82aaf, 0x95570002, 0x9557d572,
  0xaaa55560, 0xaaa6aab1, 0x55580002, 0x55595570,
  0xeaa3d562, 0xeaa5aab2, 0x15588002, 0x155a556f,
  0xaaa4d562, 0xaaa62ab2, 0x55588002, 0x5559d56f,
  0x6aa65560, 0x6aa72ab1, 0x95580002, 0x9558d570,
  0x3ffc000c, 0x3ffc8007, 0xc0030002, 0xc003801a,
  0x26626674, 0x2662b33b, 0xd99d0002, 0xd99d4ce6,
  0x3ffd8006, 0x3ffe0004, 0xc0018002, 0xc002001d,
  0x7ffb800a, 0x7ffc8006, 0x80028002, 0x8003801b,
  0xbffa000c, 0xbffb8007, 0x40030002, 0x4004801a,
  0x7ffb000c, 0x7ffc0007, 0x80030002, 0x8004001a,
  0x3ffc800a, 0x3ffd0006, 0xc0028002, 0xc003001b,
  0x15522ab6, 0x1552555c, 0xeaad8002, 0xeaadaac5,
  0xfbb8911e, 0xfbb88890, 0x04478002, 0x04477791,
  0xfb78921e, 0xfb788910, 0x04878002, 0x04877711,
  0x3ffe0004, 0x3ffe8003, 0xc0010002, 0xc001801e,
  0x7ffc8006, 0x7ffd8004, 0x80018002, 0x8002801d,
  0x3ffd8006, 0x3ffe0004, 0xc0018002, 0xc002001d,
  0xffff0004, 0xffff0003, 0x00010002, 0x0001001e,
  0xd554aab0, 0xd5545559, 0x2aac0002, 0x2aabaac8,
  0xbbbb1118, 0xbbba888d, 0x44460002, 0x44457794,
  0xbb7b1218, 0xbb7a890d, 0x44860002, 0x44857714,
  0xbb3b9316, 0xbb3b098c, 0x44c58002, 0x44c4f695,
  0x3ffe8002, 0x3fff0002, 0xc0008002, 0xc001001f,
  0xffff8002, 0xffff8002, 0x00008002, 0x0000801f,
  0xc0010000, 0xc0008001, 0x40000002, 0x3fff8020,
  0x9556aaac, 0x9555d557, 0x6aab0002, 0x6aaa2aca,
  0x7bbd1114, 0x7bbc088b, 0x84450002, 0x8443f796,
  0x7b7d1214, 0x7b7c090b, 0x84850002, 0x8483f716,
  0x7b3d9312, 0x7b3c898a, 0x84c48002, 0x84c37697,
  0x7afe940e, 0x7afd8a08, 0x85038002, 0x85027619,
  0xc0010000, 0xc0008001, 0x40000002, 0x3fff8020,
  0x80027ffe, 0x80018000, 0x7fff8002, 0x7ffe8021,
  0x55582aaa, 0x5556d556, 0xaaaa8002, 0xaaa92acb,
  0x3bbe9112, 0x3bbd088a, 0xc4448002, 0xc442f797,
  0x3b7e9212, 0x3b7d090a, 0xc4848002, 0xc482f717,
  0x3b3f1310, 0x3b3d8989, 0xc4c40002, 0xc4c27698,
  0x3b00140c, 0x3afe8a07, 0xc5030002, 0xc501761a,
  0x3ac19506, 0x3ac00a84, 0xc5418002, 0xc53ff59d,
  0xc0017ffe, 0xc0010000, 0x3fff8002, 0x3fff0021,
  0x95572aaa, 0x95565556, 0x6aaa8002, 0x6aa9aacb,
  0x7bbd9112, 0x7bbc888a, 0x84448002, 0x84437797,
  0x7b7d9212, 0x7b7c890a, 0x84848002, 0x84837717,
  0x7b3e1310, 0x7b3d0989, 0x84c40002, 0x84c2f698,
  0x7aff140c, 0x7afe0a07, 0x85030002, 0x8501f61a,
  0x7ac09506, 0x7abf8a84, 0x85418002, 0x8540759d,
  0x7ab89526, 0x7ab78a94, 0x85498002, 0x8548758d,
  0xd555aaac, 0xd5555557, 0x2aab0002, 0x2aaaaaca,
  0xbbbc1114, 0xbbbb888b, 0x44450002, 0x44447796,
  0xbb7c1214, 0xbb7b890b, 0x44850002, 0x44847716,
  0xbb3c9312, 0xbb3c098a, 0x44c48002, 0x44c3f697,
  0xbafd940e, 0xbafd0a08, 0x45038002, 0x4502f619,
  0xbabf1508, 0xbabe8a85, 0x45420002, 0x4541759c,
  0xbab71528, 0xbab68a95, 0x454a0002, 0x4549758c,
  0xbab5952e, 0xbab50a98, 0x454b8002, 0x454af589,
  0xe6666668, 0xe6663335, 0x199a0002, 0x1999ccec,
  0xe6266768, 0xe62633b5, 0x19da0002, 0x19d9cc6c,
  0xe5e6e866, 0xe5e6b434, 0x1a198002, 0x1a194bed,
  0xe5a7e962, 0xe5a7b4b2, 0x1a588002, 0x1a584b6f,
  0xe5696a5c, 0xe569352f, 0x1a970002, 0x1a96caf2,
  0xe5616a7c, 0xe561353f, 0x1a9f0002, 0x1a9ecae2,
  0xe55fea82, 0xe55fb542, 0x1aa08002, 0x1aa04adf,
  0xe55eea86, 0xe55eb544, 0x1aa18002, 0x1aa14add,
  0xffc00100, 0xffc00081, 0x00400002, 0x003fffa0,
  0xff8081fe, 0xff808100, 0x007f8002, 0x007f7f21,
  0xff4182fa, 0xff41817e, 0x00be8002, 0x00be7ea3,
  0xff0303f4, 0xff0301fb, 0x00fd0002, 0x00fcfe26,
  0xfefb0414, 0xfefb020b, 0x01050002, 0x0104fe16,
  0xfef9841a, 0xfef9820e, 0x01068002, 0x01067e13,
  0xfef8841e, 0xfef88210, 0x01078002, 0x01077e11,
  0xfef80420, 0xfef80211, 0x01080002, 0x0107fe10,
  0xffc0807f, 0x003f8001, 0x003f7f83, 0x002a55ca,
  0xff8180fd, 0x007e8001, 0x007e7f05, 0x0054561e,
  0xff43017a, 0x00bd0001, 0x00bcfe88, 0x007e011c,
  0xff3b018a, 0x00c50001, 0x00c4fe78, 0x0083567c,
  0xff39818d, 0x00c68001, 0x00c67e75, 0x0084567e,
  0xff38818f, 0x00c78001, 0x00c77e73, 0x0085012a,
  0xff380190, 0x00c80001, 0x00c7fe72, 0x00855680,
  0xff380190, 0x00c80001, 0x00c7fe72, 0x00855680,
  0xffc1007e, 0x003f0001, 0x003eff84, 0x002a0074,
  0xff8280fb, 0x007d8001, 0x007d7f07, 0x0053ab72,
  0xff7a810b, 0x00858001, 0x00857ef7, 0x005900d2,
  0xff79010e, 0x00870001, 0x0086fef4, 0x005a00d4,
  0xff780110, 0x00880001, 0x0087fef2, 0x005aab80,
  0xff778111, 0x00888001, 0x00887ef1, 0x005b00d6,
  0xff778111, 0x00888001, 0x00887ef1, 0x005b00d6,
  0xff780110, 0x00880001, 0x0087fef2, 0x005aab80,
  0xffc1807d, 0x003e8001, 0x003e7f85, 0x0029ab1e,
  0xffb9808d, 0x00468001, 0x00467f75, 0x002f007e,
  0xffb80090, 0x00480001, 0x0047ff72, 0x00300080,
  0xffb70092, 0x00490001, 0x0048ff70, 0x0030ab2c,
  0xffb68093, 0x00498001, 0x00497f6f, 0x00310082,
  0xffb68093, 0x00498001, 0x00497f6f, 0x00310082,
  0xffb70092, 0x00490001, 0x0048ff70, 0x0030ab2c,
  0xffb80090, 0x00480001, 0x0047ff72, 0x00300080,
  0xfff80010, 0x00080001, 0x0007fff2, 0x00055580,
  0xfff68013, 0x00098001, 0x00097fef, 0x00065582,
  0xfff58015, 0x000a8001, 0x000a7fed, 0x0007002e,
  0xfff50016, 0x000b0001, 0x000affec, 0x00075584,
  0xfff50016, 0x000b0001, 0x000affec, 0x00075584,
  0xfff58015, 0x000a8001, 0x000a7fed, 0x0007002e,
  0xfff68013, 0x00098001, 0x00097fef, 0x00065582,
  0xfffe8003, 0x00018001, 0x00017fff, 0x00010022,
  0xfffe8003, 0x00018001, 0x00017fff, 0x00010022,
  0xfffd8005, 0x00028001, 0x00027ffd, 0x0001aace,
  0xfffd0006, 0x00030001, 0x0002fffc, 0x00020024,
  0xfffd0006, 0x00030001, 0x0002fffc, 0x00020024,
  0xfffd8005, 0x00028001, 0x00027ffd, 0x0001aace,
  0xfffe8003, 0x00018001, 0x00017fff, 0x00010022,
  0x00067ff3, 0xfff98001, 0xfff9800f, 0xfffbaac2,
  0x0044ff76, 0xffbb0001, 0xffbb008c, 0xffd1ffc4,
  0xffff0002, 0x00010001, 0x00010000, 0x0000aacc,
  0xfffe8003, 0x00018001, 0x00017fff, 0x00010022,
  0xfffe8003, 0x00018001, 0x00017fff, 0x00010022,
  0xffff0002, 0x00010001, 0x00010000, 0x0000aacc,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0007fff0, 0xfff80001, 0xfff80012, 0xfffaaac0,
  0x00467f73, 0xffb98001, 0xffb9808f, 0xffd0ffc2,
  0x00857ef5, 0xff7a8001, 0xff7a810d, 0xffa6ff6e,
  0xffff8001, 0x00008001, 0x00008001, 0x00005576,
  0xffff8001, 0x00008001, 0x00008001, 0x00005576,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000fffe, 0xffff0001, 0xffff0004, 0xffff5574,
  0x0008ffee, 0xfff70001, 0xfff70014, 0xfffa0014,
  0x00477f71, 0xffb88001, 0xffb88091, 0xffd05516,
  0x00867ef3, 0xff798001, 0xff79810f, 0xffa654c2,
  0x00c5fe74, 0xff3a0001, 0xff3a018e, 0xff7bff18,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00007fff, 0xffff8001, 0xffff8003, 0xffffaaca,
  0x00017ffd, 0xfffe8001, 0xfffe8005, 0xffff001e,
  0x00097fed, 0xfff68001, 0xfff68015, 0xfff9aabe,
  0x0047ff70, 0xffb80001, 0xffb80092, 0xffcfffc0,
  0x0086fef2, 0xff790001, 0xff790110, 0xffa5ff6c,
  0x00c67e73, 0xff398001, 0xff39818f, 0xff7ba9c2,
  0x1a5fcb40, 0xe5a00001, 0xe5a034c2, 0xee6a87a0,
  0x00007fff, 0xffff8001, 0xffff8003, 0xffffaaca,
  0x00017ffd, 0xfffe8001, 0xfffe8005, 0xffff001e,
  0x00097fed, 0xfff68001, 0xfff68015, 0xfff9aabe,
  0x0047ff70, 0xffb80001, 0xffb80092, 0xffcfffc0,
  0x0086fef2, 0xff790001, 0xff790110, 0xffa5ff6c,
  0x00c67e73, 0xff398001, 0xff39818f, 0xff7ba9c2,
  0x1a5fcb40, 0xe5a00001, 0xe5a034c2, 0xee6a87a0,
  0x4509f5eb, 0xbaf58001, 0xbaf60a17, 0xd1f8a412,
  0x0000fffe, 0xffff0001, 0xffff0004, 0xffff5574,
  0x0008ffee, 0xfff70001, 0xfff70014, 0xfffa0014,
  0x00477f71, 0xffb88001, 0xffb88091, 0xffd05516,
  0x00867ef3, 0xff798001, 0xff79810f, 0xffa654c2,
  0x00c5fe74, 0xff3a0001, 0xff3a018e, 0xff7bff18,
  0x1a5f4b41, 0xe5a08001, 0xe5a0b4c1, 0xee6adcf6,
  0x450975ec, 0xbaf60001, 0xbaf68a16, 0xd1f8f968,
  0x850775ef, 0x7af78001, 0x7af88a13, 0xa74ef96a,
  0x0007fff0, 0xfff80001, 0xfff80012, 0xfffaaac0,
  0x00467f73, 0xffb98001, 0xffb9808f, 0xffd0ffc2,
  0x00857ef5, 0xff7a8001, 0xff7a810d, 0xffa6ff6e,
  0x00c4fe76, 0xff3b0001, 0xff3b018c, 0xff7ca9c4,
  0x1a5e4b43, 0xe5a18001, 0xe5a1b4bf, 0xee6b87a2,
  0x450875ee, 0xbaf70001, 0xbaf78a14, 0xd1f9a414,
  0x850675f1, 0x7af88001, 0x7af98a11, 0xa74fa416,
  0xc504f5f3, 0x3af98001, 0x3afb0a0f, 0x7ca54ec2,
  0x003e7f83, 0xffc18001, 0xffc1807f, 0xffd65522,
  0x007d7f05, 0xff828001, 0xff8280fd, 0xffac54ce,
  0x00bcfe86, 0xff430001, 0xff43017c, 0xff81ff24,
  0x1a564b53, 0xe5a98001, 0xe5a9b4af, 0xee70dd02,
  0x450075fe, 0xbaff0001, 0xbaff8a04, 0xd1fef974,
  0x84fe7601, 0x7b008001, 0x7b018a01, 0xa754f976,
  0xc4fcf603, 0x3b018001, 0x3b0309ff, 0x7caaa422,
  0x04fbf604, 0xfb020001, 0xfb0409fe, 0x51fff978,
  0x003eff82, 0xffc10001, 0xffc10080, 0xffd5ffcc,
  0x007e7f03, 0xff818001, 0xff8180ff, 0xffabaa22,
  0x1a17cbd0, 0xe5e80001, 0xe5e83432, 0xee9a8800,
  0x44c1f67b, 0xbb3d8001, 0xbb3e0987, 0xd228a472,
  0x84bff67e, 0x7b3f0001, 0x7b400984, 0xa77ea474,
  0xc4be7680, 0x3b400001, 0x3b418982, 0x7cd44f20,
  0x04bd7681, 0xfb408001, 0xfb428981, 0x5229a476,
  0xc4bdf681, 0x3b408001, 0x3b420981, 0x7cd4a476,
  0x003f7f81, 0xffc08001, 0xffc08081, 0xffd5aa76,
  0x19d8cc4e, 0xe6270001, 0xe62733b4, 0xeec48854,
  0x4482f6f9, 0xbb7c8001, 0xbb7d0909, 0xd252a4c6,
  0x8480f6fc, 0x7b7e0001, 0x7b7f0906, 0xa7a8a4c8,
  0xc47f76fe, 0x3b7f0001, 0x3b808904, 0x7cfe4f74,
  0x047e76ff, 0xfb7f8001, 0xfb818903, 0x5253a4ca,
  0xc47ef6ff, 0x3b7f8001, 0x3b810903, 0x7cfea4ca,
  0x847ff6fe, 0x7b7f0001, 0x7b800904, 0xa7a94f74,
  0x19994ccd, 0xe6668001, 0xe666b335, 0xeeeeddfe,
  0x44437778, 0xbbbc0001, 0xbbbc888a, 0xd27cfa70,
  0x8441777b, 0x7bbd8001, 0x7bbe8887, 0xa7d2fa72,
  0xc43ff77d, 0x3bbe8001, 0x3bc00885, 0x7d28a51e,
  0x043ef77e, 0xfbbf0001, 0xfbc10884, 0x527dfa74,
  0xc43f777e, 0x3bbf0001, 0x3bc08884, 0x7d28fa74,
  0x8440777d, 0x7bbe8001, 0x7bbf8885, 0xa7d3a51e,
  0x5995ccd3, 0xa6698001, 0xa66a332f, 0xc445de02,
  0x2aaa2aab, 0xd5558001, 0xd555d557, 0xe38e1c92,
  0x6aa82aae, 0x95570001, 0x9557d554, 0xb8e41c94,
  0xaaa6aab0, 0x55580001, 0x55595552, 0x8e39c740,
  0xeaa5aab1, 0x15588001, 0x155a5551, 0x638f1c96,
  0xaaa62ab1, 0x55588001, 0x5559d551, 0x8e3a1c96,
  0x6aa72ab0, 0x95580001, 0x9558d552, 0xb8e4c740,
  0x3ffc8006, 0xc0030001, 0xc0037ffc, 0xd5570024,
  0x2662b33a, 0xd99d0001, 0xd99d4cc8, 0xe668779c,
  0x3ffe0003, 0xc0018001, 0xc001ffff, 0xd5560022,
  0x7ffc8005, 0x80028001, 0x80037ffd, 0xaaabaace,
  0xbffb8006, 0x40030001, 0x40047ffc, 0x80010024,
  0x7ffc0006, 0x80030001, 0x8003fffc, 0xaaac0024,
  0x3ffd0005, 0xc0028001, 0xc002fffd, 0xd556aace,
  0x1552555b, 0xeaad8001, 0xeaadaaa7, 0xf1c8e3b2,
  0xfbb8888f, 0x04478001, 0x04477773, 0x02da5b2a,
  0xfb78890f, 0x04878001, 0x048776f3, 0x0305062a,
  0x3ffe8002, 0xc0010001, 0xc0018000, 0xd555aacc,
  0x7ffd8003, 0x80018001, 0x80027fff, 0xaaab0022,
  0x3ffe0003, 0xc0018001, 0xc001ffff, 0xd5560022,
  0xffff0002, 0x00010001, 0x00010000, 0x0000aacc,
  0xd5545558, 0x2aac0001, 0x2aabaaaa, 0x1c72e3b0,
  0xbbba888c, 0x44460001, 0x44457776, 0x2d845b28,
  0xbb7a890c, 0x44860001, 0x448576f6, 0x2daf0628,
  0xbb3b098b, 0x44c58001, 0x44c4f677, 0x2dd95bd2,
  0x3fff0001, 0xc0008001, 0xc0010001, 0xd5555576,
  0xffff8001, 0x00008001, 0x00008001, 0x00005576,
  0xc0008000, 0x40000001, 0x3fff8002, 0x2aab0020,
  0x9555d556, 0x6aab0001, 0x6aaa2aac, 0x471d3904,
  0x7bbc088a, 0x84450001, 0x8443f778, 0x582eb07c,
  0x7b7c090a, 0x84850001, 0x8483f6f8, 0x58595b7c,
  0x7b3c8989, 0x84c48001, 0x84c37679, 0x5883b126,
  0x7afd8a07, 0x85038001, 0x850275fb, 0x58adb17a,
  0xc0008000, 0x40000001, 0x3fff8002, 0x2aab0020,
  0x80017fff, 0x7fff8001, 0x7ffe8003, 0x5555aaca,
  0x5556d555, 0xaaaa8001, 0xaaa92aad, 0x71c7e3ae,
  0x3bbd0889, 0xc4448001, 0xc442f779, 0x82d95b26,
  0x3b7d0909, 0xc4848001, 0xc482f6f9, 0x83040626,
  0x3b3d8988, 0xc4c40001, 0xc4c2767a, 0x832e5bd0,
  0x3afe8a06, 0xc5030001, 0xc50175fc, 0x83585c24,
  0x3ac00a83, 0xc5418001, 0xc53ff57f, 0x83820722,
  0xc000ffff, 0x3fff8001, 0x3fff0003, 0x2aaaaaca,
  0x95565555, 0x6aaa8001, 0x6aa9aaad, 0x471ce3ae,
  0x7bbc8889, 0x84448001, 0x84437779, 0x582e5b26,
  0x7b7c8909, 0x84848001, 0x848376f9, 0x58590626,
  0x7b3d0988, 0x84c40001, 0x84c2f67a, 0x58835bd0,
  0x7afe0a06, 0x85030001, 0x8501f5fc, 0x58ad5c24,
  0x7abf8a83, 0x85418001, 0x8540757f, 0x58d70722,
  0x7ab78a93, 0x85498001, 0x8548756f, 0x58dc5c82,
  0xd5555556, 0x2aab0001, 0x2aaaaaac, 0x1c723904,
  0xbbbb888a, 0x44450001, 0x44447778, 0x2d83b07c,
  0xbb7b890a, 0x44850001, 0x448476f8, 0x2dae5b7c,
  0xbb3c0989, 0x44c48001, 0x44c3f679, 0x2dd8b126,
  0xbafd0a07, 0x45038001, 0x4502f5fb, 0x2e02b17a,
  0xbabe8a84, 0x45420001, 0x4541757e, 0x2e2c5c78,
  0xbab68a94, 0x454a0001, 0x4549756e, 0x2e31b1d8,
  0xbab50a97, 0x454b8001, 0x454af56b, 0x2e32b1da,
  0xe6663334, 0x199a0001, 0x1999ccce, 0x11117798,
  0xe62633b4, 0x19da0001, 0x19d9cc4e, 0x113c2298,
  0xe5e6b433, 0x1a198001, 0x1a194bcf, 0x11667842,
  0xe5a7b4b1, 0x1a588001, 0x1a584b51, 0x11907896,
  0xe569352e, 0x1a970001, 0x1a96cad4, 0x11ba2394,
  0xe561353e, 0x1a9f0001, 0x1a9ecac4, 0x11bf78f4,
  0xe55fb541, 0x1aa08001, 0x1aa04ac1, 0x11c078f6,
  0xe55eb543, 0x1aa18001, 0x1aa14abf, 0x11c123a2,
  0xffc00080, 0x00400001, 0x003fff82, 0x002aab20,
  0xff8080ff, 0x007f8001, 0x007f7f03, 0x005500ca,
  0xff41817d, 0x00be8001, 0x00be7e85, 0x007f011e,
  0xff0301fa, 0x00fd0001, 0x00fcfe08, 0x00a8ac1c,
  0xfefb020a, 0x01050001, 0x0104fdf8, 0x00ae017c,
  0xfef9820d, 0x01068001, 0x01067df5, 0x00af017e,
  0xfef8820f, 0x01078001, 0x01077df3, 0x00afac2a,
  0xfef80210, 0x01080001, 0x0107fdf2, 0x00b00180,
  0x003f8000, 0x003f7f82, 0x002a55ac, 0x001966ec,
  0x007e8000, 0x007e7f04, 0x00545600, 0x00329a84,
  0x00bd0000, 0x00bcfe87, 0x007e00fe, 0x004b9ae8,
  0x00c50000, 0x00c4fe77, 0x0083565e, 0x004ece28,
  0x00c68000, 0x00c67e74, 0x00845660, 0x004f67c4,
  0x00c78000, 0x00c77e72, 0x0085010c, 0x004fce2c,
  0x00c80000, 0x00c7fe71, 0x00855662, 0x00500160,
  0x00c80000, 0x00c7fe71, 0x00855662, 0x00500160,
  0x003f0000, 0x003eff83, 0x002a0056, 0x001933b8,
  0x007d8000, 0x007d7f06, 0x0053ab54, 0x0032341c,
  0x00858000, 0x00857ef6, 0x005900b4, 0x0035675c,
  0x00870000, 0x0086fef3, 0x005a00b6, 0x003600f8,
  0x00880000, 0x0087fef1, 0x005aab62, 0x00366760,
  0x00888000, 0x00887ef0, 0x005b00b8, 0x00369a94,
  0x00888000, 0x00887ef0, 0x005b00b8, 0x00369a94,
  0x00880000, 0x0087fef1, 0x005aab62, 0x00366760,
  0x003e8000, 0x003e7f84, 0x0029ab00, 0x00190084,
  0x00468000, 0x00467f74, 0x002f0060, 0x001c33c4,
  0x00480000, 0x0047ff71, 0x00300062, 0x001ccd60,
  0x00490000, 0x0048ff6f, 0x0030ab0e, 0x001d33c8,
  0x00498000, 0x00497f6e, 0x00310064, 0x001d66fc,
  0x00498000, 0x00497f6e, 0x00310064, 0x001d66fc,
  0x00490000, 0x0048ff6f, 0x0030ab0e, 0x001d33c8,
  0x00480000, 0x0047ff71, 0x00300062, 0x001ccd60,
  0x00080000, 0x0007fff1, 0x00055562, 0x00033360,
  0x00098000, 0x00097fee, 0x00065564, 0x0003ccfc,
  0x000a8000, 0x000a7fec, 0x00070010, 0x00043364,
  0x000b0000, 0x000affeb, 0x00075566, 0x00046698,
  0x000b0000, 0x000affeb, 0x00075566, 0x00046698,
  0x000a8000, 0x000a7fec, 0x00070010, 0x00043364,
  0x00098000, 0x00097fee, 0x00065564, 0x0003ccfc,
  0x00018000, 0x00017ffe, 0x00010004, 0x000099bc,
  0x00018000, 0x00017ffe, 0x00010004, 0x000099bc,
  0x00028000, 0x00027ffc, 0x0001aab0, 0x00010024,
  0x00030000, 0x0002fffb, 0x00020006, 0x00013358,
  0x00030000, 0x0002fffb, 0x00020006, 0x00013358,
  0x00028000, 0x00027ffc, 0x0001aab0, 0x00010024,
  0x00018000, 0x00017ffe, 0x00010004, 0x000099bc,
  0xfff98000, 0xfff9800e, 0xfffbaaa4, 0xfffd667c,
  0xffbb0000, 0xffbb008b, 0xffd1ffa6, 0xffe46618,
  0x00010000, 0x0000ffff, 0x0000aaae, 0x00006688,
  0x00018000, 0x00017ffe, 0x00010004, 0x000099bc,
  0x00018000, 0x00017ffe, 0x00010004, 0x000099bc,
  0x00010000, 0x0000ffff, 0x0000aaae, 0x00006688,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfff80000, 0xfff80011, 0xfffaaaa2, 0xfffccce0,
  0xffb98000, 0xffb9808e, 0xffd0ffa4, 0xffe3cc7c,
  0xff7a8000, 0xff7a810c, 0xffa6ff50, 0xffca98e4,
  0x00008000, 0x00008000, 0x00005558, 0x00003354,
  0x00008000, 0x00008000, 0x00005558, 0x00003354,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff0000, 0xffff0003, 0xffff5556, 0xffff99b8,
  0xfff70000, 0xfff70013, 0xfff9fff6, 0xfffc6678,
  0xffb88000, 0xffb88090, 0xffd054f8, 0xffe36614,
  0xff798000, 0xff79810e, 0xffa654a4, 0xffca327c,
  0xff3a0000, 0xff3a018d, 0xff7bfefa, 0xffb0cbb0,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff8000, 0xffff8002, 0xffffaaac, 0xffffccec,
  0xfffe8000, 0xfffe8004, 0xffff0000, 0xffff6684,
  0xfff68000, 0xfff68014, 0xfff9aaa0, 0xfffc3344,
  0xffb80000, 0xffb80091, 0xffcfffa2, 0xffe332e0,
  0xff790000, 0xff79010f, 0xffa5ff4e, 0xffc9ff48,
  0xff398000, 0xff39818e, 0xff7ba9a4, 0xffb0987c,
  0xe5a00000, 0xe5a034c1, 0xee6a8782, 0xf5730920,
  0xffff8000, 0xffff8002, 0xffffaaac, 0xffffccec,
  0xfffe8000, 0xfffe8004, 0xffff0000, 0xffff6684,
  0xfff68000, 0xfff68014, 0xfff9aaa0, 0xfffc3344,
  0xffb80000, 0xffb80091, 0xffcfffa2, 0xffe332e0,
  0xff790000, 0xff79010f, 0xffa5ff4e, 0xffc9ff48,
  0xff398000, 0xff39818e, 0xff7ba9a4, 0xffb0987c,
  0xe5a00000, 0xe5a034c1, 0xee6a8782, 0xf5730920,
  0xbaf58000, 0xbaf60a16, 0xd1f8a3f4, 0xe461c4dc,
  0xffff0000, 0xffff0003, 0xffff5556, 0xffff99b8,
  0xfff70000, 0xfff70013, 0xfff9fff6, 0xfffc6678,
  0xffb88000, 0xffb88090, 0xffd054f8, 0xffe36614,
  0xff798000, 0xff79810e, 0xffa654a4, 0xffca327c,
  0xff3a0000, 0xff3a018d, 0xff7bfefa, 0xffb0cbb0,
  0xe5a08000, 0xe5a0b4c0, 0xee6adcd8, 0xf5733c54,
  0xbaf60000, 0xbaf68a15, 0xd1f8f94a, 0xe461f810,
  0x7af78000, 0x7af88a12, 0xa74ef94c, 0xcac891ac,
  0xfff80000, 0xfff80011, 0xfffaaaa2, 0xfffccce0,
  0xffb98000, 0xffb9808e, 0xffd0ffa4, 0xffe3cc7c,
  0xff7a8000, 0xff7a810c, 0xffa6ff50, 0xffca98e4,
  0xff3b0000, 0xff3b018b, 0xff7ca9a6, 0xffb13218,
  0xe5a18000, 0xe5a1b4be, 0xee6b8784, 0xf573a2bc,
  0xbaf70000, 0xbaf78a13, 0xd1f9a3f6, 0xe4625e78,
  0x7af88000, 0x7af98a10, 0xa74fa3f8, 0xcac8f814,
  0x3af98000, 0x3afb0a0e, 0x7ca54ea4, 0xb12f5e7c,
  0xffc18000, 0xffc1807e, 0xffd65504, 0xffe6ffbc,
  0xff828000, 0xff8280fc, 0xffac54b0, 0xffcdcc24,
  0xff430000, 0xff43017b, 0xff81ff06, 0xffb46558,
  0xe5a98000, 0xe5a9b4ae, 0xee70dce4, 0xf576d5fc,
  0xbaff0000, 0xbaff8a03, 0xd1fef956, 0xe46591b8,
  0x7b008000, 0x7b018a00, 0xa754f958, 0xcacc2b54,
  0x3b018000, 0x3b0309fe, 0x7caaa404, 0xb13291bc,
  0xfb020000, 0xfb0409fd, 0x51fff95a, 0x9798c4f0,
  0xffc10000, 0xffc1007f, 0xffd5ffae, 0xffe6cc88,
  0xff818000, 0xff8180fe, 0xffabaa04, 0xffcd65bc,
  0xe5e80000, 0xe5e83431, 0xee9a87e2, 0xf58fd660,
  0xbb3d8000, 0xbb3e0986, 0xd228a454, 0xe47e921c,
  0x7b3f0000, 0x7b400983, 0xa77ea456, 0xcae52bb8,
  0x3b400000, 0x3b418981, 0x7cd44f02, 0xb14b9220,
  0xfb408000, 0xfb428980, 0x5229a458, 0x97b1c554,
  0x3b408000, 0x3b420980, 0x7cd4a458, 0xb14bc554,
  0xffc08000, 0xffc08080, 0xffd5aa58, 0xffe69954,
  0xe6270000, 0xe62733b3, 0xeec48836, 0xf5a909f8,
  0xbb7c8000, 0xbb7d0908, 0xd252a4a8, 0xe497c5b4,
  0x7b7e0000, 0x7b7f0905, 0xa7a8a4aa, 0xcafe5f50,
  0x3b7f0000, 0x3b808903, 0x7cfe4f56, 0xb164c5b8,
  0xfb7f8000, 0xfb818902, 0x5253a4ac, 0x97caf8ec,
  0x3b7f8000, 0x3b810902, 0x7cfea4ac, 0xb164f8ec,
  0x7b7f0000, 0x7b800903, 0xa7a94f56, 0xcafec5b8,
  0xe6668000, 0xe666b334, 0xeeeedde0, 0xf5c270c4,
  0xbbbc0000, 0xbbbc8889, 0xd27cfa52, 0xe4b12c80,
  0x7bbd8000, 0x7bbe8886, 0xa7d2fa54, 0xcb17c61c,
  0x3bbe8000, 0x3bc00884, 0x7d28a500, 0xb17e2c84,
  0xfbbf0000, 0xfbc10883, 0x527dfa56, 0x97e45fb8,
  0x3bbf0000, 0x3bc08883, 0x7d28fa56, 0xb17e5fb8,
  0x7bbe8000, 0x7bbf8884, 0xa7d3a500, 0xcb182c84,
  0xa6698000, 0xa66a332e, 0xc445dde4, 0xdc29a3fc,
  0xd5558000, 0xd555d556, 0xe38e1c74, 0xeeeebbdc,
  0x95570000, 0x9557d553, 0xb8e41c76, 0xd5555578,
  0x55580000, 0x55595551, 0x8e39c722, 0xbbbbbbe0,
  0x15588000, 0x155a5550, 0x638f1c78, 0xa221ef14,
  0x55588000, 0x5559d550, 0x8e3a1c78, 0xbbbbef14,
  0x95580000, 0x9558d551, 0xb8e4c722, 0xd555bbe0,
  0xc0030000, 0xc0037ffb, 0xd5570006, 0xe6673358,
  0xd99d0000, 0xd99d4cc7, 0xe668777e, 0xf0a4f5e8,
  0xc0018000, 0xc001fffe, 0xd5560004, 0xe66699bc,
  0x80028000, 0x80037ffc, 0xaaabaab0, 0xcccd0024,
  0x40030000, 0x40047ffb, 0x80010006, 0xb3333358,
  0x80030000, 0x8003fffb, 0xaaac0006, 0xcccd3358,
  0xc0028000, 0xc002fffc, 0xd556aab0, 0xe6670024,
  0xeaad8000, 0xeaadaaa6, 0xf1c8e394, 0xf778779c,
  0x04478000, 0x04477772, 0x02da5b0c, 0x01b63a2c,
  0x04878000, 0x048776f2, 0x0305060c, 0x01cfd42c,
  0xc0010000, 0xc0017fff, 0xd555aaae, 0xe6666688,
  0x80018000, 0x80027ffe, 0xaaab0004, 0xcccc99bc,
  0xc0018000, 0xc001fffe, 0xd5560004, 0xe66699bc,
  0x00010000, 0x0000ffff, 0x0000aaae, 0x00006688,
  0x2aac0000, 0x2aabaaa9, 0x1c72e392, 0x1111de00,
  0x44460000, 0x44457775, 0x2d845b0a, 0x1b4fa090,
  0x44860000, 0x448576f5, 0x2daf060a, 0x1b693a90,
  0x44c58000, 0x44c4f676, 0x2dd95bb4, 0x1b82a15c,
  0xc0008000, 0xc0010000, 0xd5555558, 0xe6663354,
  0x00008000, 0x00008000, 0x00005558, 0x00003354,
  0x40000000, 0x3fff8001, 0x2aab0002, 0x199a0020,
  0x6aab0000, 0x6aaa2aab, 0x471d38e6, 0x2aab7798,
  0x84450000, 0x8443f777, 0x582eb05e, 0x34e93a28,
  0x84850000, 0x8483f6f7, 0x58595b5e, 0x3502d428,
  0x84c48000, 0x84c37678, 0x5883b108, 0x351c3af4,
  0x85038000, 0x850275fa, 0x58adb15c, 0x35356e8c,
  0x40000000, 0x3fff8001, 0x2aab0002, 0x199a0020,
  0x7fff8000, 0x7ffe8002, 0x5555aaac, 0x3333ccec,
  0xaaaa8000, 0xaaa92aac, 0x71c7e390, 0x44454464,
  0xc4448000, 0xc442f778, 0x82d95b08, 0x4e8306f4,
  0xc4848000, 0xc482f6f8, 0x83040608, 0x4e9ca0f4,
  0xc4c40000, 0xc4c27679, 0x832e5bb2, 0x4eb607c0,
  0xc5030000, 0xc50175fb, 0x83585c06, 0x4ecf3b58,
  0xc5418000, 0xc53ff57e, 0x83820704, 0x4ee83bbc,
  0x3fff8000, 0x3fff0002, 0x2aaaaaac, 0x1999ccec,
  0x6aaa8000, 0x6aa9aaac, 0x471ce390, 0x2aab4464,
  0x84448000, 0x84437778, 0x582e5b08, 0x34e906f4,
  0x84848000, 0x848376f8, 0x58590608, 0x3502a0f4,
  0x84c40000, 0x84c2f679, 0x58835bb2, 0x351c07c0,
  0x85030000, 0x8501f5fb, 0x58ad5c06, 0x35353b58,
  0x85418000, 0x8540757e, 0x58d70704, 0x354e3bbc,
  0x85498000, 0x8548756e, 0x58dc5c64, 0x35516efc,
  0x2aab0000, 0x2aaaaaab, 0x1c7238e6, 0x11117798,
  0x44450000, 0x44447777, 0x2d83b05e, 0x1b4f3a28,
  0x44850000, 0x448476f7, 0x2dae5b5e, 0x1b68d428,
  0x44c48000, 0x44c3f678, 0x2dd8b108, 0x1b823af4,
  0x45038000, 0x4502f5fa, 0x2e02b15c, 0x1b9b6e8c,
  0x45420000, 0x4541757d, 0x2e2c5c5a, 0x1bb46ef0,
  0x454a0000, 0x4549756d, 0x2e31b1ba, 0x1bb7a230,
  0x454b8000, 0x454af56a, 0x2e32b1bc, 0x1bb83bcc,
  0x199a0000, 0x1999cccd, 0x1111777a, 0x0a3dc2b0,
  0x19da0000, 0x19d9cc4d, 0x113c227a, 0x0a575cb0,
  0x1a198000, 0x1a194bce, 0x11667824, 0x0a70c37c,
  0x1a588000, 0x1a584b50, 0x11907878, 0x0a89f714,
  0x1a970000, 0x1a96cad3, 0x11ba2376, 0x0aa2f778,
  0x1a9f0000, 0x1a9ecac3, 0x11bf78d6, 0x0aa62ab8,
  0x1aa08000, 0x1aa04ac0, 0x11c078d8, 0x0aa6c454,
  0x1aa18000, 0x1aa14abe, 0x11c12384, 0x0aa72abc,
  0x00400000, 0x003fff81, 0x002aab02, 0x00199a20,
  0x007f8000, 0x007f7f02, 0x005500ac, 0x003300ec,
  0x00be8000, 0x00be7e84, 0x007f0100, 0x004c3484,
  0x00fd0000, 0x00fcfe07, 0x00a8abfe, 0x006534e8,
  0x01050000, 0x0104fdf7, 0x00ae015e, 0x00686828,
  0x01068000, 0x01067df4, 0x00af0160, 0x006901c4,
  0x01078000, 0x01077df2, 0x00afac0c, 0x0069682c,
  0x01080000, 0x0107fdf1, 0x00b00162, 0x00699b60,
  0x003f7f81, 0x002a55ab, 0x001966ce, 0x00003fa0,
  0x007e7f03, 0x005455ff, 0x00329a66, 0x00007ea0,
  0x00bcfe86, 0x007e00fd, 0x004b9aca, 0x0000bd20,
  0x00c4fe76, 0x0083565d, 0x004ece0a, 0x0000c520,
  0x00c67e73, 0x0084565f, 0x004f67a6, 0x0000c6a0,
  0x00c77e71, 0x0085010b, 0x004fce0e, 0x0000c7a0,
  0x00c7fe70, 0x00855661, 0x00500142, 0x0000c820,
  0x00c7fe70, 0x00855661, 0x00500142, 0x0000c820,
  0x003eff82, 0x002a0055, 0x0019339a, 0x00003f20,
  0x007d7f05, 0x0053ab53, 0x003233fe, 0x00007da0,
  0x00857ef5, 0x005900b3, 0x0035673e, 0x000085a0,
  0x0086fef2, 0x005a00b5, 0x003600da, 0x00008720,
  0x0087fef0, 0x005aab61, 0x00366742, 0x00008820,
  0x00887eef, 0x005b00b7, 0x00369a76, 0x000088a0,
  0x00887eef, 0x005b00b7, 0x00369a76, 0x000088a0,
  0x0087fef0, 0x005aab61, 0x00366742, 0x00008820,
  0x003e7f83, 0x0029aaff, 0x00190066, 0x00003ea0,
  0x00467f73, 0x002f005f, 0x001c33a6, 0x000046a0,
  0x0047ff70, 0x00300061, 0x001ccd42, 0x00004820,
  0x0048ff6e, 0x0030ab0d, 0x001d33aa, 0x00004920,
  0x00497f6d, 0x00310063, 0x001d66de, 0x000049a0,
  0x00497f6d, 0x00310063, 0x001d66de, 0x000049a0,
  0x0048ff6e, 0x0030ab0d, 0x001d33aa, 0x00004920,
  0x0047ff70, 0x00300061, 0x001ccd42, 0x00004820,
  0x0007fff0, 0x00055561, 0x00033342, 0x00000820,
  0x00097fed, 0x00065563, 0x0003ccde, 0x000009a0,
  0x000a7feb, 0x0007000f, 0x00043346, 0x00000aa0,
  0x000affea, 0x00075565, 0x0004667a, 0x00000b20,
  0x000affea, 0x00075565, 0x0004667a, 0x00000b20,
  0x000a7feb, 0x0007000f, 0x00043346, 0x00000aa0,
  0x00097fed, 0x00065563, 0x0003ccde, 0x000009a0,
  0x00017ffd, 0x00010003, 0x0000999e, 0x000001a0,
  0x00017ffd, 0x00010003, 0x0000999e, 0x000001a0,
  0x00027ffb, 0x0001aaaf, 0x00010006, 0x000002a0,
  0x0002fffa, 0x00020005, 0x0001333a, 0x00000320,
  0x0002fffa, 0x00020005, 0x0001333a, 0x00000320,
  0x00027ffb, 0x0001aaaf, 0x00010006, 0x000002a0,
  0x00017ffd, 0x00010003, 0x0000999e, 0x000001a0,
  0xfff9800d, 0xfffbaaa3, 0xfffd665e, 0xfffff9a0,
  0xffbb008a, 0xffd1ffa5, 0xffe465fa, 0xffffbb20,
  0x0000fffe, 0x0000aaad, 0x0000666a, 0x00000120,
  0x00017ffd, 0x00010003, 0x0000999e, 0x000001a0,
  0x00017ffd, 0x00010003, 0x0000999e, 0x000001a0,
  0x0000fffe, 0x0000aaad, 0x0000666a, 0x00000120,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfff80010, 0xfffaaaa1, 0xfffcccc2, 0xfffff820,
  0xffb9808d, 0xffd0ffa3, 0xffe3cc5e, 0xffffb9a0,
  0xff7a810b, 0xffa6ff4f, 0xffca98c6, 0xffff7aa0,
  0x00007fff, 0x00005557, 0x00003336, 0x000000a0,
  0x00007fff, 0x00005557, 0x00003336, 0x000000a0,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff0002, 0xffff5555, 0xffff999a, 0xffffff20,
  0xfff70012, 0xfff9fff5, 0xfffc665a, 0xfffff720,
  0xffb8808f, 0xffd054f7, 0xffe365f6, 0xffffb8a0,
  0xff79810d, 0xffa654a3, 0xffca325e, 0xffff79a0,
  0xff3a018c, 0xff7bfef9, 0xffb0cb92, 0xffff3a20,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff8001, 0xffffaaab, 0xffffccce, 0xffffffa0,
  0xfffe8003, 0xfffeffff, 0xffff6666, 0xfffffea0,
  0xfff68013, 0xfff9aa9f, 0xfffc3326, 0xfffff6a0,
  0xffb80090, 0xffcfffa1, 0xffe332c2, 0xffffb820,
  0xff79010e, 0xffa5ff4d, 0xffc9ff2a, 0xffff7920,
  0xff39818d, 0xff7ba9a3, 0xffb0985e, 0xffff39a0,
  0xe5a034c0, 0xee6a8781, 0xf5730902, 0xffe5a020,
  0xffff8001, 0xffffaaab, 0xffffccce, 0xffffffa0,
  0xfffe8003, 0xfffeffff, 0xffff6666, 0xfffffea0,
  0xfff68013, 0xfff9aa9f, 0xfffc3326, 0xfffff6a0,
  0xffb80090, 0xffcfffa1, 0xffe332c2, 0xffffb820,
  0xff79010e, 0xffa5ff4d, 0xffc9ff2a, 0xffff7920,
  0xff39818d, 0xff7ba9a3, 0xffb0985e, 0xffff39a0,
  0xe5a034c0, 0xee6a8781, 0xf5730902, 0xffe5a020,
  0xbaf60a15, 0xd1f8a3f3, 0xe461c4be, 0xffbaf5a0,
  0xffff0002, 0xffff5555, 0xffff999a, 0xffffff20,
  0xfff70012, 0xfff9fff5, 0xfffc665a, 0xfffff720,
  0xffb8808f, 0xffd054f7, 0xffe365f6, 0xffffb8a0,
  0xff79810d, 0xffa654a3, 0xffca325e, 0xffff79a0,
  0xff3a018c, 0xff7bfef9, 0xffb0cb92, 0xffff3a20,
  0xe5a0b4bf, 0xee6adcd7, 0xf5733c36, 0xffe5a0a0,
  0xbaf68a14, 0xd1f8f949, 0xe461f7f2, 0xffbaf620,
  0x7af88a11, 0xa74ef94b, 0xcac8918e, 0xff7af7a0,
  0xfff80010, 0xfffaaaa1, 0xfffcccc2, 0xfffff820,
  0xffb9808d, 0xffd0ffa3, 0xffe3cc5e, 0xffffb9a0,
  0xff7a810b, 0xffa6ff4f, 0xffca98c6, 0xffff7aa0,
  0xff3b018a, 0xff7ca9a5, 0xffb131fa, 0xffff3b20,
  0xe5a1b4bd, 0xee6b8783, 0xf573a29e, 0xffe5a1a0,
  0xbaf78a12, 0xd1f9a3f5, 0xe4625e5a, 0xffbaf720,
  0x7af98a0f, 0xa74fa3f7, 0xcac8f7f6, 0xff7af8a0,
  0x3afb0a0d, 0x7ca54ea3, 0xb12f5e5e, 0xff3af9a0,
  0xffc1807d, 0xffd65503, 0xffe6ff9e, 0xffffc1a0,
  0xff8280fb, 0xffac54af, 0xffcdcc06, 0xffff82a0,
  0xff43017a, 0xff81ff05, 0xffb4653a, 0xffff4320,
  0xe5a9b4ad, 0xee70dce3, 0xf576d5de, 0xffe5a9a0,
  0xbaff8a02, 0xd1fef955, 0xe465919a, 0xffbaff20,
  0x7b0189ff, 0xa754f957, 0xcacc2b36, 0xff7b00a0,
  0x3b0309fd, 0x7caaa403, 0xb132919e, 0xff3b01a0,
  0xfb0409fc, 0x51fff959, 0x9798c4d2, 0xfefb0220,
  0xffc1007e, 0xffd5ffad, 0xffe6cc6a, 0xffffc120,
  0xff8180fd, 0xffabaa03, 0xffcd659e, 0xffff81a0,
  0xe5e83430, 0xee9a87e1, 0xf58fd642, 0xffe5e820,
  0xbb3e0985, 0xd228a453, 0xe47e91fe, 0xffbb3da0,
  0x7b400982, 0xa77ea455, 0xcae52b9a, 0xff7b3f20,
  0x3b418980, 0x7cd44f01, 0xb14b9202, 0xff3b4020,
  0xfb42897f, 0x5229a457, 0x97b1c536, 0xfefb40a0,
  0x3b42097f, 0x7cd4a457, 0xb14bc536, 0xff3b40a0,
  0xffc0807f, 0xffd5aa57, 0xffe69936, 0xffffc0a0,
  0xe62733b2, 0xeec48835, 0xf5a909da, 0xffe62720,
  0xbb7d0907, 0xd252a4a7, 0xe497c596, 0xffbb7ca0,
  0x7b7f0904, 0xa7a8a4a9, 0xcafe5f32, 0xff7b7e20,
  0x3b808902, 0x7cfe4f55, 0xb164c59a, 0xff3b7f20,
  0xfb818901, 0x5253a4ab, 0x97caf8ce, 0xfefb7fa0,
  0x3b810901, 0x7cfea4ab, 0xb164f8ce, 0xff3b7fa0,
  0x7b800902, 0xa7a94f55, 0xcafec59a, 0xff7b7f20,
  0xe666b333, 0xeeeedddf, 0xf5c270a6, 0xffe666a0,
  0xbbbc8888, 0xd27cfa51, 0xe4b12c62, 0xffbbbc20,
  0x7bbe8885, 0xa7d2fa53, 0xcb17c5fe, 0xff7bbda0,
  0x3bc00883, 0x7d28a4ff, 0xb17e2c66, 0xff3bbea0,
  0xfbc10882, 0x527dfa55, 0x97e45f9a, 0xfefbbf20,
  0x3bc08882, 0x7d28fa55, 0xb17e5f9a, 0xff3bbf20,
  0x7bbf8883, 0xa7d3a4ff, 0xcb182c66, 0xff7bbea0,
  0xa66a332d, 0xc445dde3, 0xdc29a3de, 0xffa669a0,
  0xd555d555, 0xe38e1c73, 0xeeeebbbe, 0xffd555a0,
  0x9557d552, 0xb8e41c75, 0xd555555a, 0xff955720,
  0x55595550, 0x8e39c721, 0xbbbbbbc2, 0xff555820,
  0x155a554f, 0x638f1c77, 0xa221eef6, 0xff1558a0,
  0x5559d54f, 0x8e3a1c77, 0xbbbbeef6, 0xff5558a0,
  0x9558d550, 0xb8e4c721, 0xd555bbc2, 0xff955820,
  0xc0037ffa, 0xd5570005, 0xe667333a, 0xffc00320,
  0xd99d4cc6, 0xe668777d, 0xf0a4f5ca, 0xffd99d20,
  0xc001fffd, 0xd5560003, 0xe666999e, 0xffc001a0,
  0x80037ffb, 0xaaabaaaf, 0xcccd0006, 0xff8002a0,
  0x40047ffa, 0x80010005, 0xb333333a, 0xff400320,
  0x8003fffa, 0xaaac0005, 0xcccd333a, 0xff800320,
  0xc002fffb, 0xd556aaaf, 0xe6670006, 0xffc002a0,
  0xeaadaaa5, 0xf1c8e393, 0xf778777e, 0xffeaada0,
  0x04477771, 0x02da5b0b, 0x01b63a0e, 0x000447a0,
  0x048776f1, 0x0305060b, 0x01cfd40e, 0x000487a0,
  0xc0017ffe, 0xd555aaad, 0xe666666a, 0xffc00120,
  0x80027ffd, 0xaaab0003, 0xcccc999e, 0xff8001a0,
  0xc001fffd, 0xd5560003, 0xe666999e, 0xffc001a0,
  0x0000fffe, 0x0000aaad, 0x0000666a, 0x00000120,
  0x2aabaaa8, 0x1c72e391, 0x1111dde2, 0x002aac20,
  0x44457774, 0x2d845b09, 0x1b4fa072, 0x00444620,
  0x448576f4, 0x2daf0609, 0x1b693a72, 0x00448620,
  0x44c4f675, 0x2dd95bb3, 0x1b82a13e, 0x0044c5a0,
  0xc000ffff, 0xd5555557, 0xe6663336, 0xffc000a0,
  0x00007fff, 0x00005557, 0x00003336, 0x000000a0,
  0x3fff8000, 0x2aab0001, 0x199a0002, 0x00400020,
  0x6aaa2aaa, 0x471d38e5, 0x2aab777a, 0x006aab20,
  0x8443f776, 0x582eb05d, 0x34e93a0a, 0x00844520,
  0x8483f6f6, 0x58595b5d, 0x3502d40a, 0x00848520,
  0x84c37677, 0x5883b107, 0x351c3ad6, 0x0084c4a0,
  0x850275f9, 0x58adb15b, 0x35356e6e, 0x008503a0,
  0x3fff8000, 0x2aab0001, 0x199a0002, 0x00400020,
  0x7ffe8001, 0x5555aaab, 0x3333ccce, 0x007fffa0,
  0xaaa92aab, 0x71c7e38f, 0x44454446, 0x00aaaaa0,
  0xc442f777, 0x82d95b07, 0x4e8306d6, 0x00c444a0,
  0xc482f6f7, 0x83040607, 0x4e9ca0d6, 0x00c484a0,
  0xc4c27678, 0x832e5bb1, 0x4eb607a2, 0x00c4c420,
  0xc50175fa, 0x83585c05, 0x4ecf3b3a, 0x00c50320,
  0xc53ff57d, 0x83820703, 0x4ee83b9e, 0x00c541a0,
  0x3fff0001, 0x2aaaaaab, 0x1999ccce, 0x003fffa0,
  0x6aa9aaab, 0x471ce38f, 0x2aab4446, 0x006aaaa0,
  0x84437777, 0x582e5b07, 0x34e906d6, 0x008444a0,
  0x848376f7, 0x58590607, 0x3502a0d6, 0x008484a0,
  0x84c2f678, 0x58835bb1, 0x351c07a2, 0x0084c420,
  0x8501f5fa, 0x58ad5c05, 0x35353b3a, 0x00850320,
  0x8540757d, 0x58d70703, 0x354e3b9e, 0x008541a0,
  0x8548756d, 0x58dc5c63, 0x35516ede, 0x008549a0,
  0x2aaaaaaa, 0x1c7238e5, 0x1111777a, 0x002aab20,
  0x44447776, 0x2d83b05d, 0x1b4f3a0a, 0x00444520,
  0x448476f6, 0x2dae5b5d, 0x1b68d40a, 0x00448520,
  0x44c3f677, 0x2dd8b107, 0x1b823ad6, 0x0044c4a0,
  0x4502f5f9, 0x2e02b15b, 0x1b9b6e6e, 0x004503a0,
  0x4541757c, 0x2e2c5c59, 0x1bb46ed2, 0x00454220,
  0x4549756c, 0x2e31b1b9, 0x1bb7a212, 0x00454a20,
  0x454af569, 0x2e32b1bb, 0x1bb83bae, 0x00454ba0,
  0x1999cccc, 0x11117779, 0x0a3dc292, 0x00199a20,
  0x19d9cc4c, 0x113c2279, 0x0a575c92, 0x0019da20,
  0x1a194bcd, 0x11667823, 0x0a70c35e, 0x001a19a0,
  0x1a584b4f, 0x11907877, 0x0a89f6f6, 0x001a58a0,
  0x1a96cad2, 0x11ba2375, 0x0aa2f75a, 0x001a9720,
  0x1a9ecac2, 0x11bf78d5, 0x0aa62a9a, 0x001a9f20,
  0x1aa04abf, 0x11c078d7, 0x0aa6c436, 0x001aa0a0,
  0x1aa14abd, 0x11c12383, 0x0aa72a9e, 0x001aa1a0,
  0x003fff80, 0x002aab01, 0x00199a02, 0x00004020,
  0x007f7f01, 0x005500ab, 0x003300ce, 0x00007fa0,
  0x00be7e83, 0x007f00ff, 0x004c3466, 0x0000bea0,
  0x00fcfe06, 0x00a8abfd, 0x006534ca, 0x0000fd20,
  0x0104fdf6, 0x00ae015d, 0x0068680a, 0x00010520,
  0x01067df3, 0x00af015f, 0x006901a6, 0x000106a0,
  0x01077df1, 0x00afac0b, 0x0069680e, 0x000107a0,
  0x0107fdf0, 0x00b00161, 0x00699b42, 0x00010820,
  0x002a55aa, 0x001966cd, 0x00003f82, 0x00003f21,
  0x005455fe, 0x00329a65, 0x00007e82, 0x00007da3,
  0x007e00fc, 0x004b9ac9, 0x0000bd02, 0x0000bba6,
  0x0083565c, 0x004ece09, 0x0000c502, 0x0000c396,
  0x0084565e, 0x004f67a5, 0x0000c682, 0x0000c513,
  0x0085010a, 0x004fce0d, 0x0000c782, 0x0000c611,
  0x00855660, 0x00500141, 0x0000c802, 0x0000c690,
  0x00855660, 0x00500141, 0x0000c802, 0x0000c690,
  0x002a0054, 0x00193399, 0x00003f02, 0x00003ea2,
  0x0053ab52, 0x003233fd, 0x00007d82, 0x00007ca5,
  0x005900b2, 0x0035673d, 0x00008582, 0x00008495,
  0x005a00b4, 0x003600d9, 0x00008702, 0x00008612,
  0x005aab60, 0x00366741, 0x00008802, 0x00008710,
  0x005b00b6, 0x00369a75, 0x00008882, 0x0000878f,
  0x005b00b6, 0x00369a75, 0x00008882, 0x0000878f,
  0x005aab60, 0x00366741, 0x00008802, 0x00008710,
  0x0029aafe, 0x00190065, 0x00003e82, 0x00003e23,
  0x002f005e, 0x001c33a5, 0x00004682, 0x00004613,
  0x00300060, 0x001ccd41, 0x00004802, 0x00004790,
  0x0030ab0c, 0x001d33a9, 0x00004902, 0x0000488e,
  0x00310062, 0x001d66dd, 0x00004982, 0x0000490d,
  0x00310062, 0x001d66dd, 0x00004982, 0x0000490d,
  0x0030ab0c, 0x001d33a9, 0x00004902, 0x0000488e,
  0x00300060, 0x001ccd41, 0x00004802, 0x00004790,
  0x00055560, 0x00033341, 0x00000802, 0x00000810,
  0x00065562, 0x0003ccdd, 0x00000982, 0x0000098d,
  0x0007000e, 0x00043345, 0x00000a82, 0x00000a8b,
  0x00075564, 0x00046679, 0x00000b02, 0x00000b0a,
  0x00075564, 0x00046679, 0x00000b02, 0x00000b0a,
  0x0007000e, 0x00043345, 0x00000a82, 0x00000a8b,
  0x00065562, 0x0003ccdd, 0x00000982, 0x0000098d,
  0x00010002, 0x0000999d, 0x00000182, 0x0000019d,
  0x00010002, 0x0000999d, 0x00000182, 0x0000019d,
  0x0001aaae, 0x00010005, 0x00000282, 0x0000029b,
  0x00020004, 0x00013339, 0x00000302, 0x0000031a,
  0x00020004, 0x00013339, 0x00000302, 0x0000031a,
  0x0001aaae, 0x00010005, 0x00000282, 0x0000029b,
  0x00010002, 0x0000999d, 0x00000182, 0x0000019d,
  0xfffbaaa2, 0xfffd665d, 0xfffff982, 0xfffff9ad,
  0xffd1ffa4, 0xffe465f9, 0xffffbb02, 0xffffbbaa,
  0x0000aaac, 0x00006669, 0x00000102, 0x0000011e,
  0x00010002, 0x0000999d, 0x00000182, 0x0000019d,
  0x00010002, 0x0000999d, 0x00000182, 0x0000019d,
  0x0000aaac, 0x00006669, 0x00000102, 0x0000011e,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffaaaa0, 0xfffcccc1, 0xfffff802, 0xfffff830,
  0xffd0ffa2, 0xffe3cc5d, 0xffffb982, 0xffffba2d,
  0xffa6ff4e, 0xffca98c5, 0xffff7a82, 0xffff7bab,
  0x00005556, 0x00003335, 0x00000082, 0x0000009f,
  0x00005556, 0x00003335, 0x00000082, 0x0000009f,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff5554, 0xffff9999, 0xffffff02, 0xffffff22,
  0xfff9fff4, 0xfffc6659, 0xfffff702, 0xfffff732,
  0xffd054f6, 0xffe365f5, 0xffffb882, 0xffffb92f,
  0xffa654a2, 0xffca325d, 0xffff7982, 0xffff7aad,
  0xff7bfef8, 0xffb0cb91, 0xffff3a02, 0xffff3bac,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffaaaa, 0xffffcccd, 0xffffff82, 0xffffffa1,
  0xfffefffe, 0xffff6665, 0xfffffe82, 0xfffffea3,
  0xfff9aa9e, 0xfffc3325, 0xfffff682, 0xfffff6b3,
  0xffcfffa0, 0xffe332c1, 0xffffb802, 0xffffb8b0,
  0xffa5ff4c, 0xffc9ff29, 0xffff7902, 0xffff7a2e,
  0xff7ba9a2, 0xffb0985d, 0xffff3982, 0xffff3b2d,
  0xee6a8780, 0xf5730901, 0xffe5a002, 0xffe5d4e0,
  0xffffaaaa, 0xffffcccd, 0xffffff82, 0xffffffa1,
  0xfffefffe, 0xffff6665, 0xfffffe82, 0xfffffea3,
  0xfff9aa9e, 0xfffc3325, 0xfffff682, 0xfffff6b3,
  0xffcfffa0, 0xffe332c1, 0xffffb802, 0xffffb8b0,
  0xffa5ff4c, 0xffc9ff29, 0xffff7902, 0xffff7a2e,
  0xff7ba9a2, 0xffb0985d, 0xffff3982, 0xffff3b2d,
  0xee6a8780, 0xf5730901, 0xffe5a002, 0xffe5d4e0,
  0xd1f8a3f2, 0xe461c4bd, 0xffbaf582, 0xffbb7fb5,
  0xffff5554, 0xffff9999, 0xffffff02, 0xffffff22,
  0xfff9fff4, 0xfffc6659, 0xfffff702, 0xfffff732,
  0xffd054f6, 0xffe365f5, 0xffffb882, 0xffffb92f,
  0xffa654a2, 0xffca325d, 0xffff7982, 0xffff7aad,
  0xff7bfef8, 0xffb0cb91, 0xffff3a02, 0xffff3bac,
  0xee6adcd6, 0xf5733c35, 0xffe5a082, 0xffe5d55f,
  0xd1f8f948, 0xe461f7f1, 0xffbaf602, 0xffbb8034,
  0xa74ef94a, 0xcac8918d, 0xff7af782, 0xff7c01b1,
  0xfffaaaa0, 0xfffcccc1, 0xfffff802, 0xfffff830,
  0xffd0ffa2, 0xffe3cc5d, 0xffffb982, 0xffffba2d,
  0xffa6ff4e, 0xffca98c5, 0xffff7a82, 0xffff7bab,
  0xff7ca9a4, 0xffb131f9, 0xffff3b02, 0xffff3caa,
  0xee6b8782, 0xf573a29d, 0xffe5a182, 0xffe5d65d,
  0xd1f9a3f4, 0xe4625e59, 0xffbaf702, 0xffbb8132,
  0xa74fa3f6, 0xcac8f7f5, 0xff7af882, 0xff7c02af,
  0x7ca54ea2, 0xb12f5e5d, 0xff3af982, 0xff3c83ad,
  0xffd65502, 0xffe6ff9d, 0xffffc182, 0xffffc21d,
  0xffac54ae, 0xffcdcc05, 0xffff8282, 0xffff839b,
  0xff81ff04, 0xffb46539, 0xffff4302, 0xffff449a,
  0xee70dce2, 0xf576d5dd, 0xffe5a982, 0xffe5de4d,
  0xd1fef954, 0xe4659199, 0xffbaff02, 0xffbb8922,
  0xa754f956, 0xcacc2b35, 0xff7b0082, 0xff7c0a9f,
  0x7caaa402, 0xb132919d, 0xff3b0182, 0xff3c8b9d,
  0x51fff958, 0x9798c4d1, 0xfefb0202, 0xfefd0c1c,
  0xffd5ffac, 0xffe6cc69, 0xffffc102, 0xffffc19e,
  0xffabaa02, 0xffcd659d, 0xffff8182, 0xffff829d,
  0xee9a87e0, 0xf58fd641, 0xffe5e802, 0xffe61c50,
  0xd228a452, 0xe47e91fd, 0xffbb3d82, 0xffbbc725,
  0xa77ea454, 0xcae52b99, 0xff7b3f02, 0xff7c48a2,
  0x7cd44f00, 0xb14b9201, 0xff3b4002, 0xff3cc9a0,
  0x5229a456, 0x97b1c535, 0xfefb4082, 0xfefd4a1f,
  0x7cd4a456, 0xb14bc535, 0xff3b4082, 0xff3cca1f,
  0xffd5aa56, 0xffe69935, 0xffffc082, 0xffffc11f,
  0xeec48834, 0xf5a909d9, 0xffe62702, 0xffe65ad2,
  0xd252a4a6, 0xe497c595, 0xffbb7c82, 0xffbc05a7,
  0xa7a8a4a8, 0xcafe5f31, 0xff7b7e02, 0xff7c8724,
  0x7cfe4f54, 0xb164c599, 0xff3b7f02, 0xff3d0822,
  0x5253a4aa, 0x97caf8cd, 0xfefb7f82, 0xfefd88a1,
  0x7cfea4aa, 0xb164f8cd, 0xff3b7f82, 0xff3d08a1,
  0xa7a94f54, 0xcafec599, 0xff7b7f02, 0xff7c8822,
  0xeeeeddde, 0xf5c270a5, 0xffe66682, 0xffe699d3,
  0xd27cfa50, 0xe4b12c61, 0xffbbbc02, 0xffbc44a8,
  0xa7d2fa52, 0xcb17c5fd, 0xff7bbd82, 0xff7cc625,
  0x7d28a4fe, 0xb17e2c65, 0xff3bbe82, 0xff3d4723,
  0x527dfa54, 0x97e45f99, 0xfefbbf02, 0xfefdc7a2,
  0x7d28fa54, 0xb17e5f99, 0xff3bbf02, 0xff3d47a2,
  0xa7d3a4fe, 0xcb182c65, 0xff7bbe82, 0xff7cc723,
  0xc445dde2, 0xdc29a3dd, 0xffa66982, 0xffa71ccd,
  0xe38e1c72, 0xeeeebbbd, 0xffd55582, 0xffd5aaf5,
  0xb8e41c74, 0xd5555559, 0xff955702, 0xff962c72,
  0x8e39c720, 0xbbbbbbc1, 0xff555802, 0xff56ad70,
  0x638f1c76, 0xa221eef5, 0xff155882, 0xff172def,
  0x8e3a1c76, 0xbbbbeef5, 0xff555882, 0xff56adef,
  0xb8e4c720, 0xd555bbc1, 0xff955802, 0xff962d70,
  0xd5570004, 0xe6673339, 0xffc00302, 0xffc0831a,
  0xe668777c, 0xf0a4f5c9, 0xffd99d02, 0xffd9e9e6,
  0xd5560002, 0xe666999d, 0xffc00182, 0xffc0819d,
  0xaaabaaae, 0xcccd0005, 0xff800282, 0xff81029b,
  0x80010004, 0xb3333339, 0xff400302, 0xff41831a,
  0xaaac0004, 0xcccd3339, 0xff800302, 0xff81031a,
  0xd556aaae, 0xe6670005, 0xffc00282, 0xffc0829b,
  0xf1c8e392, 0xf778777d, 0xffeaad82, 0xffead845,
  0x02da5b0a, 0x01b63a0d, 0x00044782, 0x00043f11,
  0x0305060a, 0x01cfd40d, 0x00048782, 0x00047e91,
  0xd555aaac, 0xe6666669, 0xffc00102, 0xffc0811e,
  0xaaab0002, 0xcccc999d, 0xff800182, 0xff81019d,
  0xd5560002, 0xe666999d, 0xffc00182, 0xffc0819d,
  0x0000aaac, 0x00006669, 0x00000102, 0x0000011e,
  0x1c72e390, 0x1111dde1, 0x002aac02, 0x002a56c8,
  0x2d845b08, 0x1b4fa071, 0x00444602, 0x0043bd94,
  0x2daf0608, 0x1b693a71, 0x00448602, 0x0043fd14,
  0x2dd95bb2, 0x1b82a13d, 0x0044c582, 0x00443c15,
  0xd5555556, 0xe6663335, 0xffc00082, 0xffc0809f,
  0x00005556, 0x00003335, 0x00000082, 0x0000009f,
  0x2aab0000, 0x199a0001, 0x00400002, 0x003f8020,
  0x471d38e4, 0x2aab7779, 0x006aab02, 0x0069d5ca,
  0x582eb05c, 0x34e93a09, 0x00844502, 0x00833c96,
  0x58595b5c, 0x3502d409, 0x00848502, 0x00837c16,
  0x5883b106, 0x351c3ad5, 0x0084c482, 0x0083bb17,
  0x58adb15a, 0x35356e6d, 0x00850382, 0x0083f999,
  0x2aab0000, 0x199a0001, 0x00400002, 0x003f8020,
  0x5555aaaa, 0x3333cccd, 0x007fff82, 0x007effa1,
  0x71c7e38e, 0x44454445, 0x00aaaa82, 0x00a9554b,
  0x82d95b06, 0x4e8306d5, 0x00c44482, 0x00c2bc17,
  0x83040606, 0x4e9ca0d5, 0x00c48482, 0x00c2fb97,
  0x832e5bb0, 0x4eb607a1, 0x00c4c402, 0x00c33a98,
  0x83585c04, 0x4ecf3b39, 0x00c50302, 0x00c3791a,
  0x83820702, 0x4ee83b9d, 0x00c54182, 0x00c3b71d,
  0x2aaaaaaa, 0x1999cccd, 0x003fff82, 0x003f7fa1,
  0x471ce38e, 0x2aab4445, 0x006aaa82, 0x0069d54b,
  0x582e5b06, 0x34e906d5, 0x00844482, 0x00833c17,
  0x58590606, 0x3502a0d5, 0x00848482, 0x00837b97,
  0x58835bb0, 0x351c07a1, 0x0084c402, 0x0083ba98,
  0x58ad5c04, 0x35353b39, 0x00850302, 0x0083f91a,
  0x58d70702, 0x354e3b9d, 0x00854182, 0x0084371d,
  0x58dc5c62, 0x35516edd, 0x00854982, 0x00843f0d,
  0x1c7238e4, 0x11117779, 0x002aab02, 0x002a55ca,
  0x2d83b05c, 0x1b4f3a09, 0x00444502, 0x0043bc96,
  0x2dae5b5c, 0x1b68d409, 0x00448502, 0x0043fc16,
  0x2dd8b106, 0x1b823ad5, 0x0044c482, 0x00443b17,
  0x2e02b15a, 0x1b9b6e6d, 0x00450382, 0x00447999,
  0x2e2c5c58, 0x1bb46ed1, 0x00454202, 0x0044b79c,
  0x2e31b1b8, 0x1bb7a211, 0x00454a02, 0x0044bf8c,
  0x2e32b1ba, 0x1bb83bad, 0x00454b82, 0x0044c109,
  0x11117778, 0x0a3dc291, 0x00199a02, 0x001966ec,
  0x113c2278, 0x0a575c91, 0x0019da02, 0x0019a66c,
  0x11667822, 0x0a70c35d, 0x001a1982, 0x0019e56d,
  0x11907876, 0x0a89f6f5, 0x001a5882, 0x001a23ef,
  0x11ba2374, 0x0aa2f759, 0x001a9702, 0x001a61f2,
  0x11bf78d4, 0x0aa62a99, 0x001a9f02, 0x001a69e2,
  0x11c078d6, 0x0aa6c435, 0x001aa082, 0x001a6b5f,
  0x11c12382, 0x0aa72a9d, 0x001aa182, 0x001a6c5d,
  0x002aab00, 0x00199a01, 0x00004002, 0x00003fa0,
  0x005500aa, 0x003300cd, 0x00007f82, 0x00007ea1,
  0x007f00fe, 0x004c3465, 0x0000be82, 0x0000bd23,
  0x00a8abfc, 0x006534c9, 0x0000fd02, 0x0000fb26,
  0x00ae015c, 0x00686809, 0x00010502, 0x00010316,
  0x00af015e, 0x006901a5, 0x00010682, 0x00010493,
  0x00afac0a, 0x0069680d, 0x00010782, 0x00010591,
  0x00b00160, 0x00699b41, 0x00010802, 0x00010610,
  0x001966cc, 0x00003f81, 0x00003f03, 0x00003ea2,
  0x00329a64, 0x00007e81, 0x00007d85, 0x00007ca6,
  0x004b9ac8, 0x0000bd01, 0x0000bb88, 0x0000ba2c,
  0x004ece08, 0x0000c501, 0x0000c378, 0x0000c20c,
  0x004f67a4, 0x0000c681, 0x0000c4f5, 0x0000c386,
  0x004fce0c, 0x0000c781, 0x0000c5f3, 0x0000c482,
  0x00500140, 0x0000c801, 0x0000c672, 0x0000c500,
  0x00500140, 0x0000c801, 0x0000c672, 0x0000c500,
  0x00193398, 0x00003f01, 0x00003e84, 0x00003e24,
  0x003233fc, 0x00007d81, 0x00007c87, 0x00007baa,
  0x0035673c, 0x00008581, 0x00008477, 0x0000838a,
  0x003600d8, 0x00008701, 0x000085f4, 0x00008504,
  0x00366740, 0x00008801, 0x000086f2, 0x00008600,
  0x00369a74, 0x00008881, 0x00008771, 0x0000867e,
  0x00369a74, 0x00008881, 0x00008771, 0x0000867e,
  0x00366740, 0x00008801, 0x000086f2, 0x00008600,
  0x00190064, 0x00003e81, 0x00003e05, 0x00003da6,
  0x001c33a4, 0x00004681, 0x000045f5, 0x00004586,
  0x001ccd40, 0x00004801, 0x00004772, 0x00004700,
  0x001d33a8, 0x00004901, 0x00004870, 0x000047fc,
  0x001d66dc, 0x00004981, 0x000048ef, 0x0000487a,
  0x001d66dc, 0x00004981, 0x000048ef, 0x0000487a,
  0x001d33a8, 0x00004901, 0x00004870, 0x000047fc,
  0x001ccd40, 0x00004801, 0x00004772, 0x00004700,
  0x00033340, 0x00000801, 0x000007f2, 0x00000800,
  0x0003ccdc, 0x00000981, 0x0000096f, 0x0000097a,
  0x00043344, 0x00000a81, 0x00000a6d, 0x00000a76,
  0x00046678, 0x00000b01, 0x00000aec, 0x00000af4,
  0x00046678, 0x00000b01, 0x00000aec, 0x00000af4,
  0x00043344, 0x00000a81, 0x00000a6d, 0x00000a76,
  0x0003ccdc, 0x00000981, 0x0000096f, 0x0000097a,
  0x0000999c, 0x00000181, 0x0000017f, 0x0000019a,
  0x0000999c, 0x00000181, 0x0000017f, 0x0000019a,
  0x00010004, 0x00000281, 0x0000027d, 0x00000296,
  0x00013338, 0x00000301, 0x000002fc, 0x00000314,
  0x00013338, 0x00000301, 0x000002fc, 0x00000314,
  0x00010004, 0x00000281, 0x0000027d, 0x00000296,
  0x0000999c, 0x00000181, 0x0000017f, 0x0000019a,
  0xfffd665c, 0xfffff981, 0xfffff98f, 0xfffff9ba,
  0xffe465f8, 0xffffbb01, 0xffffbb8c, 0xffffbc34,
  0x00006668, 0x00000101, 0x00000100, 0x0000011c,
  0x0000999c, 0x00000181, 0x0000017f, 0x0000019a,
  0x0000999c, 0x00000181, 0x0000017f, 0x0000019a,
  0x00006668, 0x00000101, 0x00000100, 0x0000011c,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffcccc0, 0xfffff801, 0xfffff812, 0xfffff840,
  0xffe3cc5c, 0xffffb981, 0xffffba0f, 0xffffbaba,
  0xffca98c4, 0xffff7a81, 0xffff7b8d, 0xffff7cb6,
  0x00003334, 0x00000081, 0x00000081, 0x0000009e,
  0x00003334, 0x00000081, 0x00000081, 0x0000009e,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff9998, 0xffffff01, 0xffffff04, 0xffffff24,
  0xfffc6658, 0xfffff701, 0xfffff714, 0xfffff744,
  0xffe365f4, 0xffffb881, 0xffffb911, 0xffffb9be,
  0xffca325c, 0xffff7981, 0xffff7a8f, 0xffff7bba,
  0xffb0cb90, 0xffff3a01, 0xffff3b8e, 0xffff3d38,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffcccc, 0xffffff81, 0xffffff83, 0xffffffa2,
  0xffff6664, 0xfffffe81, 0xfffffe85, 0xfffffea6,
  0xfffc3324, 0xfffff681, 0xfffff695, 0xfffff6c6,
  0xffe332c0, 0xffffb801, 0xffffb892, 0xffffb940,
  0xffc9ff28, 0xffff7901, 0xffff7a10, 0xffff7b3c,
  0xffb0985c, 0xffff3981, 0xffff3b0f, 0xffff3cba,
  0xf5730900, 0xffe5a001, 0xffe5d4c2, 0xffe609a0,
  0xffffcccc, 0xffffff81, 0xffffff83, 0xffffffa2,
  0xffff6664, 0xfffffe81, 0xfffffe85, 0xfffffea6,
  0xfffc3324, 0xfffff681, 0xfffff695, 0xfffff6c6,
  0xffe332c0, 0xffffb801, 0xffffb892, 0xffffb940,
  0xffc9ff28, 0xffff7901, 0xffff7a10, 0xffff7b3c,
  0xffb0985c, 0xffff3981, 0xffff3b0f, 0xffff3cba,
  0xf5730900, 0xffe5a001, 0xffe5d4c2, 0xffe609a0,
  0xe461c4bc, 0xffbaf581, 0xffbb7f97, 0xffbc09ca,
  0xffff9998, 0xffffff01, 0xffffff04, 0xffffff24,
  0xfffc6658, 0xfffff701, 0xfffff714, 0xfffff744,
  0xffe365f4, 0xffffb881, 0xffffb911, 0xffffb9be,
  0xffca325c, 0xffff7981, 0xffff7a8f, 0xffff7bba,
  0xffb0cb90, 0xffff3a01, 0xffff3b8e, 0xffff3d38,
  0xf5733c34, 0xffe5a081, 0xffe5d541, 0xffe60a1e,
  0xe461f7f0, 0xffbaf601, 0xffbb8016, 0xffbc0a48,
  0xcac8918c, 0xff7af781, 0xff7c0193, 0xff7d0bc2,
  0xfffcccc0, 0xfffff801, 0xfffff812, 0xfffff840,
  0xffe3cc5c, 0xffffb981, 0xffffba0f, 0xffffbaba,
  0xffca98c4, 0xffff7a81, 0xffff7b8d, 0xffff7cb6,
  0xffb131f8, 0xffff3b01, 0xffff3c8c, 0xffff3e34,
  0xf573a29c, 0xffe5a181, 0xffe5d63f, 0xffe60b1a,
  0xe4625e58, 0xffbaf701, 0xffbb8114, 0xffbc0b44,
  0xcac8f7f4, 0xff7af881, 0xff7c0291, 0xff7d0cbe,
  0xb12f5e5c, 0xff3af981, 0xff3c838f, 0xff3e0dba,
  0xffe6ff9c, 0xffffc181, 0xffffc1ff, 0xffffc29a,
  0xffcdcc04, 0xffff8281, 0xffff837d, 0xffff8496,
  0xffb46538, 0xffff4301, 0xffff447c, 0xffff4614,
  0xf576d5dc, 0xffe5a981, 0xffe5de2f, 0xffe612fa,
  0xe4659198, 0xffbaff01, 0xffbb8904, 0xffbc1324,
  0xcacc2b34, 0xff7b0081, 0xff7c0a81, 0xff7d149e,
  0xb132919c, 0xff3b0181, 0xff3c8b7f, 0xff3e159a,
  0x9798c4d0, 0xfefb0201, 0xfefd0bfe, 0xfeff1618,
  0xffe6cc68, 0xffffc101, 0xffffc180, 0xffffc21c,
  0xffcd659c, 0xffff8181, 0xffff827f, 0xffff839a,
  0xf58fd640, 0xffe5e801, 0xffe61c32, 0xffe65080,
  0xe47e91fc, 0xffbb3d81, 0xffbbc707, 0xffbc50aa,
  0xcae52b98, 0xff7b3f01, 0xff7c4884, 0xff7d5224,
  0xb14b9200, 0xff3b4001, 0xff3cc982, 0xff3e5320,
  0x97b1c534, 0xfefb4081, 0xfefd4a01, 0xfeff539e,
  0xb14bc534, 0xff3b4081, 0xff3cca01, 0xff3e539e,
  0xffe69934, 0xffffc081, 0xffffc101, 0xffffc19e,
  0xf5a909d8, 0xffe62701, 0xffe65ab4, 0xffe68e84,
  0xe497c594, 0xffbb7c81, 0xffbc0589, 0xffbc8eae,
  0xcafe5f30, 0xff7b7e01, 0xff7c8706, 0xff7d9028,
  0xb164c598, 0xff3b7f01, 0xff3d0804, 0xff3e9124,
  0x97caf8cc, 0xfefb7f81, 0xfefd8883, 0xfeff91a2,
  0xb164f8cc, 0xff3b7f81, 0xff3d0883, 0xff3e91a2,
  0xcafec598, 0xff7b7f01, 0xff7c8804, 0xff7d9124,
  0xf5c270a4, 0xffe66681, 0xffe699b5, 0xffe6cd06,
  0xe4b12c60, 0xffbbbc01, 0xffbc448a, 0xffbccd30,
  0xcb17c5fc, 0xff7bbd81, 0xff7cc607, 0xff7dceaa,
  0xb17e2c64, 0xff3bbe81, 0xff3d4705, 0xff3ecfa6,
  0x97e45f98, 0xfefbbf01, 0xfefdc784, 0xfeffd024,
  0xb17e5f98, 0xff3bbf01, 0xff3d4784, 0xff3ed024,
  0xcb182c64, 0xff7bbe81, 0xff7cc705, 0xff7dcfa6,
  0xdc29a3dc, 0xffa66981, 0xffa71caf, 0xffa7cffa,
  0xeeeebbbc, 0xffd55581, 0xffd5aad7, 0xffd6004a,
  0xd5555558, 0xff955701, 0xff962c54, 0xff9701c4,
  0xbbbbbbc0, 0xff555801, 0xff56ad52, 0xff5802c0,
  0xa221eef4, 0xff155881, 0xff172dd1, 0xff19033e,
  0xbbbbeef4, 0xff555881, 0xff56add1, 0xff58033e,
  0xd555bbc0, 0xff955801, 0xff962d52, 0xff9702c0,
  0xe6673338, 0xffc00301, 0xffc082fc, 0xffc10314,
  0xf0a4f5c8, 0xffd99d01, 0xffd9e9c8, 0xffda36ac,
  0xe666999c, 0xffc00181, 0xffc0817f, 0xffc1019a,
  0xcccd0004, 0xff800281, 0xff81027d, 0xff820296,
  0xb3333338, 0xff400301, 0xff4182fc, 0xff430314,
  0xcccd3338, 0xff800301, 0xff8102fc, 0xff820314,
  0xe6670004, 0xffc00281, 0xffc0827d, 0xffc10296,
  0xf778777c, 0xffeaad81, 0xffead827, 0xffeb02ea,
  0x01b63a0c, 0x00044781, 0x00043ef3, 0x00043682,
  0x01cfd40c, 0x00048781, 0x00047e73, 0x00047582,
  0xe6666668, 0xffc00101, 0xffc08100, 0xffc1011c,
  0xcccc999c, 0xff800181, 0xff81017f, 0xff82019a,
  0xe666999c, 0xffc00181, 0xffc0817f, 0xffc1019a,
  0x00006668, 0x00000101, 0x00000100, 0x0000011c,
  0x1111dde0, 0x002aac01, 0x002a56aa, 0x002a0170,
  0x1b4fa070, 0x00444601, 0x0043bd76, 0x00433508,
  0x1b693a70, 0x00448601, 0x0043fcf6, 0x00437408,
  0x1b82a13c, 0x0044c581, 0x00443bf7, 0x0043b28a,
  0xe6663334, 0xffc00081, 0xffc08081, 0xffc1009e,
  0x00003334, 0x00000081, 0x00000081, 0x0000009e,
  0x199a0000, 0x00400001, 0x003f8002, 0x003f0020,
  0x2aab7778, 0x006aab01, 0x0069d5ac, 0x00690074,
  0x34e93a08, 0x00844501, 0x00833c78, 0x0082340c,
  0x3502d408, 0x00848501, 0x00837bf8, 0x0082730c,
  0x351c3ad4, 0x0084c481, 0x0083baf9, 0x0082b18e,
  0x35356e6c, 0x00850381, 0x0083f97b, 0x0082ef92,
  0x199a0000, 0x00400001, 0x003f8002, 0x003f0020,
  0x3333cccc, 0x007fff81, 0x007eff83, 0x007dffa2,
  0x44454444, 0x00aaaa81, 0x00a9552d, 0x00a7fff6,
  0x4e8306d4, 0x00c44481, 0x00c2bbf9, 0x00c1338e,
  0x4e9ca0d4, 0x00c48481, 0x00c2fb79, 0x00c1728e,
  0x4eb607a0, 0x00c4c401, 0x00c33a7a, 0x00c1b110,
  0x4ecf3b38, 0x00c50301, 0x00c378fc, 0x00c1ef14,
  0x4ee83b9c, 0x00c54181, 0x00c3b6ff, 0x00c22c9a,
  0x1999cccc, 0x003fff81, 0x003f7f83, 0x003effa2,
  0x2aab4444, 0x006aaa81, 0x0069d52d, 0x0068fff6,
  0x34e906d4, 0x00844481, 0x00833bf9, 0x0082338e,
  0x3502a0d4, 0x00848481, 0x00837b79, 0x0082728e,
  0x351c07a0, 0x0084c401, 0x0083ba7a, 0x0082b110,
  0x35353b38, 0x00850301, 0x0083f8fc, 0x0082ef14,
  0x354e3b9c, 0x00854181, 0x008436ff, 0x00832c9a,
  0x35516edc, 0x00854981, 0x00843eef, 0x0083347a,
  0x11117778, 0x002aab01, 0x002a55ac, 0x002a0074,
  0x1b4f3a08, 0x00444501, 0x0043bc78, 0x0043340c,
  0x1b68d408, 0x00448501, 0x0043fbf8, 0x0043730c,
  0x1b823ad4, 0x0044c481, 0x00443af9, 0x0043b18e,
  0x1b9b6e6c, 0x00450381, 0x0044797b, 0x0043ef92,
  0x1bb46ed0, 0x00454201, 0x0044b77e, 0x00442d18,
  0x1bb7a210, 0x00454a01, 0x0044bf6e, 0x004434f8,
  0x1bb83bac, 0x00454b81, 0x0044c0eb, 0x00443672,
  0x0a3dc290, 0x00199a01, 0x001966ce, 0x001933b8,
  0x0a575c90, 0x0019da01, 0x0019a64e, 0x001972b8,
  0x0a70c35c, 0x001a1981, 0x0019e54f, 0x0019b13a,
  0x0a89f6f4, 0x001a5881, 0x001a23d1, 0x0019ef3e,
  0x0aa2f758, 0x001a9701, 0x001a61d4, 0x001a2cc4,
  0x0aa62a98, 0x001a9f01, 0x001a69c4, 0x001a34a4,
  0x0aa6c434, 0x001aa081, 0x001a6b41, 0x001a361e,
  0x0aa72a9c, 0x001aa181, 0x001a6c3f, 0x001a371a,
  0x00199a00, 0x00004001, 0x00003f82, 0x00003f20,
  0x003300cc, 0x00007f81, 0x00007e83, 0x00007da2,
  0x004c3464, 0x0000be81, 0x0000bd05, 0x0000bba6,
  0x006534c8, 0x0000fd01, 0x0000fb08, 0x0000f92c,
  0x00686808, 0x00010501, 0x000102f8, 0x0001010c,
  0x006901a4, 0x00010681, 0x00010475, 0x00010286,
  0x0069680c, 0x00010781, 0x00010573, 0x00010382,
  0x00699b40, 0x00010801, 0x000105f2, 0x00010400,
  0x00003f80, 0x00003f02, 0x00003e84, 0x00003e23,
  0x00007e80, 0x00007d84, 0x00007c88, 0x00007ba9,
  0x0000bd00, 0x0000bb87, 0x0000ba0e, 0x0000b8b2,
  0x0000c500, 0x0000c377, 0x0000c1ee, 0x0000c082,
  0x0000c680, 0x0000c4f4, 0x0000c368, 0x0000c1f9,
  0x0000c780, 0x0000c5f2, 0x0000c464, 0x0000c2f3,
  0x0000c800, 0x0000c671, 0x0000c4e2, 0x0000c370,
  0x0000c800, 0x0000c671, 0x0000c4e2, 0x0000c370,
  0x00003f00, 0x00003e83, 0x00003e06, 0x00003da6,
  0x00007d80, 0x00007c86, 0x00007b8c, 0x00007aaf,
  0x00008580, 0x00008476, 0x0000836c, 0x0000827f,
  0x00008700, 0x000085f3, 0x000084e6, 0x000083f6,
  0x00008800, 0x000086f1, 0x000085e2, 0x000084f0,
  0x00008880, 0x00008770, 0x00008660, 0x0000856d,
  0x00008880, 0x00008770, 0x00008660, 0x0000856d,
  0x00008800, 0x000086f1, 0x000085e2, 0x000084f0,
  0x00003e80, 0x00003e04, 0x00003d88, 0x00003d29,
  0x00004680, 0x000045f4, 0x00004568, 0x000044f9,
  0x00004800, 0x00004771, 0x000046e2, 0x00004670,
  0x00004900, 0x0000486f, 0x000047de, 0x0000476a,
  0x00004980, 0x000048ee, 0x0000485c, 0x000047e7,
  0x00004980, 0x000048ee, 0x0000485c, 0x000047e7,
  0x00004900, 0x0000486f, 0x000047de, 0x0000476a,
  0x00004800, 0x00004771, 0x000046e2, 0x00004670,
  0x00000800, 0x000007f1, 0x000007e2, 0x000007f0,
  0x00000980, 0x0000096e, 0x0000095c, 0x00000967,
  0x00000a80, 0x00000a6c, 0x00000a58, 0x00000a61,
  0x00000b00, 0x00000aeb, 0x00000ad6, 0x00000ade,
  0x00000b00, 0x00000aeb, 0x00000ad6, 0x00000ade,
  0x00000a80, 0x00000a6c, 0x00000a58, 0x00000a61,
  0x00000980, 0x0000096e, 0x0000095c, 0x00000967,
  0x00000180, 0x0000017e, 0x0000017c, 0x00000197,
  0x00000180, 0x0000017e, 0x0000017c, 0x00000197,
  0x00000280, 0x0000027c, 0x00000278, 0x00000291,
  0x00000300, 0x000002fb, 0x000002f6, 0x0000030e,
  0x00000300, 0x000002fb, 0x000002f6, 0x0000030e,
  0x00000280, 0x0000027c, 0x00000278, 0x00000291,
  0x00000180, 0x0000017e, 0x0000017c, 0x00000197,
  0xfffff980, 0xfffff98e, 0xfffff99c, 0xfffff9c7,
  0xffffbb00, 0xffffbb8b, 0xffffbc16, 0xffffbcbe,
  0x00000100, 0x000000ff, 0x000000fe, 0x0000011a,
  0x00000180, 0x0000017e, 0x0000017c, 0x00000197,
  0x00000180, 0x0000017e, 0x0000017c, 0x00000197,
  0x00000100, 0x000000ff, 0x000000fe, 0x0000011a,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffff800, 0xfffff811, 0xfffff822, 0xfffff850,
  0xffffb980, 0xffffba0e, 0xffffba9c, 0xffffbb47,
  0xffff7a80, 0xffff7b8c, 0xffff7c98, 0xffff7dc1,
  0x00000080, 0x00000080, 0x00000080, 0x0000009d,
  0x00000080, 0x00000080, 0x00000080, 0x0000009d,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffff00, 0xffffff03, 0xffffff06, 0xffffff26,
  0xfffff700, 0xfffff713, 0xfffff726, 0xfffff756,
  0xffffb880, 0xffffb910, 0xffffb9a0, 0xffffba4d,
  0xffff7980, 0xffff7a8e, 0xffff7b9c, 0xffff7cc7,
  0xffff3a00, 0xffff3b8d, 0xffff3d1a, 0xffff3ec4,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffff80, 0xffffff82, 0xffffff84, 0xffffffa3,
  0xfffffe80, 0xfffffe84, 0xfffffe88, 0xfffffea9,
  0xfffff680, 0xfffff694, 0xfffff6a8, 0xfffff6d9,
  0xffffb800, 0xffffb891, 0xffffb922, 0xffffb9d0,
  0xffff7900, 0xffff7a0f, 0xffff7b1e, 0xffff7c4a,
  0xffff3980, 0xffff3b0e, 0xffff3c9c, 0xffff3e47,
  0xffe5a000, 0xffe5d4c1, 0xffe60982, 0xffe63e60,
  0xffffff80, 0xffffff82, 0xffffff84, 0xffffffa3,
  0xfffffe80, 0xfffffe84, 0xfffffe88, 0xfffffea9,
  0xfffff680, 0xfffff694, 0xfffff6a8, 0xfffff6d9,
  0xffffb800, 0xffffb891, 0xffffb922, 0xffffb9d0,
  0xffff7900, 0xffff7a0f, 0xffff7b1e, 0xffff7c4a,
  0xffff3980, 0xffff3b0e, 0xffff3c9c, 0xffff3e47,
  0xffe5a000, 0xffe5d4c1, 0xffe60982, 0xffe63e60,
  0xffbaf580, 0xffbb7f96, 0xffbc09ac, 0xffbc93df,
  0xffffff00, 0xffffff03, 0xffffff06, 0xffffff26,
  0xfffff700, 0xfffff713, 0xfffff726, 0xfffff756,
  0xffffb880, 0xffffb910, 0xffffb9a0, 0xffffba4d,
  0xffff7980, 0xffff7a8e, 0xffff7b9c, 0xffff7cc7,
  0xffff3a00, 0xffff3b8d, 0xffff3d1a, 0xffff3ec4,
  0xffe5a080, 0xffe5d540, 0xffe60a00, 0xffe63edd,
  0xffbaf600, 0xffbb8015, 0xffbc0a2a, 0xffbc945c,
  0xff7af780, 0xff7c0192, 0xff7d0ba4, 0xff7e15d3,
  0xfffff800, 0xfffff811, 0xfffff822, 0xfffff850,
  0xffffb980, 0xffffba0e, 0xffffba9c, 0xffffbb47,
  0xffff7a80, 0xffff7b8c, 0xffff7c98, 0xffff7dc1,
  0xffff3b00, 0xffff3c8b, 0xffff3e16, 0xffff3fbe,
  0xffe5a180, 0xffe5d63e, 0xffe60afc, 0xffe63fd7,
  0xffbaf700, 0xffbb8113, 0xffbc0b26, 0xffbc9556,
  0xff7af880, 0xff7c0290, 0xff7d0ca0, 0xff7e16cd,
  0xff3af980, 0xff3c838e, 0xff3e0d9c, 0xff3f97c7,
  0xffffc180, 0xffffc1fe, 0xffffc27c, 0xffffc317,
  0xffff8280, 0xffff837c, 0xffff8478, 0xffff8591,
  0xffff4300, 0xffff447b, 0xffff45f6, 0xffff478e,
  0xffe5a980, 0xffe5de2e, 0xffe612dc, 0xffe647a7,
  0xffbaff00, 0xffbb8903, 0xffbc1306, 0xffbc9d26,
  0xff7b0080, 0xff7c0a80, 0xff7d1480, 0xff7e1e9d,
  0xff3b0180, 0xff3c8b7e, 0xff3e157c, 0xff3f9f97,
  0xfefb0200, 0xfefd0bfd, 0xfeff15fa, 0xff012014,
  0xffffc100, 0xffffc17f, 0xffffc1fe, 0xffffc29a,
  0xffff8180, 0xffff827e, 0xffff837c, 0xffff8497,
  0xffe5e800, 0xffe61c31, 0xffe65062, 0xffe684b0,
  0xffbb3d80, 0xffbbc706, 0xffbc508c, 0xffbcda2f,
  0xff7b3f00, 0xff7c4883, 0xff7d5206, 0xff7e5ba6,
  0xff3b4000, 0xff3cc981, 0xff3e5302, 0xff3fdca0,
  0xfefb4080, 0xfefd4a00, 0xfeff5380, 0xff015d1d,
  0xff3b4080, 0xff3cca00, 0xff3e5380, 0xff3fdd1d,
  0xffffc080, 0xffffc100, 0xffffc180, 0xffffc21d,
  0xffe62700, 0xffe65ab3, 0xffe68e66, 0xffe6c236,
  0xffbb7c80, 0xffbc0588, 0xffbc8e90, 0xffbd17b5,
  0xff7b7e00, 0xff7c8705, 0xff7d900a, 0xff7e992c,
  0xff3b7f00, 0xff3d0803, 0xff3e9106, 0xff401a26,
  0xfefb7f80, 0xfefd8882, 0xfeff9184, 0xff019aa3,
  0xff3b7f80, 0xff3d0882, 0xff3e9184, 0xff401aa3,
  0xff7b7f00, 0xff7c8803, 0xff7d9106, 0xff7e9a26,
  0xffe66680, 0xffe699b4, 0xffe6cce8, 0xffe70039,
  0xffbbbc00, 0xffbc4489, 0xffbccd12, 0xffbd55b8,
  0xff7bbd80, 0xff7cc606, 0xff7dce8c, 0xff7ed72f,
  0xff3bbe80, 0xff3d4704, 0xff3ecf88, 0xff405829,
  0xfefbbf00, 0xfefdc783, 0xfeffd006, 0xff01d8a6,
  0xff3bbf00, 0xff3d4783, 0xff3ed006, 0xff4058a6,
  0xff7bbe80, 0xff7cc704, 0xff7dcf88, 0xff7ed829,
  0xffa66980, 0xffa71cae, 0xffa7cfdc, 0xffa88327,
  0xffd55580, 0xffd5aad6, 0xffd6002c, 0xffd6559f,
  0xff955700, 0xff962c53, 0xff9701a6, 0xff97d716,
  0xff555800, 0xff56ad51, 0xff5802a2, 0xff595810,
  0xff155880, 0xff172dd0, 0xff190320, 0xff1ad88d,
  0xff555880, 0xff56add0, 0xff580320, 0xff59588d,
  0xff955800, 0xff962d51, 0xff9702a2, 0xff97d810,
  0xffc00300, 0xffc082fb, 0xffc102f6, 0xffc1830e,
  0xffd99d00, 0xffd9e9c7, 0xffda368e, 0xffda8372,
  0xffc00180, 0xffc0817e, 0xffc1017c, 0xffc18197,
  0xff800280, 0xff81027c, 0xff820278, 0xff830291,
  0xff400300, 0xff4182fb, 0xff4302f6, 0xff44830e,
  0xff800300, 0xff8102fb, 0xff8202f6, 0xff83030e,
  0xffc00280, 0xffc0827c, 0xffc10278, 0xffc18291,
  0xffeaad80, 0xffead826, 0xffeb02cc, 0xffeb2d8f,
  0x00044780, 0x00043ef2, 0x00043664, 0x00042df3,
  0x00048780, 0x00047e72, 0x00047564, 0x00046c73,
  0xffc00100, 0xffc080ff, 0xffc100fe, 0xffc1811a,
  0xff800180, 0xff81017e, 0xff82017c, 0xff830197,
  0xffc00180, 0xffc0817e, 0xffc1017c, 0xffc18197,
  0x00000100, 0x000000ff, 0x000000fe, 0x0000011a,
  0x002aac00, 0x002a56a9, 0x002a0152, 0x0029ac18,
  0x00444600, 0x0043bd75, 0x004334ea, 0x0042ac7c,
  0x00448600, 0x0043fcf5, 0x004373ea, 0x0042eafc,
  0x0044c580, 0x00443bf6, 0x0043b26c, 0x004328ff,
  0xffc00080, 0xffc08080, 0xffc10080, 0xffc1809d,
  0x00000080, 0x00000080, 0x00000080, 0x0000009d,
  0x00400000, 0x003f8001, 0x003f0002, 0x003e8020,
  0x006aab00, 0x0069d5ab, 0x00690056, 0x00682b1e,
  0x00844500, 0x00833c77, 0x008233ee, 0x00812b82,
  0x00848500, 0x00837bf7, 0x008272ee, 0x00816a02,
  0x0084c480, 0x0083baf8, 0x0082b170, 0x0081a805,
  0x00850380, 0x0083f97a, 0x0082ef74, 0x0081e58b,
  0x00400000, 0x003f8001, 0x003f0002, 0x003e8020,
  0x007fff80, 0x007eff82, 0x007dff84, 0x007cffa3,
  0x00aaaa80, 0x00a9552c, 0x00a7ffd8, 0x00a6aaa1,
  0x00c44480, 0x00c2bbf8, 0x00c13370, 0x00bfab05,
  0x00c48480, 0x00c2fb78, 0x00c17270, 0x00bfe985,
  0x00c4c400, 0x00c33a79, 0x00c1b0f2, 0x00c02788,
  0x00c50300, 0x00c378fb, 0x00c1eef6, 0x00c0650e,
  0x00c54180, 0x00c3b6fe, 0x00c22c7c, 0x00c0a217,
  0x003fff80, 0x003f7f82, 0x003eff84, 0x003e7fa3,
  0x006aaa80, 0x0069d52c, 0x0068ffd8, 0x00682aa1,
  0x00844480, 0x00833bf8, 0x00823370, 0x00812b05,
  0x00848480, 0x00837b78, 0x00827270, 0x00816985,
  0x0084c400, 0x0083ba79, 0x0082b0f2, 0x0081a788,
  0x00850300, 0x0083f8fb, 0x0082eef6, 0x0081e50e,
  0x00854180, 0x008436fe, 0x00832c7c, 0x00822217,
  0x00854980, 0x00843eee, 0x0083345c, 0x008229e7,
  0x002aab00, 0x002a55ab, 0x002a0056, 0x0029ab1e,
  0x00444500, 0x0043bc77, 0x004333ee, 0x0042ab82,
  0x00448500, 0x0043fbf7, 0x004372ee, 0x0042ea02,
  0x0044c480, 0x00443af8, 0x0043b170, 0x00432805,
  0x00450380, 0x0044797a, 0x0043ef74, 0x0043658b,
  0x00454200, 0x0044b77d, 0x00442cfa, 0x0043a294,
  0x00454a00, 0x0044bf6d, 0x004434da, 0x0043aa64,
  0x00454b80, 0x0044c0ea, 0x00443654, 0x0043abdb,
  0x00199a00, 0x001966cd, 0x0019339a, 0x00190084,
  0x0019da00, 0x0019a64d, 0x0019729a, 0x00193f04,
  0x001a1980, 0x0019e54e, 0x0019b11c, 0x00197d07,
  0x001a5880, 0x001a23d0, 0x0019ef20, 0x0019ba8d,
  0x001a9700, 0x001a61d3, 0x001a2ca6, 0x0019f796,
  0x001a9f00, 0x001a69c3, 0x001a3486, 0x0019ff66,
  0x001aa080, 0x001a6b40, 0x001a3600, 0x001a00dd,
  0x001aa180, 0x001a6c3e, 0x001a36fc, 0x001a01d7,
  0x00004000, 0x00003f81, 0x00003f02, 0x00003ea0,
  0x00007f80, 0x00007e82, 0x00007d84, 0x00007ca3,
  0x0000be80, 0x0000bd04, 0x0000bb88, 0x0000ba29,
  0x0000fd00, 0x0000fb07, 0x0000f90e, 0x0000f732,
  0x00010500, 0x000102f7, 0x000100ee, 0x0000ff02,
  0x00010680, 0x00010474, 0x00010268, 0x00010079,
  0x00010780, 0x00010572, 0x00010364, 0x00010173,
  0x00010800, 0x000105f1, 0x000103e2, 0x000101f0,
};
const unsigned kExpectedCount_NEON_smlal_4S_4H_H = 4608;

#endif  // VIXL_SIM_SMLAL_4S_4H_H_TRACE_AARCH64_H_
