/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.sensor;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLKeyDeviceSensorNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLSensorNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseSensorNode;
import org.web3d.vrml.util.Xj3DKeyEvent;

public class BaseKeySensor
extends BaseSensorNode
implements VRMLKeyDeviceSensorNodeType {
    protected static final int FIELD_KEY_PRESS = 3;
    protected static final int FIELD_KEY_RELEASE = 4;
    protected static final int FIELD_ACTION_PRESS = 5;
    protected static final int FIELD_ACTION_RELEASE = 6;
    protected static final int FIELD_SHIFTKEY = 7;
    protected static final int FIELD_CONTROLKEY = 8;
    protected static final int FIELD_ALTKEY = 10;
    protected static final int LAST_KEYSENSOR_INDEX = 10;
    protected static final int NUM_FIELDS = 11;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected String vfKeyPress;
    protected String vfKeyRelease;
    protected int vfActionKeyPress;
    protected int vfActionKeyRelease;
    protected boolean vfShiftKey;
    protected boolean vfControlKey;
    protected boolean vfAltKey;

    public BaseKeySensor() {
        super("KeySensor");
        this.hasChanged = new boolean[11];
        this.vfShiftKey = false;
        this.vfControlKey = false;
        this.vfAltKey = false;
        this.vfEnabled = true;
        this.vfIsActive = false;
    }

    public BaseKeySensor(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLSensorNodeType)vRMLNodeType);
    }

    public boolean requiresLastEventOnly() {
        return true;
    }

    public void keyPressed(Xj3DKeyEvent xj3DKeyEvent) {
        this.vfIsActive = true;
        this.hasChanged[2] = true;
        this.fireFieldChanged(2);
        if (xj3DKeyEvent.isCharacter()) {
            this.vfKeyPress = String.valueOf(xj3DKeyEvent.getKeyChar());
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        } else if (xj3DKeyEvent.isModifier()) {
            int n = xj3DKeyEvent.getKeyCode();
            switch (n) {
                case 258: {
                    this.vfShiftKey = true;
                    this.hasChanged[7] = true;
                    this.fireFieldChanged(7);
                    break;
                }
                case 257: {
                    this.vfControlKey = true;
                    this.hasChanged[8] = true;
                    this.fireFieldChanged(8);
                    break;
                }
                case 256: {
                    this.vfAltKey = true;
                    this.hasChanged[10] = true;
                    this.fireFieldChanged(10);
                }
            }
        } else if (xj3DKeyEvent.isAction()) {
            this.vfActionKeyPress = xj3DKeyEvent.getKeyCode();
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
    }

    public void keyReleased(Xj3DKeyEvent xj3DKeyEvent) {
        if (xj3DKeyEvent.isCharacter()) {
            this.vfKeyRelease = String.valueOf(xj3DKeyEvent.getKeyChar());
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        } else if (xj3DKeyEvent.isModifier()) {
            int n = xj3DKeyEvent.getKeyCode();
            switch (n) {
                case 258: {
                    this.vfShiftKey = false;
                    this.hasChanged[7] = true;
                    this.fireFieldChanged(7);
                    break;
                }
                case 257: {
                    this.vfControlKey = false;
                    this.hasChanged[8] = true;
                    this.fireFieldChanged(8);
                    break;
                }
                case 256: {
                    this.vfAltKey = false;
                    this.hasChanged[10] = true;
                    this.fireFieldChanged(10);
                }
            }
        } else if (xj3DKeyEvent.isAction()) {
            this.vfActionKeyRelease = xj3DKeyEvent.getKeyCode();
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
        this.vfIsActive = false;
        this.hasChanged[2] = true;
        this.fireFieldChanged(2);
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 10) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 26;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 3: {
                vRMLFieldData.clear();
                vRMLFieldData.stringValue = this.vfKeyPress;
                vRMLFieldData.dataType = (short)6;
                break;
            }
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.stringValue = this.vfKeyRelease;
                vRMLFieldData.dataType = (short)6;
                break;
            }
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.intValue = this.vfActionKeyPress;
                vRMLFieldData.dataType = (short)2;
                break;
            }
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.intValue = this.vfActionKeyRelease;
                vRMLFieldData.dataType = (short)2;
                break;
            }
            case 7: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfShiftKey;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 10: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfAltKey;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 8: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfControlKey;
                vRMLFieldData.dataType = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfKeyPress);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfKeyRelease);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfActionKeyPress);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfActionKeyRelease);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfShiftKey);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfControlKey);
                    break;
                }
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfAltKey);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[11];
        fieldMap = new HashMap(33);
        BaseKeySensor.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseKeySensor.fieldDecl[2] = new VRMLFieldDeclaration(4, "SFBool", "isActive");
        BaseKeySensor.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        BaseKeySensor.fieldDecl[3] = new VRMLFieldDeclaration(4, "SFString", "keyPress");
        BaseKeySensor.fieldDecl[4] = new VRMLFieldDeclaration(4, "SFString", "keyRelease");
        BaseKeySensor.fieldDecl[5] = new VRMLFieldDeclaration(4, "SFInt32", "actionKeyPress");
        BaseKeySensor.fieldDecl[6] = new VRMLFieldDeclaration(4, "SFInt32", "actionKeyRelease");
        BaseKeySensor.fieldDecl[7] = new VRMLFieldDeclaration(4, "SFBool", "shiftKey");
        BaseKeySensor.fieldDecl[8] = new VRMLFieldDeclaration(4, "SFBool", "controlKey");
        BaseKeySensor.fieldDecl[10] = new VRMLFieldDeclaration(4, "SFBool", "altKey");
        fieldMap.put("isActive", new Integer(2));
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        n = new Integer(3);
        fieldMap.put("keyPress", n);
        fieldMap.put("keyPress_changed", n);
        n = new Integer(4);
        fieldMap.put("keyRelease", n);
        fieldMap.put("keyRelease_changed", n);
        n = new Integer(5);
        fieldMap.put("actionKeyPress", n);
        fieldMap.put("actionKeyPress_changed", n);
        n = new Integer(6);
        fieldMap.put("actionKeyRelease", n);
        fieldMap.put("actionKeyRelease_changed", n);
        n = new Integer(7);
        fieldMap.put("shiftKey", n);
        fieldMap.put("shiftKey_changed", n);
        n = new Integer(10);
        fieldMap.put("altKey", n);
        fieldMap.put("altKey_changed", n);
        n = new Integer(8);
        fieldMap.put("controlKey", n);
        fieldMap.put("controlKey_changed", n);
    }
}

