/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.java3d.ui;

import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Raster;
import javax.vecmath.Point3f;
import org.j3d.ui.CapturedImageObserver;

public class ImageCaptureCanvas3D
extends Canvas3D {
    private boolean captureImage = false;
    private transient ArrayList observers = new ArrayList();

    public ImageCaptureCanvas3D(GraphicsConfiguration graphicsConfiguration) {
        super(graphicsConfiguration);
    }

    public ImageCaptureCanvas3D(GraphicsConfiguration graphicsConfiguration, boolean bl) {
        super(graphicsConfiguration, bl);
    }

    public void postSwap() {
        if (!this.captureImage) {
            return;
        }
        GraphicsContext3D graphicsContext3D = this.getGraphicsContext3D();
        Rectangle rectangle = this.getBounds();
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 1);
        ImageComponent2D imageComponent2D = new ImageComponent2D(1, bufferedImage, true, false);
        Raster raster = new Raster(new Point3f(-1.0f, -1.0f, -1.0f), 1, 0, 0, rectangle.width, rectangle.height, imageComponent2D, null);
        graphicsContext3D.readRaster(raster);
        this.notifyObservers(bufferedImage);
    }

    public void addCaptureObserver(CapturedImageObserver capturedImageObserver) {
        if (capturedImageObserver != null && !this.observers.contains(capturedImageObserver)) {
            this.observers.add(capturedImageObserver);
            this.captureImage = true;
        }
    }

    public void removeCaptureObserver(CapturedImageObserver capturedImageObserver) {
        if (capturedImageObserver != null) {
            this.observers.remove(capturedImageObserver);
            if (this.observers.size() == 0) {
                this.captureImage = false;
            }
        }
    }

    private void notifyObservers(BufferedImage bufferedImage) {
        int n = this.observers.size();
        for (int i = 0; i < n; ++i) {
            CapturedImageObserver capturedImageObserver = (CapturedImageObserver)this.observers.get(i);
            try {
                capturedImageObserver.canvasImageCaptured(bufferedImage);
                continue;
            }
            catch (Exception exception) {
                System.err.println("Error sending image to observer");
                exception.printStackTrace();
            }
        }
    }
}

